/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.run;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.KtorStarterIcons;
import com.intellij.ktor.run.KtorRunConfiguration;
import com.intellij.ktor.run.KtorRunConfigurationOptions;
import com.intellij.ktor.run.KtorRunConfigurationType;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ktor/run/KtorRunConfigurationType;", "Lcom/intellij/execution/configurations/ConfigurationTypeBase;", "<init>", "()V", "myFactory", "com/intellij/ktor/run/KtorRunConfigurationType$myFactory$1", "Lcom/intellij/ktor/run/KtorRunConfigurationType$myFactory$1;", "isDumbAware", "", "defaultConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getDefaultConfigurationFactory", "()Lcom/intellij/execution/configurations/ConfigurationFactory;", "intellij.ktor"})
public final class KtorRunConfigurationType
extends ConfigurationTypeBase {
    @NotNull
    private myFactory.1 myFactory = new ConfigurationFactory(this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return (RunConfiguration)new KtorRunConfiguration("", project, this);
        }

        public boolean isApplicable(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return KtorLibraryUtilKt.hasKtorServerLibrary(project);
        }

        public String getId() {
            return "Ktor";
        }

        public boolean isEditableInDumbMode() {
            return true;
        }

        public Class<? extends BaseState> getOptionsClass() {
            return KtorRunConfigurationOptions.class;
        }
    };

    public KtorRunConfigurationType() {
        super("KtorApplicationConfigurationType", KtorStarterBundle.INSTANCE.message("ktor.run.configuration.name", new Object[0]), KtorStarterBundle.INSTANCE.message("ktor.run.configuration.type.description", new Object[0]), KtorStarterIcons.Ktor);
        this.addFactory(this.myFactory);
    }

    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    public final ConfigurationFactory getDefaultConfigurationFactory() {
        return this.myFactory;
    }
}

