/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.junit.JUnitVersion;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UElement;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0000\"\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"isJUnit3InScope", "", "file", "Lcom/intellij/psi/PsiFile;", "isJUnit4InScope", "isJUnit5InScope", "hasInModuleScope", "detectionClass", "", "getProductionClassDetectionMap", "", "module", "Lcom/intellij/openapi/module/Module;", "JUNIT_3_AND_4_COORDINATES", "JUNIT_5_COORDINATES", "getUJUnitVersion", "Lcom/intellij/execution/junit/JUnitVersion;", "elem", "Lorg/jetbrains/uast/UElement;", "getJUnitVersion", "Lcom/intellij/psi/PsiElement;", "intellij.junit"})
public final class JunitLibrarySetupKt {
    @NotNull
    private static final String JUNIT_3_AND_4_COORDINATES = "junit:junit";
    @NotNull
    private static final String JUNIT_5_COORDINATES = "org.junit.jupiter:junit-jupiter-api";

    public static final boolean isJUnit3InScope(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JunitLibrarySetupKt.hasInModuleScope(file, "junit.framework.TestCase");
    }

    public static final boolean isJUnit4InScope(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JunitLibrarySetupKt.hasInModuleScope(file, "org.junit.Test");
    }

    public static final boolean isJUnit5InScope(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JunitLibrarySetupKt.hasInModuleScope(file, "org.junit.jupiter.api.Test");
    }

    private static final boolean hasInModuleScope(PsiFile file, String detectionClass) {
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vFile = virtualFile;
        Module module = ModuleUtil.findModuleForFile((PsiFile)file);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        GlobalSearchScope globalSearchScope = module2.getModuleScope(false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleScope(...)");
        GlobalSearchScope productionScope = globalSearchScope;
        if (!productionScope.contains(vFile)) {
            return JavaLibraryUtil.hasLibraryClass((Module)module2, (String)detectionClass);
        }
        return JunitLibrarySetupKt.getProductionClassDetectionMap(module2).getOrDefault(detectionClass, false);
    }

    private static final Map<String, Boolean> getProductionClassDetectionMap(Module module) {
        Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> JunitLibrarySetupKt.getProductionClassDetectionMap$lambda$0(module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Map)object;
    }

    @Nullable
    public static final JUnitVersion getUJUnitVersion(@NotNull UElement elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        PsiElement psiElement = elem.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourcePsi = psiElement;
        return JunitLibrarySetupKt.getJUnitVersion(sourcePsi);
    }

    @Nullable
    public static final JUnitVersion getJUnitVersion(@NotNull PsiElement elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)elem);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        return JunitLibrarySetupKt.getJUnitVersion(module2);
    }

    @Nullable
    public static final JUnitVersion getJUnitVersion(@NotNull Module module) {
        String junit3Or4Version;
        String junit5Version;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (module.isDisposed() || module.getProject().isDefault()) {
            return null;
        }
        String string = JavaLibraryUtil.getLibraryVersion((Module)module, (String)JUNIT_5_COORDINATES);
        String string2 = junit5Version = string != null ? StringsKt.substringBeforeLast$default((String)string, (String)"-", null, (int)2, null) : null;
        if (junit5Version != null) {
            return new JUnitVersion(junit5Version);
        }
        String string3 = JavaLibraryUtil.getLibraryVersion((Module)module, (String)JUNIT_3_AND_4_COORDINATES);
        String string4 = junit3Or4Version = string3 != null ? StringsKt.substringBeforeLast$default((String)string3, (String)"-", null, (int)2, null) : null;
        if (junit3Or4Version != null) {
            return new JUnitVersion(junit3Or4Version);
        }
        return null;
    }

    private static final CachedValueProvider.Result getProductionClassDetectionMap$lambda$0(Module $module) {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> JunitLibrarySetupKt.getProductionClassDetectionMap$lambda$0$1(arg_0 -> JunitLibrarySetupKt.getProductionClassDetectionMap$lambda$0$0($module, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        ConcurrentMap map = concurrentMap;
        Object[] objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)$module.getProject())};
        return CachedValueProvider.Result.create((Object)map, (Object[])objectArray);
    }

    private static final Boolean getProductionClassDetectionMap$lambda$0$0(Module $module, String it) {
        GlobalSearchScope globalSearchScope = $module.getModuleWithDependenciesAndLibrariesScope(false);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getModuleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope productionScope = globalSearchScope;
        return JavaPsiFacade.getInstance((Project)$module.getProject()).findClass(it, productionScope) != null;
    }

    private static final Boolean getProductionClassDetectionMap$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

