/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JunitLibrarySetupKt;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.testIntegration.TestFramework;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.siyeh.ig.testFrameworks.AbstractAssertHint;
import com.siyeh.ig.testFrameworks.UAssertHint;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0016\u0012\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0015\u0010\u0012\u001a\u00020\u00032\u000b\u0010\u0013\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0002R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnit5AssertionsConverterInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "frameworkName", "", "Lorg/jetbrains/annotations/NonNls;", "<init>", "(Ljava/lang/String;)V", "getFrameworkName", "()Ljava/lang/String;", "shouldInspect", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getNewAssertClassName", "methodName", "JUnit5AssertionsConverterVisitor", "ReplaceObsoleteAssertsFix", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnit5AssertionsConverterInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnit5AssertionsConverterInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnit5AssertionsConverterInspection\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,149:1\n12767#2,2:150\n*S KotlinDebug\n*F\n+ 1 JUnit5AssertionsConverterInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnit5AssertionsConverterInspection\n*L\n29#1:150,2\n*E\n"})
public final class JUnit5AssertionsConverterInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    private final String frameworkName;

    public JUnit5AssertionsConverterInspection(@NotNull String frameworkName) {
        Intrinsics.checkNotNullParameter((Object)frameworkName, (String)"frameworkName");
        this.frameworkName = frameworkName;
    }

    public /* synthetic */ JUnit5AssertionsConverterInspection(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "JUnit5";
        }
        this(string);
    }

    @NotNull
    public final String getFrameworkName() {
        return this.frameworkName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldInspect(PsiFile file) {
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)file, JavaSdkVersion.JDK_1_8)) return false;
        if (!JunitLibrarySetupKt.isJUnit4InScope(file)) return false;
        if (!JunitLibrarySetupKt.isJUnit5InScope(file)) return false;
        if (!(file instanceof PsiClassOwner)) return false;
        PsiClass[] psiClassArray = (PsiClass[])file;
        PsiClass[] psiClassArray2 = psiClassArray;
        if (psiClassArray == null) return false;
        PsiClass[] psiClassArray3 = psiClassArray2.getClasses();
        psiClassArray2 = psiClassArray3;
        if (psiClassArray3 == null) return false;
        PsiClass[] $this$all$iv = psiClassArray2;
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            PsiClass element$iv;
            PsiClass it = element$iv = $this$all$iv[n];
            boolean bl = false;
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)it);
            if (Intrinsics.areEqual((Object)(testFramework != null ? testFramework.getName() : null), (Object)this.frameworkName)) return true;
            boolean bl2 = true;
            if (!bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (!this.shouldInspect(psiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UCallExpression.class, UCallableReferenceExpression.class};
        return UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new JUnit5AssertionsConverterVisitor(holder), classArray, true);
    }

    private final String getNewAssertClassName(String methodName) {
        return Intrinsics.areEqual((Object)methodName, (Object)"assertThat") ? "org.hamcrest.MatcherAssert" : (StringsKt.startsWith$default((String)methodName, (String)"assume", (boolean)false, (int)2, null) ? "org.junit.jupiter.api.Assumptions" : "org.junit.jupiter.api.Assertions");
    }

    public JUnit5AssertionsConverterInspection() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J6\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00130\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J\u001d\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u000b\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnit5AssertionsConverterInspection$JUnit5AssertionsConverterVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/execution/junit/codeInspection/JUnit5AssertionsConverterInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/uast/UCallableReferenceExpression;", "doCheck", "", "Lorg/jetbrains/uast/UExpression;", "toHighlight", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiElement;", "createHint", "Lcom/siyeh/ig/testFrameworks/AbstractAssertHint;", "registerError", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "absentInJUnit5", "methodName", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.junit"})
    public final class JUnit5AssertionsConverterVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public JUnit5AssertionsConverterVisitor(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getMethodIdentifier() == null) {
                return true;
            }
            this.doCheck((UExpression)node, (Function0<? extends PsiElement>)((Function0)() -> JUnit5AssertionsConverterVisitor.visitCallExpression$lambda$0(node)), (Function0<? extends AbstractAssertHint<UExpression>>)((Function0)() -> JUnit5AssertionsConverterVisitor.visitCallExpression$lambda$1(node)));
            return true;
        }

        public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.doCheck((UExpression)node, (Function0<? extends PsiElement>)((Function0)() -> JUnit5AssertionsConverterVisitor.visitCallableReferenceExpression$lambda$0(node)), (Function0<? extends AbstractAssertHint<UExpression>>)((Function0)() -> JUnit5AssertionsConverterVisitor.visitCallableReferenceExpression$lambda$1(node)));
            return true;
        }

        private final void doCheck(UExpression node, Function0<? extends PsiElement> toHighlight, Function0<? extends AbstractAssertHint<UExpression>> createHint) {
            PsiElement psiElement = node.getSourcePsi();
            if (psiElement == null) {
                return;
            }
            PsiElement sourcePsi = psiElement;
            AbstractAssertHint abstractAssertHint = (AbstractAssertHint)createHint.invoke();
            if (abstractAssertHint == null) {
                return;
            }
            AbstractAssertHint hint = abstractAssertHint;
            PsiMethod psiMethod = hint.getMethod();
            if (!psiMethod.hasModifierProperty("static")) {
                return;
            }
            if (!hint.isMessageOnFirstPosition()) {
                return;
            }
            PsiFile psiFile = sourcePsi.getContainingFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.psi.PsiClassOwner");
            PsiClassOwner file = (PsiClassOwner)psiFile;
            PsiClass[] psiClassArray = file.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
            for (PsiClass psiClass : psiClassArray) {
                TestFramework testFramework;
                if (TestFrameworks.detectFramework((PsiClass)psiClass) == null || !Intrinsics.areEqual((Object)JUnit5AssertionsConverterInspection.this.getFrameworkName(), (Object)testFramework.getName())) continue;
                PsiElement psiElement2 = (PsiElement)toHighlight.invoke();
                if (psiElement2 == null) {
                    return;
                }
                PsiElement highlight = psiElement2;
                this.registerError(psiMethod, highlight);
                break;
            }
        }

        private final void registerError(PsiMethod psiMethod, PsiElement toHighlight) {
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass == null) {
                return;
            }
            PsiClass containingClass = psiClass;
            String string = psiMethod.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String methodName = string;
            String assertClassName = JUnit5AssertionsConverterInspection.this.getNewAssertClassName(methodName);
            Object[] objectArray = new Object[]{containingClass.getName(), assertClassName};
            String string2 = JUnitBundle.message("jvm.inspections.junit5.assertions.converter.problem.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String message = string2;
            if (!this.absentInJUnit5(psiMethod, methodName)) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceObsoleteAssertsFix(JUnit5AssertionsConverterInspection.this.getNewAssertClassName(methodName))};
                this.holder.registerProblem(toHighlight, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
            } else {
                this.holder.registerProblem(toHighlight, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        private final boolean absentInJUnit5(PsiMethod psiMethod, String methodName) {
            if (Intrinsics.areEqual((Object)"assertNotEquals", (Object)methodName)) {
                Object[] objectArray = psiMethod.getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getParameters(...)");
                Object[] parameters = objectArray;
                if (!(parameters.length == 0)) {
                    int lastParamIdx;
                    int n = lastParamIdx = ((PsiParameter)ArraysKt.first((Object[])parameters)).getType().equalsToText("java.lang.String") ? 3 : 2;
                    if (parameters.length > lastParamIdx && parameters[lastParamIdx].getType() instanceof PsiPrimitiveType) {
                        return true;
                    }
                }
            }
            return false;
        }

        private static final PsiElement visitCallExpression$lambda$0(UCallExpression $node) {
            UIdentifier uIdentifier = $node.getMethodIdentifier();
            return uIdentifier != null ? uIdentifier.getSourcePsi() : null;
        }

        private static final AbstractAssertHint visitCallExpression$lambda$1(UCallExpression $node) {
            return (AbstractAssertHint)UAssertHint.Companion.create($node, JUnit5AssertionsConverterVisitor::visitCallExpression$lambda$1$0);
        }

        private static final Integer visitCallExpression$lambda$1$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Integer)AbstractAssertHint.ASSERT_METHOD_2_PARAMETER_COUNT.get(it);
        }

        private static final PsiElement visitCallableReferenceExpression$lambda$0(UCallableReferenceExpression $node) {
            return $node.getSourcePsi();
        }

        private static final AbstractAssertHint visitCallableReferenceExpression$lambda$1(UCallableReferenceExpression $node) {
            return (AbstractAssertHint)UAssertHint.Companion.create($node, JUnit5AssertionsConverterVisitor::visitCallableReferenceExpression$lambda$1$0);
        }

        private static final Integer visitCallableReferenceExpression$lambda$1$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Integer)AbstractAssertHint.ASSERT_METHOD_2_PARAMETER_COUNT.get(it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnit5AssertionsConverterInspection$ReplaceObsoleteAssertsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "baseClassName", "", "<init>", "(Lcom/intellij/execution/junit/codeInspection/JUnit5AssertionsConverterInspection;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getName", "getFamilyName", "intellij.junit"})
    @SourceDebugExtension(value={"SMAP\nJUnit5AssertionsConverterInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnit5AssertionsConverterInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnit5AssertionsConverterInspection$ReplaceObsoleteAssertsFix\n+ 2 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,149:1\n229#2,6:150\n236#2:157\n229#2,6:159\n236#2:166\n13#3:156\n13#3:165\n18#4:158\n*S KotlinDebug\n*F\n+ 1 JUnit5AssertionsConverterInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnit5AssertionsConverterInspection$ReplaceObsoleteAssertsFix\n*L\n115#1:150,6\n115#1:157\n140#1:159,6\n140#1:166\n115#1:156\n140#1:165\n118#1:158\n*E\n"})
    public final class ReplaceObsoleteAssertsFix
    implements LocalQuickFix {
        @NotNull
        private final String baseClassName;

        public ReplaceObsoleteAssertsFix(String baseClassName) {
            Intrinsics.checkNotNullParameter((Object)baseClassName, (String)"baseClassName");
            this.baseClassName = baseClassName;
        }

        /*
         * WARNING - void declaration
         */
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement element = descriptor.getPsiElement();
            UElement uElement = UastContextKt.toUElement((PsiElement)element);
            if (uElement instanceof UCallableReferenceExpression) {
                UElement uElement2;
                void $this$replace$iv;
                String string;
                String methodName = ((UCallableReferenceExpression)uElement).getCallableName();
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(JUnit5AssertionsConverterInspection.this.getNewAssertClassName(methodName), element.getResolveScope());
                if (psiClass == null || (string = psiClass.getQualifiedName()) == null) {
                    return;
                }
                String newClassName = string;
                UastElementFactory uastElementFactory = UastCodeGenerationPluginKt.getUastElementFactory((UElement)uElement, (Project)project);
                if (uastElementFactory == null) {
                    return;
                }
                UastElementFactory psiFactory = uastElementFactory;
                UQualifiedReferenceExpression uQualifiedReferenceExpression = psiFactory.createQualifiedReference(newClassName, element);
                if (uQualifiedReferenceExpression == null) {
                    return;
                }
                UQualifiedReferenceExpression newQualifier = uQualifiedReferenceExpression;
                UCallableReferenceExpression uCallableReferenceExpression = psiFactory.createCallableReferenceExpression((UExpression)newQualifier, methodName, null);
                if (uCallableReferenceExpression == null) {
                    return;
                }
                UCallableReferenceExpression newCallableReferences = uCallableReferenceExpression;
                UElement uElement3 = uElement;
                UElement newElement$iv = (UElement)newCallableReferences;
                boolean $i$f$replace = false;
                if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
                    uElement2 = newElement$iv;
                } else {
                    UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                    UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin = uastCodeGenerationPlugin != null ? uastCodeGenerationPlugin.replace((UElement)$this$replace$iv, newElement$iv, UCallableReferenceExpression.class) : null;
                    boolean bl = false;
                    if (it$iv == null) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
                    }
                    uElement2 = uastCodeGenerationPlugin;
                }
                if ((UCallableReferenceExpression)uElement2 == null) {
                    return;
                }
            } else if (uElement instanceof UIdentifier) {
                void $this$replace$iv;
                UElement $this$getParentOfType_u24default$iv = uElement;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                UCallExpression uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
                if (uCallExpression == null) {
                    return;
                }
                UCallExpression methodCall = uCallExpression;
                String string = methodCall.getMethodName();
                if (string == null) {
                    return;
                }
                String methodName = string;
                UAssertHint uAssertHint = UAssertHint.Companion.create(methodCall, ReplaceObsoleteAssertsFix::applyFix$lambda$0);
                if (uAssertHint == null) {
                    return;
                }
                UAssertHint assertHint = uAssertHint;
                List arguments = CollectionsKt.toMutableList((Collection)methodCall.getValueArguments());
                if (!Intrinsics.areEqual((Object)"assertThat", (Object)methodName)) {
                    UExpression uExpression = assertHint.getMessage();
                    if (uExpression != null) {
                        UExpression it = uExpression;
                        boolean bl = false;
                        arguments.remove(it);
                        arguments.add(it);
                    }
                }
                UastElementFactory uastElementFactory = UastCodeGenerationPluginKt.getUastElementFactory((UElement)((UElement)methodCall), (Project)project);
                if (uastElementFactory == null) {
                    return;
                }
                UastElementFactory psiFactory = uastElementFactory;
                PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(JUnit5AssertionsConverterInspection.this.getNewAssertClassName(methodName), element.getResolveScope());
                if (psiClass == null) {
                    return;
                }
                PsiClass clazz = psiClass;
                String string2 = clazz.getQualifiedName();
                if (string2 == null) {
                    return;
                }
                String newClassName = string2;
                UQualifiedReferenceExpression newReceiver = psiFactory.createQualifiedReference(newClassName, methodCall.getSourcePsi());
                UCallExpression uCallExpression2 = psiFactory.createCallExpression((UExpression)newReceiver, methodName, arguments, null, methodCall.getKind(), null);
                if (uCallExpression2 == null) {
                    return;
                }
                UCallExpression newCall = uCallExpression2;
                UExpression qualifiedCall = UastUtils.getQualifiedParentOrThis((UExpression)((UExpression)methodCall));
                UElement it$iv = (UElement)qualifiedCall;
                UElement newElement$iv = (UElement)newCall;
                boolean $i$f$replace = false;
                if (!Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
                    UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
                    UastCodeGenerationPlugin it$iv2 = uastCodeGenerationPlugin = uastCodeGenerationPlugin != null ? uastCodeGenerationPlugin.replace((UElement)$this$replace$iv, newElement$iv, UCallExpression.class) : null;
                    boolean bl = false;
                    if (it$iv2 == null) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
                    }
                }
            }
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.baseClassName};
            String string = JUnitBundle.message("jvm.inspections.junit5.assertions.converter.quickfix", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JUnitBundle.message("jvm.inspections.junit5.assertions.converter.familyName", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        private static final Integer applyFix$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Integer)AbstractAssertHint.ASSERT_METHOD_2_PARAMETER_COUNT.get(it);
        }
    }
}

