/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sybase.introspector;

import com.google.common.collect.ImmutableList;
import com.intellij.database.Dbms;
import com.intellij.database.diagnostic.DataSourceDiagnosticRecorder;
import com.intellij.database.diagnostic.DiagnosticSectionReference;
import com.intellij.database.dialects.base.introspector.BaseIntrospectionFunctions;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseMultiDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.sybase.introspector.AseIntroQueries;
import com.intellij.database.dialects.sybase.introspector.AseIntrospector;
import com.intellij.database.dialects.sybase.introspector.AseIntrospectorKt;
import com.intellij.database.dialects.sybase.introspector.SrcText;
import com.intellij.database.dialects.sybase.model.AseArgument;
import com.intellij.database.dialects.sybase.model.AseCheck;
import com.intellij.database.dialects.sybase.model.AseDatabase;
import com.intellij.database.dialects.sybase.model.AseForeignKey;
import com.intellij.database.dialects.sybase.model.AseFunction;
import com.intellij.database.dialects.sybase.model.AseGrantsHolder;
import com.intellij.database.dialects.sybase.model.AseIndex;
import com.intellij.database.dialects.sybase.model.AseKey;
import com.intellij.database.dialects.sybase.model.AseLikeColumn;
import com.intellij.database.dialects.sybase.model.AseLikeTable;
import com.intellij.database.dialects.sybase.model.AseLogin;
import com.intellij.database.dialects.sybase.model.AseMajorObject;
import com.intellij.database.dialects.sybase.model.AseMajorSchemaObject;
import com.intellij.database.dialects.sybase.model.AseProcedure;
import com.intellij.database.dialects.sybase.model.AseProcedureGroup;
import com.intellij.database.dialects.sybase.model.AseRole;
import com.intellij.database.dialects.sybase.model.AseRoot;
import com.intellij.database.dialects.sybase.model.AseRoutine;
import com.intellij.database.dialects.sybase.model.AseSchema;
import com.intellij.database.dialects.sybase.model.AseSchemaObject;
import com.intellij.database.dialects.sybase.model.AseTable;
import com.intellij.database.dialects.sybase.model.AseTableColumn;
import com.intellij.database.dialects.sybase.model.AseTrigger;
import com.intellij.database.dialects.sybase.model.AseUser;
import com.intellij.database.dialects.sybase.model.AseView;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModMateDatabase;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.references.BasicIdOrNameReference;
import com.intellij.database.model.properties.references.BasicIdReference;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicPositionReference;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.database.remote.jdba.util.StringOperator;
import com.intellij.database.remote.jdba.util.Strings;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003\"#$B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\"\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u001c\u0010\u001a\u001a\u00060\u001bR\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0014J\u001c\u0010\u001d\u001a\u00060\u001eR\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0004H\u0014J&\u0010 \u001a \u0012\u0002\b\u0003\u0012\u0002\b\u00030!R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/sybase/model/AseRoot;", "Lcom/intellij/database/dialects/sybase/model/AseDatabase;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "myQueries", "Lcom/intellij/database/dialects/sybase/introspector/AseIntroQueries;", "checkElementsUptodate", "", "Lcom/intellij/database/model/basic/BasicElement;", "", "elements", "", "introspectServerObjectsInner", "", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "retrieveLogins", "transaction", "retrieveRoles", "createDatabaseRetriever", "Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever;", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever;", "schema", "createDatabaseLister", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$DatabaseLister;", "Factory", "AseDatabaseRetriever", "AseSchemaRetriever", "intellij.database.dialects.sybase"})
@SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,955:1\n1869#2,2:956\n1869#2,2:960\n216#3,2:958\n179#4,7:962\n179#4,7:969\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector\n*L\n78#1:956,2\n95#1:960,2\n88#1:958,2\n110#1:962,7\n127#1:969,7\n*E\n"})
public final class AseIntrospector
extends BaseMultiDatabaseIntrospector<AseRoot, AseDatabase, AseSchema> {
    @NotNull
    private final AseIntroQueries myQueries;

    public AseIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = (BaseIntrospector.Nature)BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.SYBASE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SYBASE");
        super(context, nature, dbms, modelFactory);
        AseIntroQueries aseIntroQueries = AseIntroQueries.QUERIES;
        Intrinsics.checkNotNullExpressionValue((Object)aseIntroQueries, (String)"QUERIES");
        this.myQueries = aseIntroQueries;
    }

    @NotNull
    protected Map<BasicElement, Boolean> checkElementsUptodate(@NotNull Iterable<? extends BasicElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        LinkedHashMap res = new LinkedHashMap();
        for (BasicDatabase database : JBIterable.from(elements).transform(arg_0 -> AseIntrospector.checkElementsUptodate$lambda$1(AseIntrospector::checkElementsUptodate$lambda$0, arg_0)).toSet()) {
            LinkedHashMap ids = new LinkedHashMap();
            Iterable<? extends BasicElement> $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator<? extends BasicElement> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                BasicElement basicElement;
                BasicElement it = basicElement = iterator.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDatabase(), (Object)database) || !AseIntrospectorKt.access$canCheckOutdated(it)) continue;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.database.dialects.sybase.model.AseSchemaObject");
                AseSchemaObject cfr_ignored_0 = (AseSchemaObject)it;
                ((Map)ids).put(((AseSchemaObject)it).getObjectId(), it);
            }
            if (ids.isEmpty()) continue;
            BasicDatabase basicDatabase = database;
            Intrinsics.checkNotNull((Object)basicDatabase);
            this.setQueryParameter("CAT", AseIntrospectorKt.access$catalogPrefix(basicDatabase));
            Set set = ids.keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            this.setQueryParameter("OBJECT_IDS", CollectionsKt.toLongArray((Collection)set));
            BaseNativeIntrospector baseNativeIntrospector = (BaseNativeIntrospector)this;
            SqlQuery<List<AseIntroQueries.OneState>> sqlQuery = AseIntroQueries.QUERIES.retrieveStates;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveStates");
            List states = (List)BaseNativeIntrospector.performQuery$default((BaseNativeIntrospector)baseNativeIntrospector, sqlQuery, null, (int)2, null);
            Map $this$forEach$iv2 = ids;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv3;
                Map.Entry entry = element$iv3 = iterator2.next();
                boolean bl = false;
                AseSchemaObject v = (AseSchemaObject)entry.getValue();
                ((Map)res).put(v, false);
            }
            for (AseIntroQueries.OneState s : states) {
                AseSchemaObject aseSchemaObject;
                if ((AseSchemaObject)ids.get(s.object_id) == null) continue;
                ((Map)res).put(aseSchemaObject, aseSchemaObject.getStateNumber() == s.state_nr);
            }
        }
        this.inModel(arg_0 -> AseIntrospector.checkElementsUptodate$lambda$4(res, arg_0));
        return res;
    }

    protected void introspectServerObjectsInner(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveLogins(tran);
        this.retrieveRoles(tran);
    }

    private final void retrieveLogins(DBTransaction transaction) {
        SqlQuery<List<AseIntroQueries.OneLogin>> sqlQuery = this.myQueries.retrieveLogins;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveLogins");
        List logins = (List)this.performQuery(transaction, sqlQuery);
        this.inModel(arg_0 -> AseIntrospector.retrieveLogins$lambda$0(logins, arg_0));
    }

    private final void retrieveRoles(DBTransaction transaction) {
        block2: {
            try {
                SqlQuery<List<AseIntroQueries.OneRole>> sqlQuery = this.myQueries.retrieveRoles;
                Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveRoles");
                List roles = (List)this.performQuery(transaction, sqlQuery);
                this.inModel(arg_0 -> AseIntrospector.retrieveRoles$lambda$0(roles, arg_0));
            }
            catch (DBException e) {
                this.inModel(AseIntrospector::retrieveRoles$lambda$1);
                String string = e.getMessage();
                if (string != null ? StringsKt.contains((CharSequence)string, (CharSequence)"permission denied", (boolean)true) : false) break block2;
                throw e;
            }
        }
    }

    @NotNull
    protected AseDatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull AseDatabase database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return new AseDatabaseRetriever(transaction, database);
    }

    @NotNull
    protected AseSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull AseSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new AseSchemaRetriever(transaction, schema);
    }

    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseLister<?, ?> createDatabaseLister() {
        return (BaseMultiDatabaseIntrospector.DatabaseLister)new BaseMultiDatabaseIntrospector.DatabaseLister<LongIdName, AseDatabase>(this){
            final /* synthetic */ AseIntrospector this$0;
            {
                this.this$0 = $receiver;
                super((BaseMultiDatabaseIntrospector)$receiver);
            }

            protected List<LongIdName> listDatabases(DBTransaction tran) {
                Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
                Object object = tran.query(AseIntrospector.access$getMyQueries$p((AseIntrospector)this.this$0).listDatabases).runOnce();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runOnce(...)");
                return (List)object;
            }

            protected AseDatabase applyDatabase(ModNamingFamily<?> databases, LongIdName db) {
                Intrinsics.checkNotNullParameter(databases, (String)"databases");
                Intrinsics.checkNotNullParameter((Object)db, (String)"db");
                return (AseDatabase)this.renew(databases, db.id, db.name);
            }
        };
    }

    private static final BasicDatabase checkElementsUptodate$lambda$0(BasicElement it) {
        return it.getDatabase();
    }

    private static final BasicDatabase checkElementsUptodate$lambda$1(Function1 $tmp0, Object p0) {
        return (BasicDatabase)$tmp0.invoke(p0);
    }

    private static final Unit checkElementsUptodate$lambda$4(LinkedHashMap $res, AseRoot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Set set = $res.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            BasicElement obj = (BasicElement)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            Boolean ok = (Boolean)v;
            Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModElement");
            ((BasicModElement)obj).setOutdated(ok == false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveLogins$lambda$0(List $logins, AseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)r.getLogins();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        for (AseIntroQueries.OneLogin l : $logins) {
            BasicModNamedElement basicModNamedElement;
            Intrinsics.checkNotNullExpressionValue((Object)r.getLogins().renew((long)l.id, l.name), (String)"renew(...)");
            AseLogin $this$retrieveLogins_u24lambda_u240_u240_u240 = (AseLogin)basicModNamedElement;
            boolean bl2 = false;
            $this$retrieveLogins_u24lambda_u240_u240_u240.setDefaultDatabaseRef((BasicReference)BasicNameReference.create((String)l.default_db));
            $this$retrieveLogins_u24lambda_u240_u240_u240.setLanguage(l.language);
            $this$retrieveLogins_u24lambda_u240_u240_u240.setFullName(l.fullname);
            $this$retrieveLogins_u24lambda_u240_u240_u240.setLoginScriptId(l.procid);
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoles$lambda$0(List $roles, AseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)r.getRoles();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        for (AseIntroQueries.OneRole role : $roles) {
            BasicModNamedElement basicModNamedElement;
            Intrinsics.checkNotNullExpressionValue((Object)r.getRoles().renew((long)role.id, role.name), (String)"renew(...)");
            AseRole $this$retrieveRoles_u24lambda_u240_u240_u240 = (AseRole)basicModNamedElement;
            boolean bl2 = false;
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoles$lambda$1(AseRoot r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        r.getRoles().clear();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0003B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector$BaseDatabaseRetriever;", "Lcom/intellij/database/dialects/sybase/model/AseDatabase;", "Lcom/intellij/database/dialects/base/introspector/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/dialects/sybase/model/AseRoot;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "database", "<init>", "(Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/sybase/model/AseDatabase;)V", "beforeSchemasRetrieval", "", "retrieveSchemas", "retrieveAuxiliaryObjects", "retrieveGrants", "retrieveUsers", "intellij.database.dialects.sybase"})
    @SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,955:1\n1869#2,2:956\n179#3,7:958\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseDatabaseRetriever\n*L\n183#1:956,2\n190#1:958,7\n*E\n"})
    protected final class AseDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.BaseDatabaseRetriever<AseDatabase> {
        public AseDatabaseRetriever(@NotNull DBTransaction transaction, AseDatabase database) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)AseIntrospector.this, transaction, (BasicModMateDatabase)database);
        }

        protected void beforeSchemasRetrieval() {
            this.setQueryParameter("CAT", AseIntrospectorKt.access$catalogPrefix((BasicDatabase)this.getDatabase()));
        }

        public void retrieveSchemas() {
            super.retrieveSchemas();
            this.inDatabase(arg_0 -> AseDatabaseRetriever.retrieveSchemas$lambda$0(this, AseIntrospector.this, arg_0));
        }

        public void retrieveAuxiliaryObjects() {
            super.retrieveAuxiliaryObjects();
            this.retrieveUsers();
            this.retrieveGrants();
        }

        private final void retrieveGrants() {
            SqlQuery<List<AseIntroQueries.OneGrant>> sqlQuery = ((AseIntrospector)AseIntrospector.this).myQueries.retrieveDatabaseGrants;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveDatabaseGrants");
            List grants = (List)this.performQuery(sqlQuery);
            Intrinsics.checkNotNull((Object)grants);
            Iterable $this$forEach$iv = grants;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseIntroQueries.OneGrant it = (AseIntroQueries.OneGrant)element$iv;
                boolean bl = false;
                if (it.object_id != 0) continue;
                it.object_id = (int)((AseDatabase)this.getDatabase()).getObjectId();
            }
            this.inDatabase(arg_0 -> AseDatabaseRetriever.retrieveGrants$lambda$1(grants, arg_0));
        }

        private final void retrieveUsers() {
            SqlQuery<List<AseIntroQueries.OneUser>> sqlQuery = ((AseIntrospector)AseIntrospector.this).myQueries.retrieveUsers;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"retrieveUsers");
            List users = (List)this.performQuery(sqlQuery);
            this.inDatabase(arg_0 -> AseDatabaseRetriever.retrieveUsers$lambda$0(users, arg_0));
        }

        private static final Unit retrieveSchemas$lambda$0(AseDatabaseRetriever this$0, AseIntrospector this$1, AseDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingIdentifyingFamily<? extends AseSchema> modNamingIdentifyingFamily = it.getSchemas();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getSchemas(...)");
            SqlQuery<List<LongIdName>> sqlQuery = ((AseIntrospector)this$1).myQueries.listSchemas;
            Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"listSchemas");
            Object object = this$0.performQuery(sqlQuery);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"performQuery(...)");
            ModelFun.applyNameIds(modNamingIdentifyingFamily, (List)((List)object));
            return Unit.INSTANCE;
        }

        private static final Unit retrieveGrants$lambda$1(List $grants, AseDatabase it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AseGrantsHolder aseGrantsHolder = it;
            Intrinsics.checkNotNull((Object)$grants);
            AseIntrospectorKt.access$applyGrants(aseGrantsHolder, $grants);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveUsers$lambda$0(List $users, AseDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)db.getUsers();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingIdentifyingFamily it = (ModNamingIdentifyingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            for (AseIntroQueries.OneUser user : $users) {
                BasicModNamedElement basicModNamedElement;
                Intrinsics.checkNotNullExpressionValue((Object)db.getUsers().renew((long)user.id, user.name), (String)"renew(...)");
                AseUser $this$retrieveUsers_u24lambda_u240_u240_u240 = (AseUser)basicModNamedElement;
                boolean bl2 = false;
                $this$retrieveUsers_u24lambda_u240_u240_u240.setGroupRef((BasicReference)BasicIdReference.create((long)user.group_id));
                $this$retrieveUsers_u24lambda_u240_u240_u240.setLoginRef((BasicReference)BasicIdReference.create((long)user.login_id));
            }
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u0003B\u0019\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\b\u0010\u0018\u001a\u00020\u0014H\u0014J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J \u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0014H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010*\u001a\u00020\u0014H\u0002J\b\u0010+\u001a\u00020\u0014H\u0002J\b\u0010,\u001a\u00020\u0014H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\u001a\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104H\u0002J\b\u00105\u001a\u00020\u0014H\u0002J\b\u00106\u001a\u00020\u0014H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/sybase/model/AseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/sybase/model/AseRoot;", "Lcom/intellij/database/dialects/sybase/model/AseDatabase;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/sybase/model/AseSchema;)V", "schemaId", "", "rewriter", "Lcom/intellij/database/remote/jdba/util/StringOperator;", "wasProcedures", "", "isPossibleToIntrospectSchemaIncrementally", "tran", "clearSchema", "", "analyzeCurrentContent", "retrieveGrants", "retrieveMajorNames", "retrieveMainContent", "retrieveProcedures", "retrieveColumnsAndArguments", "addRoutineArgument", "routine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "ca", "Lcom/intellij/database/dialects/sybase/introspector/AseIntroQueries$OneColumnOrArgument;", "dt", "Lcom/intellij/database/model/DataType;", "retrieveIndicesAndKeys", "peekIndexColumns", "index", "Lcom/intellij/database/dialects/sybase/model/AseIndex;", "keys", "", "peekColumnPositions", "", "retrieveForeignKeys", "retrieveCheckConstraints", "retrieveDefaults", "adjustDef", "", "def", "cleanupTableDefaults", "table", "Lcom/intellij/database/dialects/sybase/model/AseTable;", "columnsWithDef", "Lit/unimi/dsi/fastutil/ints/IntSet;", "retrieveTriggers", "retrieveSources", "intellij.database.dialects.sybase"})
    @SourceDebugExtension(value={"SMAP\nAseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever\n+ 2 NumberFun.kt\ncom/intellij/database/util/common/NumberFun\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 5 BaseNativeIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseNativeIntrospector\n+ 6 BaseIntrospector.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospector\n+ 7 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 9 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,955:1\n48#2:956\n38#2:957\n48#2:1089\n38#2:1090\n48#2:1091\n38#2:1092\n48#2:1093\n38#2:1094\n48#2:1103\n38#2:1104\n48#2:1105\n38#2:1106\n48#2:1107\n38#2:1108\n48#2:1109\n38#2:1110\n48#2:1111\n38#2:1112\n295#3,2:958\n1869#3,2:1029\n1563#3:1057\n1634#3,3:1058\n1374#3:1079\n1460#3,5:1080\n1869#3,2:1085\n1869#3,2:1087\n1869#3,2:1095\n1869#3,2:1097\n1869#3,2:1099\n1869#3,2:1101\n1869#3,2:1113\n1869#3,2:1115\n1869#3,2:1117\n1869#3,2:1119\n295#3,2:1167\n1869#3,2:1169\n1869#3,2:1172\n1869#3,2:1174\n1869#3,2:1176\n106#4:960\n78#4,22:961\n106#4:983\n78#4,22:984\n106#4:1006\n78#4,22:1007\n106#4:1121\n78#4,22:1122\n106#4:1144\n78#4,22:1145\n400#5:1031\n401#5,2:1037\n1092#6:1032\n1187#6,2:1033\n1093#6,2:1035\n1097#6:1039\n1192#6,2:1040\n1098#6,2:1042\n196#7,13:1044\n337#7,3:1061\n340#7:1066\n198#7,11:1067\n341#7:1078\n37#8,2:1064\n1#9:1171\n*S KotlinDebug\n*F\n+ 1 AseIntrospector.kt\ncom/intellij/database/dialects/sybase/introspector/AseIntrospector$AseSchemaRetriever\n*L\n374#1:956\n374#1:957\n348#1:1089\n348#1:1090\n349#1:1091\n349#1:1092\n351#1:1093\n351#1:1094\n418#1:1103\n418#1:1104\n419#1:1105\n419#1:1106\n420#1:1107\n420#1:1108\n438#1:1109\n438#1:1110\n442#1:1111\n442#1:1112\n456#1:958,2\n633#1:1029,2\n309#1:1057\n309#1:1058,3\n325#1:1079\n325#1:1080,5\n326#1:1085,2\n327#1:1087,2\n367#1:1095,2\n368#1:1097,2\n369#1:1099,2\n407#1:1101,2\n446#1:1113,2\n486#1:1115,2\n534#1:1117,2\n547#1:1119,2\n568#1:1167,2\n578#1:1169,2\n614#1:1172,2\n646#1:1174,2\n662#1:1176,2\n622#1:960\n622#1:961,22\n624#1:983\n624#1:984,22\n627#1:1006\n627#1:1007,22\n557#1:1121\n557#1:1122,22\n559#1:1144\n559#1:1145,22\n679#1:1031\n679#1:1037,2\n679#1:1032\n679#1:1033,2\n679#1:1035,2\n679#1:1039\n679#1:1040,2\n679#1:1042,2\n262#1:1044,13\n309#1:1061,3\n309#1:1066\n309#1:1067,11\n309#1:1078\n309#1:1064,2\n*E\n"})
    protected final class AseSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<AseSchema> {
        private final int schemaId;
        @NotNull
        private final StringOperator rewriter;
        private boolean wasProcedures;

        public AseSchemaRetriever(@NotNull DBTransaction transaction, AseSchema schema) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)AseIntrospector.this, transaction, (BasicModSchema)schema);
            this.schemaId = (int)schema.getObjectId();
            AseDatabase db = schema.getDatabase();
            if (db == null || db.isCurrent()) {
                object = "dbo";
            } else {
                char c = '[';
                String string = db.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string;
                object = c + string2 + "].dbo";
            }
            String catalogPrefix = object;
            this.rewriter = arg_0 -> AseSchemaRetriever._init_$lambda$0(catalogPrefix, arg_0);
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return false;
        }

        protected void clearSchema() {
        }

        protected void analyzeCurrentContent() {
        }

        private final void retrieveGrants() {
            Object[] objectArray = new Object[]{this.schemaId};
            List grants = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveSchemaGrants.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveGrants$lambda$0(grants, arg_0));
        }

        protected void retrieveMajorNames() {
            AseIntrospector.this.reportRetrieving("major object names", "introspection.retrieve.majorObjectNames");
            Object[] objectArray = new Object[]{this.schemaId};
            List ms = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveMajorNames.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveMajorNames$lambda$0(ms, this, arg_0));
        }

        protected void retrieveMainContent() {
            this.retrieveProcedures();
            this.retrieveColumnsAndArguments();
            this.retrieveDefaults();
            this.retrieveIndicesAndKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveTriggers();
            this.retrieveGrants();
            this.retrieveSources();
            this.finishSchema();
        }

        private final void retrieveProcedures() {
            if (!this.wasProcedures) {
                return;
            }
            ObjectKind objectKind = ObjectKind.ROUTINE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"ROUTINE");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List ps = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveProcedures.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveProcedures$lambda$0(ps, arg_0));
        }

        private final void retrieveColumnsAndArguments() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List cas = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveColumnsAndArguments.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveColumnsAndArguments$lambda$0(cas, AseIntrospector.this, this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private final void addRoutineArgument(BasicModRoutine routine, AseIntroQueries.OneColumnOrArgument ca, DataType dt) {
            BasicModArgument basicModArgument;
            boolean result;
            void $this$and$iv;
            short s = ca.bits2;
            short that$iv = 2;
            boolean $i$f$and = false;
            short $this$toUnsignedInt$iv$iv = $this$and$iv;
            boolean $i$f$toUnsignedInt = false;
            int n = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
            $this$toUnsignedInt$iv$iv = that$iv;
            $i$f$toUnsignedInt = false;
            boolean out = (short)(n & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0;
            boolean bl = result = out && Strings.eq((String)ca.name, (String)"Return Type", (boolean)false);
            if (result) {
                basicModArgument = routine.createOrGetReturnArgument();
            } else {
                AseArgument aseArgument;
                BasicModRoutine basicModRoutine = routine;
                if (basicModRoutine instanceof AseFunction) {
                    ModPositioningNamingFamily<? extends AseArgument> modPositioningNamingFamily = ((AseFunction)routine).getArguments();
                    Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getArguments(...)");
                    ModFamily modFamily = (ModFamily)modPositioningNamingFamily;
                    String string = ca.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    aseArgument = AseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else if (basicModRoutine instanceof AseProcedure) {
                    ModPositioningNamingFamily modPositioningNamingFamily = ((AseProcedure)routine).getArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)modPositioningNamingFamily, (String)"getArguments(...)");
                    ModFamily modFamily = (ModFamily)modPositioningNamingFamily;
                    String string = ca.name;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    aseArgument = AseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else {
                    return;
                }
                basicModArgument = aseArgument;
            }
            BasicModArgument basicModArgument2 = basicModArgument;
            Intrinsics.checkNotNull((Object)basicModArgument2);
            BasicModArgument argument = basicModArgument2;
            argument.setPosition(ca.colid);
            argument.setStoredType(DasUnresolvedTypeReference.Companion.of(dt));
            if (!result) {
                argument.setArgumentDirection(out ? ArgumentDirection.OUT : ArgumentDirection.IN);
            }
        }

        private final void retrieveIndicesAndKeys() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List inds = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveIndices.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveIndicesAndKeys$lambda$0(inds, this, arg_0));
        }

        private final void peekIndexColumns(AseIndex index, byte[] keys) {
            short[] positions = this.peekColumnPositions(keys);
            ImmutableList.Builder builder = ImmutableList.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            ImmutableList.Builder names = builder;
            for (short position : positions) {
                Object v3;
                block2: {
                    if (position == 0) break;
                    AseTable aseTable = index.getTable();
                    Intrinsics.checkNotNull((Object)aseTable);
                    ModPositioningNamingFamily<? extends AseTableColumn> modPositioningNamingFamily = aseTable.getColumns();
                    Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                    Iterable $this$firstOrNull$iv = (Iterable)modPositioningNamingFamily;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        AseTableColumn column = (AseTableColumn)element$iv;
                        boolean bl = false;
                        if (!(column.getPosition() == position)) continue;
                        v3 = element$iv;
                        break block2;
                    }
                    v3 = null;
                }
                AseTableColumn column = v3;
                if (column == null) continue;
                names.add((Object)column.getName());
            }
            index.setColNames((List)names.build());
        }

        private final short[] peekColumnPositions(byte[] keys) {
            int n = (keys.length + 7) / 16;
            short[] positions = new short[n];
            for (int i = 0; i < n; ++i) {
                short position;
                int offset = i << 4 | 4;
                positions[i] = position = AseIntrospectorKt.peek16(keys, offset);
                if (position == 0) break;
            }
            return positions;
        }

        private final void retrieveForeignKeys() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"FOREIGN_KEY");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List fks = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveForeignKeys.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            Ref.BooleanRef wides = new Ref.BooleanRef();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveForeignKeys$lambda$0(fks, wides, arg_0));
            if (wides.element) {
                Object[] objectArray2 = new Object[]{this.schemaId};
                List wfks = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveForeignKeysWideColumnLists.rewrite(this.rewriter)).withParams(objectArray2).runOnce();
                this.inSchema(arg_0 -> AseSchemaRetriever.retrieveForeignKeys$lambda$1(wfks, arg_0));
            }
            this.inSchema(AseSchemaRetriever::retrieveForeignKeys$lambda$2);
        }

        private final void retrieveCheckConstraints() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.CHECK;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"CHECK");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List cs = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveChecks.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveCheckConstraints$lambda$0(cs, arg_0));
        }

        private final void retrieveDefaults() {
            ObjectKind objectKind = ObjectKind.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DEFAULT");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId};
            List ds = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveDefaults.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveDefaults$lambda$0(ds, this, arg_0));
        }

        private final String adjustDef(String def) {
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            String res;
            String $this$trim$iv = res = def;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default((String)(res = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"DEFAULT", (boolean)false, (int)2, null)) {
                String string = res.substring(8);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$trim$iv = string;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim2 = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                res = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            } else if (StringsKt.startsWith$default((String)res, (String)"AS", (boolean)false, (int)2, null)) {
                String string = res.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                $this$trim$iv = string;
                $i$f$trim = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim2 = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                res = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            }
            return res;
        }

        private final void cleanupTableDefaults(AseTable table, IntSet columnsWithDef) {
            ModPositioningNamingFamily<? extends AseTableColumn> modPositioningNamingFamily = table.getColumns();
            Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
            Iterable $this$forEach$iv = (Iterable)modPositioningNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseTableColumn c = (AseTableColumn)element$iv;
                boolean bl = false;
                if (columnsWithDef != null && columnsWithDef.contains((int)c.getPosition())) continue;
                c.setDefaultExpression(null);
            }
        }

        private final void retrieveTriggers() {
            if (((AseSchema)this.getSchema()).getTables().isEmpty() && ((AseSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            ObjectKind objectKind = ObjectKind.TRIGGER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TRIGGER");
            AseIntrospector.this.reportRetrieving(objectKind);
            Object[] objectArray = new Object[]{this.schemaId, this.schemaId, this.schemaId};
            List ts2 = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveTriggers.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            this.inSchema(arg_0 -> AseSchemaRetriever.retrieveTriggers$lambda$0(ts2, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void retrieveSources() {
            void this_$iv$iv$iv;
            DiagnosticSectionReference sectionReference$iv$iv$iv;
            void $this$iv$iv$iv;
            void this_$iv$iv;
            if (AseIntrospector.this.getOptions().getSources() == DBIntrospectionOptions.SourceLoading.NO_SOURCES) {
                return;
            }
            if (((AseSchema)this.getSchema()).getTables().isEmpty() && ((AseSchema)this.getSchema()).getViews().isEmpty() && ((AseSchema)this.getSchema()).getProcedureGroups().isEmpty() && ((AseSchema)this.getSchema()).getFunctions().isEmpty()) {
                return;
            }
            Object[] objectArray = new Object[]{this.schemaId, this.schemaId, this.schemaId};
            List ss = (List)this.getTransaction().query(((AseIntrospector)AseIntrospector.this).myQueries.retrieveSources.rewrite(this.rewriter)).withParams(objectArray).runOnce();
            if (ss.isEmpty()) {
                return;
            }
            Intrinsics.checkNotNull((Object)ss);
            Iterable ts2 = BaseIntrospectionFunctions.group((Iterable)ss, AseSchemaRetriever::retrieveSources$lambda$0, (Function1)retrieveSources.ts.2.INSTANCE, AseSchemaRetriever::retrieveSources$lambda$1);
            BaseNativeIntrospector this_$iv = (BaseNativeIntrospector)AseIntrospector.this;
            boolean $i$f$writeSources = false;
            BaseIntrospector baseIntrospector = (BaseIntrospector)this_$iv;
            String name$iv$iv = "WriteSources";
            boolean $i$f$doSection = false;
            void var8_8 = this_$iv$iv;
            String name$iv$iv$iv = name$iv$iv;
            CharSequence message$iv$iv$iv = null;
            boolean $i$f$logSectionBegin = false;
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)$this$iv$iv$iv);
            DiagnosticSectionReference ref$iv$iv = dataSourceDiagnosticRecorder != null ? dataSourceDiagnosticRecorder.recordSectionBegin(name$iv$iv$iv, message$iv$iv$iv) : null;
            try {
                boolean bl = false;
                this_$iv.getModel().writeSources(new Runnable(this, ts2){
                    final /* synthetic */ AseSchemaRetriever this$0;
                    final /* synthetic */ Iterable $ts$inlined;
                    {
                        this.this$0 = aseSchemaRetriever;
                        this.$ts$inlined = iterable;
                    }

                    public final void run() {
                        boolean bl = false;
                        AseSchemaRetriever.access$inSchema(this.this$0, (Function1)new Function1<AseSchema, Unit>((Iterable<SrcText>)this.$ts$inlined){
                            final /* synthetic */ Iterable<SrcText> $ts;
                            {
                                this.$ts = $ts;
                            }

                            public final void invoke(AseSchema schema) {
                                Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
                                for (SrcText t : this.$ts) {
                                    ModPositioningNamingFamily<? extends AseProcedure> modPositioningNamingFamily;
                                    ModNamingIdentifyingFamily<? extends AseTrigger> modNamingIdentifyingFamily;
                                    Object o = t.getMinor_kind() == 'G' ? (BasicModSourceAware)((modNamingIdentifyingFamily = AseIntrospectorKt.access$findTableOrView(schema, t.getMajor_kind(), t.getMajor_id())) != null && (modNamingIdentifyingFamily = modNamingIdentifyingFamily.getTriggers()) != null ? (AseTrigger)modNamingIdentifyingFamily.getByObjectId(t.getMinor_id()) : null) : (t.getMajor_kind() == 'V' ? (BasicModSourceAware)schema.getViews().getByObjectId(t.getMajor_id()) : (t.getMajor_kind() == 'F' ? (BasicModSourceAware)schema.getFunctions().getByObjectId(t.getMajor_id()) : (t.getMajor_kind() == 'P' ? (BasicModSourceAware)((modPositioningNamingFamily = (ModPositioningNamingFamily<? extends AseProcedure>)schema.getProcedureGroups().getByObjectId(t.getMajor_id())) != null && (modPositioningNamingFamily = modPositioningNamingFamily.getProcedures()) != null ? (AseProcedure)modPositioningNamingFamily.getByNaturalPosition((short)t.getMinor_id()) : null) : null)));
                                    if (o == null) continue;
                                    String string = t.getText();
                                    o.setSourceText((CompositeText)(string != null ? BaseIntrospectionFunctions.toCompositeText((String)string, (CompositeText.Kind)CompositeText.Kind.ORIGINAL_TEXT) : null));
                                }
                            }
                        });
                    }
                });
                $this$iv$iv$iv = this_$iv$iv;
                sectionReference$iv$iv$iv = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv == null) return;
            }
            catch (Throwable throwable) {
                void this_$iv$iv$iv2;
                sectionReference$iv$iv$iv = this_$iv$iv;
                DiagnosticSectionReference sectionReference$iv$iv$iv2 = ref$iv$iv;
                boolean $i$f$logSectionEnd = false;
                if (sectionReference$iv$iv$iv2 == null) throw throwable;
                DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder2 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv2);
                if (dataSourceDiagnosticRecorder2 == null) throw throwable;
                DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder2, (DiagnosticSectionReference)sectionReference$iv$iv$iv2, null, (int)2, null);
                throw throwable;
            }
            DataSourceDiagnosticRecorder dataSourceDiagnosticRecorder3 = BaseIntrospector.access$getDiagnosticRecorder((BaseIntrospector)this_$iv$iv$iv);
            if (dataSourceDiagnosticRecorder3 == null) return;
            DataSourceDiagnosticRecorder.recordSectionEnd$default((DataSourceDiagnosticRecorder)dataSourceDiagnosticRecorder3, (DiagnosticSectionReference)sectionReference$iv$iv$iv, null, (int)2, null);
        }

        private static final String _init_$lambda$0(String $catalogPrefix, String arg) {
            return Strings.replace((String)arg, (String)"#CAT", (String)$catalogPrefix);
        }

        private static final Unit retrieveGrants$lambda$0(List $grants, AseSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            AseGrantsHolder aseGrantsHolder = it;
            Intrinsics.checkNotNull((Object)$grants);
            AseIntrospectorKt.access$applyGrants(aseGrantsHolder, $grants);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveMajorNames$lambda$0(List $ms, AseSchemaRetriever this$0, AseSchema schema) {
            void families$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModFamily[] modFamilyArray = new ModFamily[4];
            Intrinsics.checkNotNullExpressionValue(schema.getTables(), (String)"getTables(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getViews(), (String)"getViews(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getFunctions(), (String)"getFunctions(...)");
            Intrinsics.checkNotNullExpressionValue(schema.getProcedureGroups(), (String)"getProcedureGroups(...)");
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            for (void f$iv : families$iv) {
                f$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            block7: for (AseIntroQueries.OneMajorName m : $ms) {
                Object family = null;
                switch (m.type) {
                    case 'S': 
                    case 'U': {
                        ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
                        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
                        family = modNamingIdentifyingFamily;
                        break;
                    }
                    case 'V': {
                        ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily = schema.getViews();
                        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getViews(...)");
                        family = modNamingIdentifyingFamily;
                        break;
                    }
                    case 'F': {
                        ModNamingIdentifyingFamily<? extends AseFunction> modNamingIdentifyingFamily = schema.getFunctions();
                        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getFunctions(...)");
                        family = modNamingIdentifyingFamily;
                        break;
                    }
                    case 'P': {
                        ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily = schema.getProcedureGroups();
                        Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getProcedureGroups(...)");
                        family = modNamingIdentifyingFamily;
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                this$0.wasProcedures = this$0.wasProcedures | m.type == 'P';
                BasicModNamedElement basicModNamedElement = family.renew((long)m.id, m.name);
                Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                AseMajorSchemaObject obj = (AseMajorSchemaObject)basicModNamedElement;
                obj.setStateNumber(m.state_nr);
            }
            for (void f$iv : families$iv) {
                f$iv.removeSyncPendingChildren();
                f$iv.sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveProcedures$lambda$0(List $ps, AseSchema schema) {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily = schema.getProcedureGroups();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getProcedureGroups(...)");
            ModNamingIdentifyingFamily<? extends AseProcedureGroup> groups = modNamingIdentifyingFamily;
            Iterable $this$map$iv = (Iterable)groups;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AseProcedureGroup aseProcedureGroup = (AseProcedureGroup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getProcedures());
            }
            ModFamily[] families$iv = (ModFamily[])((List)destination$iv$iv);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            ModFamily[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            for (AseIntroQueries.OneProcedure p : $ps) {
                AseProcedureGroup aseProcedureGroup;
                if ((AseProcedureGroup)groups.getByObjectId((long)p.id) == null) continue;
                Intrinsics.checkNotNull((Object)aseProcedureGroup);
                AseProcedureGroup group = aseProcedureGroup;
                group.getProcedures().createOrGetAt(p.procedure_position);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveColumnsAndArguments$lambda$0(List $cas, AseIntrospector this$0, AseSchemaRetriever this$1, AseSchema schema) {
            Iterator<Object> $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily = schema.getProcedureGroups();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getProcedureGroups(...)");
            Iterable $this$flatMap$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                AseProcedureGroup it = (AseProcedureGroup)element$iv$iv;
                boolean bl = false;
                ModPositioningNamingFamily<? extends AseProcedure> modPositioningNamingFamily = it.getProcedures();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getProcedures(...)");
                Iterable list$iv$iv = (Iterable)modPositioningNamingFamily;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable procedures = (List)destination$iv$iv;
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
            Iterable iterable2 = (Iterable)modNamingIdentifyingFamily2;
            ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily3 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getViews(...)");
            Iterable $this$forEach$iv = CollectionsKt.plus((Iterable)iterable2, (Iterable)((Iterable)modNamingIdentifyingFamily3));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseLikeTable it = (AseLikeTable)element$iv;
                boolean bl = false;
                it.getColumns().markChildrenAsSyncPending();
            }
            ModNamingIdentifyingFamily<? extends AseFunction> modNamingIdentifyingFamily4 = schema.getFunctions();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getFunctions(...)");
            $this$forEach$iv = CollectionsKt.plus((Iterable)((Iterable)modNamingIdentifyingFamily4), (Iterable)procedures);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseRoutine it = (AseRoutine)element$iv;
                boolean bl = false;
                it.getArguments().markChildrenAsSyncPending();
            }
            AseMajorObject obj = null;
            int objId = Integer.MIN_VALUE;
            for (AseIntroQueries.OneColumnOrArgument ca : $cas) {
                if (obj == null || objId != ca.id) {
                    obj = AseIntrospectorKt.access$findObjectById(schema, ca.id);
                    objId = ca.id;
                    if (obj == null) continue;
                }
                DataType dt = AseIntrospectorKt.access$makeDataType(ca.type_name, ca.length, ca.prec, ca.scale, ca.variable, this$0.getServerVersion());
                if (obj instanceof AseLikeTable) {
                    short $this$and$iv;
                    AseLikeColumn column = (AseLikeColumn)((AseLikeTable)obj).getColumns().createOrGet(ca.name);
                    column.setPosition(ca.colid);
                    column.setStoredType(DasUnresolvedTypeReference.Companion.of(dt));
                    short element$iv$iv = ca.bits1;
                    short that$iv = 8;
                    boolean $i$f$and = false;
                    short $this$toUnsignedInt$iv$iv = $this$and$iv;
                    boolean $i$f$toUnsignedInt = false;
                    int n = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                    $this$toUnsignedInt$iv$iv = that$iv;
                    $i$f$toUnsignedInt = false;
                    column.setNotNull((short)(n & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) == 0);
                    $this$and$iv = ca.bits2;
                    that$iv = 16;
                    $i$f$and = false;
                    $this$toUnsignedInt$iv$iv = $this$and$iv;
                    $i$f$toUnsignedInt = false;
                    int n2 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                    $this$toUnsignedInt$iv$iv = that$iv;
                    $i$f$toUnsignedInt = false;
                    column.setComputed((short)(n2 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                    if (column instanceof AseTableColumn) {
                        $this$and$iv = ca.bits1;
                        that$iv = 128;
                        $i$f$and = false;
                        $this$toUnsignedInt$iv$iv = $this$and$iv;
                        $i$f$toUnsignedInt = false;
                        int n3 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                        $this$toUnsignedInt$iv$iv = that$iv;
                        $i$f$toUnsignedInt = false;
                        ((AseTableColumn)column).setSequenceIdentity((SequenceIdentity)((short)(n3 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0 ? SequenceIdentity.UNKNOWN : null));
                    }
                }
                if (obj instanceof BasicModRoutine) {
                    BasicModRoutine basicModRoutine = (BasicModRoutine)obj;
                    Intrinsics.checkNotNull((Object)ca);
                    this$1.addRoutineArgument(basicModRoutine, ca, dt);
                }
                if (!(obj instanceof AseProcedureGroup)) continue;
                AseProcedure procedure = (AseProcedure)((AseProcedureGroup)obj).getProcedures().createOrGetAt(ca.procedure_position);
                Intrinsics.checkNotNull((Object)procedure);
                BasicModRoutine basicModRoutine = procedure;
                Intrinsics.checkNotNull((Object)ca);
                this$1.addRoutineArgument(basicModRoutine, ca, dt);
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily5 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getTables(...)");
            Iterable iterable3 = (Iterable)modNamingIdentifyingFamily5;
            ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily6 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily6, (String)"getViews(...)");
            Iterable $this$forEach$iv2 = CollectionsKt.plus((Iterable)iterable3, (Iterable)((Iterable)modNamingIdentifyingFamily6));
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AseLikeTable it = (AseLikeTable)element$iv;
                boolean bl = false;
                ModPositioningNamingFamily<? extends AseLikeColumn> modPositioningNamingFamily = it.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                AseIntrospectorKt.access$finish((ModFamily)modPositioningNamingFamily);
            }
            ModNamingIdentifyingFamily<? extends AseFunction> modNamingIdentifyingFamily7 = schema.getFunctions();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily7, (String)"getFunctions(...)");
            $this$forEach$iv2 = CollectionsKt.plus((Iterable)((Iterable)modNamingIdentifyingFamily7), (Iterable)procedures);
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AseRoutine it = (AseRoutine)element$iv;
                boolean bl = false;
                ModPositioningNamingFamily<? extends AseArgument> modPositioningNamingFamily = it.getArguments();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getArguments(...)");
                AseIntrospectorKt.access$finish((ModFamily)modPositioningNamingFamily);
            }
            ModNamingIdentifyingFamily<? extends AseProcedureGroup> modNamingIdentifyingFamily8 = schema.getProcedureGroups();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily8, (String)"getProcedureGroups(...)");
            $this$forEach$iv2 = (Iterable)modNamingIdentifyingFamily8;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                AseProcedureGroup it = (AseProcedureGroup)element$iv;
                boolean bl = false;
                it.getProcedures().sort();
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveIndicesAndKeys$lambda$0(List $inds, AseSchemaRetriever this$0, AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            AseTable table = null;
            int tableId = Integer.MIN_VALUE;
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Object $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                AseTable it = (AseTable)element$iv;
                boolean bl = false;
                it.getIndices().markChildrenAsSyncPending();
                it.getKeys().markChildrenAsSyncPending();
            }
            for (AseIntroQueries.OneIndex ind : $inds) {
                void $this$and$iv;
                short $this$and$iv2;
                if (table == null || tableId != ind.id) {
                    if ((AseTable)schema.getTables().getByObjectId((long)ind.id) == null) continue;
                    tableId = ind.id;
                }
                AseIndex index = (AseIndex)table.getIndices().createOrGet(ind.name);
                index.setPosition(ind.position);
                short element$iv = ind.bits2;
                short that$iv = 8;
                boolean $i$f$and = false;
                short $this$toUnsignedInt$iv$iv = $this$and$iv2;
                boolean $i$f$toUnsignedInt = false;
                int n = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                $this$toUnsignedInt$iv$iv = that$iv;
                $i$f$toUnsignedInt = false;
                index.setNameSurrogate((short)(n & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                $this$and$iv2 = ind.bits1;
                that$iv = 16;
                $i$f$and = false;
                $this$toUnsignedInt$iv$iv = $this$and$iv2;
                $i$f$toUnsignedInt = false;
                int n2 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                $this$toUnsignedInt$iv$iv = that$iv;
                $i$f$toUnsignedInt = false;
                index.setClustering((short)(n2 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                $this$and$iv2 = ind.bits1;
                that$iv = 2;
                $i$f$and = false;
                $this$toUnsignedInt$iv$iv = $this$and$iv2;
                $i$f$toUnsignedInt = false;
                int n3 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                $this$toUnsignedInt$iv$iv = that$iv;
                $i$f$toUnsignedInt = false;
                index.setUnique((short)(n3 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) != 0);
                if (ind.keys1 != null) {
                    byte[] keys = null;
                    Object object = ind.keys1;
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                    byte[] keys1 = (byte[])object;
                    if (ind.keys2 == null) {
                        keys = keys1;
                    } else {
                        Object object2 = ind.keys2;
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.ByteArray");
                        byte[] keys2 = (byte[])object2;
                        keys = new byte[keys1.length + keys2.length];
                        System.arraycopy(keys1, 0, keys, 0, keys1.length);
                        System.arraycopy(keys2, 0, keys, keys1.length, keys2.length);
                    }
                    Intrinsics.checkNotNull((Object)index);
                    this$0.peekIndexColumns(index, keys);
                }
                short keys = ind.bits2;
                that$iv = 2;
                $i$f$and = false;
                $this$toUnsignedInt$iv$iv = $this$and$iv;
                $i$f$toUnsignedInt = false;
                int n4 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv);
                $this$toUnsignedInt$iv$iv = that$iv;
                $i$f$toUnsignedInt = false;
                if ((short)(n4 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv)) == 0) continue;
                AseKey key = (AseKey)table.getKeys().createOrGet(ind.name);
                key.setNameSurrogate(index.isNameSurrogate());
                key.setUnderlyingIndexRef((BasicReference)BasicNameReference.create((String)ind.name));
                that$iv = ind.bits1;
                short that$iv2 = 2048;
                boolean $i$f$and2 = false;
                short $this$toUnsignedInt$iv$iv2 = $this$and$iv;
                boolean $i$f$toUnsignedInt2 = false;
                int n5 = Short.toUnsignedInt($this$toUnsignedInt$iv$iv2);
                $this$toUnsignedInt$iv$iv2 = that$iv2;
                $i$f$toUnsignedInt2 = false;
                key.setPrimary((short)(n5 & Short.toUnsignedInt($this$toUnsignedInt$iv$iv2)) != 0);
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
            $this$forEach$iv = (Iterable)modNamingIdentifyingFamily2;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                AseTable it = (AseTable)element$iv;
                boolean bl = false;
                ModPositioningNamingFamily<? extends AseIndex> modPositioningNamingFamily = it.getIndices();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getIndices(...)");
                AseIntrospectorKt.access$finish((ModFamily)modPositioningNamingFamily);
                ModNamingIdentifyingFamily<? extends AseKey> modNamingIdentifyingFamily3 = it.getKeys();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getKeys(...)");
                AseIntrospectorKt.access$finish((ModFamily)modNamingIdentifyingFamily3);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignKeys$lambda$0(List $fks, Ref.BooleanRef $wides, AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseTable it = (AseTable)element$iv;
                boolean bl = false;
                it.getForeignKeys().markChildrenAsSyncPending();
            }
            for (AseIntroQueries.OneForeignKey fk : $fks) {
                AseTable table;
                if ((AseTable)schema.getTables().getByObjectId(fk.source_table_id) == null) continue;
                BasicModNamedElement basicModNamedElement = table.getForeignKeys().renew((long)fk.source_constraint_id, fk.source_constraint_name);
                Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                AseForeignKey foreignKey = (AseForeignKey)basicModNamedElement;
                foreignKey.setNameSurrogate(AseIntrospectorKt.access$detectSurrogateName(fk.source_constraint_name, fk.source_constraint_id));
                BasicIdReference idRef = BasicIdReference.create((long)fk.target_table_id);
                foreignKey.setRefTableRef(BasicIdOrNameReference.create((BasicIdReference)idRef, (BasicReference)BasicMetaUtils.createPortableReference((BasicElement)((BasicElement)foreignKey), (BasicMetaReferenceId)BasicModForeignKey.REF_TABLE_REF, (BasicReference)((BasicReference)idRef))));
                foreignKey.setRefIndexRef((BasicReference)BasicPositionReference.create((short)fk.target_index_position));
                short n = fk.involved_columns_count;
                if (n <= 4) {
                    short[] columnPositions = new short[n];
                    if (n >= 1) {
                        columnPositions[0] = fk.column_position_1;
                    }
                    if (n >= 2) {
                        columnPositions[1] = fk.column_position_2;
                    }
                    if (n >= 3) {
                        columnPositions[2] = fk.column_position_3;
                    }
                    if (n >= 4) {
                        columnPositions[3] = fk.column_position_4;
                    }
                    AseIntrospectorKt.access$assignForeignKeyColumns(foreignKey, columnPositions);
                    continue;
                }
                $wides.element = true;
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignKeys$lambda$1(List $wfks, AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            for (int[] wfk : $wfks) {
                AseForeignKey foreignKey;
                int n;
                int constraintId = wfk[0];
                if (AseIntrospectorKt.access$findForeignKeyById(schema, constraintId) == null) continue;
                for (n = 0; n < 16 && wfk[n + 1] > 0; ++n) {
                }
                short[] columnPositions = new short[n];
                int n2 = n;
                for (int i = 0; i < n2; ++i) {
                    columnPositions[i] = (short)wfk[i + 1];
                }
                AseIntrospectorKt.access$assignForeignKeyColumns(foreignKey, columnPositions);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveForeignKeys$lambda$2(AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseTable it = (AseTable)element$iv;
                boolean bl = false;
                ModNamingIdentifyingFamily<? extends AseForeignKey> modNamingIdentifyingFamily2 = it.getForeignKeys();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getForeignKeys(...)");
                AseIntrospectorKt.access$finish((ModFamily)modNamingIdentifyingFamily2);
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveCheckConstraints$lambda$0(List $cs, AseSchema schema) {
            AseTable it;
            Object element$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Object $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (AseTable)element$iv;
                boolean bl = false;
                it.getChecks().markChildrenAsSyncPending();
            }
            for (AseIntroQueries.OneCheck c : $cs) {
                AseTableColumn aseTableColumn;
                AseTable table;
                if ((AseTable)schema.getTables().getByObjectId(c.table_id) == null) continue;
                BasicModNamedElement basicModNamedElement = table.getChecks().renew((long)c.constraint_id, c.constraint_name);
                Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                AseCheck check = (AseCheck)basicModNamedElement;
                check.setNameSurrogate(AseIntrospectorKt.access$detectSurrogateName(c.constraint_name, c.constraint_id));
                if (c.definition != null) {
                    String s;
                    int len;
                    void $this$trim$iv;
                    String string = c.definition;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"definition");
                    int p = StringsKt.indexOf$default((CharSequence)string, (String)"CHECK", (int)0, (boolean)false, (int)6, null);
                    p = p >= 0 ? p + 5 : 0;
                    String string2 = c.definition;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"definition");
                    Intrinsics.checkNotNullExpressionValue((Object)string2.substring(p), (String)"substring(...)");
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if ((len = (s = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length()) >= 3 && s.charAt(0) == '(' && s.charAt(len - 1) == ')') {
                        void $this$trim$iv2;
                        Intrinsics.checkNotNullExpressionValue((Object)s.substring(1, len - 1), (String)"substring(...)");
                        boolean $i$f$trim3 = false;
                        CharSequence $this$trim$iv$iv2 = (CharSequence)$this$trim$iv2;
                        boolean $i$f$trim4 = false;
                        int startIndex$iv$iv2 = 0;
                        int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
                        boolean startFound$iv$iv2 = false;
                        while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                            char it3 = $this$trim$iv$iv2.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it3, (int)32) <= 0;
                            if (!startFound$iv$iv2) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv2 = true;
                                    continue;
                                }
                                ++startIndex$iv$iv2;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv2;
                        }
                        s = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
                    }
                    check.setPredicate(s);
                } else {
                    check.setPredicate(null);
                }
                if (c.column_position > 0) {
                    Object v8;
                    block15: {
                        AseTable aseTable = check.getTable();
                        Intrinsics.checkNotNull((Object)aseTable);
                        ModPositioningNamingFamily<? extends AseTableColumn> modPositioningNamingFamily = aseTable.getColumns();
                        Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                        Iterable $this$firstOrNull$iv = (Iterable)modPositioningNamingFamily;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv2 : $this$firstOrNull$iv) {
                            AseTableColumn col = (AseTableColumn)element$iv2;
                            boolean bl = false;
                            if (!(col.getPosition() == c.column_position)) continue;
                            v8 = element$iv2;
                            break block15;
                        }
                        v8 = null;
                    }
                    aseTableColumn = v8;
                } else {
                    aseTableColumn = null;
                }
                AseTableColumn column = aseTableColumn;
                AseTableColumn aseTableColumn2 = column;
                check.setColNames(aseTableColumn2 != null ? Collections.singletonList(aseTableColumn2.getName()) : CollectionsKt.emptyList());
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getTables(...)");
            $this$forEach$iv = (Iterable)modNamingIdentifyingFamily2;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (AseTable)element$iv;
                boolean bl = false;
                ModNamingIdentifyingFamily<? extends AseCheck> modNamingIdentifyingFamily3 = it.getChecks();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getChecks(...)");
                AseIntrospectorKt.access$finish((ModFamily)modNamingIdentifyingFamily3);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDefaults$lambda$0(List $ds, AseSchemaRetriever this$0, AseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            AseTable obj = null;
            int objectId = Integer.MIN_VALUE;
            IntOpenHashSet tablesWithDefs = new IntOpenHashSet();
            IntOpenHashSet columnsWithDefs = new IntOpenHashSet();
            for (AseIntroQueries.OneDefault d : $ds) {
                Object it;
                if (obj == null || objectId != d.id) {
                    if (obj != null) {
                        boolean bl = false;
                        this$0.cleanupTableDefaults((AseTable)it, (IntSet)columnsWithDefs);
                    }
                    obj = (AseTable)schema.getTables().getByObjectId(d.id);
                    objectId = d.id;
                    if (obj == null) continue;
                    columnsWithDefs.clear();
                    tablesWithDefs.add(objectId);
                }
                columnsWithDefs.add((int)d.position);
                String string = d.text;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                String def = this$0.adjustDef(string);
                if ((AseTableColumn)obj.getColumns().getByNaturalPosition(d.position) == null) continue;
                Object $this$retrieveDefaults_u24lambda_u240_u241 = it;
                boolean bl = false;
                $this$retrieveDefaults_u24lambda_u240_u241.setDefaultExpression(def);
            }
            AseTable aseTable = obj;
            if (aseTable != null) {
                AseTable it = aseTable;
                boolean bl = false;
                this$0.cleanupTableDefaults(it, (IntSet)columnsWithDefs);
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingIdentifyingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AseTable tab = (AseTable)element$iv;
                boolean bl = false;
                if (tablesWithDefs.contains((int)tab.getObjectId())) continue;
                Intrinsics.checkNotNull((Object)tab);
                this$0.cleanupTableDefaults(tab, null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTriggers$lambda$0(List $ts, AseSchema schema) {
            AseLikeTable it;
            Object element$iv;
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily, (String)"getTables(...)");
            Iterable iterable = (Iterable)modNamingIdentifyingFamily;
            ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily2 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily2, (String)"getViews(...)");
            Object $this$forEach$iv = CollectionsKt.plus((Iterable)iterable, (Iterable)((Iterable)modNamingIdentifyingFamily2));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (AseLikeTable)element$iv;
                boolean bl = false;
                it.getTriggers().markChildrenAsSyncPending();
            }
            for (AseIntroQueries.OneTrigger t : $ts) {
                AseLikeTable aseLikeTable;
                AseTable aseTable = (AseTable)schema.getTables().getByObjectId(t.table_id);
                if (aseTable != null) {
                    aseLikeTable = aseTable;
                } else {
                    AseView aseView = (AseView)schema.getViews().getByObjectId(t.table_id);
                    if (aseView == null) continue;
                    aseLikeTable = aseView;
                }
                AseLikeTable table = aseLikeTable;
                BasicModNamedElement basicModNamedElement = table.getTriggers().renew((long)t.trig_id, t.trig_name);
                Intrinsics.checkNotNullExpressionValue((Object)basicModNamedElement, (String)"renew(...)");
                AseTrigger trigger = (AseTrigger)basicModNamedElement;
                TrigEvent event = TrigEvent.of((char)t.event_code);
                AseIntrospectorKt.access$addEvent(trigger, event);
                trigger.setStateNumber(t.state_nr);
                trigger.setTurn(t.turn_code == 'I' ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
            }
            ModNamingIdentifyingFamily<? extends AseTable> modNamingIdentifyingFamily3 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily3, (String)"getTables(...)");
            Iterable iterable2 = (Iterable)modNamingIdentifyingFamily3;
            ModNamingIdentifyingFamily<? extends AseView> modNamingIdentifyingFamily4 = schema.getViews();
            Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily4, (String)"getViews(...)");
            $this$forEach$iv = CollectionsKt.plus((Iterable)iterable2, (Iterable)((Iterable)modNamingIdentifyingFamily4));
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (AseLikeTable)element$iv;
                boolean bl = false;
                ModNamingIdentifyingFamily<? extends AseTrigger> modNamingIdentifyingFamily5 = it.getTriggers();
                Intrinsics.checkNotNullExpressionValue(modNamingIdentifyingFamily5, (String)"getTriggers(...)");
                AseIntrospectorKt.access$finish((ModFamily)modNamingIdentifyingFamily5);
            }
            return Unit.INSTANCE;
        }

        private static final boolean retrieveSources$lambda$0(AseIntroQueries.OneSource a, AseIntroQueries.OneSource b) {
            return a.major_id == b.major_id && a.major_kind == b.major_kind && a.minor_id == b.minor_id && a.minor_kind == b.minor_kind;
        }

        private static final SrcText retrieveSources$lambda$1(SrcText x, AseIntroQueries.OneSource os) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            return SrcText.copy$default(x, '\u0000', '\u0000', 0, 0, AseIntrospectorKt.access$joinSourceTextParts(x.getText(), os.text), 15, null);
        }

        public static final /* synthetic */ void access$inSchema(AseSchemaRetriever $this, Function1 modifier) {
            $this.inSchema(modifier);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "isIncremental", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.sybase"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{15};
            return version.isOrGreater(nArray);
        }

        public boolean isIncremental() {
            return true;
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return (DBIntrospector)new AseIntrospector(context, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return AseIntrospectorKt.access$canCheckOutdated(e);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/sybase/introspector/AseIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.sybase"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

