/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.find;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.find.FindUsagesHandlerKt;
import com.intellij.kotlin.jupyter.core.editor.find.NotebookReferenceFinder;
import com.intellij.kotlin.jupyter.core.editor.find.PsiRefHelpersKt;
import com.intellij.kotlin.jupyter.core.editor.find.ReferenceSearchStrategy;
import com.intellij.kotlin.jupyter.core.scriptingSupport.NotebookStructureTrackerService;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterNotebook;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"searchForElementDeclarationOrUsages", "", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "target", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "searchStrategy", "Lcom/intellij/kotlin/jupyter/core/editor/find/ReferenceSearchStrategy;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\npsiAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 psiAware.kt\ncom/intellij/kotlin/jupyter/core/editor/find/PsiAwareKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,87:1\n27#2:88\n*S KotlinDebug\n*F\n+ 1 psiAware.kt\ncom/intellij/kotlin/jupyter/core/editor/find/PsiAwareKt\n*L\n38#1:88\n*E\n"})
public final class PsiAwareKt {
    @Nullable
    public static final Set<PsiElement> searchForElementDeclarationOrUsages(@NotNull Project project, @NotNull PsiElement target, @NotNull VirtualFile virtualFile, @NotNull ReferenceSearchStrategy searchStrategy) {
        Set<String> targetClassName;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)((Object)searchStrategy), (String)"searchStrategy");
        if (!IsKotlinNotebookKt.isKotlinNotebook(virtualFile)) {
            return null;
        }
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)project);
        Set foundData = new LinkedHashSet();
        PsiFile psiFile = UtilKt.findPsiFile(virtualFile, project);
        if (psiFile == null) {
            return null;
        }
        PsiFile asPsiFile = psiFile;
        PsiElement[] psiElementArray = asPsiFile.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object object = ArraysKt.firstOrNull((Object[])psiElementArray);
        Object object2 = object instanceof JupyterNotebook ? (JupyterNotebook)object : null;
        if (object2 == null || (object2 = object2.getPsiCellList()) == null) {
            return null;
        }
        Object notebookCells = object2;
        Map<Integer, Set<String>> ordinalMap = NotebookStructureTrackerService.Companion.getForFile(project, BackedNotebookVirtualFile.Companion.takeBackend(virtualFile)).getCellOrdinalToClassNameStructure();
        InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)project);
        PsiLanguageInjectionHost targetHost = injectionManager.getInjectionHost((PsiElement)target.getContainingFile());
        boolean condition$iv = searchStrategy == ReferenceSearchStrategy.REFERENCES;
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            PsiLanguageInjectionHost psiLanguageInjectionHost = targetHost;
            if (psiLanguageInjectionHost != null) {
                PsiLanguageInjectionHost it = psiLanguageInjectionHost;
                boolean bl2 = false;
                Set<String> name = ordinalMap.get(CollectionsKt.indexOf((List)notebookCells, (Object)it));
                if (it.getUserData(NotebookReferenceFinder.INSTANCE.getCELL_CLASS_NAME()) == null && name != null) {
                    it.putUserData(NotebookReferenceFinder.INSTANCE.getCELL_CLASS_NAME(), name);
                }
                v4 = name;
            } else {
                v4 = null;
            }
        } else {
            v4 = targetClassName = null;
        }
        if (target.getParent() == null) {
            return null;
        }
        PsiFile targetContainingFile = target.getContainingFile();
        Ref.BooleanRef isLocalSearch = new Ref.BooleanRef();
        if (searchStrategy == ReferenceSearchStrategy.REFERENCES) {
            PsiLanguageInjectionHost psiLanguageInjectionHost = targetHost;
            v6 = (psiLanguageInjectionHost != null ? (Set)psiLanguageInjectionHost.getUserData(NotebookReferenceFinder.INSTANCE.getCELL_CLASS_NAME()) : null) == null && !FindUsagesHandlerKt.isCompiledCellClassDeclaration(target);
        } else {
            v6 = isLocalSearch.element = false;
        }
        if (!isLocalSearch.element) {
            String string = targetContainingFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)".kotlinx.dataframe.", (boolean)false, (int)2, null)) {
                isLocalSearch.element = PsiRefHelpersKt.isItGeneratedNameInsideLambdaCall(target, target);
            }
        }
        Object properContainer = isLocalSearch.element ? CollectionsKt.listOf((Object)injectionManager.getInjectionHost((PsiElement)targetContainingFile)) : notebookCells;
        return (Set)ActionsKt.runReadAction(() -> PsiAwareKt.searchForElementDeclarationOrUsages$lambda$1((List)properContainer, isLocalSearch, (List)notebookCells, injectedManager, target, targetContainingFile, searchStrategy, ordinalMap, injectionManager, targetClassName, foundData));
    }

    private static final Set searchForElementDeclarationOrUsages$lambda$1(List $properContainer, Ref.BooleanRef $isLocalSearch, List $notebookCells, InjectedLanguageManager $injectedManager, PsiElement $target, PsiFile $targetContainingFile, ReferenceSearchStrategy $searchStrategy, Map $ordinalMap, InjectedLanguageManager $injectionManager, Set $targetClassName, Set $foundData) {
        int n = ((Collection)$properContainer).size();
        for (int ind = 0; ind < n; ++ind) {
            PsiElement psiFile;
            PsiLanguageInjectionHost gotHost;
            PsiLanguageInjectionHost host2;
            List list;
            if ((PsiLanguageInjectionHost)$properContainer.get(ind) == null || (list = $injectedManager.getInjectedPsiFiles((PsiElement)(host2 = $isLocalSearch.element ? gotHost : (PsiLanguageInjectionHost)$notebookCells.get(ind)))) == null || (list = (Pair)CollectionsKt.firstOrNull((List)list)) == null) continue;
            List firstInjectedFileInfo = list;
            if ((PsiElement)((Pair)firstInjectedFileInfo).first == null) continue;
            if ($target.getParent() == null) break;
            if (!(psiFile instanceof KtFile) || Intrinsics.areEqual((Object)psiFile, (Object)$targetContainingFile) && $searchStrategy == ReferenceSearchStrategy.DECLARATION) continue;
            Object[] objectArray = ((KtFile)psiFile).findChildrenByClass(KtScript.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findChildrenByClass(...)");
            KtScript ktScript = (KtScript)ArraysKt.firstOrNull((Object[])objectArray);
            if (ktScript == null || (ktScript = ktScript.getBlockExpression()) == null) continue;
            KtScript scriptBlock = ktScript;
            List elements = new ArrayList();
            Set possibleClassName = (Set)$ordinalMap.get(ind);
            Intrinsics.checkNotNull((Object)$injectionManager);
            Intrinsics.checkNotNull((Object)host2);
            Set set = $targetClassName;
            if (set == null) {
                set = possibleClassName;
            }
            NotebookReferenceFinder.INSTANCE.traverseChildrenAndSearch($injectionManager, host2, set, (PsiElement)scriptBlock, $target, $searchStrategy, elements);
            if ($searchStrategy == ReferenceSearchStrategy.DECLARATION) {
                NavigatablePsiElement first = (NavigatablePsiElement)CollectionsKt.firstOrNull((List)elements);
                if (first == null) continue;
                $foundData.add(first);
                break;
            }
            CollectionsKt.addAll((Collection)$foundData, (Iterable)elements);
        }
        return $foundData;
    }
}

