/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.ide;

import com.intellij.ide.FileIconProvider;
import com.intellij.jupyter.core.executor.JupyterExecutionManager;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.KotlinJupyterIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kotlin/jupyter/core/ide/KotlinNotebookFileIconProvider;", "Lcom/intellij/ide/FileIconProvider;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "flags", "", "project", "Lcom/intellij/openapi/project/Project;", "isRunningNotebook", "", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookFileIconProvider
implements FileIconProvider {
    @Nullable
    public Icon getIcon(@NotNull VirtualFile file, int flags, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!IsKotlinNotebookKt.isKotlinNotebook(file)) {
            return null;
        }
        return this.isRunningNotebook(file, project) ? KotlinJupyterIcons.FileIconRunning : KotlinJupyterIcons.FileIcon;
    }

    private final boolean isRunningNotebook(VirtualFile file, Project project) {
        if (project == null) {
            return false;
        }
        return JupyterExecutionManager.Companion.getInstance(project, file).hasSession();
    }
}

