/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server;

import com.intellij.jupyter.core.jupyter.connections.session.KernelStartupOptions;
import com.intellij.jupyter.execution.kernel.KernelRunnableFactory;
import com.intellij.jupyter.execution.kernel.KernelRunnableHandler;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunMode;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunModeKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/ModeAwareKernelRunnableFactory;", "Lcom/intellij/jupyter/execution/kernel/KernelRunnableFactory;", "mode", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookSessionRunMode;", "<init>", "(Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookSessionRunMode;)V", "startProcess", "Lcom/intellij/jupyter/execution/kernel/KernelRunnableHandler;", "startupOptions", "Lcom/intellij/jupyter/core/jupyter/connections/session/KernelStartupOptions;", "(Lcom/intellij/jupyter/core/jupyter/connections/session/KernelStartupOptions;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSpecificKernelRunnableHandler", "intellij.kotlin.jupyter.core"})
public abstract class ModeAwareKernelRunnableFactory
implements KernelRunnableFactory {
    @NotNull
    private final KotlinNotebookSessionRunMode mode;

    public ModeAwareKernelRunnableFactory(@NotNull KotlinNotebookSessionRunMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mode = mode;
    }

    @Nullable
    public final Object startProcess(@NotNull KernelStartupOptions startupOptions, @NotNull Continuation<? super KernelRunnableHandler> $completion) {
        if (!IsKotlinNotebookKt.isKotlinNotebook(startupOptions.getNotebookVirtualFile())) {
            return null;
        }
        KotlinNotebookSessionRunMode currentMode = KotlinNotebookSessionRunModeKt.getSessionRunMode(startupOptions.getNotebookVirtualFile(), startupOptions.getProject());
        if (currentMode != this.mode) {
            return null;
        }
        return this.createSpecificKernelRunnableHandler(startupOptions);
    }

    @NotNull
    protected abstract KernelRunnableHandler createSpecificKernelRunnableHandler(@NotNull KernelStartupOptions var1);
}

