/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.api;

import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.MimeTypedResult;
import org.jetbrains.kotlinx.jupyter.api.ResultsKt;
import org.jetbrains.kotlinx.jupyter.api.libraries.ColorScheme;
import org.jetbrains.kotlinx.jupyter.util.HtmlUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u001b\u001a\u00020\u0010J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\u0012\u0010\u001c\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlinx/jupyter/api/HtmlData;", "", "style", "", "body", "script", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "getScript", "getStyle", "component1", "component2", "component3", "copy", "equals", "", "other", "generateIframePlaneText", "colorScheme", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/ColorScheme;", "hashCode", "", "plus", "toIFrame", "Lorg/jetbrains/kotlinx/jupyter/api/MimeTypedResult;", "toSimpleHtml", "isolated", "toString", "Companion", "api"})
public final class HtmlData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String style;
    @NotNull
    private final String body;
    @NotNull
    private final String script;
    @NotNull
    private static final AtomicLong iframeCounter = new AtomicLong();

    public HtmlData(@NotNull String style, @NotNull String body, @NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.style = style;
        this.body = body;
        this.script = script;
    }

    @NotNull
    public final String getStyle() {
        return this.style;
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    @NotNull
    public final String getScript() {
        return this.script;
    }

    @NotNull
    public String toString() {
        return this.toString(null);
    }

    @Language(value="html")
    @NotNull
    public final String toString(@Nullable ColorScheme colorScheme) {
        return StringsKt.trimIndent((String)("\n        <html" + (colorScheme == ColorScheme.DARK ? " theme='dark'" : "") + ">\n        <head>\n            <style type=\"text/css\">\n                " + this.style + "\n            </style>\n        </head>\n        <body>\n            " + this.body + "\n        </body>\n        <script>\n            " + this.script + "\n        </script>\n        </html>\n        "));
    }

    @NotNull
    public final MimeTypedResult toSimpleHtml(@Nullable ColorScheme colorScheme, boolean isolated) {
        return ResultsKt.HTML(this.toString(colorScheme), isolated);
    }

    public static /* synthetic */ MimeTypedResult toSimpleHtml$default(HtmlData htmlData, ColorScheme colorScheme, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return htmlData.toSimpleHtml(colorScheme, bl);
    }

    @NotNull
    public final MimeTypedResult toIFrame(@Nullable ColorScheme colorScheme) {
        String iFramedText = this.generateIframePlaneText(colorScheme);
        return ResultsKt.htmlResult(iFramedText, false);
    }

    @NotNull
    public final String generateIframePlaneText(@Nullable ColorScheme colorScheme) {
        HtmlData styleData = new HtmlData(":root {\n    --scroll-bg: #f5f5f5;\n    --scroll-fg: #b3b3b3;\n}\n:root[theme=\"dark\"], :root [data-jp-theme-light=\"false\"]{\n    --scroll-bg: #3c3c3c;\n    --scroll-fg: #97e1fb;\n}\nbody {\n    scrollbar-color: var(--scroll-fg) var(--scroll-bg);\n}\nbody::-webkit-scrollbar {\n    width: 10px; /* Mostly for vertical scrollbars */\n    height: 10px; /* Mostly for horizontal scrollbars */\n}\nbody::-webkit-scrollbar-thumb {\n    background-color: var(--scroll-fg);\n}\nbody::-webkit-scrollbar-track {\n    background-color: var(--scroll-bg);\n}", "", "");
        HtmlData wholeData = this.plus(styleData);
        String text2 = wholeData.toString(colorScheme);
        String id = "iframe_out_" + iframeCounter.incrementAndGet();
        String fName = "resize_" + id;
        String cleanText = HtmlUtilKt.escapeForIframe(text2);
        String iFramedText = StringsKt.trimIndent((String)("\n            <iframe onload=\"o_" + fName + "()\" style=\"width:100%;\" class=\"result_container\" id=\"" + id + "\" frameBorder=\"0\" srcdoc=\"" + cleanText + "\"></iframe>\n            <script>\n                function o_" + fName + "() {\n                    let elem = document.getElementById(\"" + id + "\");\n                    " + fName + "(elem);\n                    setInterval(" + fName + ", 5000, elem);\n                }\n                function " + fName + "(el) {\n                    let h = el.contentWindow.document.body.scrollHeight;\n                    el.height = h === 0 ? 0 : h + 41;\n                }\n            </script>\n            "));
        return iFramedText;
    }

    @NotNull
    public final HtmlData plus(@NotNull HtmlData other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new HtmlData(this.style + "\n" + other.style, this.body + "\n" + other.body, this.script + "\n" + other.script);
    }

    @NotNull
    public final String component1() {
        return this.style;
    }

    @NotNull
    public final String component2() {
        return this.body;
    }

    @NotNull
    public final String component3() {
        return this.script;
    }

    @NotNull
    public final HtmlData copy(@NotNull String style, @NotNull String body, @NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return new HtmlData(style, body, script);
    }

    public static /* synthetic */ HtmlData copy$default(HtmlData htmlData, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = htmlData.style;
        }
        if ((n & 2) != 0) {
            string2 = htmlData.body;
        }
        if ((n & 4) != 0) {
            string3 = htmlData.script;
        }
        return htmlData.copy(string, string2, string3);
    }

    public int hashCode() {
        int result2 = this.style.hashCode();
        result2 = result2 * 31 + this.body.hashCode();
        result2 = result2 * 31 + this.script.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HtmlData)) {
            return false;
        }
        HtmlData htmlData = (HtmlData)other;
        if (!Intrinsics.areEqual((Object)this.style, (Object)htmlData.style)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)htmlData.body)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.script, (Object)htmlData.script);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlinx/jupyter/api/HtmlData$Companion;", "", "()V", "iframeCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

