/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.common;

import java.io.File;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.common.CommonLoggerFactory;
import org.jetbrains.kotlinx.jupyter.common.ExceptionsHandler;
import org.jetbrains.kotlinx.jupyter.common.HttpClient;
import org.jetbrains.kotlinx.jupyter.common.HttpUtilKt;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.common.ResponseKt;
import org.jetbrains.kotlinx.jupyter.common.ResponseWrapper;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 N2\u00020\u0001:\u0001NB_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0012\u0010&\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\b\u0010-\u001a\u00020\u0003H\u0016J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\b\u0010/\u001a\u00020\u0003H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\rH\u0016J\u001c\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\u00032\b\u00106\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u00107\u001a\u0004\u0018\u00010\u00032\u0006\u00105\u001a\u00020\u0003H\u0016J\u0018\u00108\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J\u0010\u00109\u001a\u0002012\u0006\u00105\u001a\u00020\u0003H\u0016J\u0012\u0010:\u001a\u0002012\b\u0010;\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u00105\u001a\u00020\u0003H\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0003H\u0002J\u0018\u0010A\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0002J\u0018\u0010C\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0002J\u0018\u0010D\u001a\u00020\u00032\u0006\u0010B\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0002J\u0010\u0010E\u001a\u00020=2\u0006\u00105\u001a\u00020\u0003H\u0002J\u0016\u0010F\u001a\u00020=*\u00020\r2\b\b\u0002\u0010G\u001a\u00020\u0003H\u0002J-\u0010H\u001a\u0004\u0018\u0001HI\"\u0004\b\u0000\u0010I2\b\b\u0002\u0010J\u001a\u00020\u00032\f\u0010K\u001a\b\u0012\u0004\u0012\u0002HI0LH\u0002\u00a2\u0006\u0002\u0010MR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001d\u0010\"\u001a\u0004\u0018\u00010\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b#\u0010!R\u001b\u0010(\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010%\u001a\u0004\b)\u0010\u001c\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManagerImpl;", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "user", "", "repo", "remotePath", "localPath", "homePath", "userPath", "resourcesPath", "exceptionsHandler", "Lorg/jetbrains/kotlinx/jupyter/common/ExceptionsHandler;", "userSettingsDir", "Ljava/io/File;", "httpClient", "Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/common/CommonLoggerFactory;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlinx/jupyter/common/ExceptionsHandler;Ljava/io/File;Lorg/jetbrains/kotlinx/jupyter/common/HttpClient;Lorg/jetbrains/kotlinx/jupyter/common/CommonLoggerFactory;)V", "logger", "Lorg/slf4j/Logger;", "authUser", "authToken", "githubApiPrefix", "rawContentApiPrefix", "userLibrariesDir", "getUserLibrariesDir", "()Ljava/io/File;", "localLibrariesDir", "getLocalLibrariesDir", "defaultBranch", "getDefaultBranch", "()Ljava/lang/String;", "latestCommitOnDefaultBranch", "getLatestCommitOnDefaultBranch", "latestCommitOnDefaultBranch$delegate", "Lkotlin/Lazy;", "homeLibrariesDir", "homeDir", "commitHashFile", "getCommitHashFile", "commitHashFile$delegate", "descriptorFileName", "name", "optionsFileName", "resourceLibraryPath", "resourceOptionsPath", "isLibraryDescriptor", "", "file", "getLatestCommitToLibraries", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager$CommitInfo;", "ref", "sinceTimestamp", "downloadGlobalDescriptorOptions", "downloadLibraryDescriptor", "checkRefExistence", "checkIfRefUpToDate", "remoteRef", "downloadLibraries", "", "getGithubHttpWithAuth", "Lorg/jetbrains/kotlinx/jupyter/common/ResponseWrapper;", "url", "downloadFileDirectly", "filePath", "buildRawContentApiDownloadUrl", "buildGithubApiDownloadUrl", "saveLocalRef", "createDirsAndWrite", "text", "catchAll", "T", "message", "body", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "common-dependencies"})
@SourceDebugExtension(value={"SMAP\nLibraries.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Libraries.kt\norg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManagerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,327:1\n1761#2,3:328\n*S KotlinDebug\n*F\n+ 1 Libraries.kt\norg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManagerImpl\n*L\n193#1:328,3\n*E\n"})
final class LibraryDescriptorsManagerImpl
implements LibraryDescriptorsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String remotePath;
    @NotNull
    private final String homePath;
    @NotNull
    private final String resourcesPath;
    @NotNull
    private final ExceptionsHandler exceptionsHandler;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final Logger logger;
    @Nullable
    private final String authUser;
    @Nullable
    private final String authToken;
    @NotNull
    private final String githubApiPrefix;
    @NotNull
    private final String rawContentApiPrefix;
    @NotNull
    private final File userLibrariesDir;
    @NotNull
    private final File localLibrariesDir;
    @NotNull
    private final String defaultBranch;
    @NotNull
    private final Lazy latestCommitOnDefaultBranch$delegate;
    @NotNull
    private final Lazy commitHashFile$delegate;
    @NotNull
    private static final String GITHUB_API_HOST = "api.github.com";
    @NotNull
    private static final String RAW_GITHUB_CONTENT_HOST = "raw.githubusercontent.com";
    @NotNull
    private static final String DESCRIPTOR_EXTENSION = "json";
    @NotNull
    private static final String COMMIT_HASH_FILE = "commit_sha";
    @NotNull
    private static final String OPTIONS_FILE = "global.options";

    public LibraryDescriptorsManagerImpl(@NotNull String user, @NotNull String repo, @NotNull String remotePath, @NotNull String localPath, @NotNull String homePath, @NotNull String userPath, @NotNull String resourcesPath, @NotNull ExceptionsHandler exceptionsHandler, @NotNull File userSettingsDir, @NotNull HttpClient httpClient, @NotNull CommonLoggerFactory loggerFactory) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        Intrinsics.checkNotNullParameter((Object)homePath, (String)"homePath");
        Intrinsics.checkNotNullParameter((Object)userPath, (String)"userPath");
        Intrinsics.checkNotNullParameter((Object)resourcesPath, (String)"resourcesPath");
        Intrinsics.checkNotNullParameter((Object)exceptionsHandler, (String)"exceptionsHandler");
        Intrinsics.checkNotNullParameter((Object)userSettingsDir, (String)"userSettingsDir");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        this.remotePath = remotePath;
        this.homePath = homePath;
        this.resourcesPath = resourcesPath;
        this.exceptionsHandler = exceptionsHandler;
        this.httpClient = httpClient;
        this.logger = loggerFactory.getLogger(this.getClass());
        this.authUser = System.getenv("KOTLIN_JUPYTER_GITHUB_USER");
        this.authToken = System.getenv("KOTLIN_JUPYTER_GITHUB_TOKEN");
        this.githubApiPrefix = "https://api.github.com/repos/" + user + "/" + repo;
        this.rawContentApiPrefix = "https://raw.githubusercontent.com/" + user + "/" + repo;
        this.userLibrariesDir = FilesKt.resolve((File)userSettingsDir, (String)userPath);
        this.localLibrariesDir = new File(localPath);
        this.defaultBranch = "master";
        this.latestCommitOnDefaultBranch$delegate = LazyKt.lazy(() -> LibraryDescriptorsManagerImpl.latestCommitOnDefaultBranch_delegate$lambda$0(this));
        this.commitHashFile$delegate = LazyKt.lazy(() -> LibraryDescriptorsManagerImpl.commitHashFile_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public File getUserLibrariesDir() {
        return this.userLibrariesDir;
    }

    @Override
    @NotNull
    public File getLocalLibrariesDir() {
        return this.localLibrariesDir;
    }

    @Override
    @NotNull
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Override
    @Nullable
    public String getLatestCommitOnDefaultBranch() {
        Lazy lazy = this.latestCommitOnDefaultBranch$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public File homeLibrariesDir(@Nullable File homeDir) {
        File file = homeDir;
        if (file == null) {
            file = new File("");
        }
        return FilesKt.resolve((File)file, (String)this.homePath);
    }

    @Override
    @NotNull
    public File getCommitHashFile() {
        Lazy lazy = this.commitHashFile$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public String descriptorFileName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return name + ".json";
    }

    @Override
    @NotNull
    public String optionsFileName() {
        return OPTIONS_FILE;
    }

    @Override
    @NotNull
    public String resourceLibraryPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.resourcesPath + "/" + this.descriptorFileName(name);
    }

    @Override
    @NotNull
    public String resourceOptionsPath() {
        return this.resourcesPath + "/" + this.optionsFileName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLibraryDescriptor(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) return false;
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Override
    @Nullable
    public LibraryDescriptorsManager.CommitInfo getLatestCommitToLibraries(@NotNull String ref, @Nullable String sinceTimestamp) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return (LibraryDescriptorsManager.CommitInfo)LibraryDescriptorsManagerImpl.catchAll$default(this, null, () -> LibraryDescriptorsManagerImpl.getLatestCommitToLibraries$lambda$0(this, ref, sinceTimestamp), 1, null);
    }

    @Override
    @Nullable
    public String downloadGlobalDescriptorOptions(@NotNull String ref) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.logger.info("Downloading global descriptor options");
        try {
            string = this.downloadFileDirectly(OPTIONS_FILE, ref);
        }
        catch (Throwable e) {
            this.logger.warn("Unable to load global descriptor options", e);
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    public String downloadLibraryDescriptor(@NotNull String ref, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String fileName = name + ".json";
        this.logger.info("Downloading library descriptor " + fileName);
        return this.downloadFileDirectly(fileName, ref);
    }

    @Override
    public boolean checkRefExistence(@NotNull String ref) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            Object[] objectArray = new String[]{".properties", "LICENSE"};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String fileName = (String)element$iv;
                    boolean bl2 = false;
                    String url = this.buildRawContentApiDownloadUrl(fileName, ref);
                    this.logger.info("Checking ref existence directly at " + url);
                    ResponseWrapper response = HttpUtilKt.getHttp(this.httpClient, url);
                    if (!ResponseKt.getSuccessful(response.getStatus())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean checkIfRefUpToDate(@Nullable String remoteRef) {
        if (!this.getCommitHashFile().exists()) {
            return false;
        }
        if (remoteRef == null) {
            this.logger.warn("Considering reference up-to-date because getting the last reference failed");
            return true;
        }
        String localRef = FilesKt.readText$default((File)this.getCommitHashFile(), null, (int)1, null);
        return Intrinsics.areEqual((Object)localRef, (Object)remoteRef);
    }

    @Override
    public void downloadLibraries(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        FilesKt.deleteRecursively((File)this.getLocalLibrariesDir());
        this.getLocalLibrariesDir().mkdirs();
        String url = this.buildGithubApiDownloadUrl("", ref);
        this.logger.info("Requesting library descriptors at " + url);
        JsonArray response = HttpUtilKt.getJsonArray(this.getGithubHttpWithAuth(url));
        for (JsonElement item : response) {
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
            JsonObject cfr_ignored_0 = (JsonObject)item;
            JsonElement jsonElement = (JsonElement)((JsonObject)item).get((Object)"type");
            if (!Intrinsics.areEqual((Object)(jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null), (Object)"file")) continue;
            Object object = ((JsonObject)item).get((Object)"name");
            Intrinsics.checkNotNull((Object)object);
            String fileName = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object)).getContent();
            if (!StringsKt.endsWith$default((String)fileName, (String)".json", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)fileName, (Object)OPTIONS_FILE)) continue;
            Object object2 = ((JsonObject)item).get((Object)"download_url");
            Intrinsics.checkNotNull((Object)object2);
            String downloadUrl = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)object2)).getContent();
            ResponseWrapper descriptorResponse = HttpUtilKt.getHttp(this.httpClient, downloadUrl);
            String descriptorText = descriptorResponse.getText();
            File file = FilesKt.resolve((File)this.getLocalLibrariesDir(), (String)fileName);
            FilesKt.writeText$default((File)file, (String)descriptorText, null, (int)2, null);
        }
        this.saveLocalRef(ref);
    }

    private final ResponseWrapper getGithubHttpWithAuth(String url) {
        ResponseWrapper response;
        ResponseWrapper responseWrapper = response = this.authToken == null || this.authUser == null ? HttpUtilKt.getHttp(this.httpClient, url) : HttpUtilKt.getHttpWithAuth(this.httpClient, url, this.authUser, this.authToken);
        if (this.logger.isDebugEnabled() && !ResponseKt.getSuccessful(response.getStatus())) {
            this.logger.debug("Request to GitHub API '" + url + "' failed, response:\n" + response.getText());
        }
        return response;
    }

    private final String downloadFileDirectly(String filePath, String ref) {
        String url = this.buildRawContentApiDownloadUrl(filePath, ref);
        this.logger.info("Directly downloading file from " + url);
        ResponseWrapper res = HttpUtilKt.getHttp(this.httpClient, url);
        HttpUtilKt.assertSuccessful(res);
        return res.getText();
    }

    private final String buildRawContentApiDownloadUrl(String filePath, String ref) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildRawContentApiDownloadUrl_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildRawContentApiDownloadUrl_u24lambda_u240.append(this.rawContentApiPrefix);
        $this$buildRawContentApiDownloadUrl_u24lambda_u240.append("/");
        $this$buildRawContentApiDownloadUrl_u24lambda_u240.append(ref);
        if (((CharSequence)this.remotePath).length() > 0) {
            $this$buildRawContentApiDownloadUrl_u24lambda_u240.append("/");
            $this$buildRawContentApiDownloadUrl_u24lambda_u240.append(this.remotePath);
        }
        if (((CharSequence)filePath).length() > 0) {
            $this$buildRawContentApiDownloadUrl_u24lambda_u240.append("/");
            $this$buildRawContentApiDownloadUrl_u24lambda_u240.append(filePath);
        }
        return stringBuilder.toString();
    }

    private final String buildGithubApiDownloadUrl(String filePath, String ref) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildGithubApiDownloadUrl_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildGithubApiDownloadUrl_u24lambda_u240.append(this.githubApiPrefix);
        $this$buildGithubApiDownloadUrl_u24lambda_u240.append("/contents");
        if (((CharSequence)this.remotePath).length() > 0) {
            $this$buildGithubApiDownloadUrl_u24lambda_u240.append("/");
            $this$buildGithubApiDownloadUrl_u24lambda_u240.append(this.remotePath);
        }
        if (((CharSequence)filePath).length() > 0) {
            $this$buildGithubApiDownloadUrl_u24lambda_u240.append("/");
            $this$buildGithubApiDownloadUrl_u24lambda_u240.append(filePath);
        }
        $this$buildGithubApiDownloadUrl_u24lambda_u240.append("?ref=");
        $this$buildGithubApiDownloadUrl_u24lambda_u240.append(ref);
        return stringBuilder.toString();
    }

    private final void saveLocalRef(String ref) {
        this.createDirsAndWrite(this.getCommitHashFile(), ref);
    }

    private final void createDirsAndWrite(File $this$createDirsAndWrite, String text2) {
        $this$createDirsAndWrite.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$createDirsAndWrite, (String)text2, null, (int)2, null);
    }

    static /* synthetic */ void createDirsAndWrite$default(LibraryDescriptorsManagerImpl libraryDescriptorsManagerImpl, File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        libraryDescriptorsManagerImpl.createDirsAndWrite(file, string);
    }

    private final <T> T catchAll(String message, Function0<? extends T> body) {
        Object object;
        try {
            object = body.invoke();
        }
        catch (Throwable e) {
            this.exceptionsHandler.handle(this.logger, message, e);
            object = null;
        }
        return (T)object;
    }

    static /* synthetic */ Object catchAll$default(LibraryDescriptorsManagerImpl libraryDescriptorsManagerImpl, String string, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return libraryDescriptorsManagerImpl.catchAll(string, function0);
    }

    private static final String latestCommitOnDefaultBranch_delegate$lambda$0(LibraryDescriptorsManagerImpl this$0) {
        LibraryDescriptorsManager.CommitInfo commitInfo = LibraryDescriptorsManager.getLatestCommitToLibraries$default(this$0, this$0.getDefaultBranch(), null, 2, null);
        return commitInfo != null ? commitInfo.getSha() : null;
    }

    private static final File commitHashFile_delegate$lambda$0(LibraryDescriptorsManagerImpl this$0) {
        File file;
        File file2 = file = FilesKt.resolve((File)this$0.getLocalLibrariesDir(), (String)COMMIT_HASH_FILE);
        boolean bl = false;
        if (!file2.exists()) {
            LibraryDescriptorsManagerImpl.createDirsAndWrite$default(this$0, file2, null, 1, null);
        }
        return file;
    }

    private static final LibraryDescriptorsManager.CommitInfo getLatestCommitToLibraries$lambda$0(LibraryDescriptorsManagerImpl this$0, String $ref, String $sinceTimestamp) {
        LibraryDescriptorsManager.CommitInfo commitInfo;
        String url = this$0.githubApiPrefix + "/commits?path=" + this$0.remotePath + "&sha=" + $ref;
        if ($sinceTimestamp != null) {
            url = url + "&since=" + $sinceTimestamp;
        }
        this$0.logger.info("Checking for new commits to library descriptors at " + url);
        JsonArray arr = HttpUtilKt.getJsonArrayOrNull(this$0.getGithubHttpWithAuth(url));
        if (arr == null) {
            this$0.logger.error("Request for the latest commit in libraries failed");
            return null;
        }
        if (arr.isEmpty()) {
            if ($sinceTimestamp != null) {
                commitInfo = this$0.getLatestCommitToLibraries($ref, null);
            } else {
                this$0.logger.info("Didn't find any commits to libraries at " + url);
                commitInfo = null;
            }
        } else {
            JsonElement jsonElement = arr.get(0);
            Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonObject");
            JsonObject commit = (JsonObject)jsonElement;
            Object object = commit.get((Object)"sha");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlinx.serialization.json.JsonPrimitive");
            String sha = ((JsonPrimitive)object).getContent();
            commitInfo = new LibraryDescriptorsManager.CommitInfo(sha);
        }
        return commitInfo;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManagerImpl$Companion;", "", "<init>", "()V", "GITHUB_API_HOST", "", "RAW_GITHUB_CONTENT_HOST", "DESCRIPTOR_EXTENSION", "COMMIT_HASH_FILE", "OPTIONS_FILE", "common-dependencies"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

