/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.chooser.ui.BannerOverlay;
import com.intellij.ide.startup.importSettings.chooser.ui.OnboardingPage;
import com.intellij.ide.startup.importSettings.chooser.ui.WizardPageTracker;
import com.intellij.ide.startup.importSettings.data.NotificationData;
import com.intellij.ide.startup.importSettings.data.StartupWizardService;
import com.intellij.ide.startup.importSettings.statistics.ImportSettingsEventsCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnboardingBackgroundImageProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.ide.bootstrap.StartupWizardStage;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B2\u0012\u001b\u0010\u0002\u001a\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u00020\tH\u0016J\u0006\u0010\u0019\u001a\u00020\tJ\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0017J\b\u0010\u001f\u001a\u00020 H\u0014J\u0006\u0010#\u001a\u00020\tJ\u0016\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020*H\u0014J!\u0010+\u001a\u00020,2\u000b\u0010-\u001a\u00070\u0005\u00a2\u0006\u0002\b.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0\bJ!\u00100\u001a\u00020,2\u000b\u0010-\u001a\u00070\u0005\u00a2\u0006\u0002\b.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0\bJ#\u00101\u001a\u0002022\u000b\u0010-\u001a\u00070\u0005\u00a2\u0006\u0002\b.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u00103\u001a\u00020\tH\u0014R/\u0010\u0002\u001a\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "titleGetter", "Lkotlin/Function1;", "Lcom/intellij/platform/ide/bootstrap/StartupWizardStage;", "", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "cancelCallback", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getTitleGetter", "()Lkotlin/jvm/functions/Function1;", "setTitleGetter", "(Lkotlin/jvm/functions/Function1;)V", "getCancelCallback", "()Lkotlin/jvm/functions/Function0;", "tracker", "Lcom/intellij/ide/startup/importSettings/chooser/ui/WizardPageTracker;", "pane", "Ljavax/swing/JPanel;", "currentPage", "Lcom/intellij/ide/startup/importSettings/chooser/ui/OnboardingPage;", "doCancelAction", "dialogClose", "doClose", "code", "", "changePage", "page", "createContentPaneBorder", "Ljavax/swing/border/Border;", "overlay", "Lcom/intellij/ide/startup/importSettings/chooser/ui/BannerOverlay;", "initialize", "showOverlay", "notification", "Lcom/intellij/ide/startup/importSettings/data/NotificationData;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createCenterPanel", "Ljavax/swing/JComponent;", "createDefaultButton", "Ljavax/swing/JButton;", "name", "Lorg/jetbrains/annotations/Nls;", "handler", "createButton", "createAction", "Ljavax/swing/Action;", "dispose", "intellij.ide.startup.importSettings"})
public final class OnboardingDialog
extends DialogWrapper {
    @NotNull
    private Function1<? super StartupWizardStage, String> titleGetter;
    @NotNull
    private final Function0<Unit> cancelCallback;
    @NotNull
    private final WizardPageTracker tracker;
    @NotNull
    private final JPanel pane;
    @NotNull
    private OnboardingPage currentPage;
    @NotNull
    private final BannerOverlay overlay;

    /*
     * WARNING - void declaration
     */
    public OnboardingDialog(@NotNull Function1<? super StartupWizardStage, String> titleGetter, @NotNull Function0<Unit> cancelCallback) {
        void $this$pane_u24lambda_u240;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter(titleGetter, (String)"titleGetter");
        Intrinsics.checkNotNullParameter(cancelCallback, (String)"cancelCallback");
        super(null, null, true, DialogWrapper.IdeModalityType.IDE, false);
        this.titleGetter = titleGetter;
        this.cancelCallback = cancelCallback;
        this.tracker = new WizardPageTracker();
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        OnboardingDialog onboardingDialog = this;
        boolean bl = false;
        $this$pane_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        $this$pane_u24lambda_u240.setPreferredSize((Dimension)new JBDimension(640, 467));
        onboardingDialog.pane = jPanel;
        this.currentPage = new OnboardingPage(){
            private final JComponent content;
            private final StartupWizardStage stage;
            {
                this.content = new JPanel();
                this.stage = StartupWizardStage.InitialStart;
            }

            public JComponent getContent() {
                return this.content;
            }

            public StartupWizardStage getStage() {
                return this.stage;
            }

            public boolean confirmExit(Component parentComponent) {
                return true;
            }
        };
        this.overlay = new BannerOverlay(this.pane);
    }

    @NotNull
    public final Function1<StartupWizardStage, String> getTitleGetter() {
        return this.titleGetter;
    }

    public final void setTitleGetter(@NotNull Function1<? super StartupWizardStage, String> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.titleGetter = function1;
    }

    @NotNull
    public final Function0<Unit> getCancelCallback() {
        return this.cancelCallback;
    }

    public void doCancelAction() {
        boolean shouldExit = this.currentPage.confirmExit(this.getPeer().getContentPane());
        if (shouldExit) {
            this.tracker.onLeave();
            ImportSettingsEventsCollector.INSTANCE.dialogClosed();
            StartupWizardService startupWizardService = StartupWizardService.Companion.getInstance();
            if (startupWizardService != null) {
                startupWizardService.onCancel();
            }
            this.cancelCallback.invoke();
            super.doCancelAction();
        }
    }

    public final void dialogClose() {
        if (this.isShowing() && this.isVisible()) {
            this.doClose(1);
        }
    }

    private final void doClose(int code) {
        this.tracker.onLeave();
        this.close(code);
    }

    public final void changePage(@NotNull OnboardingPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        this.overlay.clearNotifications();
        this.pane.removeAll();
        Disposer.dispose((Disposable)this.currentPage);
        this.tracker.onLeave();
        String string = (String)this.titleGetter.invoke((Object)page.getStage());
        if (string == null) {
            string = "";
        }
        this.setTitle(string);
        JComponent content = page.getContent();
        this.pane.add(content);
        this.currentPage = page;
        this.tracker.onEnter(page.getStage());
        OnboardingBackgroundImageProvider.Companion.getInstance().setBackgroundImageToDialog((DialogWrapper)this, page.getBackgroundImage());
    }

    @NotNull
    protected Border createContentPaneBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        return (Border)jBEmptyBorder;
    }

    public final void initialize() {
        this.init();
    }

    public final void showOverlay(@NotNull NotificationData notification, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.overlay.showOverlay(notification, lifetime, OnboardingBackgroundImageProvider.Companion.getInstance().hasBackgroundImage((DialogWrapper)this));
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.overlay.getComponent();
    }

    @NotNull
    public final JButton createDefaultButton(@NotNull String name, @NotNull Function0<Unit> handler) {
        Action action;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Action $this$createDefaultButton_u24lambda_u240 = action = this.createAction(name, handler);
        boolean bl = false;
        $this$createDefaultButton_u24lambda_u240.putValue("DefaultAction", true);
        $this$createDefaultButton_u24lambda_u240.putValue("FocusedAction", true);
        Action action2 = action;
        JButton jButton = this.createJButtonForAction(action2);
        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"createJButtonForAction(...)");
        return jButton;
    }

    @NotNull
    public final JButton createButton(@NotNull String name, @NotNull Function0<Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Action action = this.createAction(name, handler);
        JButton jButton = this.createJButtonForAction(action);
        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"createJButtonForAction(...)");
        return jButton;
    }

    private final Action createAction(String name, Function0<Unit> handler) {
        return (Action)new DialogWrapper.DialogWrapperAction(this, name, handler){
            final /* synthetic */ Function0<Unit> $handler;
            {
                this.$handler = $handler;
                super((DialogWrapper)$receiver, $name);
            }

            protected void doAction(ActionEvent e) {
                this.$handler.invoke();
            }
        };
    }

    protected void dispose() {
        StartupWizardService startupWizardService = StartupWizardService.Companion.getInstance();
        if (startupWizardService != null) {
            startupWizardService.onExit();
        }
        super.dispose();
    }
}

