/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file.singleFile;

import com.intellij.jupyter.core.core.impl.file.JupyterNotebookLanguageUtils;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBuilder;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.transformer.TextPresentationTransformer;
import java.io.StringWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/singleFile/JupyterTextPresentationTransformer;", "Lcom/intellij/openapi/vfs/transformer/TextPresentationTransformer;", "<init>", "()V", "fromPersistent", "", "text", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "toPersistent", "getEmptyNotebookSource", "intellij.jupyter.core"})
public final class JupyterTextPresentationTransformer
implements TextPresentationTransformer {
    @NotNull
    public CharSequence fromPersistent(@NotNull CharSequence text, @NotNull VirtualFile virtualFile2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        if (text.length() == 0) {
            object = this.getEmptyNotebookSource();
        } else if (!StringsKt.startsWith$default((CharSequence)text, (CharSequence)"{", (boolean)false, (int)2, null)) {
            object = text;
        } else {
            JupyterNotebookBase notebook;
            JupyterNotebookBase jupyterNotebookBase = notebook = JupyterFileUtils.readNotebookOrNull$default(JupyterFileUtils.INSTANCE, text, null, 2, null);
            JupyterNotebookLanguageUtils.INSTANCE.setNotebookLanguage(virtualFile2, (Language)(jupyterNotebookBase != null ? jupyterNotebookBase.getLanguage() : null));
            object = notebook;
            if (object == null || (object = ((JupyterNotebookBase)object).asSource()) == null) {
                object = this.getEmptyNotebookSource();
            }
        }
        return object;
    }

    @NotNull
    public CharSequence toPersistent(@NotNull CharSequence text, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        JupyterNotebook jupyterNotebook = JupyterFileExtensionsKt.getJupyterNotebookOrNull(virtualFile2);
        if (jupyterNotebook == null) {
            jupyterNotebook = JupyterFileUtils.INSTANCE.restoreJupyterNotebookFromSource(virtualFile2);
        }
        StringWriter stringWriter = new StringWriter();
        String separator = LoadTextUtil.detectLineSeparator((VirtualFile)virtualFile2, (boolean)true);
        jupyterNotebook.writeJson(stringWriter, separator);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String result2 = string;
        return result2;
    }

    private final CharSequence getEmptyNotebookSource() {
        JupyterNotebookBase emptyNotebook = JupyterFileUtils.createEmptyNotebook$default(JupyterFileUtils.INSTANCE, null, 1, null);
        emptyNotebook.addCell((Function1<? super JupyterCellBuilder, Unit>)((Function1)JupyterTextPresentationTransformer::getEmptyNotebookSource$lambda$0));
        return emptyNotebook.asSource();
    }

    private static final Unit getEmptyNotebookSource$lambda$0(JupyterCellBuilder $this$addCell) {
        Intrinsics.checkNotNullParameter((Object)$this$addCell, (String)"$this$addCell");
        $this$addCell.setSource("");
        $this$addCell.setCellType(JupyterCellType.Companion.getCODE());
        return Unit.INSTANCE;
    }
}

