/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.jupyter.core.editor.settings.JupyterDSettingsMarkdownRenderMode;
import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.jupyter.ui.JupyterUiUtilKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import com.intellij.notebooks.visualization.ui.EditorNotebook;
import com.intellij.notebooks.visualization.ui.EditorNotebookKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.jcef.JBCefHealthMonitor;
import com.intellij.ui.jcef.JBCefNotifications;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.event.HierarchyEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookCefHealthManager;", "Lcom/intellij/notebooks/visualization/ui/EditorCellEventListener;", "Lcom/intellij/openapi/Disposable;", "textEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/intellij/openapi/editor/Editor;)V", "notificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "onEditorCellEvents", "", "events", "", "Lcom/intellij/notebooks/visualization/ui/EditorCellEventListener$EditorCellEvent;", "showNotificationIfNecessary", "dispose", "status", "Lcom/intellij/ui/jcef/JBCefHealthMonitor$Status;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookCefHealthManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCefHealthManager.kt\ncom/intellij/jupyter/core/editor/NotebookCefHealthManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1761#2,3:117\n*S KotlinDebug\n*F\n+ 1 NotebookCefHealthManager.kt\ncom/intellij/jupyter/core/editor/NotebookCefHealthManager\n*L\n61#1:117,3\n*E\n"})
public final class NotebookCefHealthManager
implements EditorCellEventListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileEditor textEditor;
    @NotNull
    private final Editor editor;
    @Nullable
    private EditorNotificationPanel notificationPanel;

    public NotebookCefHealthManager(@NotNull FileEditor textEditor, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"textEditor");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.textEditor = textEditor;
        this.editor = editor;
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        Topic topic = JBCefHealthMonitor.JBCefHealthCheckTopic.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new JBCefHealthMonitor.JBCefHealthCheckTopic(){

            public void onHealthHealthStatusChanged(JBCefHealthMonitor.Status status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                SwingUtilities.invokeLater(() -> 1.onHealthHealthStatusChanged$lambda$0(this, status));
            }

            private static final void onHealthHealthStatusChanged$lambda$0(NotebookCefHealthManager this$0, JBCefHealthMonitor.Status $status) {
                EditorNotificationPanel panel = this$0.showNotificationIfNecessary($status);
                EditorNotificationPanel notificationPanel = this$0.notificationPanel;
                if (panel == null && notificationPanel != null) {
                    Project project = this$0.editor.getProject();
                    Intrinsics.checkNotNull((Object)project);
                    FileEditorManager.getInstance((Project)project).removeTopComponent(this$0.textEditor, (JComponent)notificationPanel);
                }
                this$0.notificationPanel = panel;
            }
        });
        EditorNotebook notebook = EditorNotebookKt.getNotebook((Editor)this.editor);
        if (notebook != null) {
            boolean bl;
            block6: {
                Iterable $this$any$iv = notebook.getCells();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        EditorCell it = (EditorCell)element$iv;
                        boolean bl2 = false;
                        if (!(it.getType() == NotebookCellLines.CellType.MARKDOWN)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.showNotificationIfNecessary();
            } else {
                notebook.addCellEventsListener((Disposable)this, (EditorCellEventListener)this);
            }
        }
    }

    public void onEditorCellEvents(@NotNull List<? extends EditorCellEventListener.EditorCellEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (EditorCellEventListener.EditorCellEvent editorCellEvent : events) {
            if (!(editorCellEvent instanceof EditorCellEventListener.CellCreated) || ((EditorCellEventListener.CellCreated)editorCellEvent).getCell().getType() != NotebookCellLines.CellType.MARKDOWN) continue;
            this.showNotificationIfNecessary();
        }
    }

    private final EditorNotificationPanel showNotificationIfNecessary() {
        JBCefHealthMonitor.Status status = JBCefHealthMonitor.getInstance().getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)status, (String)"getStatus(...)");
        return this.showNotificationIfNecessary(status);
    }

    public void dispose() {
    }

    private final EditorNotificationPanel showNotificationIfNecessary(JBCefHealthMonitor.Status status) {
        Project project = this.editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        EditorNotificationPanel panel = JBCefNotifications.createEditorNotificationPanel((Editor)this.editor, (JBCefHealthMonitor.Status)status);
        if (panel != null) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
            Intrinsics.checkNotNull((Object)fileEditorManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
            FileEditorManagerImpl fileEditorManager2 = (FileEditorManagerImpl)fileEditorManager;
            panel.setCloseAction(() -> NotebookCefHealthManager.showNotificationIfNecessary$lambda$0(fileEditorManager2, this, panel));
            if (!this.editor.getComponent().isDisplayable()) {
                JComponent jComponent = this.editor.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                JupyterUiUtilKt.onComponentAddedToHierarchy(jComponent, (Function1<? super HierarchyEvent, Unit>)((Function1)arg_0 -> NotebookCefHealthManager.showNotificationIfNecessary$lambda$1(fileEditorManager2, this, panel, arg_0)));
            } else {
                fileEditorManager2.addTopComponent(this.textEditor, (JComponent)panel);
            }
        }
        return panel;
    }

    private static final void showNotificationIfNecessary$lambda$0(FileEditorManagerImpl $fileEditorManager, NotebookCefHealthManager this$0, EditorNotificationPanel $panel) {
        $fileEditorManager.removeTopComponent(this$0.textEditor, (JComponent)$panel);
    }

    private static final Unit showNotificationIfNecessary$lambda$1(FileEditorManagerImpl $fileEditorManager, NotebookCefHealthManager this$0, EditorNotificationPanel $panel, HierarchyEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SwingUtilities.invokeLater(() -> NotebookCefHealthManager.showNotificationIfNecessary$lambda$1$0($fileEditorManager, this$0, $panel));
        return Unit.INSTANCE;
    }

    private static final void showNotificationIfNecessary$lambda$1$0(FileEditorManagerImpl $fileEditorManager, NotebookCefHealthManager this$0, EditorNotificationPanel $panel) {
        $fileEditorManager.addTopComponent(this$0.textEditor, (JComponent)$panel);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/editor/NotebookCefHealthManager$Companion;", "", "<init>", "()V", "install", "", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull FileEditor fileEditor, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (!SystemInfo.isLinux) {
                return;
            }
            if (JupyterSettings.Companion.getInstance().getMarkdownRenderMode() != JupyterDSettingsMarkdownRenderMode.NOTEBOOK_CEF || JBCefHealthMonitor.getInstance().getStatus() == JBCefHealthMonitor.Status.OK) {
                return;
            }
            Disposer.register((Disposable)((Disposable)fileEditor), (Disposable)new NotebookCefHealthManager(fileEditor, editor));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

