/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.executor.info;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionListener;
import com.intellij.jupyter.core.executor.JupyterExecutionState;
import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNbFormatHelpersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputListener;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerConcurrentMap;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fJ\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u001bJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010'\u001a\u00020(H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010)\u001a\u00070*\u00a2\u0006\u0002\b+*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lcom/intellij/jupyter/core/executor/info/JupyterExecutionStateImpl;", "Lcom/intellij/jupyter/core/executor/JupyterExecutionState;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "getNotebookVirtualFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "cellStatus", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointerConcurrentMap;", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "value", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "lastExecutingCell", "getLastExecutingCell", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "lastExecutingStatus", "getLastExecutingStatus", "()Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "cellSubmitted", "", "cellPointer", "executionStarted", "startTime", "Ljava/time/ZonedDateTime;", "executionStopped", "jupyterStatus", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "endTime", "hasOutput", "", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "getQueued", "", "getProgressStatus", "cellOrdinal", "", "eventMulticaster", "Lcom/intellij/jupyter/core/jupyter/actions/CellExecutionListener;", "Lorg/jetbrains/annotations/NotNull;", "getEventMulticaster", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)Lcom/intellij/jupyter/core/jupyter/actions/CellExecutionListener;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterExecutionStateImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterExecutionStateImpl.kt\ncom/intellij/jupyter/core/executor/info/JupyterExecutionStateImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1#2:135\n774#3:136\n865#3,2:137\n1563#3:139\n1634#3,3:140\n774#3:143\n865#3,2:144\n*S KotlinDebug\n*F\n+ 1 JupyterExecutionStateImpl.kt\ncom/intellij/jupyter/core/executor/info/JupyterExecutionStateImpl\n*L\n118#1:136\n118#1:137,2\n119#1:139\n119#1:140,3\n120#1:143\n120#1:144,2\n*E\n"})
public final class JupyterExecutionStateImpl
implements JupyterExecutionState,
Disposable.Default {
    @NotNull
    private final BackedNotebookVirtualFile notebookVirtualFile;
    @NotNull
    private final NotebookIntervalPointerConcurrentMap<ProgressStatus> cellStatus;
    @Nullable
    private NotebookIntervalPointer lastExecutingCell;

    /*
     * WARNING - void declaration
     */
    public JupyterExecutionStateImpl(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile2) {
        void it;
        NotebookIntervalPointerConcurrentMap notebookIntervalPointerConcurrentMap;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile2, (String)"notebookVirtualFile");
        this.notebookVirtualFile = notebookVirtualFile2;
        MessageBus messageBus = project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        NotebookIntervalPointerConcurrentMap notebookIntervalPointerConcurrentMap2 = notebookIntervalPointerConcurrentMap = new NotebookIntervalPointerConcurrentMap(messageBus, (Disposable)this);
        JupyterExecutionStateImpl jupyterExecutionStateImpl = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
        jupyterExecutionStateImpl.cellStatus = notebookIntervalPointerConcurrentMap;
        this.notebookVirtualFile.getNotebook().getListeners().getOutputListeners().addListener((EventListener)new JupyterOutputListener(){

            @Override
            public void executionInfoUpdated(JupyterNotebook notebook, NotebookIntervalPointer pointer) {
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
                ProgressStatus progressStatus = (ProgressStatus)cellStatus.get(pointer);
                if (progressStatus == null) {
                    return;
                }
                ProgressStatus status = progressStatus;
                if (status == ProgressStatus.QUEUED) {
                    return;
                }
                JupyterCell jupyterCell = JupyterNbFormatHelpersKt.getCellByPointer(notebook, pointer);
                if (jupyterCell == null) {
                    return;
                }
                JupyterCell jupyterCell2 = jupyterCell;
                if (jupyterCell2.getExecutionStartTime() == null) {
                    cellStatus.remove(pointer);
                    this.getEventMulticaster(this.getNotebookVirtualFile()).executionOutputCleared(pointer);
                }
            }

            @Override
            public void allOutputsUpdated(JupyterNotebook notebook) {
                Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
                Set allIntervals = cellStatus.getAllIntervals();
                Iterable $this$forEach$iv = allIntervals;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    NotebookIntervalPointer it = (NotebookIntervalPointer)element$iv;
                    boolean bl = false;
                    this.outputUpdated(notebook, it);
                }
            }
        }, (Disposable)this);
        JupyterExecutionListener.Companion.register((Disposable)this, new JupyterExecutionListener(){

            @Override
            public Object sessionDeleted(JupyterNotebookSession session, Continuation<? super Unit> $completion) {
                BackedNotebookVirtualFile virtualFile2 = session.getVirtualFile();
                if (!Intrinsics.areEqual((Object)virtualFile2, (Object)this.getNotebookVirtualFile())) {
                    return Unit.INSTANCE;
                }
                cellStatus.clear();
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final BackedNotebookVirtualFile getNotebookVirtualFile() {
        return this.notebookVirtualFile;
    }

    @Override
    @Nullable
    public NotebookIntervalPointer getLastExecutingCell() {
        return this.lastExecutingCell;
    }

    @Override
    @Nullable
    public ProgressStatus getLastExecutingStatus() {
        ProgressStatus progressStatus;
        NotebookIntervalPointer notebookIntervalPointer = this.getLastExecutingCell();
        if (notebookIntervalPointer != null) {
            NotebookIntervalPointer it = notebookIntervalPointer;
            boolean bl = false;
            progressStatus = (ProgressStatus)this.cellStatus.get(it);
        } else {
            progressStatus = null;
        }
        return progressStatus;
    }

    public final void cellSubmitted(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        this.cellStatus.set(cellPointer, (Object)ProgressStatus.QUEUED);
        JupyterNotebook notebook = this.notebookVirtualFile.getNotebook();
        JupyterNbFormatHelpersKt.clearCellOutput(notebook, cellPointer);
        this.getEventMulticaster(this.notebookVirtualFile).executionSubmitted(cellPointer);
    }

    public final void executionStarted(@NotNull NotebookIntervalPointer cellPointer, @NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        this.cellStatus.set(cellPointer, (Object)ProgressStatus.RUNNING);
        JupyterNotebook notebook = this.notebookVirtualFile.getNotebook();
        JupyterCell jupyterCell = JupyterNbFormatHelpersKt.getCellByPointer(notebook, cellPointer);
        if (jupyterCell == null) {
            return;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        jupyterCell2.setExecutionStartTime(startTime);
        JupyterListenersKt.executionInfoUpdated(notebook, cellPointer);
        this.lastExecutingCell = cellPointer;
        CellExecutionListener.executionStarted$default(this.getEventMulticaster(this.notebookVirtualFile), cellPointer, null, 2, null);
    }

    public static /* synthetic */ void executionStarted$default(JupyterExecutionStateImpl jupyterExecutionStateImpl, NotebookIntervalPointer notebookIntervalPointer, ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 2) != 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"now(...)");
            zonedDateTime = zonedDateTime2;
        }
        jupyterExecutionStateImpl.executionStarted(notebookIntervalPointer, zonedDateTime);
    }

    public final void executionStopped(@NotNull NotebookIntervalPointer cellPointer, @NotNull JupyterExecutionStatus jupyterStatus, @NotNull ZonedDateTime endTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        switch (WhenMappings.$EnumSwitchMapping$0[jupyterStatus.ordinal()]) {
            case 1: {
                this.cellStatus.set(cellPointer, (Object)ProgressStatus.STOPPED_OK);
                break;
            }
            case 2: {
                this.cellStatus.set(cellPointer, (Object)ProgressStatus.STOPPED_ERROR);
                break;
            }
            case 3: {
                this.cellStatus.set(cellPointer, (Object)ProgressStatus.CANCELLED);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JupyterNotebook notebook = this.notebookVirtualFile.getNotebook();
        JupyterCell jupyterCell = JupyterNbFormatHelpersKt.getCellByPointer(notebook, cellPointer);
        if (jupyterCell == null) {
            return;
        }
        JupyterCell cell = jupyterCell;
        cell.setExecutionEndTime(endTime);
        this.getEventMulticaster(this.notebookVirtualFile).executionStopped(cellPointer, jupyterStatus, endTime);
    }

    public static /* synthetic */ void executionStopped$default(JupyterExecutionStateImpl jupyterExecutionStateImpl, NotebookIntervalPointer notebookIntervalPointer, JupyterExecutionStatus jupyterExecutionStatus, ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 4) != 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"now(...)");
            zonedDateTime = zonedDateTime2;
        }
        jupyterExecutionStateImpl.executionStopped(notebookIntervalPointer, jupyterExecutionStatus, zonedDateTime);
    }

    @Override
    public boolean hasOutput(@NotNull NotebookIntervalPointer cellPointer, @NotNull JupyterNotebookSession session) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object[] objectArray = new ProgressStatus[]{ProgressStatus.RUNNING, ProgressStatus.STOPPED_ERROR, ProgressStatus.STOPPED_OK};
        if (!CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)this.cellStatus.get(cellPointer))) {
            return false;
        }
        JupyterCell jupyterCell = JupyterNbFormatHelpersKt.getCellByPointer(this.notebookVirtualFile.getNotebook(), cellPointer);
        if (jupyterCell == null) {
            return false;
        }
        JupyterCell jupyterCell2 = jupyterCell;
        return jupyterCell2.getOutputs() != null;
    }

    @Override
    @NotNull
    public List<NotebookIntervalPointer> getQueued() {
        Iterable $this$mapTo$iv$iv;
        Pair it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.cellStatus.getAll();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() == ProgressStatus.QUEUED)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((NotebookIntervalPointer)it.getFirst());
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (NotebookIntervalPointer)element$iv$iv;
            boolean bl = false;
            if (!(it.get() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public ProgressStatus getProgressStatus(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        return (ProgressStatus)this.cellStatus.get(cellPointer);
    }

    @Override
    @Nullable
    public ProgressStatus getProgressStatus(int cellOrdinal) {
        return (ProgressStatus)this.cellStatus.get(cellOrdinal);
    }

    private final CellExecutionListener getEventMulticaster(BackedNotebookVirtualFile $this$eventMulticaster) {
        EventListener eventListener = $this$eventMulticaster.getNotebook().getListeners().getCellExecutionListeners().getMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)eventListener, (String)"getMulticaster(...)");
        return (CellExecutionListener)eventListener;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JupyterExecutionStatus.values().length];
            try {
                nArray[JupyterExecutionStatus.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionStatus.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterExecutionStatus.ABORTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

