/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.executor.kernel.session.impl;

import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterNotebookRuntimeSettings;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.WithSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\tJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\bJ\u0018\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00120\u0011J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/executor/kernel/session/impl/NotebookRuntimeStore;", "", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "map", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/notebook/JupyterNotebookRuntimeSettings;", "get", "file", "put", "value", "putIfAbsent", "remove", "all", "", "Lkotlin/Pair;", "contains", "", "clear", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookRuntimeStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookRuntimeStore.kt\ncom/intellij/jupyter/core/executor/kernel/session/impl/NotebookRuntimeStore\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n382#2,7:48\n1563#3:55\n1634#3,3:56\n*S KotlinDebug\n*F\n+ 1 NotebookRuntimeStore.kt\ncom/intellij/jupyter/core/executor/kernel/session/impl/NotebookRuntimeStore\n*L\n24#1:48,7\n32#1:55\n32#1:56,3\n*E\n"})
public final class NotebookRuntimeStore {
    @NotNull
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @NotNull
    private final Map<VirtualFile, JupyterNotebookRuntimeSettings> map = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JupyterNotebookRuntimeSettings get(@NotNull VirtualFile file) {
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            jupyterNotebookRuntimeSettings = this.map.get(file);
        }
        finally {
            readLock.unlock();
        }
        return jupyterNotebookRuntimeSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JupyterNotebookRuntimeSettings put(@NotNull VirtualFile file, @NotNull JupyterNotebookRuntimeSettings value) {
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            jupyterNotebookRuntimeSettings = this.map.put(file, value);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return jupyterNotebookRuntimeSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final JupyterNotebookRuntimeSettings putIfAbsent(@NotNull VirtualFile file, @NotNull JupyterNotebookRuntimeSettings value) {
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map<VirtualFile, JupyterNotebookRuntimeSettings> map = this.map;
            VirtualFile key$iv = file;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                JupyterNotebookRuntimeSettings answer$iv = value;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            jupyterNotebookRuntimeSettings = (JupyterNotebookRuntimeSettings)object;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return jupyterNotebookRuntimeSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JupyterNotebookRuntimeSettings remove(@NotNull VirtualFile file) {
        JupyterNotebookRuntimeSettings jupyterNotebookRuntimeSettings;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            jupyterNotebookRuntimeSettings = this.map.remove(file);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return jupyterNotebookRuntimeSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<VirtualFile, JupyterNotebookRuntimeSettings>> all() {
        List list;
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.map.entrySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var13_15 = it;
                collection.add(new Pair(var13_15.getKey(), var13_15.getValue()));
            }
            list = (List)destination$iv$iv;
        }
        finally {
            readLock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean contains(@NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl2 = false;
            bl = this.map.containsKey(file);
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            for (JupyterNotebookRuntimeSettings settings : this.map.values()) {
                Object session;
                Object object = settings instanceof WithSession ? (WithSession)((Object)settings) : null;
                if (object == null) continue;
                if ((object = object.getSession()) == null || Disposer.isDisposed((Disposable)((Disposable)(session = object)))) continue;
                Disposer.dispose((Disposable)((Disposable)session));
            }
            this.map.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }
}

