/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.executor.queue;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.queue.JupyterFileExecutionQueue;
import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RemoveUserDataKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/executor/queue/JupyterExecutionNotebookModelInMemoryKeeper;", "Lcom/intellij/openapi/Disposable$Default;", "executor", "Lcom/intellij/jupyter/core/executor/queue/JupyterFileExecutionQueue;", "<init>", "(Lcom/intellij/jupyter/core/executor/queue/JupyterFileExecutionQueue;)V", "Companion", "intellij.jupyter.core"})
public final class JupyterExecutionNotebookModelInMemoryKeeper
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Disposable> DISPOSE_KEY = new Key("DISPOSE_EXECUTION_KEY");

    public JupyterExecutionNotebookModelInMemoryKeeper(@NotNull JupyterFileExecutionQueue executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        BackedNotebookVirtualFile notebookFile = executor.getFile();
        VirtualFile file = notebookFile.getFile();
        NotebookEditorUiUtilKt.afterDistinctChange(executor.isExecutedOrQueued(), (Disposable)executor, arg_0 -> JupyterExecutionNotebookModelInMemoryKeeper._init_$lambda$0(file, executor, notebookFile, arg_0));
    }

    private static final Unit _init_$lambda$0(VirtualFile $file, JupyterFileExecutionQueue $executor, BackedNotebookVirtualFile $notebookFile, boolean isExecuting) {
        if (isExecuting) {
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable newDisposable = disposable;
            $file.putUserData(DISPOSE_KEY, (Object)newDisposable);
            Disposer.register((Disposable)$executor, (Disposable)newDisposable);
            $notebookFile.registryDispose(newDisposable);
        } else {
            Disposable disposable = (Disposable)RemoveUserDataKt.removeUserData((UserDataHolder)((UserDataHolder)$file), DISPOSE_KEY);
            if (disposable == null) {
                return Unit.INSTANCE;
            }
            Disposable disposable2 = disposable;
            Disposer.dispose((Disposable)disposable2);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jupyter/core/executor/queue/JupyterExecutionNotebookModelInMemoryKeeper$Companion;", "", "<init>", "()V", "DISPOSE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/Disposable;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

