/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.executor.queue;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.queue.JupyterExecutionNotebookModelInMemoryKeeper;
import com.intellij.jupyter.core.executor.queue.JupyterFileExecutionQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/executor/queue/JupyterExecutionQueueStore;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "executionQueueManagers", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Lcom/intellij/jupyter/core/executor/queue/JupyterFileExecutionQueue;", "getAllQueues", "", "getOrInitNotebookTaskManager", "notebook", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterExecutionQueueStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterExecutionQueueStore.kt\ncom/intellij/jupyter/core/executor/queue/JupyterExecutionQueueStore\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n72#2,2:40\n1#3:42\n*S KotlinDebug\n*F\n+ 1 JupyterExecutionQueueStore.kt\ncom/intellij/jupyter/core/executor/queue/JupyterExecutionQueueStore\n*L\n22#1:40,2\n22#1:42\n*E\n"})
public final class JupyterExecutionQueueStore
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ConcurrentHashMap<BackedNotebookVirtualFile, JupyterFileExecutionQueue> executionQueueManagers;

    public JupyterExecutionQueueStore(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.executionQueueManagers = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Collection<JupyterFileExecutionQueue> getAllQueues() {
        Collection<JupyterFileExecutionQueue> collection = this.executionQueueManagers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JupyterFileExecutionQueue getOrInitNotebookTaskManager(@NotNull BackedNotebookVirtualFile notebook) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        if (this.project.isDisposed()) {
            return null;
        }
        ConcurrentMap concurrentMap = this.executionQueueManagers;
        BackedNotebookVirtualFile key$iv = notebook;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            CoroutineScope childScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.scope, (String)("Execution queue of " + notebook), null, (boolean)false, (int)6, null);
            JupyterFileExecutionQueue notebookQueue = new JupyterFileExecutionQueue(this.project, childScope, notebook);
            Disposer.register((Disposable)((Disposable)this), (Disposable)notebookQueue);
            Disposer.register((Disposable)notebookQueue, (Disposable)((Disposable)new JupyterExecutionNotebookModelInMemoryKeeper(notebookQueue)));
            Disposer.register((Disposable)notebookQueue, () -> JupyterExecutionQueueStore.getOrInitNotebookTaskManager$lambda$0$0(childScope, this, notebook));
            JupyterFileExecutionQueue default$iv = notebookQueue;
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (JupyterFileExecutionQueue)object;
    }

    private static final void getOrInitNotebookTaskManager$lambda$0$0(CoroutineScope $childScope, JupyterExecutionQueueStore this$0, BackedNotebookVirtualFile $notebook) {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$childScope, null, (int)1, null);
        this$0.executionQueueManagers.remove($notebook);
    }

    @JvmStatic
    @NotNull
    public static final JupyterExecutionQueueStore getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/executor/queue/JupyterExecutionQueueStore$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/executor/queue/JupyterExecutionQueueStore;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JupyterExecutionQueueStore getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(JupyterExecutionQueueStore.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JupyterExecutionQueueStore)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

