/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.settings.config;

import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.managed.JupyterRuntimeManagedServerInfo;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerStarted;
import com.intellij.jupyter.core.jupyter.connections.managed.state.JupyterServerState;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterConfiguredServerConfig;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterManagedServerConfig;
import com.intellij.jupyter.core.jupyter.server.JupyterManagedServerConfigurationProvider;
import com.intellij.jupyter.core.jupyter.server.JupyterManagedServerExecutionServiceProvider;
import com.intellij.jupyter.core.jupyter.server.common.JupyterServerExecution;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u0082\u0001\u0002\u0013\u0014\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterServerConfig;", "", "id", "", "getId", "()Ljava/lang/String;", "name", "getName", "authority", "getAuthority", "getConnectionParameters", "Lcom/intellij/jupyter/core/jupyter/connections/JupyterConnectionParameters;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getManagedServerEffectiveConnectionParameters", "module", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterConfiguredServerConfig;", "Lcom/intellij/jupyter/core/jupyter/connections/settings/config/JupyterManagedServerConfig;", "intellij.jupyter.core"})
public sealed interface JupyterServerConfig
permits JupyterConfiguredServerConfig, JupyterManagedServerConfig {
    @NotNull
    public String getId();

    @NotNull
    public String getName();

    @NotNull
    default public String getAuthority() {
        return this.getName();
    }

    @Nullable
    default public JupyterConnectionParameters getConnectionParameters(@NotNull Project project, @Nullable VirtualFile virtualFile2) {
        JupyterConnectionParameters jupyterConnectionParameters;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JupyterServerConfig jupyterServerConfig = this;
        if (jupyterServerConfig instanceof JupyterManagedServerConfig) {
            VirtualFile virtualFile3 = virtualFile2;
            if (virtualFile3 != null) {
                VirtualFile it = virtualFile3;
                boolean bl = false;
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile2, (Project)project);
                if (module != null) {
                    Module it2 = module;
                    boolean bl2 = false;
                    jupyterConnectionParameters = this.getManagedServerEffectiveConnectionParameters(it2, virtualFile2);
                } else {
                    jupyterConnectionParameters = null;
                }
            } else {
                jupyterConnectionParameters = null;
            }
        } else if (jupyterServerConfig instanceof JupyterConfiguredServerConfig) {
            jupyterConnectionParameters = ((JupyterConfiguredServerConfig)this).toConnectionParameters();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jupyterConnectionParameters;
    }

    private JupyterConnectionParameters getManagedServerEffectiveConnectionParameters(Module module, VirtualFile virtualFile2) {
        JupyterRuntimeManagedServerInfo managedServerConfiguration = JupyterManagedServerConfigurationProvider.Companion.getJupyterManagedServerConfiguration(module, virtualFile2);
        JupyterServerExecution jupyterServerExecution = JupyterManagedServerExecutionServiceProvider.Companion.getInstance().getManaged(managedServerConfiguration);
        JupyterServerState state = jupyterServerExecution != null ? jupyterServerExecution.getState() : null;
        JupyterServerStarted jupyterServerStarted = state instanceof JupyterServerStarted ? (JupyterServerStarted)state : null;
        return jupyterServerStarted != null ? jupyterServerStarted.getConnectionParameters() : null;
    }

    public static /* synthetic */ JupyterConnectionParameters getManagedServerEffectiveConnectionParameters$default(JupyterServerConfig jupyterServerConfig, Module module, VirtualFile virtualFile2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getManagedServerEffectiveConnectionParameters");
        }
        if ((n & 2) != 0) {
            virtualFile2 = null;
        }
        return jupyterServerConfig.getManagedServerEffectiveConnectionParameters(module, virtualFile2);
    }
}

