/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.connections.settings.listeners;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.connections.settings.config.JupyterServerConfig;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/core/jupyter/connections/settings/listeners/JupyterFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "processEvent", "event", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFileListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileListener.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/listeners/JupyterFileListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1869#2,2:34\n*S KotlinDebug\n*F\n+ 1 JupyterFileListener.kt\ncom/intellij/jupyter/core/jupyter/connections/settings/listeners/JupyterFileListener\n*L\n13#1:34,2\n*E\n"})
public final class JupyterFileListener
implements BulkFileListener {
    @NotNull
    private final Project project;

    public JupyterFileListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VFileEvent event = (VFileEvent)element$iv;
            boolean bl = false;
            this.processEvent(event);
        }
    }

    private final void processEvent(VFileEvent event) {
        VirtualFile virtualFile2 = event.getFile();
        if (!Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getExtension() : null), (Object)JupyterFileType.INSTANCE.getDefaultExtension())) {
            return;
        }
        JupyterConnectionSettingsManager settingsManager = JupyterConnectionSettingsManager.Companion.getInstance();
        VFileEvent vFileEvent = event;
        if (vFileEvent instanceof VFileCopyEvent) {
            VirtualFile virtualFile3 = ((VFileCopyEvent)event).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getFile(...)");
            BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile3);
            if (backedNotebookVirtualFile == null) {
                return;
            }
            BackedNotebookVirtualFile notebookVirtualFile2 = backedNotebookVirtualFile;
            JupyterServerConfig jupyterServerConfig = settingsManager.getConfigForVirtualFile(notebookVirtualFile2, this.project);
            if (jupyterServerConfig == null) {
                return;
            }
            JupyterServerConfig cachedConfig = jupyterServerConfig;
            VirtualFile virtualFile4 = ((VFileCopyEvent)event).findCreatedFile();
            if (virtualFile4 == null) {
                return;
            }
            VirtualFile createdFile = virtualFile4;
            settingsManager.setConfigForFile(createdFile, cachedConfig);
        } else if (vFileEvent instanceof VFileDeleteEvent) {
            VirtualFile virtualFile5 = ((VFileDeleteEvent)event).getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile5, (String)"getFile(...)");
            settingsManager.removeConfigForFile(virtualFile5);
        }
    }
}

