/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.actions;

import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/actions/FileSaveUtils;", "", "<init>", "()V", "createSaveFile", "Lcom/intellij/openapi/vfs/VirtualFileWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "defaultFileName", "", "title", "extension", "saveToFile", "", "wrapper", "data", "", "intellij.jupyter.core"})
public final class FileSaveUtils {
    @NotNull
    public static final FileSaveUtils INSTANCE = new FileSaveUtils();

    private FileSaveUtils() {
    }

    @Nullable
    public final VirtualFileWrapper createSaveFile(@Nullable Project project, @NotNull String defaultFileName, @NlsContexts.DialogTitle @NotNull String title, @Nullable String extension) {
        Intrinsics.checkNotNullParameter((Object)defaultFileName, (String)"defaultFileName");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        String string = extension;
        if (string == null) {
            string = "";
        }
        FileSaverDescriptor descriptor = new FileSaverDescriptor(title, "", string);
        Project project2 = project;
        if (project2 == null) {
            return null;
        }
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project2);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog chooser = fileSaverDialog;
        return chooser.save(defaultFileName);
    }

    public static /* synthetic */ VirtualFileWrapper createSaveFile$default(FileSaveUtils fileSaveUtils, Project project, String string, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return fileSaveUtils.createSaveFile(project, string, string2, string3);
    }

    public final void saveToFile(@Nullable VirtualFileWrapper wrapper, @NotNull byte[] data) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Object object = wrapper;
            if (object == null || (object = object.getFile()) == null || (object = ((File)object).toPath()) == null) {
                return;
            }
            Files.write((Path)object, data, new OpenOption[0]);
            VirtualFile virtualFile2 = wrapper.getVirtualFile();
            if (virtualFile2 == null) break block1;
            virtualFile2.refresh(true, false);
        }
    }
}

