/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.controllers.below;

import com.intellij.jupyter.core.editor.settings.JupyterSettings;
import com.intellij.jupyter.core.editor.settings.JupyterShowExecutionTimeMode;
import com.intellij.jupyter.core.jupyter.editor.controllers.below.execution.NotebookCellExecutionPanelController;
import com.intellij.jupyter.core.jupyter.editor.controllers.below.tags.NotebookCellTagsPanelController;
import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.providers.frame.CellFrameState;
import com.intellij.notebooks.visualization.ui.providers.frame.EditorCellFrameManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/controllers/below/NotebookBelowCellPanelController;", "Lcom/intellij/openapi/Disposable$Default;", "editorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "getEditorCell", "()Lcom/intellij/notebooks/visualization/ui/EditorCell;", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "tagPanel", "Lcom/intellij/jupyter/core/jupyter/editor/controllers/below/tags/NotebookCellTagsPanelController;", "executionPanel", "Lcom/intellij/jupyter/core/jupyter/editor/controllers/below/execution/NotebookCellExecutionPanelController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "delimiterHeight", "", "frameManager", "Lcom/intellij/notebooks/visualization/ui/providers/frame/EditorCellFrameManager;", "getFrameManager", "()Lcom/intellij/notebooks/visualization/ui/providers/frame/EditorCellFrameManager;", "updateBackgroundAndBorderColor", "", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookBelowCellPanelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookBelowCellPanelController.kt\ncom/intellij/jupyter/core/jupyter/editor/controllers/below/NotebookBelowCellPanelController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class NotebookBelowCellPanelController
implements Disposable.Default {
    @NotNull
    private final EditorCell editorCell;
    @NotNull
    private final JPanel component;
    @NotNull
    private final NotebookCellTagsPanelController tagPanel;
    @NotNull
    private final NotebookCellExecutionPanelController executionPanel;
    @NotNull
    private final EditorImpl editor;
    private final int delimiterHeight;

    public NotebookBelowCellPanelController(@NotNull EditorCell editorCell) {
        EditorCellFrameManager editorCellFrameManager;
        Object it;
        Intrinsics.checkNotNullParameter((Object)editorCell, (String)"editorCell");
        this.editorCell = editorCell;
        this.component = new JPanel(new BorderLayout());
        Object object = new NotebookCellTagsPanelController(this.editorCell);
        NotebookCellTagsPanelController notebookCellTagsPanelController = object;
        NotebookBelowCellPanelController notebookBelowCellPanelController = this;
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
        notebookBelowCellPanelController.tagPanel = object;
        it = object = new NotebookCellExecutionPanelController(this.editorCell);
        notebookBelowCellPanelController = this;
        boolean bl2 = false;
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
        notebookBelowCellPanelController.executionPanel = object;
        this.editor = this.editorCell.getEditor();
        this.delimiterHeight = NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellBorderHeight() / 4;
        NotebookCellLines.Interval interval = this.editorCell.getIntervalOrNull();
        if ((interval != null ? interval.getType() : null) == NotebookCellLines.CellType.CODE) {
            NotebookEditorUiUtilKt.bind((ObservableProperty)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCodeCellBackgroundColor(), (Disposable)((Disposable)this), arg_0 -> NotebookBelowCellPanelController._init_$lambda$0(this, arg_0));
        } else {
            NotebookEditorUiUtilKt.bind((ObservableProperty)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getEditorBackgroundColor(), (Disposable)((Disposable)this), arg_0 -> NotebookBelowCellPanelController._init_$lambda$1(this, arg_0));
        }
        if ((editorCellFrameManager = this.getFrameManager()) != null && (editorCellFrameManager = editorCellFrameManager.getState()) != null) {
            NotebookEditorUiUtilKt.afterDistinctChange((ObservableProperty)((ObservableProperty)editorCellFrameManager), (Disposable)((Disposable)this), arg_0 -> NotebookBelowCellPanelController._init_$lambda$2(this, arg_0));
        }
        this.component.add((Component)this.tagPanel.getComponent(), "East");
        if (JupyterSettings.Companion.getInstance().getExecutionTimeShowMode() != JupyterShowExecutionTimeMode.HIDDEN) {
            this.component.add((Component)this.executionPanel.getComponent(), "West");
        }
        this.component.setCursor(Cursor.getPredefinedCursor(0));
        this.updateBackgroundAndBorderColor();
    }

    @NotNull
    public final EditorCell getEditorCell() {
        return this.editorCell;
    }

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    private final EditorCellFrameManager getFrameManager() {
        return this.editorCell.getCellFrameManager();
    }

    private final void updateBackgroundAndBorderColor() {
        Color backgroundColor;
        EditorCellFrameManager editorCellFrameManager = this.getFrameManager();
        if (editorCellFrameManager == null) {
            return;
        }
        EditorCellFrameManager frameManager = editorCellFrameManager;
        CellFrameState state = (CellFrameState)frameManager.getState().get();
        NotebookCellLines.Interval interval = this.editorCell.getIntervalOrNull();
        Color color = backgroundColor = (interval != null ? interval.getType() : null) != NotebookCellLines.CellType.MARKDOWN ? (Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCodeCellBackgroundColor().get() : (Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getEditorBackgroundColor().get();
        if (!Intrinsics.areEqual((Object)this.component.getBackground(), (Object)backgroundColor)) {
            this.component.setBackground(backgroundColor);
        }
        Color frameBorderColor = state.isVisible() ? state.getColor() : backgroundColor;
        this.component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, frameBorderColor), BorderFactory.createEmptyBorder(this.delimiterHeight, 0, this.delimiterHeight, 0)));
        this.component.repaint();
    }

    private static final Unit _init_$lambda$0(NotebookBelowCellPanelController this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateBackgroundAndBorderColor();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(NotebookBelowCellPanelController this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateBackgroundAndBorderColor();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(NotebookBelowCellPanelController this$0, CellFrameState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateBackgroundAndBorderColor();
        return Unit.INSTANCE;
    }
}

