/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.NotebookLanguageDetectorKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EDT;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/core/jupyter/helper/NotebookLanguageDetector;", "", "<init>", "()V", "detectLanguage", "Lcom/intellij/lang/Language;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "backedFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.core"})
public final class NotebookLanguageDetector {
    @NotNull
    public static final NotebookLanguageDetector INSTANCE = new NotebookLanguageDetector();

    private NotebookLanguageDetector() {
    }

    @Nullable
    public final Language detectLanguage(@Nullable VirtualFile virtualFile2) {
        if (virtualFile2 == null || !Intrinsics.areEqual((Object)virtualFile2.getExtension(), (Object)JupyterFileType.INSTANCE.getDefaultExtension())) {
            return null;
        }
        boolean cachedOnly = EDT.isCurrentThreadEdt();
        return NotebookLanguageDetectorKt.access$getNotebookLanguage(virtualFile2, cachedOnly);
    }

    @Nullable
    public final Language detectLanguage(@NotNull BackedNotebookVirtualFile backedFile) {
        Intrinsics.checkNotNullParameter((Object)backedFile, (String)"backedFile");
        JupyterNotebook jupyterNotebook = backedFile.getNotebookOrNull();
        if (jupyterNotebook == null) {
            return this.detectLanguage(backedFile.getFile());
        }
        JupyterNotebook notebook = jupyterNotebook;
        return this.detectLanguage(notebook);
    }

    @NotNull
    public final Language detectLanguage(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        return notebook.getLanguage();
    }

    @Nullable
    public final Language detectLanguage(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getNotebookFile(dataContext);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile backedFile = backedNotebookVirtualFile;
        return this.detectLanguage(backedFile);
    }

    @Nullable
    public final Language detectLanguage(@Nullable Editor editor) {
        if (!(editor instanceof EditorEx)) {
            return null;
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile((Document)((EditorEx)editor).getDocument());
        return this.detectLanguage(virtualFile2);
    }
}

