/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.lang;

import com.intellij.jupyter.core.core.JupyterCellTypeProvider;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.lang.Language;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData;", "", "language", "Lcom/intellij/lang/Language;", "jupyterCellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "cellType", "Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "headerSuffix", "", "<init>", "(Lcom/intellij/lang/Language;Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;Ljava/lang/String;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getJupyterCellType", "()Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "getCellType", "()Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "getHeaderSuffix", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.jupyter.core"})
public final class JupyterLangData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language language;
    @NotNull
    private final JupyterCellType jupyterCellType;
    @NotNull
    private final NotebookCellLines.CellType cellType;
    @Nullable
    private final String headerSuffix;
    @NotNull
    private static final JupyterLangData rawData;

    public JupyterLangData(@NotNull Language language, @NotNull JupyterCellType jupyterCellType, @NotNull NotebookCellLines.CellType cellType, @Nullable String headerSuffix) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)jupyterCellType, (String)"jupyterCellType");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        this.language = language;
        this.jupyterCellType = jupyterCellType;
        this.cellType = cellType;
        this.headerSuffix = headerSuffix;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final JupyterCellType getJupyterCellType() {
        return this.jupyterCellType;
    }

    @NotNull
    public final NotebookCellLines.CellType getCellType() {
        return this.cellType;
    }

    @Nullable
    public final String getHeaderSuffix() {
        return this.headerSuffix;
    }

    @NotNull
    public final Language component1() {
        return this.language;
    }

    @NotNull
    public final JupyterCellType component2() {
        return this.jupyterCellType;
    }

    @NotNull
    public final NotebookCellLines.CellType component3() {
        return this.cellType;
    }

    @Nullable
    public final String component4() {
        return this.headerSuffix;
    }

    @NotNull
    public final JupyterLangData copy(@NotNull Language language, @NotNull JupyterCellType jupyterCellType, @NotNull NotebookCellLines.CellType cellType, @Nullable String headerSuffix) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)jupyterCellType, (String)"jupyterCellType");
        Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
        return new JupyterLangData(language, jupyterCellType, cellType, headerSuffix);
    }

    public static /* synthetic */ JupyterLangData copy$default(JupyterLangData jupyterLangData, Language language, JupyterCellType jupyterCellType, NotebookCellLines.CellType cellType, String string, int n, Object object) {
        if ((n & 1) != 0) {
            language = jupyterLangData.language;
        }
        if ((n & 2) != 0) {
            jupyterCellType = jupyterLangData.jupyterCellType;
        }
        if ((n & 4) != 0) {
            cellType = jupyterLangData.cellType;
        }
        if ((n & 8) != 0) {
            string = jupyterLangData.headerSuffix;
        }
        return jupyterLangData.copy(language, jupyterCellType, cellType, string);
    }

    @NotNull
    public String toString() {
        return "JupyterLangData(language=" + this.language + ", jupyterCellType=" + this.jupyterCellType + ", cellType=" + this.cellType + ", headerSuffix=" + this.headerSuffix + ")";
    }

    public int hashCode() {
        int result2 = this.language.hashCode();
        result2 = result2 * 31 + this.jupyterCellType.hashCode();
        result2 = result2 * 31 + this.cellType.hashCode();
        result2 = result2 * 31 + (this.headerSuffix == null ? 0 : this.headerSuffix.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JupyterLangData)) {
            return false;
        }
        JupyterLangData jupyterLangData = (JupyterLangData)other;
        if (!Intrinsics.areEqual((Object)this.language, (Object)jupyterLangData.language)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jupyterCellType, (Object)jupyterLangData.jupyterCellType)) {
            return false;
        }
        if (this.cellType != jupyterLangData.cellType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.headerSuffix, (Object)jupyterLangData.headerSuffix);
    }

    static {
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
        rawData = new JupyterLangData((Language)plainTextLanguage, JupyterCellType.Companion.getRAW(), NotebookCellLines.CellType.RAW, "raw");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData$Companion;", "", "<init>", "()V", "rawData", "Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData;", "getRawData", "()Lcom/intellij/jupyter/core/jupyter/lang/JupyterLangData;", "getDataByJupyterCellType", "notebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "cellTypeProvider", "Lcom/intellij/jupyter/core/core/JupyterCellTypeProvider;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterLangData getRawData() {
            return rawData;
        }

        @Nullable
        public final JupyterLangData getDataByJupyterCellType(@NotNull BackedNotebookVirtualFile notebook, @Nullable JupyterCellTypeProvider cellTypeProvider) {
            Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
            if (cellTypeProvider == null) {
                return null;
            }
            Language language = JupyterCellLinesProvider.Util.INSTANCE.getDefaultCodeLanguage(notebook.getNotebook());
            return new JupyterLangData(cellTypeProvider.getLanguage(language), cellTypeProvider.getJupyterCellType(), cellTypeProvider.getCellType(), cellTypeProvider.getCellHeader());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

