/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote.projectView;

import com.intellij.ide.IdeView;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.projectView.impl.IdeViewForProjectViewPane;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.jupyter.core.jupyter.connections.settings.JupyterConnectionSettingsManager;
import com.intellij.jupyter.core.jupyter.remote.projectView.JupyterRemoteAuthorityNodeCache;
import com.intellij.jupyter.core.jupyter.remote.projectView.JupyterRemoteStructureProvider;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteDirectoryNode;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteFileNode;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteLoadingNode;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteNode;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteNotLoadedNode;
import com.intellij.jupyter.core.jupyter.remote.providers.JupyterRemoteCopyPasteProvider;
import com.intellij.jupyter.core.jupyter.remote.providers.JupyterRemoteDeleteProvider;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J:\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0015H\u0016J$\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0015H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/projectView/JupyterRemoteStructureProvider;", "Lcom/intellij/ide/projectView/TreeStructureProvider;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "modify", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "parent", "children", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "selection", "", "filterOutJupyterServerModules", "getIdeView", "Lcom/intellij/ide/IdeView;", "selected", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterRemoteStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterRemoteStructureProvider.kt\ncom/intellij/jupyter/core/jupyter/remote/projectView/JupyterRemoteStructureProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,110:1\n30#2,2:111\n1869#3,2:113\n1617#3,9:115\n1869#3:124\n1870#3:126\n1626#3:127\n1617#3,9:130\n1869#3:139\n1870#3:141\n1626#3:142\n1#4:125\n1#4:140\n37#5,2:128\n37#5,2:143\n*S KotlinDebug\n*F\n+ 1 JupyterRemoteStructureProvider.kt\ncom/intellij/jupyter/core/jupyter/remote/projectView/JupyterRemoteStructureProvider\n*L\n41#1:111,2\n42#1:113,2\n50#1:115,9\n50#1:124\n50#1:126\n50#1:127\n62#1:130,9\n62#1:139\n62#1:141\n62#1:142\n50#1:125\n62#1:140\n59#1:128,2\n62#1:143,2\n*E\n"})
public final class JupyterRemoteStructureProvider
implements TreeStructureProvider,
DumbAware {
    @NotNull
    private final Project project;

    public JupyterRemoteStructureProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, @Nullable ViewSettings settings) {
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        if (!(parent instanceof ProjectViewProjectNode)) {
            return children;
        }
        JupyterConnectionSettingsManager settingsManager = JupyterConnectionSettingsManager.Companion.getInstance();
        Collection<String> configs = settingsManager.getKnownAuthorities();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<JupyterRemoteAuthorityNodeCache> serviceClass$iv = JupyterRemoteAuthorityNodeCache.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        JupyterRemoteAuthorityNodeCache authorityNodeCache = (JupyterRemoteAuthorityNodeCache)object;
        Iterable $this$forEach$iv = configs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String authority = (String)element$iv;
            boolean bl = false;
            children.add((AbstractTreeNode<?>)authorityNodeCache.getOrCreateRootServerNode(authority, settings));
        }
        return this.filterOutJupyterServerModules(children);
    }

    /*
     * WARNING - void declaration
     */
    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull Collection<? extends AbstractTreeNode<?>> selection) {
        boolean bl;
        JupyterRemoteNode it$iv$iv;
        Object it;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Iterable $this$mapNotNull$iv = selection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (AbstractTreeNode)element$iv$iv;
            boolean bl3 = false;
            if ((it instanceof JupyterRemoteNode ? (JupyterRemoteNode)((Object)it) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nodes2 = (List)destination$iv$iv;
        if (nodes2.isEmpty()) {
            return;
        }
        DataKey dataKey = PlatformDataKeys.DELETE_ELEMENT_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"DELETE_ELEMENT_PROVIDER");
        sink.set(dataKey, (Object)new JupyterRemoteDeleteProvider(this.project, selection));
        if (nodes2.size() != selection.size()) {
            return;
        }
        DataKey dataKey2 = CommonDataKeys.NAVIGATABLE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"NAVIGATABLE");
        sink.set(dataKey2, CollectionsKt.firstOrNull((List)nodes2));
        DataKey dataKey3 = CommonDataKeys.NAVIGATABLE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"NAVIGATABLE_ARRAY");
        Iterable $this$toTypedArray$iv = nodes2;
        boolean $i$f$toTypedArray = false;
        Iterable thisCollection$iv = $this$toTypedArray$iv;
        sink.set(dataKey3, (Object)thisCollection$iv.toArray(new JupyterRemoteNode[0]));
        DataKey dataKey4 = PlatformDataKeys.VIRTUAL_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey4, (String)"VIRTUAL_FILE");
        JupyterRemoteNode jupyterRemoteNode = (JupyterRemoteNode)((Object)CollectionsKt.firstOrNull((List)nodes2));
        sink.set(dataKey4, jupyterRemoteNode != null ? jupyterRemoteNode.getVirtualFile() : null);
        DataKey dataKey5 = PlatformDataKeys.VIRTUAL_FILE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey5, (String)"VIRTUAL_FILE_ARRAY");
        $this$toTypedArray$iv = nodes2;
        DataKey dataKey6 = dataKey5;
        DataSink dataSink = sink;
        $i$f$mapNotNull = false;
        thisCollection$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            it = (JupyterRemoteNode)((Object)element$iv$iv);
            boolean bl4 = false;
            if (((JupyterRemoteNode)((Object)it)).getVirtualFile() == null) continue;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        $this$mapNotNull$iv = list;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        dataSink.set(dataKey6, (Object)thisCollection$iv.toArray(new VirtualFile[0]));
        DataKey dataKey7 = LangDataKeys.IDE_VIEW;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey7, (String)"IDE_VIEW");
        sink.set(dataKey7, (Object)this.getIdeView(selection));
        JupyterRemoteCopyPasteProvider copyPasteProvider = new JupyterRemoteCopyPasteProvider();
        DataKey dataKey8 = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey8, (String)"COPY_PROVIDER");
        sink.set(dataKey8, (Object)copyPasteProvider);
        DataKey dataKey9 = PlatformDataKeys.CUT_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey9, (String)"CUT_PROVIDER");
        sink.set(dataKey9, (Object)copyPasteProvider);
        DataKey dataKey10 = PlatformDataKeys.PASTE_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey10, (String)"PASTE_PROVIDER");
        sink.set(dataKey10, (Object)copyPasteProvider);
    }

    private final Collection<AbstractTreeNode<?>> filterOutJupyterServerModules(Collection<AbstractTreeNode<?>> children) {
        Iterator<AbstractTreeNode<?>> iter = children.iterator();
        while (iter.hasNext()) {
            Object nodeValue = iter.next().getValue();
            if (!(nodeValue instanceof PsiDirectory) || !(((PsiDirectory)nodeValue).getVirtualFile() instanceof JupyterRemoteVirtualFile)) continue;
            iter.remove();
        }
        return children;
    }

    private final IdeView getIdeView(Collection<? extends AbstractTreeNode<?>> selected) {
        ProjectManager projectManager = ProjectManager.getInstance();
        Project[] projectArray = projectManager.getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Project project = (Project)ArraysKt.singleOrNull((Object[])projectArray);
        if (project == null) {
            Project project2 = projectManager.getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        Project currentProject = project;
        AbstractProjectViewPane projectViewPane = ProjectView.getInstance((Project)currentProject).getCurrentProjectViewPane();
        return new IdeView(projectViewPane, selected, currentProject){
            private final IdeViewForProjectViewPane delegate;
            final /* synthetic */ Collection<AbstractTreeNode<?>> $selected;
            final /* synthetic */ Project $currentProject;
            {
                this.$selected = $selected;
                this.$currentProject = $currentProject;
                this.delegate = new IdeViewForProjectViewPane(() -> getIdeView.1.delegate$lambda$0($projectViewPane));
            }

            /*
             * WARNING - void declaration
             */
            public PsiDirectory[] getDirectories() {
                void $this$map2Array$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.$selected;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof JupyterRemoteNode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile virtualFile2;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    JupyterRemoteNode jupyterRemoteNode = (JupyterRemoteNode)((Object)element$iv$iv);
                    boolean bl2 = false;
                    JupyterRemoteNode jupyterRemoteNode2 = jupyterRemoteNode;
                    if (jupyterRemoteNode2 instanceof JupyterRemoteDirectoryNode) {
                        virtualFile2 = ((JupyterRemoteDirectoryNode)jupyterRemoteNode).getVirtualFile();
                    } else if (jupyterRemoteNode2 instanceof JupyterRemoteFileNode || jupyterRemoteNode2 instanceof JupyterRemoteLoadingNode) {
                        AbstractTreeNode abstractTreeNode = jupyterRemoteNode.getParent();
                        Intrinsics.checkNotNull((Object)abstractTreeNode, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteDirectoryNode");
                        virtualFile2 = ((JupyterRemoteDirectoryNode)abstractTreeNode).getVirtualFile();
                    } else if (jupyterRemoteNode2 instanceof JupyterRemoteNotLoadedNode) {
                        virtualFile2 = null;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    if (virtualFile2 == null) continue;
                    VirtualFile it$iv$iv = virtualFile2;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                PsiDirectoryFactory psiDirectoryFactory = PsiDirectoryFactory.getInstance((Project)this.$currentProject);
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryFactory, (String)"getInstance(...)");
                PsiDirectoryFactory psiDirectoryFactory2 = psiDirectoryFactory;
                boolean $i$f$map2Array = false;
                PsiDirectory[] psiDirectoryArray = new PsiDirectory[$this$map2Array$iv.size()];
                Object[] array$iv = psiDirectoryArray;
                boolean bl = false;
                Iterable $this$forEachIndexed$iv$iv = (Iterable)$this$map2Array$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$forEachIndexed$iv$iv) {
                    void p0;
                    void t$iv;
                    int n;
                    if ((n = index$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    T bl2 = item$iv$iv;
                    int index$iv = n;
                    boolean bl4 = false;
                    VirtualFile bl3 = (VirtualFile)t$iv;
                    int n2 = index$iv;
                    Object[] objectArray = array$iv;
                    boolean bl5 = false;
                    PsiDirectory psiDirectory = psiDirectoryFactory2.createDirectory((VirtualFile)p0);
                    objectArray[n2] = psiDirectory;
                }
                return (PsiDirectory[])((Object[])psiDirectoryArray);
            }

            public PsiDirectory getOrChooseDirectory() {
                return DirectoryChooserUtil.getOrChooseDirectory((IdeView)this);
            }

            public void selectElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.delegate.selectElement(element);
            }

            private static final AbstractProjectViewPane delegate$lambda$0(AbstractProjectViewPane $projectViewPane) {
                return $projectViewPane;
            }
        };
    }
}

