/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.server;

import com.intellij.jupyter.core.jupyter.helper.ModuleExtensionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/server/JupyterServerPathUtils;", "", "<init>", "()V", "getContentRootForFile", "Ljava/nio/file/Path;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRelativePathFromModule", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterServerPathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterServerPathUtils.kt\ncom/intellij/jupyter/core/jupyter/server/JupyterServerPathUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n11879#2,9:32\n13805#2:41\n13806#2:43\n11888#2:44\n1#3:42\n295#4,2:45\n*S KotlinDebug\n*F\n+ 1 JupyterServerPathUtils.kt\ncom/intellij/jupyter/core/jupyter/server/JupyterServerPathUtils\n*L\n17#1:32,9\n17#1:41\n17#1:43\n17#1:44\n17#1:42\n20#1:45,2\n*E\n"})
public final class JupyterServerPathUtils {
    @NotNull
    public static final JupyterServerPathUtils INSTANCE = new JupyterServerPathUtils();

    private JupyterServerPathUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Path getContentRootForFile(@NotNull Module module, @Nullable VirtualFile file) {
        Object v2;
        block4: {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile[] virtualFileArray = ModuleExtensionsKt.getRootManager(module).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            VirtualFile[] roots = virtualFileArray;
            if (roots.length == 1 || file == null) {
                return null;
            }
            VirtualFile[] $this$mapNotNull$iv = roots;
            boolean $i$f$mapNotNull = false;
            VirtualFile[] virtualFileArray2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Path it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (VirtualFileUtil.toNioPathOrNull((VirtualFile)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List contentRootsPath = (List)destination$iv$iv;
            Path path = file.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            Path filePath = path;
            Iterable $this$firstOrNull$iv = contentRootsPath;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it = (Path)element$iv;
                boolean bl = false;
                if (!filePath.startsWith(it)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Path path = v2;
        if (path == null) {
            return null;
        }
        Path matchingContentRoot = path;
        Path path2 = matchingContentRoot.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        return path2;
    }

    @Nullable
    public final Path getRelativePathFromModule(@NotNull Module module, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = this.getContentRootForFile(module, file);
        if (path == null) {
            VirtualFile virtualFile2 = ModuleExtensionsKt.getBaseDir(module);
            path = virtualFile2 != null ? VirtualFileUtil.toNioPathOrNull((VirtualFile)virtualFile2) : null;
            if (path == null) {
                VirtualFile virtualFile3 = module.getProject().getBaseDir();
                path = virtualFile3 != null ? VirtualFileUtil.toNioPathOrNull((VirtualFile)virtualFile3) : null;
                if (path == null) {
                    return null;
                }
            }
        }
        Path contentRootForFile = path;
        Path path2 = VirtualFileUtil.toNioPathOrNull((VirtualFile)file);
        return path2 != null ? PathsKt.relativeToOrNull((Path)path2, (Path)contentRootForFile) : null;
    }
}

