<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="xml" indent="yes"/>

  <!-- Template for all elements -->
  <xsl:template match="*">
    <xsl:copy>
      <!-- Move the id attribute -->
      <xsl:if test="@id">
        <xsl:attribute name="id">
          <xsl:value-of select="@id"/>
        </xsl:attribute>
      </xsl:if>
      <!-- Move the version attribute -->
      <xsl:if test="@declared-in">
        <xsl:attribute name="declared-in">
          <xsl:value-of select="@declared-in"/>
        </xsl:attribute>
      </xsl:if>

      <!-- Output all other attributes except id -->
      <xsl:for-each select="@*">
        <xsl:if test="name() != 'id' and name() != 'declared-in'">
          <xsl:attribute name="{name()}">
            <xsl:value-of select="."/>
          </xsl:attribute>
        </xsl:if>
      </xsl:for-each>

      <!-- Copy all child nodes -->
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <!-- Template for comment nodes -->
  <xsl:template match="comment()">
    <xsl:comment>
      <xsl:value-of select="."/>
    </xsl:comment>
  </xsl:template>
</xsl:stylesheet>
