/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.constants.BvAnnoConstants;
import com.intellij.beanValidation.highlighting.BaseBeanValidationInspection;
import com.intellij.beanValidation.highlighting.fixes.SwapMinMax;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinMaxValuesInspection
extends BaseBeanValidationInspection {
    private static final PsiConstantEvaluationHelper HELPER = new PsiConstantEvaluationHelperImpl();

    @Override
    public ProblemDescriptor[] checkAnnotation(@NotNull PsiAnnotation anno, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (anno == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(1);
        }
        if (MinMaxValuesInspection.isMinMaxAnnotation(anno)) {
            PsiAnnotationMemberValue maxValue = anno.findAttributeValue("max");
            PsiAnnotationMemberValue minValue = anno.findAttributeValue("min");
            if (maxValue == null || minValue == null) {
                return null;
            }
            PsiElement maxElement = maxValue.getOriginalElement();
            PsiElement minElement = minValue.getOriginalElement();
            if (maxElement instanceof PsiExpression && minElement instanceof PsiExpression) {
                Integer max = MinMaxValuesInspection.getIntOrNull(HELPER.computeConstantExpression(maxElement));
                Integer min = MinMaxValuesInspection.getIntOrNull(HELPER.computeConstantExpression(minElement));
                if (max == null && min == null) {
                    return null;
                }
                ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
                if (min != null && min < 0 && MinMaxValuesInspection.isLengthAnnotation(anno)) {
                    problems.add(manager.createProblemDescriptor(minElement, BVInspectionBundle.message("min.value.is.negative", new Object[0]), isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
                if (max != null && min != null && min > max) {
                    problems.add(manager.createProblemDescriptor(maxElement, BVInspectionBundle.message("max.value.is.less.than.min", new Object[0]), (LocalQuickFix)new SwapMinMax(minElement, maxElement, min, max), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                }
                return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
            }
        }
        return null;
    }

    @Nullable
    public static Integer getIntOrNull(@Nullable Object obj) {
        String value;
        String string = value = obj == null ? null : obj.toString();
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isMinMaxAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(2);
        }
        return MinMaxValuesInspection.isLengthAnnotation(anno) || MinMaxValuesInspection.isSizeAnnotation(anno);
    }

    public static boolean isLengthAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(3);
        }
        return "org.hibernate.validator.constraints.Length".equals(anno.getQualifiedName());
    }

    public static boolean isSizeAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            MinMaxValuesInspection.$$$reportNull$$$0(4);
        }
        return BvAnnoConstants.SIZE.isFqn(anno.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/beanValidation/highlighting/MinMaxValuesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isMinMaxAnnotation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLengthAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSizeAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

