/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.css.JavaFxCssBundle;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxCSSReferenceContributor;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class JavaFxUnresolvedStyleClassReferenceInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaFxUnresolvedStyleClassReferenceInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(this){

            public void visitXmlFile(@NotNull XmlFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!JavaFxFileTypeFactory.isFxml((PsiFile)file)) {
                    return;
                }
                super.visitXmlFile(file);
            }

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                XmlTag parentTag;
                XmlTag xmlTag;
                String attributeName;
                if (attribute == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ("styleClass".equals(attributeName = attribute.getName())) {
                    this.checkStyleAttribute(attribute);
                } else if ("fx:value".equals(attributeName) && (xmlTag = attribute.getParent()) != null && (parentTag = xmlTag.getParentTag()) != null && "styleClass".equals(parentTag.getName())) {
                    this.checkStyleAttribute(attribute);
                }
            }

            private void checkStyleAttribute(XmlAttribute attribute) {
                XmlAttributeValue valueElement = attribute.getValueElement();
                if (valueElement != null) {
                    PsiReference[] references;
                    for (PsiReference reference : references = valueElement.getReferences()) {
                        LocalQuickFix[] localQuickFixArray;
                        if (!(reference instanceof JavaFxCSSReferenceContributor.JavaFxCssReference) || ((JavaFxCSSReferenceContributor.JavaFxCssReference)reference).multiResolve(false).length != 0) continue;
                        Collection<VirtualFile> files = ((JavaFxCSSReferenceContributor.JavaFxCssReference)reference).getCssFiles();
                        PsiElement psiElement = reference.getElement();
                        TextRange textRange = reference.getRangeInElement();
                        String string = JavaFxCssBundle.message("unresolved.style.class.problem.description", new Object[0]);
                        if (files.isEmpty() || !holder.isOnTheFly()) {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        } else {
                            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                            localQuickFixArray = localQuickFixArray2;
                            localQuickFixArray2[0] = new JavaFxCreateStyleClassFromUsageFix(reference.getCanonicalText());
                        }
                        holder.registerProblem(psiElement, textRange, string, localQuickFixArray);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttribute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection", "buildVisitor"));
    }

    private static class JavaFxCreateStyleClassFromUsageFix
    implements LocalQuickFix {
        private static final Logger LOG = Logger.getInstance(JavaFxCreateStyleClassFromUsageFix.class);
        private final String myRefName;

        JavaFxCreateStyleClassFromUsageFix(String refName) {
            this.myRefName = refName;
        }

        @NotNull
        public String getName() {
            String string = JavaFxCssBundle.message("create.style.class.reference.name", this.myRefName);
            if (string == null) {
                JavaFxCreateStyleClassFromUsageFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaFxCssBundle.message("create.style.class.family.name", new Object[0]);
            if (string == null) {
                JavaFxCreateStyleClassFromUsageFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                JavaFxCreateStyleClassFromUsageFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                JavaFxCreateStyleClassFromUsageFix.$$$reportNull$$$0(3);
            }
            if ((psiElement = descriptor.getPsiElement()) == null) {
                return;
            }
            PsiReference reference = psiElement.getReference();
            if (!(reference instanceof JavaFxCSSReferenceContributor.JavaFxCssReference)) {
                return;
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (virtualFile == null) {
                return;
            }
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
            Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
            ApplicationManager.getApplication().invokeLater(() -> {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                Collection<VirtualFile> files = ((JavaFxCSSReferenceContributor.JavaFxCssReference)reference).getCssFiles();
                if (files.size() == 1) {
                    this.createClassInFile(project, psiManager.findFile(files.iterator().next()));
                } else {
                    Object[] psiFiles = (PsiFile[])ContainerUtil.map2Array(files, PsiFile.class, arg_0 -> ((PsiManager)psiManager).findFile(arg_0));
                    JBList list = new JBList(psiFiles);
                    int width = WindowManagerEx.getInstanceEx().getFrame((Project)project).getSize().width;
                    list.setCellRenderer((ListCellRenderer)new GotoFileCellRenderer(width));
                    JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(JavaFxCssBundle.message("create.style.class.choose.popup.title", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(() -> this.createClassInFile(project, (PsiFile)list.getSelectedValue())).createPopup();
                    if (editor != null) {
                        popup.showInBestPositionFor(editor);
                    } else {
                        popup.showCenteredInCurrentWindow(project);
                    }
                }
            });
        }

        private void createClassInFile(Project project, PsiFile psiFile) {
            if (psiFile instanceof StylesheetFile) {
                if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
                    return;
                }
                IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
                String styleClassText = "." + this.myRefName + "{}";
                StylesheetFile fileWithStyleClass = (StylesheetFile)PsiFileFactory.getInstance((Project)project).createFileFromText("javafx.dummy.css", (Language)CSSLanguage.INSTANCE, (CharSequence)styleClassText);
                CssStylesheet stylesheet = fileWithStyleClass.getStylesheet();
                LOG.assertTrue(stylesheet != null);
                CssRuleset[] rulesets = stylesheet.getRulesetList().getRulesets();
                LOG.assertTrue(rulesets.length == 1);
                @Nls String commandName = this.getName();
                SmartPsiElementPointer newStyleClass = (SmartPsiElementPointer)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{psiFile}).withName(commandName).compute(() -> {
                    PsiElement element1 = psiFile.add((PsiElement)rulesets[0]);
                    return SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(element1);
                });
                PsiElement element = newStyleClass.getElement();
                if (element != null) {
                    NavigationUtil.activateFileWithPsiElement((PsiElement)element);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$JavaFxCreateStyleClassFromUsageFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/javaFX/css/inspections/JavaFxUnresolvedStyleClassReferenceInspection$JavaFxCreateStyleClassFromUsageFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

