/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.javaee;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.data.Ear;
import org.jetbrains.plugins.gradle.model.data.EarConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.EarResource;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.model.data.War;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;
import org.jetbrains.plugins.gradle.model.data.WebConfigurationModelData;
import org.jetbrains.plugins.gradle.model.data.WebResource;
import org.jetbrains.plugins.gradle.model.ear.EarConfiguration;
import org.jetbrains.plugins.gradle.model.web.WebConfiguration;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.LibraryDataNodeSubstitutor;
import org.jetbrains.plugins.gradle.service.project.MapBasedArtifactMappingService;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Order(value=1000)
final class JavaEEGradleProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final com.intellij.openapi.util.Key<ArtifactMappingService> ARCHIVES_ARTIFACTS = com.intellij.openapi.util.Key.create((String)"archivesArtifactsMap");
    private static final com.intellij.openapi.util.Key<List<Pair<DataNode<? extends ModuleData>, EarConfiguration>>> EAR_CONFIGURATIONS = com.intellij.openapi.util.Key.create((String)"earConfigurations");

    JavaEEGradleProjectResolverExtension() {
    }

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        EarConfiguration earConfiguration;
        WebConfiguration webConfiguration;
        if (gradleModule == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(0);
        }
        if (ideModule == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(1);
        }
        DataNode projectDataNode = ideModule.getParent(ProjectData.class);
        NotNullLazyValue findTargetModuleNode = NotNullLazyValue.createValue(() -> {
            String mainSourceSetModuleId = ((ModuleData)ideModule.getData()).getId() + ":main";
            DataNode targetModuleNode = ExternalSystemApiUtil.find((DataNode)ideModule, (Key)GradleSourceSetData.KEY, node -> mainSourceSetModuleId.equals(((GradleSourceSetData)node.getData()).getId()));
            if (targetModuleNode == null) {
                targetModuleNode = ideModule;
            }
            return targetModuleNode;
        });
        if (projectDataNode != null) {
            ExternalProject externalProject;
            ArtifactMappingService archivesMap = (ArtifactMappingService)projectDataNode.getUserData(ARCHIVES_ARTIFACTS);
            if (archivesMap == null) {
                archivesMap = new MapBasedArtifactMappingService(CollectionFactory.createFilePathMap());
                projectDataNode.putUserData(ARCHIVES_ARTIFACTS, (Object)archivesMap);
            }
            if ((externalProject = (ExternalProject)this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null && externalProject.getArtifactsByConfiguration().get("archives") != null) {
                HashSet archivesArtifacts = new HashSet((Collection)externalProject.getArtifactsByConfiguration().get("archives"));
                Set testsArtifacts = (Set)externalProject.getArtifactsByConfiguration().get("tests");
                if (testsArtifacts != null) {
                    archivesArtifacts.removeAll(testsArtifacts);
                }
                for (File artifactFile : archivesArtifacts) {
                    archivesMap.storeModuleId(ExternalSystemApiUtil.toCanonicalPath((String)artifactFile.getAbsolutePath()), ((ModuleData)((DataNode)findTargetModuleNode.getValue()).getData()).getId());
                }
            }
        }
        if ((webConfiguration = (WebConfiguration)this.resolverCtx.getExtraProject(gradleModule, WebConfiguration.class)) != null) {
            List warModels = ContainerUtil.map((Collection)webConfiguration.getWarModels(), model -> {
                War war = new War(model.getWarName(), model.getWebAppDirName(), model.getWebAppDir());
                war.setWebXml(model.getWebXml());
                war.setWebResources(JavaEEGradleProjectResolverExtension.mapWebResources(model.getWebResources()));
                war.setClasspath(model.getClasspath());
                war.setManifestContent(model.getManifestContent());
                war.setArchivePath(model.getArchivePath());
                return war;
            });
            ((DataNode)findTargetModuleNode.getValue()).createChild(WebConfigurationModelData.KEY, (Object)new WebConfigurationModelData(GradleConstants.SYSTEM_ID, warModels));
        }
        if ((earConfiguration = (EarConfiguration)this.resolverCtx.getExtraProject(gradleModule, EarConfiguration.class)) != null && projectDataNode != null) {
            ArrayList<Pair> ears = (ArrayList<Pair>)projectDataNode.getUserData(EAR_CONFIGURATIONS);
            if (ears == null) {
                ears = new ArrayList<Pair>();
                projectDataNode.putUserData(EAR_CONFIGURATIONS, ears);
            }
            ears.add(Pair.create((Object)((DataNode)findTargetModuleNode.getValue()), (Object)earConfiguration));
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public Set<Class<?>> getExtraProjectModelClasses() {
        Set<Class<?>> set = Set.of(WebConfiguration.class, EarConfiguration.class);
        if (set == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(2);
        }
        return set;
    }

    public void resolveFinished(@NotNull DataNode<ProjectData> projectDataNode) {
        List earConfigurations;
        if (projectDataNode == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(3);
        }
        if ((earConfigurations = (List)projectDataNode.getUserData(EAR_CONFIGURATIONS)) == null) {
            return;
        }
        for (Pair pair : earConfigurations) {
            DataNode moduleNode = (DataNode)pair.first;
            EarConfiguration earConfiguration = (EarConfiguration)pair.second;
            List warModels = ContainerUtil.map((Collection)earConfiguration.getEarModels(), model -> {
                Ear ear = new Ear(model.getEarName(), model.getAppDirName(), model.getLibDirName());
                ear.setManifestContent(model.getManifestContent());
                ear.setDeploymentDescriptor(model.getDeploymentDescriptor());
                ear.setResources(JavaEEGradleProjectResolverExtension.mapEarResources(model.getResources()));
                ear.setArchivePath(model.getArchivePath());
                return ear;
            });
            Collection<DependencyData<?>> deployDependencies = JavaEEGradleProjectResolverExtension.getDependencies(this.resolverCtx, projectDataNode, (DataNode<? extends ModuleData>)moduleNode, earConfiguration.getDeployDependencies());
            Collection<DependencyData<?>> earlibDependencies = JavaEEGradleProjectResolverExtension.getDependencies(this.resolverCtx, projectDataNode, (DataNode<? extends ModuleData>)moduleNode, earConfiguration.getEarlibDependencies());
            moduleNode.createChild(EarConfigurationModelData.KEY, (Object)new EarConfigurationModelData(GradleConstants.SYSTEM_ID, warModels, deployDependencies, earlibDependencies));
        }
    }

    private static List<WebResource> mapWebResources(List<WebConfiguration.WebResource> webResources) {
        return ContainerUtil.mapNotNull(webResources, resource -> {
            if (resource == null) {
                return null;
            }
            WarDirectory warDirectory = WarDirectory.fromPath((String)resource.getWarDirectory());
            return new WebResource(warDirectory, resource.getRelativePath(), resource.getFile());
        });
    }

    private static List<EarResource> mapEarResources(List<EarConfiguration.EarResource> resources) {
        return ContainerUtil.mapNotNull(resources, resource -> {
            if (resource == null) {
                return null;
            }
            return new EarResource(resource.getEarDirectory(), resource.getRelativePath(), resource.getFile());
        });
    }

    private static Collection<DependencyData<?>> getDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull DataNode<ProjectData> ideProject, @NotNull DataNode<? extends ModuleData> moduleDataNode, @NotNull Collection<ExternalDependency> dependencies) throws IllegalStateException {
        ArtifactMappingService allArtifactsMap;
        if (resolverCtx == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(4);
        }
        if (ideProject == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(5);
        }
        if (moduleDataNode == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(6);
        }
        if (dependencies == null) {
            JavaEEGradleProjectResolverExtension.$$$reportNull$$$0(7);
        }
        Map moduleOutputsMap = (Map)ideProject.getUserData(GradleProjectResolver.MODULES_OUTPUTS);
        assert (moduleOutputsMap != null);
        Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        ArtifactMappingService artifactsMap = resolverCtx.getArtifactsMap();
        assert (artifactsMap != null);
        ArtifactMappingService archivesMap = (ArtifactMappingService)ideProject.getUserData(ARCHIVES_ARTIFACTS);
        if (archivesMap != null) {
            allArtifactsMap = new MapBasedArtifactMappingService(CollectionFactory.createFilePathMap());
            allArtifactsMap.putAll(artifactsMap);
            allArtifactsMap.putAll(archivesMap);
        } else {
            allArtifactsMap = artifactsMap;
        }
        DataNode fakeNode = new DataNode(moduleDataNode.getKey(), moduleDataNode.getData(), null);
        GradleProjectResolverUtil.buildDependencies((ProjectResolverContext)resolverCtx, (Map)sourceSetMap, (ArtifactMappingService)allArtifactsMap, (DataNode)fakeNode, dependencies, null);
        LibraryDataNodeSubstitutor librarySubstitutor = new LibraryDataNodeSubstitutor(resolverCtx, null, null, sourceSetMap, moduleOutputsMap, allArtifactsMap);
        Collection libraryDependencies = ExternalSystemApiUtil.findAllRecursively((DataNode)fakeNode, (Key)ProjectKeys.LIBRARY_DEPENDENCY);
        for (DataNode libraryDependencyDataNode : libraryDependencies) {
            librarySubstitutor.run(libraryDependencyDataNode);
        }
        Collection dataNodes = ExternalSystemApiUtil.findAllRecursively((DataNode)fakeNode, node -> node.getData() instanceof DependencyData);
        return ContainerUtil.map((Collection)dataNodes, node -> (DependencyData)node.getData());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/javaee/JavaEEGradleProjectResolverExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolverCtx";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDataNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/javaee/JavaEEGradleProjectResolverExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveFinished";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

