/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.server;

import com.intellij.javaee.oss.server.WslConfiguration;
import com.intellij.javaee.oss.server.WslSupportUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u001d\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n2\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/tomcat/server/TomcatWslInspector;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getServerInfo", "", "tomcatHome", "searchForLibraries", "", "Ljava/io/File;", "(Ljava/lang/String;)[Ljava/io/File;", "deployTomcatInspectorIfNeeded", "", "wslConfiguration", "Lcom/intellij/javaee/oss/server/WslConfiguration;", "getTomcatInspectorDir", "getTomcatInspectorLocation", "getTomcatInspectorBinaryName", "intellij.javaee.appServers.tomcat"})
@SourceDebugExtension(value={"SMAP\nTomcatWslInspector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomcatWslInspector.kt\norg/jetbrains/idea/tomcat/server/TomcatWslInspector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,99:1\n1563#2:100\n1634#2,3:101\n37#3,2:104\n13#4:106\n*S KotlinDebug\n*F\n+ 1 TomcatWslInspector.kt\norg/jetbrains/idea/tomcat/server/TomcatWslInspector\n*L\n52#1:100\n52#1:101,3\n54#1:104,2\n21#1:106\n*E\n"})
public final class TomcatWslInspector {
    @NotNull
    public static final TomcatWslInspector INSTANCE = new TomcatWslInspector();
    @NotNull
    private static final Logger LOG;

    private TomcatWslInspector() {
    }

    @JvmStatic
    @Nullable
    public static final String getServerInfo(@NotNull String tomcatHome) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)tomcatHome, (String)"tomcatHome");
        WslConfiguration wslConfiguration = WslSupportUtil.INSTANCE.getWslConfiguration(tomcatHome);
        if (wslConfiguration == null) {
            return null;
        }
        WslConfiguration wslConfiguration2 = wslConfiguration;
        if (!INSTANCE.deployTomcatInspectorIfNeeded(wslConfiguration2)) {
            return null;
        }
        StringBuilder $this$getServerInfo_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getServerInfo_u24lambda_u240.append(INSTANCE.getTomcatInspectorLocation());
        $this$getServerInfo_u24lambda_u240.append(" ");
        $this$getServerInfo_u24lambda_u240.append("getServerInfo");
        $this$getServerInfo_u24lambda_u240.append(" ");
        $this$getServerInfo_u24lambda_u240.append(WslSupportUtil.fromWslToLinuxPath((String)tomcatHome));
        String command = stringBuilder.toString();
        List list = WslSupportUtil.INSTANCE.executeOnWsl(wslConfiguration2, command);
        return list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final File[] searchForLibraries(@NotNull String tomcatHome) {
        File[] fileArray;
        block7: {
            block6: {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)tomcatHome, (String)"tomcatHome");
                WslConfiguration wslConfiguration = WslSupportUtil.INSTANCE.getWslConfiguration(tomcatHome);
                if (wslConfiguration == null) {
                    return new File[0];
                }
                WslConfiguration wslConfiguration2 = wslConfiguration;
                if (!INSTANCE.deployTomcatInspectorIfNeeded(wslConfiguration2)) {
                    return new File[0];
                }
                StringBuilder $this$searchForLibraries_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$searchForLibraries_u24lambda_u240.append(INSTANCE.getTomcatInspectorLocation());
                $this$searchForLibraries_u24lambda_u240.append(" ");
                $this$searchForLibraries_u24lambda_u240.append("searchForClasses");
                $this$searchForLibraries_u24lambda_u240.append(" ");
                $this$searchForLibraries_u24lambda_u240.append(WslSupportUtil.fromWslToLinuxPath((String)tomcatHome));
                String command = stringBuilder.toString();
                fileArray = WslSupportUtil.INSTANCE.executeOnWsl(wslConfiguration2, command);
                if (fileArray == null) break block6;
                Iterable $this$map$iv = (Iterable)fileArray;
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void classInJar;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new File(WslSupportUtil.INSTANCE.fromLinuxToWslPath(StringsKt.substringAfter$default((String)classInJar, (char)':', null, (int)2, null), wslConfiguration2)));
                }
                Collection $i$f$map22 = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                fileArray = thisCollection$iv.toArray(new File[0]);
                if (fileArray != null) break block7;
            }
            fileArray = new File[]{};
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean deployTomcatInspectorIfNeeded(WslConfiguration wslConfiguration) {
        File tomcatInspectorDir = new File(WslSupportUtil.INSTANCE.fromLinuxToWslPath(this.getTomcatInspectorDir(), wslConfiguration));
        if (!tomcatInspectorDir.exists() && !tomcatInspectorDir.mkdirs()) {
            LOG.warn("Unable to create a directory for Tomcat WSL inspector: " + tomcatInspectorDir.getPath());
            return false;
        }
        String tomcatInspectorBinaryName = this.getTomcatInspectorBinaryName();
        File tomcatInspector = new File(tomcatInspectorDir, tomcatInspectorBinaryName);
        if (tomcatInspector.exists()) {
            return true;
        }
        try {
            Closeable closeable = new FileOutputStream(tomcatInspector);
            Throwable throwable = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)closeable;
                boolean bl = false;
                InputStream inputStream = TomcatWslInspector.class.getClassLoader().getResourceAsStream("org/jetbrains/idea/tomcat/" + tomcatInspectorBinaryName);
                Long l = inputStream != null ? Long.valueOf(inputStream.transferTo(outputStream)) : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to deploy Tomcat WSL inspector", (Throwable)e);
            return false;
        }
        WslSupportUtil.INSTANCE.executeOnWsl(wslConfiguration, "chmod a+x " + this.getTomcatInspectorLocation());
        return true;
    }

    private final String getTomcatInspectorDir() {
        String string = ApplicationInfo.getInstance().getVersionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionName(...)");
        String applicationName = StringsKt.replace$default((String)string, (char)' ', (char)'-', (boolean)false, (int)4, null);
        return "/var/tmp/JetBrains/" + applicationName + "/2023.2.0/app-servers/tomcat/tomcat-inspector";
    }

    private final String getTomcatInspectorLocation() {
        return this.getTomcatInspectorDir() + "/" + this.getTomcatInspectorBinaryName();
    }

    private final String getTomcatInspectorBinaryName() {
        return "tomcat-inspector-2023.2.0.bin";
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TomcatWslInspector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

