/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.logs.KubernetesLogUtilsKt;
import com.intellij.kubernetes.splitApi.KubernetesActionsRpcServiceKt;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.nodes.KubernetesCachedValueBasedServiceViewContributorBase;
import com.intellij.kubernetes.view.nodes.KubernetesNamespacedKeyValueResourceServiceViewContributor;
import com.intellij.kubernetes.view.nodes.KubernetesServiceViewDescriptor;
import com.intellij.kubernetes.view.nodes.crd.KubernetesCustomResourceDefinitionServiceViewContributor;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerServiceViewDescriptor;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesEventContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesPodServiceViewContributorDescriptorKt;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeleteResourceProviderKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesPodContainerActionBaseKt;
import com.intellij.kubernetes.view.ui.actions.SelectedKubernetesResource;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1CronJob;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001d\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u001f\u0010\u0006\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u001a\u0018\u00101\u001a\u0004\u0018\u0001002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020*\u001a\u000f\u0010;\u001a\u00070&\u00a2\u0006\u0002\b<*\u000209\u001a1\u0010=\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\u0006\u0010>\u001a\u00020\u00022\u0010\u0010?\u001a\f\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030@H\u0002\u00a2\u0006\u0002\u0010A\u001a\n\u0010K\u001a\u00020L*\u00020\u0004\u001a\u0018\u0010M\u001a\b\u0012\u0004\u0012\u00020F08*\u00020\u0004H\u0086@\u00a2\u0006\u0002\u0010N\u001a2\u0010O\u001a\b\u0012\u0004\u0012\u00020P082\u0006\u0010>\u001a\u0002092\u0006\u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020P08H\u0082@\u00a2\u0006\u0002\u0010T\u001a\u0006\u0010U\u001a\u00020V\"\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\n8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\b*\u00020\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u00048\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\"\u0017\u0010 \u001a\u0004\u0018\u00010!*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\"\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\"\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020*0%\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010(\"\u0017\u0010,\u001a\u0004\u0018\u00010**\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\"\u0017\u0010/\u001a\u0004\u0018\u000100*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b1\u00102\"\u0017\u0010/\u001a\u0004\u0018\u000100*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b1\u00106\"\u001d\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000209080%\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010(\"\u001d\u0010B\u001a\n\u0012\u0004\u0012\u000209\u0018\u000108*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\"\u0017\u0010E\u001a\b\u0012\u0004\u0012\u00020F0%\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010(\"\u0017\u0010H\u001a\u0004\u0018\u00010F*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\" \u0010>\u001a\u0004\u0018\u00010\u0002*\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u001e\u0010[\u001a\u00020L*\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\\\u0010X\u001a\u0004\b[\u0010]\"(\u0010^\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010_*\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b`\u0010X\u001a\u0004\ba\u0010b\u00a8\u0006c"}, d2={"getKubernetesResource", "T", "Lio/kubernetes/client/common/KubernetesObject;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lio/kubernetes/client/common/KubernetesObject;", "getKubernetesResourceOrNull", "selectedItems", "", "", "Lcom/intellij/openapi/actionSystem/DataContext;", "getSelectedItems", "(Lcom/intellij/openapi/actionSystem/DataContext;)[Ljava/lang/Object;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getFileEditor", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/openapi/fileEditor/FileEditor;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/openapi/vfs/VirtualFile;", "virtualFiles", "getVirtualFiles", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/psi/PsiFile;", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "getYamlFile", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lorg/jetbrains/yaml/psi/YAMLFile;", "editorEx", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getEditorEx", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/openapi/editor/ex/EditorEx;", "KUBERNETES_ENTRY_INFO_ID", "Lcom/intellij/openapi/actionSystem/DataKey;", "", "getKUBERNETES_ENTRY_INFO_ID", "()Lcom/intellij/openapi/actionSystem/DataKey;", "KUBERNETES_CONTEXT", "Lcom/intellij/kubernetes/api/Context;", "getKUBERNETES_CONTEXT", "kubernetesContext", "getKubernetesContext", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/kubernetes/api/Context;", "backendApiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "getBackendApiModel", "(Lcom/intellij/openapi/actionSystem/DataContext;)Lcom/intellij/kubernetes/api/KubernetesApiModel;", "project", "Lcom/intellij/openapi/project/Project;", "ctx", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/kubernetes/api/KubernetesApiModel;", "KUBERNETES_RESOURCES", "", "Lcom/intellij/kubernetes/view/ui/actions/SelectedKubernetesResource;", "getKUBERNETES_RESOURCES", "getResourceDisplayableName", "Lorg/jetbrains/annotations/Nls;", "getCastedValue", "resource", "entity", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/api/KubernetesEntity;)Lio/kubernetes/client/common/KubernetesObject;", "selectedKubernetesResources", "getSelectedKubernetesResources", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Ljava/util/List;", "KUBERNETES_CONTAINER", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "getKUBERNETES_CONTAINER", "kubContainer", "getKubContainer", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "canGetServiceContainer", "", "getServiceContainers", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPodsForWorkload", "Lio/kubernetes/client/openapi/models/V1Pod;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "allPods", "(Lcom/intellij/kubernetes/view/ui/actions/SelectedKubernetesResource;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createResourceActionsGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getResource$annotations", "(Ljava/lang/Object;)V", "getResource", "(Ljava/lang/Object;)Lio/kubernetes/client/common/KubernetesObject;", "isDeletableResource", "isDeletableResource$annotations", "(Ljava/lang/Object;)Z", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "getMapper$annotations", "getMapper", "(Ljava/lang/Object;)Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nactionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 actionUtils.kt\ncom/intellij/kubernetes/view/ui/actions/ActionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,274:1\n62#1:275\n1563#2:276\n1634#2,3:277\n1761#2,3:280\n774#2:283\n865#2,2:284\n1563#2:286\n1634#2,2:287\n1563#2:289\n1634#2,3:290\n1563#2:293\n1634#2,3:294\n1636#2:297\n1374#2:298\n1460#2,5:299\n1374#2:304\n1460#2,5:305\n1374#2:310\n1460#2,5:311\n1374#2:316\n1460#2,5:317\n1374#2:322\n1460#2,5:323\n1374#2:328\n1460#2,5:329\n*S KotlinDebug\n*F\n+ 1 actionUtils.kt\ncom/intellij/kubernetes/view/ui/actions/ActionUtilsKt\n*L\n65#1:275\n171#1:276\n171#1:277,3\n171#1:280,3\n181#1:283\n181#1:284,2\n185#1:286\n185#1:287,2\n190#1:289\n190#1:290,3\n194#1:293\n194#1:294,3\n185#1:297\n210#1:298\n210#1:299,5\n215#1:304\n215#1:305,5\n220#1:310\n220#1:311,5\n225#1:316\n225#1:317,5\n230#1:322\n230#1:323,5\n235#1:328\n235#1:329,5\n*E\n"})
public final class ActionUtilsKt {
    @NotNull
    private static final DataKey<String> KUBERNETES_ENTRY_INFO_ID = DataKey.Companion.create("com.intellij.kubernetes.api.ENTRY_INFO_ID");
    @NotNull
    private static final DataKey<Context> KUBERNETES_CONTEXT = DataKey.Companion.create("com.intellij.kubernetes.api.KubernetesContext");
    @NotNull
    private static final DataKey<List<SelectedKubernetesResource>> KUBERNETES_RESOURCES = DataKey.Companion.create("com.intellij.kubernetes.api.KubernetesResourcesToRefresh");
    @NotNull
    private static final DataKey<KubernetesContainerObject> KUBERNETES_CONTAINER = DataKey.Companion.create("com.intellij.kubernetes.api.KubernetesContainer");

    @NotNull
    public static final <T extends KubernetesObject> T getKubernetesResource(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        List<SelectedKubernetesResource> list2 = ActionUtilsKt.getSelectedKubernetesResources(event2);
        if (list2 == null || (list2 = (SelectedKubernetesResource)CollectionsKt.singleOrNull(list2)) == null) {
            throw new NullPointerException("failed to extract k8s resource from event: selected item is null");
        }
        List<SelectedKubernetesResource> resource = list2;
        Object v = ((SelectedKubernetesResource)((Object)resource)).getCastedValue();
        if (v == null) {
            throw new NullPointerException("failed to extract k8s resource from event: selected item's resource is null. Selected item: " + (SelectedKubernetesResource)((Object)resource));
        }
        return (T)v;
    }

    @Nullable
    public static final <T extends KubernetesObject> T getKubernetesResourceOrNull(@NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        List<SelectedKubernetesResource> list2 = ActionUtilsKt.getSelectedKubernetesResources(event2);
        if (list2 == null || (list2 = (SelectedKubernetesResource)CollectionsKt.singleOrNull(list2)) == null) {
            return null;
        }
        List<SelectedKubernetesResource> resource = list2;
        return (T)((SelectedKubernetesResource)((Object)resource)).getCastedValue();
    }

    @NotNull
    public static final Object[] getSelectedItems(@NotNull DataContext $this$selectedItems) {
        Intrinsics.checkNotNullParameter((Object)$this$selectedItems, (String)"<this>");
        boolean $i$f$getSelectedItems = false;
        Object[] objectArray = (Object[])$this$selectedItems.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
        if (objectArray == null) {
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"EMPTY_OBJECT_ARRAY");
        }
        return objectArray;
    }

    @Nullable
    public static final FileEditor getFileEditor(@NotNull AnActionEvent $this$fileEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$fileEditor, (String)"<this>");
        boolean $i$f$getFileEditor = false;
        return (FileEditor)$this$fileEditor.getData(PlatformCoreDataKeys.FILE_EDITOR);
    }

    @Nullable
    public static final VirtualFile getVirtualFile(@NotNull AnActionEvent $this$virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualFile, (String)"<this>");
        boolean $i$f$getVirtualFile = false;
        return (VirtualFile)$this$virtualFile.getData(CommonDataKeys.VIRTUAL_FILE);
    }

    @NotNull
    public static final VirtualFile[] getVirtualFiles(@NotNull AnActionEvent $this$virtualFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualFiles, (String)"<this>");
        boolean $i$f$getVirtualFiles = false;
        VirtualFile[] virtualFileArray = (VirtualFile[])$this$virtualFiles.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        }
        return virtualFileArray;
    }

    @Nullable
    public static final PsiFile getPsiFile(@NotNull AnActionEvent $this$psiFile) {
        Intrinsics.checkNotNullParameter((Object)$this$psiFile, (String)"<this>");
        boolean $i$f$getPsiFile = false;
        return (PsiFile)$this$psiFile.getData(CommonDataKeys.PSI_FILE);
    }

    @Nullable
    public static final YAMLFile getYamlFile(@NotNull AnActionEvent $this$yamlFile) {
        Intrinsics.checkNotNullParameter((Object)$this$yamlFile, (String)"<this>");
        AnActionEvent $this$psiFile$iv = $this$yamlFile;
        boolean $i$f$getPsiFile = false;
        PsiFile psiFile = (PsiFile)$this$psiFile$iv.getData(CommonDataKeys.PSI_FILE);
        return psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
    }

    @Nullable
    public static final EditorEx getEditorEx(@NotNull AnActionEvent $this$editorEx) {
        Intrinsics.checkNotNullParameter((Object)$this$editorEx, (String)"<this>");
        Object object = $this$editorEx.getData(CommonDataKeys.EDITOR);
        return object instanceof EditorEx ? (EditorEx)object : null;
    }

    @NotNull
    public static final DataKey<String> getKUBERNETES_ENTRY_INFO_ID() {
        return KUBERNETES_ENTRY_INFO_ID;
    }

    @NotNull
    public static final DataKey<Context> getKUBERNETES_CONTEXT() {
        return KUBERNETES_CONTEXT;
    }

    @Nullable
    public static final Context getKubernetesContext(@NotNull DataContext $this$kubernetesContext) {
        Intrinsics.checkNotNullParameter((Object)$this$kubernetesContext, (String)"<this>");
        return (Context)$this$kubernetesContext.getData(KUBERNETES_CONTEXT);
    }

    @Nullable
    public static final KubernetesApiModel getBackendApiModel(@NotNull DataContext $this$backendApiModel) {
        Intrinsics.checkNotNullParameter((Object)$this$backendApiModel, (String)"<this>");
        Context context = ActionUtilsKt.getKubernetesContext($this$backendApiModel);
        if (context == null) {
            return null;
        }
        Context ctx = context;
        Project project = KubernetesDeleteResourceProviderKt.getProject($this$backendApiModel);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        return ActionUtilsKt.getBackendApiModel(project2, ctx);
    }

    @Nullable
    public static final KubernetesApiModel getBackendApiModel(@NotNull Project project, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesApiProvider.Companion.getInstance(project).findModel(ctx);
        return kubernetesApiModelInterface instanceof KubernetesApiModel ? (KubernetesApiModel)kubernetesApiModelInterface : null;
    }

    @Nullable
    public static final KubernetesApiModel getBackendApiModel(@NotNull AnActionEvent $this$backendApiModel) {
        Intrinsics.checkNotNullParameter((Object)$this$backendApiModel, (String)"<this>");
        DataContext dataContext = $this$backendApiModel.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return ActionUtilsKt.getBackendApiModel(dataContext);
    }

    @NotNull
    public static final DataKey<List<SelectedKubernetesResource>> getKUBERNETES_RESOURCES() {
        return KUBERNETES_RESOURCES;
    }

    @NotNull
    public static final String getResourceDisplayableName(@NotNull SelectedKubernetesResource $this$getResourceDisplayableName) {
        Intrinsics.checkNotNullParameter((Object)$this$getResourceDisplayableName, (String)"<this>");
        if ($this$getResourceDisplayableName.getSelectedAll()) {
            return $this$getResourceDisplayableName.getResourceKind().getDisplayableKind();
        }
        KubernetesObject kubernetesObject = $this$getResourceDisplayableName.getSingleSelectedValue();
        Intrinsics.checkNotNull((Object)kubernetesObject);
        KubernetesObject resource = kubernetesObject;
        Object[] objectArray = new Object[]{$this$getResourceDisplayableName.getResourceKind().getDisplayableKind(), resource.getMetadata().getName()};
        String string = KubernetesBundle.message("KubernetesResourceMapper.resourceDisplayableName.template", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final <T extends KubernetesObject> T getCastedValue(KubernetesObject resource, KubernetesEntity<T, ?> entity) {
        Object object = resource instanceof KubernetesObject ? resource : null;
        if (object == null) {
            throw new IllegalStateException("Unexpected resource kind: " + resource.getKind());
        }
        return (T)object;
    }

    @Nullable
    public static final List<SelectedKubernetesResource> getSelectedKubernetesResources(@NotNull AnActionEvent $this$selectedKubernetesResources) {
        Intrinsics.checkNotNullParameter((Object)$this$selectedKubernetesResources, (String)"<this>");
        return (List)$this$selectedKubernetesResources.getDataContext().getData(KUBERNETES_RESOURCES);
    }

    @NotNull
    public static final DataKey<KubernetesContainerObject> getKUBERNETES_CONTAINER() {
        return KUBERNETES_CONTAINER;
    }

    @Nullable
    public static final KubernetesContainerObject getKubContainer(@NotNull AnActionEvent $this$kubContainer) {
        Intrinsics.checkNotNullParameter((Object)$this$kubContainer, (String)"<this>");
        return (KubernetesContainerObject)$this$kubContainer.getDataContext().getData(KUBERNETES_CONTAINER);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canGetServiceContainer(@NotNull AnActionEvent $this$canGetServiceContainer) {
        boolean bl;
        block7: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$canGetServiceContainer, (String)"<this>");
            if (ActionUtilsKt.getKubContainer($this$canGetServiceContainer) != null) {
                return true;
            }
            if (KubernetesActionsRpcServiceKt.getApiModel($this$canGetServiceContainer) == null) {
                return false;
            }
            List<SelectedKubernetesResource> list2 = ActionUtilsKt.getSelectedKubernetesResources($this$canGetServiceContainer);
            if (list2 == null) {
                return false;
            }
            List<SelectedKubernetesResource> resources2 = list2;
            Iterable $this$map$iv = resources2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SelectedKubernetesResource selectedKubernetesResource = (SelectedKubernetesResource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getResourceKind());
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KubernetesEntity it = (KubernetesEntity)element$iv;
                    boolean bl3 = false;
                    if (!KubernetesPodContainerActionBaseKt.getResourcesWithContainers().contains(it)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object getServiceContainers(@NotNull AnActionEvent $this$getServiceContainers, @NotNull Continuation<? super List<? extends KubernetesContainerObject>> $completion) {
        if (!($completion instanceof getServiceContainers.1)) ** GOTO lbl-1000
        var32_2 = $completion;
        if ((var32_2.label & -2147483648) != 0) {
            var32_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                int I$0;
                int I$1;
                int I$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ActionUtilsKt.getServiceContainers(null, (Continuation<? super List<? extends KubernetesContainerObject>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var33_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = container = ActionUtilsKt.getKubContainer($this$getServiceContainers);
                if (v0 != null) {
                    return CollectionsKt.listOf((Object)v0);
                }
                v1 = $this$getServiceContainers.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getDataContext(...)");
                v2 = ActionUtilsKt.getKubernetesContext(v1);
                if (v2 == null) {
                    return CollectionsKt.emptyList();
                }
                ctx = v2;
                v3 = KubernetesActionsRpcServiceKt.getApiModel($this$getServiceContainers);
                if (v3 == null) {
                    return CollectionsKt.emptyList();
                }
                apiModel = v3;
                v4 = ActionUtilsKt.getSelectedKubernetesResources($this$getServiceContainers);
                if (v4 == null) {
                    return CollectionsKt.emptyList();
                }
                resources = v4;
                $this$filter$iv = resources;
                $i$f$filter = false;
                var9_12 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (SelectedKubernetesResource)element$iv$iv;
                    $i$a$-filter-ActionUtilsKt$getServiceContainers$selectedResourcesWithContainers$1 = false;
                    if (!KubernetesPodContainerActionBaseKt.getResourcesWithContainers().contains(it.getResourceKind())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                selectedResourcesWithContainers = (List)destination$iv$iv;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getServiceContainers);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)container);
                $continuation.L$2 = ctx;
                $continuation.L$3 = apiModel;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)resources);
                $continuation.L$5 = selectedResourcesWithContainers;
                $continuation.label = 1;
                v5 = apiModel.getResource(KubernetesEntity.Pod).getValue((Continuation<List<V1Pod>>)$continuation);
                if (v5 == var33_4) {
                    return var33_4;
                }
                ** GOTO lbl62
            }
            case 1: {
                selectedResourcesWithContainers = (List)$continuation.L$5;
                resources = (List)$continuation.L$4;
                apiModel = (KubernetesApiModelInterface)$continuation.L$3;
                ctx = (Context)$continuation.L$2;
                container = (KubernetesContainerObject)$continuation.L$1;
                $this$getServiceContainers = (AnActionEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl62:
                // 2 sources

                allPods = (List)v5;
                $this$map$iv = selectedResourcesWithContainers;
                $i$f$map = 0;
                $i$f$filterTo = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = 0;
                var14_20 = $this$mapTo$iv$iv.iterator();
lbl69:
                // 2 sources

                while (var14_20.hasNext()) {
                    item$iv$iv = var14_20.next();
                    var16_24 = (SelectedKubernetesResource)item$iv$iv;
                    var30_38 = destination$iv$iv;
                    $i$a$-map-ActionUtilsKt$getServiceContainers$containers$1 = 0;
                    var18_26 = resource.getResourceKind();
                    if (!Intrinsics.areEqual(var18_26, KubernetesEntity.Event)) ** GOTO lbl78
                    v6 = CollectionsKt.listOf((Object)new KubernetesEventContainerObject(ctx));
                    ** GOTO lbl152
lbl78:
                    // 1 sources

                    if (!Intrinsics.areEqual(var18_26, KubernetesEntity.Pod)) ** GOTO lbl94
                    pods = resource.getSelectedAll() != false ? allPods : CollectionsKt.listOfNotNull(resource.getCastedValue());
                    $this$map$iv = pods;
                    $i$f$map = false;
                    var22_30 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var27_35 = (V1Pod)item$iv$iv;
                        var28_36 = destination$iv$iv;
                        $i$a$-map-ActionUtilsKt$getServiceContainers$containers$1$1 = false;
                        var28_36.add(KubernetesPodServiceViewContributorDescriptorKt.getPodContainers(ctx, it));
                    }
                    v6 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
                    ** GOTO lbl152
lbl94:
                    // 1 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$getServiceContainers);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)container);
                    $continuation.L$2 = ctx;
                    $continuation.L$3 = apiModel;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)resources);
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)selectedResourcesWithContainers);
                    $continuation.L$6 = allPods;
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$map$iv);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)$this$mapTo$iv$iv);
                    $continuation.L$9 = destination$iv$iv;
                    $continuation.L$10 = var14_20;
                    $continuation.L$11 = SpillingKt.nullOutSpilledVariable((Object)item$iv$iv);
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)resource);
                    $continuation.L$13 = var30_38;
                    $continuation.I$0 = $i$f$map;
                    $continuation.I$1 = $i$f$mapTo;
                    $continuation.I$2 = $i$a$-map-ActionUtilsKt$getServiceContainers$containers$1;
                    $continuation.label = 2;
                    v7 = ActionUtilsKt.getPodsForWorkload(resource, apiModel, allPods, (Continuation<? super List<? extends V1Pod>>)$continuation);
                    if (v7 == var33_4) {
                        return var33_4;
                    }
                    ** GOTO lbl137
                }
                break;
            }
            case 2: {
                $i$a$-map-ActionUtilsKt$getServiceContainers$containers$1 = $continuation.I$2;
                $i$f$mapTo = $continuation.I$1;
                $i$f$map = $continuation.I$0;
                var30_38 = (Collection)$continuation.L$13;
                resource = (SelectedKubernetesResource)$continuation.L$12;
                item$iv$iv = $continuation.L$11;
                var14_20 = (Iterator<T>)$continuation.L$10;
                destination$iv$iv = (Collection)$continuation.L$9;
                $this$mapTo$iv$iv = (Iterable)$continuation.L$8;
                $this$map$iv = (Iterable)$continuation.L$7;
                allPods = (List)$continuation.L$6;
                selectedResourcesWithContainers = (List)$continuation.L$5;
                resources = (List)$continuation.L$4;
                apiModel = (KubernetesApiModelInterface)$continuation.L$3;
                ctx = (Context)$continuation.L$2;
                container = (KubernetesContainerObject)$continuation.L$1;
                $this$getServiceContainers = (AnActionEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl137:
                // 2 sources

                workloadPods = (List)v7;
                $this$map$iv = workloadPods;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (V1Pod)item$iv$iv;
                    var28_36 = destination$iv$iv;
                    $i$a$-map-ActionUtilsKt$getServiceContainers$containers$1$2 = false;
                    var28_36.add(KubernetesPodServiceViewContributorDescriptorKt.getPodContainers(ctx, it));
                }
                v6 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
lbl152:
                // 3 sources

                var30_38.add(v6);
                ** GOTO lbl69
            }
        }
        containers = (List)destination$iv$iv;
        return CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)containers));
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private static final Object getPodsForWorkload(SelectedKubernetesResource resource, KubernetesApiModelInterface apiModel, List<? extends V1Pod> allPods, Continuation<? super List<? extends V1Pod>> $completion) {
        block25: {
            block38: {
                block40: {
                    block39: {
                        block35: {
                            block37: {
                                block36: {
                                    block32: {
                                        block34: {
                                            block33: {
                                                block29: {
                                                    block31: {
                                                        block30: {
                                                            block26: {
                                                                block28: {
                                                                    block27: {
                                                                        block23: {
                                                                            block24: {
                                                                                if (!($completion instanceof getPodsForWorkload.1)) ** GOTO lbl-1000
                                                                                var16_4 = $completion;
                                                                                if ((var16_4.label & -2147483648) != 0) {
                                                                                    var16_4.label -= -2147483648;
                                                                                } else lbl-1000:
                                                                                // 2 sources

                                                                                {
                                                                                    $continuation = new ContinuationImpl($completion){
                                                                                        Object L$0;
                                                                                        Object L$1;
                                                                                        Object L$2;
                                                                                        /* synthetic */ Object result;
                                                                                        int label;

                                                                                        @Nullable
                                                                                        public final Object invokeSuspend(@NotNull Object $result) {
                                                                                            this.result = $result;
                                                                                            this.label |= Integer.MIN_VALUE;
                                                                                            return ActionUtilsKt.access$getPodsForWorkload(null, null, null, (Continuation)this);
                                                                                        }
                                                                                    };
                                                                                }
                                                                                $result = $continuation.result;
                                                                                var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                                switch ($continuation.label) {
                                                                                    case 0: {
                                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                                        var4_7 = resource.getResourceKind();
                                                                                        if (!Intrinsics.areEqual(var4_7, KubernetesEntity.Deployment)) break block23;
                                                                                        if (!resource.getSelectedAll()) break;
                                                                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)resource);
                                                                                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)apiModel);
                                                                                        $continuation.L$2 = allPods;
                                                                                        $continuation.label = 1;
                                                                                        v0 = apiModel.getResource(KubernetesEntity.Deployment).getValue((Continuation<List<V1Deployment>>)$continuation);
                                                                                        if (v0 == var17_6) {
                                                                                            return var17_6;
                                                                                        }
                                                                                        ** GOTO lbl29
                                                                                    }
                                                                                    case 1: {
                                                                                        allPods = (List)$continuation.L$2;
                                                                                        apiModel = (KubernetesApiModelInterface)$continuation.L$1;
                                                                                        resource = (SelectedKubernetesResource)$continuation.L$0;
                                                                                        ResultKt.throwOnFailure((Object)$result);
                                                                                        v0 = $result;
lbl29:
                                                                                        // 2 sources

                                                                                        v1 = (List)v0;
                                                                                        break block24;
                                                                                    }
                                                                                }
                                                                                v1 = CollectionsKt.listOfNotNull(resource.getCastedValue());
                                                                            }
                                                                            deployments = v1;
                                                                            $this$flatMap$iv = deployments;
                                                                            $i$f$flatMap = false;
                                                                            var8_26 = $this$flatMap$iv;
                                                                            destination$iv$iv = new ArrayList<E>();
                                                                            $i$f$flatMapTo = false;
                                                                            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                                                                it = (V1Deployment)element$iv$iv;
                                                                                $i$a$-flatMap-ActionUtilsKt$getPodsForWorkload$2 = false;
                                                                                list$iv$iv = KubernetesLogUtilsKt.getPodsForDeployment(allPods, it);
                                                                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                                                            }
                                                                            v2 = (List)destination$iv$iv;
                                                                            break block25;
                                                                        }
                                                                        if (!Intrinsics.areEqual(var4_7, KubernetesEntity.ReplicaSet)) break block26;
                                                                        if (!resource.getSelectedAll()) break block27;
                                                                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)resource);
                                                                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)apiModel);
                                                                        $continuation.L$2 = allPods;
                                                                        $continuation.label = 2;
                                                                        v3 = apiModel.getResource(KubernetesEntity.ReplicaSet).getValue((Continuation<List<V1ReplicaSet>>)$continuation);
                                                                        if (v3 == var17_6) {
                                                                            return var17_6;
                                                                        }
                                                                        ** GOTO lbl66
                                                                        {
                                                                            case 2: {
                                                                                allPods = (List)$continuation.L$2;
                                                                                apiModel = (KubernetesApiModelInterface)$continuation.L$1;
                                                                                resource = (SelectedKubernetesResource)$continuation.L$0;
                                                                                ResultKt.throwOnFailure((Object)$result);
                                                                                v3 = $result;
lbl66:
                                                                                // 2 sources

                                                                                v4 = (List)v3;
                                                                                break block28;
                                                                            }
                                                                        }
                                                                    }
                                                                    v4 = CollectionsKt.listOfNotNull(resource.getCastedValue());
                                                                }
                                                                replicaSets = v4;
                                                                $this$flatMap$iv = replicaSets;
                                                                $i$f$flatMap = false;
                                                                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                                                                destination$iv$iv = new ArrayList<E>();
                                                                $i$f$flatMapTo = false;
                                                                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                                                    it = (V1ReplicaSet)element$iv$iv;
                                                                    $i$a$-flatMap-ActionUtilsKt$getPodsForWorkload$3 = false;
                                                                    list$iv$iv = KubernetesLogUtilsKt.getPodsForReplicaSet(allPods, it);
                                                                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                                                }
                                                                v2 = (List)destination$iv$iv;
                                                                break block25;
                                                            }
                                                            if (!Intrinsics.areEqual(var4_7, KubernetesEntity.Job)) break block29;
                                                            if (!resource.getSelectedAll()) break block30;
                                                            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)resource);
                                                            $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)apiModel);
                                                            $continuation.L$2 = allPods;
                                                            $continuation.label = 3;
                                                            v5 = apiModel.getResource(KubernetesEntity.Job).getValue((Continuation<List<V1Job>>)$continuation);
                                                            if (v5 == var17_6) {
                                                                return var17_6;
                                                            }
                                                            ** GOTO lbl104
                                                            {
                                                                case 3: {
                                                                    allPods = (List)$continuation.L$2;
                                                                    apiModel = (KubernetesApiModelInterface)$continuation.L$1;
                                                                    resource = (SelectedKubernetesResource)$continuation.L$0;
                                                                    ResultKt.throwOnFailure((Object)$result);
                                                                    v5 = $result;
lbl104:
                                                                    // 2 sources

                                                                    v6 = (List)v5;
                                                                    break block31;
                                                                }
                                                            }
                                                        }
                                                        v6 = CollectionsKt.listOfNotNull(resource.getCastedValue());
                                                    }
                                                    jobs = v6;
                                                    $this$flatMap$iv = jobs;
                                                    $i$f$flatMap = false;
                                                    $this$flatMapTo$iv$iv = $this$flatMap$iv;
                                                    destination$iv$iv = new ArrayList<E>();
                                                    $i$f$flatMapTo = false;
                                                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                                        it = (V1Job)element$iv$iv;
                                                        $i$a$-flatMap-ActionUtilsKt$getPodsForWorkload$4 = false;
                                                        list$iv$iv = KubernetesLogUtilsKt.getPodsForJob(allPods, it);
                                                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                                    }
                                                    v2 = (List)destination$iv$iv;
                                                    break block25;
                                                }
                                                if (!Intrinsics.areEqual(var4_7, KubernetesEntity.CronJob)) break block32;
                                                if (!resource.getSelectedAll()) break block33;
                                                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)resource);
                                                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)apiModel);
                                                $continuation.L$2 = allPods;
                                                $continuation.label = 4;
                                                v7 = apiModel.getResource(KubernetesEntity.CronJob).getValue((Continuation<List<V1CronJob>>)$continuation);
                                                if (v7 == var17_6) {
                                                    return var17_6;
                                                }
                                                ** GOTO lbl142
                                                {
                                                    case 4: {
                                                        allPods = (List)$continuation.L$2;
                                                        apiModel = (KubernetesApiModelInterface)$continuation.L$1;
                                                        resource = (SelectedKubernetesResource)$continuation.L$0;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v7 = $result;
lbl142:
                                                        // 2 sources

                                                        v8 = (List)v7;
                                                        break block34;
                                                    }
                                                }
                                            }
                                            v8 = CollectionsKt.listOfNotNull(resource.getCastedValue());
                                        }
                                        cronJobs = v8;
                                        $this$flatMap$iv = cronJobs;
                                        $i$f$flatMap = false;
                                        $this$flatMapTo$iv$iv = $this$flatMap$iv;
                                        destination$iv$iv = new ArrayList<E>();
                                        $i$f$flatMapTo = false;
                                        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                            it = (V1CronJob)element$iv$iv;
                                            $i$a$-flatMap-ActionUtilsKt$getPodsForWorkload$5 = false;
                                            list$iv$iv = KubernetesLogUtilsKt.getPodsForCronJob(allPods, it);
                                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                        }
                                        v2 = (List)destination$iv$iv;
                                        break block25;
                                    }
                                    if (!Intrinsics.areEqual(var4_7, KubernetesEntity.StatefulSet)) break block35;
                                    if (!resource.getSelectedAll()) break block36;
                                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)resource);
                                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)apiModel);
                                    $continuation.L$2 = allPods;
                                    $continuation.label = 5;
                                    v9 = apiModel.getResource(KubernetesEntity.StatefulSet).getValue((Continuation<List<V1StatefulSet>>)$continuation);
                                    if (v9 == var17_6) {
                                        return var17_6;
                                    }
                                    ** GOTO lbl180
                                    {
                                        case 5: {
                                            allPods = (List)$continuation.L$2;
                                            apiModel = (KubernetesApiModelInterface)$continuation.L$1;
                                            resource = (SelectedKubernetesResource)$continuation.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v9 = $result;
lbl180:
                                            // 2 sources

                                            v10 = (List)v9;
                                            break block37;
                                        }
                                    }
                                }
                                v10 = CollectionsKt.listOfNotNull(resource.getCastedValue());
                            }
                            statefulSets = v10;
                            $this$flatMap$iv = statefulSets;
                            $i$f$flatMap = false;
                            $this$flatMapTo$iv$iv = $this$flatMap$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$flatMapTo = false;
                            for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                                it = (V1StatefulSet)element$iv$iv;
                                $i$a$-flatMap-ActionUtilsKt$getPodsForWorkload$6 = false;
                                list$iv$iv = KubernetesLogUtilsKt.getPodsForStatefulSet(allPods, it);
                                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                            }
                            v2 = (List)destination$iv$iv;
                            break block25;
                        }
                        if (!Intrinsics.areEqual(var4_7, KubernetesEntity.DaemonSet)) break block38;
                        if (!resource.getSelectedAll()) break block39;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)resource);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)apiModel);
                        $continuation.L$2 = allPods;
                        $continuation.label = 6;
                        v11 = apiModel.getResource(KubernetesEntity.DaemonSet).getValue((Continuation<List<V1DaemonSet>>)$continuation);
                        if (v11 == var17_6) {
                            return var17_6;
                        }
                        ** GOTO lbl218
                        {
                            case 6: {
                                allPods = (List)$continuation.L$2;
                                apiModel = (KubernetesApiModelInterface)$continuation.L$1;
                                resource = (SelectedKubernetesResource)$continuation.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v11 = $result;
lbl218:
                                // 2 sources

                                v12 = (List)v11;
                                break block40;
                            }
                        }
                    }
                    v12 = CollectionsKt.listOfNotNull(resource.getCastedValue());
                }
                daemonSets = v12;
                $this$flatMap$iv = daemonSets;
                $i$f$flatMap = false;
                $this$flatMapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (V1DaemonSet)element$iv$iv;
                    $i$a$-flatMap-ActionUtilsKt$getPodsForWorkload$7 = false;
                    list$iv$iv = KubernetesLogUtilsKt.getPodsForDaemonSet(allPods, it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                v2 = (List)destination$iv$iv;
                break block25;
            }
            v2 = CollectionsKt.emptyList();
        }
        return v2;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final ActionGroup createResourceActionsGroup() {
        AnAction anAction = ActionManager.getInstance().getAction("Kubernetes.ResourceActions");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        return (ActionGroup)anAction;
    }

    @Nullable
    public static final KubernetesObject getResource(@NotNull Object $this$resource) {
        Intrinsics.checkNotNullParameter((Object)$this$resource, (String)"<this>");
        Object object = $this$resource;
        return object instanceof KubernetesNamespacedKeyValueResourceServiceViewContributor ? ((KubernetesNamespacedKeyValueResourceServiceViewContributor)$this$resource).getResource() : (object instanceof KubernetesCustomResourceDefinitionServiceViewContributor ? (KubernetesObject)((KubernetesCustomResourceDefinitionServiceViewContributor)$this$resource).getCustomResourceDefinition() : (object instanceof KubernetesServiceViewDescriptor ? ((KubernetesServiceViewDescriptor)$this$resource).getResource() : (object instanceof KubernetesCachedValueBasedServiceViewContributorBase ? (KubernetesObject)((KubernetesCachedValueBasedServiceViewContributorBase)$this$resource).getContent().getSelectedItem() : (object instanceof KubernetesContainerServiceViewDescriptor ? (KubernetesObject)((KubernetesContainerServiceViewDescriptor)$this$resource).getResource() : null))));
    }

    @Deprecated(message="Use DataContext")
    public static /* synthetic */ void getResource$annotations(Object object) {
    }

    public static final boolean isDeletableResource(@NotNull Object $this$isDeletableResource) {
        Intrinsics.checkNotNullParameter((Object)$this$isDeletableResource, (String)"<this>");
        Object object = $this$isDeletableResource;
        return object instanceof KubernetesNamespacedKeyValueResourceServiceViewContributor ? true : (object instanceof KubernetesCustomResourceDefinitionServiceViewContributor ? true : (object instanceof KubernetesCachedValueBasedServiceViewContributorBase ? ((KubernetesCachedValueBasedServiceViewContributorBase)$this$isDeletableResource).getContent().getSelectedItem() != null : object instanceof KubernetesServiceViewDescriptor));
    }

    @Deprecated(message="Use DataContext")
    public static /* synthetic */ void isDeletableResource$annotations(Object object) {
    }

    @Nullable
    public static final KubernetesResourceMapper<?, ?> getMapper(@NotNull Object $this$mapper) {
        Intrinsics.checkNotNullParameter((Object)$this$mapper, (String)"<this>");
        Object object = $this$mapper;
        return object instanceof KubernetesNamespacedKeyValueResourceServiceViewContributor ? ((KubernetesNamespacedKeyValueResourceServiceViewContributor)$this$mapper).getMapper() : (object instanceof KubernetesCustomResourceDefinitionServiceViewContributor ? ((KubernetesCustomResourceDefinitionServiceViewContributor)$this$mapper).getCustomResourceDefinitionMapper() : (object instanceof KubernetesCachedValueBasedServiceViewContributorBase ? ((KubernetesCachedValueBasedServiceViewContributorBase)$this$mapper).getMapper() : (object instanceof KubernetesServiceViewDescriptor ? ((KubernetesServiceViewDescriptor)$this$mapper).getMapper() : null)));
    }

    @Deprecated(message="Use DataContext")
    public static /* synthetic */ void getMapper$annotations(Object object) {
    }

    public static final /* synthetic */ KubernetesObject access$getCastedValue(KubernetesObject resource, KubernetesEntity entity) {
        return ActionUtilsKt.getCastedValue(resource, entity);
    }

    public static final /* synthetic */ Object access$getPodsForWorkload(SelectedKubernetesResource resource, KubernetesApiModelInterface apiModel2, List allPods, Continuation $completion) {
        return ActionUtilsKt.getPodsForWorkload(resource, apiModel2, allPods, (Continuation<? super List<? extends V1Pod>>)$completion);
    }
}

