/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.javaee.constants.JpaAnnotationConstants;
import com.intellij.jpa.model.common.persistence.JpaConstants;
import com.intellij.jpa.model.xml.persistence.mapping.AccessType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AccessTypeDetector {
    AccessTypeDetector() {
    }

    @Nullable
    static AccessType calculateAccessType(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return null;
        }
        boolean hasAnnotatedField = Arrays.stream(aClass.getFields()).filter(f -> !f.hasModifierProperty("static") && !f.hasModifierProperty("transient")).flatMap(AccessTypeDetector::memberAnnotations).distinct().anyMatch(id -> AccessTypeDetector.isMemberAnnotated(id.myPsiAnnotation));
        if (hasAnnotatedField) {
            return AccessType.FIELD;
        }
        boolean hasAnnotatedMethod = Arrays.stream(aClass.getMethods()).filter(m -> PropertyUtilBase.isSimplePropertyGetter((PsiMethod)m)).flatMap(AccessTypeDetector::memberAnnotations).distinct().anyMatch(id -> AccessTypeDetector.isMemberAnnotated(id.myPsiAnnotation));
        if (hasAnnotatedMethod) {
            return AccessType.PROPERTY;
        }
        return null;
    }

    private static Stream<AnnotationId> memberAnnotations(@NotNull PsiMember member) {
        PsiModifierList list;
        if (member == null) {
            AccessTypeDetector.$$$reportNull$$$0(0);
        }
        if ((list = member.getModifierList()) == null) {
            return Stream.empty();
        }
        return Arrays.stream(list.getAnnotations()).map(AnnotationId::new);
    }

    private static boolean isMemberAnnotated(PsiAnnotation annotation) {
        String qName = annotation.getQualifiedName();
        return qName != null && !JpaAnnotationConstants.TRANSIENT_ANNO.isFqn(qName) && !JpaAnnotationConstants.ACCESS_ANNO.isFqn(qName) && (qName.startsWith(JpaConstants.PERSISTENCE_PACKAGE_PREFIX.javax()) || qName.startsWith(JpaConstants.PERSISTENCE_PACKAGE_PREFIX.jakarta()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jpa/model/annotations/mapping/AccessTypeDetector", "memberAnnotations"));
    }

    private static class AnnotationId {
        public final PsiAnnotation myPsiAnnotation;
        private final String myAnnotationText;

        private AnnotationId(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                AnnotationId.$$$reportNull$$$0(0);
            }
            this.myPsiAnnotation = annotation;
            PsiJavaCodeReferenceElement nameReferenceElement = this.myPsiAnnotation.getNameReferenceElement();
            this.myAnnotationText = nameReferenceElement != null ? nameReferenceElement.getText() : "";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationId anchor = (AnnotationId)o;
            return Objects.equals(this.myAnnotationText, anchor.myAnnotationText);
        }

        public int hashCode() {
            return Objects.hash(this.myAnnotationText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/jpa/model/annotations/mapping/AccessTypeDetector$AnnotationId", "<init>"));
        }
    }
}

