/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.implicit;

import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.jpa.JpaImplementationProvider;
import com.intellij.jpa.PersistenceUnitPropertiesProvider;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaModuleConfiguration;
import com.intellij.jpa.model.common.persistence.mapping.EntityMappings;
import com.intellij.jpa.model.common.persistence.mapping.PersistentObject;
import com.intellij.jpa.model.implicit.UnitPropertiesUtilsKt;
import com.intellij.jpa.providers.HibernateProvider;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.helpers.PersistenceUnitModelHelper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualPersistenceUnitModelHelper
implements PersistenceUnitModelHelper {
    private static final Key<String> PROPERTY_PROFILE_KEY = Key.create((String)"virtual.unit.property.profile");
    private Map<String, Properties> myPropertyProfiles;
    private final JpaModuleConfiguration myFacet;

    @Deprecated
    public VirtualPersistenceUnitModelHelper(JpaFacet jpaFacet) {
        this((JpaModuleConfiguration)jpaFacet);
    }

    public VirtualPersistenceUnitModelHelper(JpaModuleConfiguration facet) {
        this.myFacet = facet;
        this.myPropertyProfiles = new HashMap<String, Properties>();
    }

    public GenericValue<Boolean> getExcludeUnlistedClasses() {
        return ReadOnlyGenericValue.getInstance((Object)Boolean.FALSE);
    }

    @Nullable
    public String getPersistenceProviderName() {
        JpaImplementationProvider provider = JpaUtil.findProviderByName(this.myFacet.getDefaultJPAProviderName());
        return provider != null ? provider.getProviderClassName(this.myFacet.getModule()) : HibernateProvider.getProvider(this.myFacet.getModule());
    }

    @Nullable
    public PersistenceMappings getAdditionalMapping() {
        return null;
    }

    @NotNull
    public <V extends PersistenceMappings> List<? extends GenericValue<V>> getMappingFiles(Class<V> mappingsClass) {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<? extends PersistenceListener> getPersistentListeners() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<? extends GenericValue<PsiFile>> getJarFiles() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<? extends GenericValue<PsiClass>> getClasses() {
        EntityMappings mappings = (EntityMappings)this.myFacet.getAnnotationEntityMappings();
        if (mappings == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(3);
            }
            return list;
        }
        List list = ContainerUtil.map(mappings.getPersistentObjects(), PersistentObject::getClazz);
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public List<? extends GenericValue<PsiPackage>> getPackages() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public GenericValue<String> getDataSourceName() {
        return null;
    }

    public Set<String> getPropertiesSources() {
        this.updatePropertyProfiles();
        return this.myPropertyProfiles.keySet();
    }

    private void updatePropertyProfiles() {
        this.myPropertyProfiles = StreamEx.of((Collection)PersistenceUnitPropertiesProvider.EP_NAME.getExtensionList()).flatMapToEntry(it -> it.getPropertyProfiles(this.myFacet.getModule())).toMap();
        if (this.getActivePropertyProfile() == null) {
            this.setActivePropertyProfile(null);
        }
    }

    @NotNull
    public Properties getPersistenceUnitProperties() {
        this.updatePropertyProfiles();
        Properties properties = this.useProviderSpecificKeys(this.myPropertyProfiles.get(this.getActivePropertyProfile()), this.myFacet.getModule());
        if (properties == null) {
            VirtualPersistenceUnitModelHelper.$$$reportNull$$$0(6);
        }
        return properties;
    }

    public void setActivePropertyProfile(@Nullable String profileLocation) {
        String activeProfile = null;
        if (profileLocation == null) {
            Optional defaultProfile = this.myPropertyProfiles.entrySet().stream().findFirst();
            if (defaultProfile.isPresent()) {
                activeProfile = (String)((Map.Entry)defaultProfile.get()).getKey();
            }
        } else {
            activeProfile = profileLocation;
        }
        this.myFacet.putUserData(PROPERTY_PROFILE_KEY, activeProfile);
    }

    public String getActivePropertyProfile() {
        return (String)this.myFacet.getUserData(PROPERTY_PROFILE_KEY);
    }

    private Properties useProviderSpecificKeys(Properties properties, Module module) {
        Properties result = new Properties();
        if (properties == null) {
            return result;
        }
        Function<String, String> mapper = VirtualPersistenceUnitModelHelper.chooseProviderMapping(this.getPersistenceProviderName());
        for (Object key : properties.keySet()) {
            if (!(key instanceof String)) continue;
            String stringKey = mapper.apply((String)key);
            result.setProperty(VirtualPersistenceUnitModelHelper.adjustJavaeeFqn(stringKey, module), properties.getProperty((String)key));
        }
        return result;
    }

    private static String adjustJavaeeFqn(String propertyKey, Module module) {
        return JavaeeClass.create((String)propertyKey).fqn(module);
    }

    private static Function<String, String> chooseProviderMapping(String providerName) {
        String string = providerName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"org.hibernate.ejb.HibernatePersistence", "org.hibernate.jpa.HibernatePersistenceProvider", "org.apache.openjpa.persistence.PersistenceProviderImpl", "oracle.toplink.essentials.PersistenceProvider", "org.eclipse.persistence.jpa.PersistenceProvider"}, (Object)string, n)) {
            case 0, 1 -> UnitPropertiesUtilsKt::toHibernateNotation;
            case 2 -> UnitPropertiesUtilsKt::toOpenJpaNotation;
            case 3 -> UnitPropertiesUtilsKt::toToplinkNotation;
            case 4 -> UnitPropertiesUtilsKt::toEclipseLinkNotation;
            default -> Function.identity();
        };
    }

    public Collection<Object> getCacheDependencies() {
        return ContainerUtil.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualPersistenceUnitModelHelper helper = (VirtualPersistenceUnitModelHelper)o;
        return Objects.equals(this.myPropertyProfiles, helper.myPropertyProfiles) && Objects.equals(this.myFacet, helper.myFacet);
    }

    public int hashCode() {
        return Objects.hash(this.myPropertyProfiles, this.myFacet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jpa/model/implicit/VirtualPersistenceUnitModelHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentListeners";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnitProperties";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

