/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.xml.impl.converters.providers;

import com.intellij.jpa.PersistenceUnitConstants;
import com.intellij.jpa.model.xml.impl.converters.providers.PersistenceConverters;
import com.intellij.jpa.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.model.xml.persistence.Property;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.persistence.model.PersistencePackage;

public final class OpenJpaConverters
extends PersistenceConverters {
    private static final Condition<Property> isOpenJpaProvider = domElement -> JpaUtil.isOpenJpa(JpaUtil.findJpaProvider(null, (PersistencePackage)domElement.getParentOfType(PersistenceUnit.class, true), false), null);

    public OpenJpaConverters() {
        this.registerConverters();
    }

    @Override
    protected Condition<Property> getCondition() {
        return isOpenJpaProvider;
    }

    private void registerConverters() {
        this.registerConverter(this.getCondition(), "openjpa.ConnectionDriverName", OpenJpaConverters.getPsiClassConverter("java.sql.Driver"));
        this.registerEmptyOpenJpaConverter("openjpa.ConnectionURL");
        this.registerEmptyOpenJpaConverter("openjpa.ConnectionUserName");
        this.registerEmptyOpenJpaConverter("openjpa.ConnectionPassword");
        for (String property : PersistenceUnitConstants.additionalOpenJpaProperties()) {
            this.registerEmptyOpenJpaConverter(property);
        }
    }

    private void registerEmptyOpenJpaConverter(String name) {
        this.registerEmptyConverter(this.getCondition(), name);
    }
}

