/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 27075453399330L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-20446920 - -15218, -20446920 - -27837, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-20446920 - -15219, -20446920 - -408, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 104359943988080L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.q();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(828624540 + 8286, 828624540 + 7079, (int)l2) + string + WindowsNamedPipeAgentIpc.b(828624540 + 8287, 828624540 + 11611, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(828624540 + 8288, 828624540 - 7394, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 131251567267837L;
                Object object = this.lock;
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.q();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1661705460 - (char)-25980, 1661705460 - 28628, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1661705460 - (char)-25983, -1661705460 - -28912, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1661705460 - (char)-25982, -1661705460 - -18510, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1661705460 - (char)-25993, -1661705460 - -((char)-27777), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1661705460 - (char)-25992, -1661705460 - -12383, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1661705460 - (char)-25995, -1661705460 - -22959, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1661705460 - (char)-25993, -1661705460 - -((char)-27777), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1661705460 - (char)-25994, -1661705460 - -16333, (int)l2));
            if (!ActionTimestamp.q()) {
                SshAgentIpcService.q(new ActionTimestamp[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 71334345484934L;
                    actionTimestampArray = SshAgentIpcService.q();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    ActionTimestamp[] actionTimestampArray;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 125364359235901L;
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            actionTimestampArray = SshAgentIpcService.q();
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (actionTimestampArray == null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11987), -1441114650 + -25925, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11991), 1441114650 + (char)-14799, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11986), 1441114650 + (char)-29943, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11991), 1441114650 + (char)-14799, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11989), 1441114650 + 25218, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11987), -1441114650 + -25925, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11991), 1441114650 + (char)-14799, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11988), -1441114650 + -30560, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (actionTimestampArray == null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n2 = Kernel32.INSTANCE.GetLastError();
                            if (n2 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11987), -1441114650 + -25925, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11991), 1441114650 + (char)-14799, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11967), 1441114650 + (char)-13318, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11991), 1441114650 + (char)-14799, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11966), 1441114650 + 27540, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray == null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string = WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11991), 1441114650 + (char)-14799, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11989), 1441114650 + 25218, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11987), -1441114650 + -25925, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11991), 1441114650 + (char)-14799, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1441114650 + -((char)-11969), 1441114650 + (char)-16464, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 98234469901535L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(22150830 - (char)-8498, 22150830 - (char)-3905, (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 55997137705932L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(645912960 - 14478, -645912960 - -5920, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "\u0006/\u00ac\u00be|\u0007\u00b5\u00b6\u00aa\u00e0\u00c5\u009d%\u00fb\u009d\u0005\b\u00be\u00dd\u00142Z*\u0016\u00b7\u00d0\u00b1\u00c9\u00a8\t@tW?\u0012\u0016\u0014\u001aYA";
                                        var4_3 = "\u0006/\u00ac\u00be|\u0007\u00b5\u00b6\u00aa\u00e0\u00c5\u009d%\u00fb\u009d\u0005\b\u00be\u00dd\u00142Z*\u0016\u00b7\u00d0\u00b1\u00c9\u00a8\t@tW?\u0012\u0016\u0014\u001aYA".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 18;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 7;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 110;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 8;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 70;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 79;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 88;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 85;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0xFFFFFB3F) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 34;
                                            case 1 -> 176;
                                            case 2 -> 248;
                                            case 3 -> 104;
                                            case 4 -> 178;
                                            case 5 -> 108;
                                            case 6 -> 250;
                                            case 7 -> 161;
                                            case 8 -> 12;
                                            case 9 -> 61;
                                            case 10 -> 234;
                                            case 11 -> 24;
                                            case 12 -> 143;
                                            case 13 -> 134;
                                            case 14 -> 33;
                                            case 15 -> 158;
                                            case 16 -> 156;
                                            case 17 -> 66;
                                            case 18 -> 148;
                                            case 19 -> 179;
                                            case 20 -> 208;
                                            case 21 -> 116;
                                            case 22 -> 144;
                                            case 23 -> 198;
                                            case 24 -> 1;
                                            case 25 -> 172;
                                            case 26 -> 122;
                                            case 27 -> 239;
                                            case 28 -> 137;
                                            case 29 -> 14;
                                            case 30 -> 83;
                                            case 31 -> 209;
                                            case 32 -> 182;
                                            case 33 -> 131;
                                            case 34 -> 152;
                                            case 35 -> 72;
                                            case 36 -> 68;
                                            case 37 -> 221;
                                            case 38 -> 99;
                                            case 39 -> 35;
                                            case 40 -> 227;
                                            case 41 -> 242;
                                            case 42 -> 92;
                                            case 43 -> 254;
                                            case 44 -> 210;
                                            case 45 -> 130;
                                            case 46 -> 41;
                                            case 47 -> 37;
                                            case 48 -> 28;
                                            case 49 -> 75;
                                            case 50 -> 84;
                                            case 51 -> 70;
                                            case 52 -> 253;
                                            case 53 -> 226;
                                            case 54 -> 5;
                                            case 55 -> 82;
                                            case 56 -> 163;
                                            case 57 -> 240;
                                            case 58 -> 25;
                                            case 59 -> 21;
                                            case 60 -> 7;
                                            case 61 -> 60;
                                            case 62 -> 71;
                                            case 63 -> 203;
                                            case 64 -> 124;
                                            case 65 -> 81;
                                            case 66 -> 167;
                                            case 67 -> 165;
                                            case 68 -> 136;
                                            case 69 -> 188;
                                            case 70 -> 160;
                                            case 71 -> 217;
                                            case 72 -> 222;
                                            case 73 -> 252;
                                            case 74 -> 117;
                                            case 75 -> 56;
                                            case 76 -> 245;
                                            case 77 -> 200;
                                            case 78 -> 23;
                                            case 79 -> 159;
                                            case 80 -> 183;
                                            case 81 -> 65;
                                            case 82 -> 111;
                                            case 83 -> 77;
                                            case 84 -> 95;
                                            case 85 -> 229;
                                            case 86 -> 107;
                                            case 87 -> 141;
                                            case 88 -> 237;
                                            case 89 -> 39;
                                            case 90 -> 202;
                                            case 91 -> 109;
                                            case 92 -> 185;
                                            case 93 -> 213;
                                            case 94 -> 184;
                                            case 95 -> 125;
                                            case 96 -> 169;
                                            case 97 -> 228;
                                            case 98 -> 225;
                                            case 99 -> 255;
                                            case 100 -> 154;
                                            case 101 -> 88;
                                            case 102 -> 157;
                                            case 103 -> 59;
                                            case 104 -> 112;
                                            case 105 -> 74;
                                            case 106 -> 101;
                                            case 107 -> 155;
                                            case 108 -> 243;
                                            case 109 -> 214;
                                            case 110 -> 139;
                                            case 111 -> 103;
                                            case 112 -> 145;
                                            case 113 -> 36;
                                            case 114 -> 196;
                                            case 115 -> 138;
                                            case 116 -> 133;
                                            case 117 -> 212;
                                            case 118 -> 241;
                                            case 119 -> 199;
                                            case 120 -> 146;
                                            case 121 -> 44;
                                            case 122 -> 128;
                                            case 123 -> 29;
                                            case 124 -> 181;
                                            case 125 -> 19;
                                            case 126 -> 249;
                                            case 127 -> 90;
                                            case 128 -> 123;
                                            case 129 -> 127;
                                            case 130 -> 15;
                                            case 131 -> 58;
                                            case 132 -> 16;
                                            case 133 -> 218;
                                            case 134 -> 236;
                                            case 135 -> 30;
                                            case 136 -> 52;
                                            case 137 -> 190;
                                            case 138 -> 118;
                                            case 139 -> 102;
                                            case 140 -> 38;
                                            case 141 -> 105;
                                            case 142 -> 80;
                                            case 143 -> 78;
                                            case 144 -> 177;
                                            case 145 -> 42;
                                            case 146 -> 193;
                                            case 147 -> 11;
                                            case 148 -> 219;
                                            case 149 -> 73;
                                            case 150 -> 173;
                                            case 151 -> 230;
                                            case 152 -> 115;
                                            case 153 -> 55;
                                            case 154 -> 110;
                                            case 155 -> 168;
                                            case 156 -> 192;
                                            case 157 -> 17;
                                            case 158 -> 195;
                                            case 159 -> 119;
                                            case 160 -> 2;
                                            case 161 -> 220;
                                            case 162 -> 180;
                                            case 163 -> 175;
                                            case 164 -> 40;
                                            case 165 -> 246;
                                            case 166 -> 129;
                                            case 167 -> 205;
                                            case 168 -> 0;
                                            case 169 -> 206;
                                            case 170 -> 6;
                                            case 171 -> 49;
                                            case 172 -> 106;
                                            case 173 -> 22;
                                            case 174 -> 32;
                                            case 175 -> 126;
                                            case 176 -> 67;
                                            case 177 -> 76;
                                            case 178 -> 140;
                                            case 179 -> 235;
                                            case 180 -> 211;
                                            case 181 -> 69;
                                            case 182 -> 150;
                                            case 183 -> 135;
                                            case 184 -> 31;
                                            case 185 -> 98;
                                            case 186 -> 63;
                                            case 187 -> 114;
                                            case 188 -> 164;
                                            case 189 -> 50;
                                            case 190 -> 18;
                                            case 191 -> 94;
                                            case 192 -> 3;
                                            case 193 -> 174;
                                            case 194 -> 4;
                                            case 195 -> 89;
                                            case 196 -> 85;
                                            case 197 -> 238;
                                            case 198 -> 162;
                                            case 199 -> 62;
                                            case 200 -> 10;
                                            case 201 -> 187;
                                            case 202 -> 223;
                                            case 203 -> 166;
                                            case 204 -> 151;
                                            case 205 -> 215;
                                            case 206 -> 189;
                                            case 207 -> 51;
                                            case 208 -> 8;
                                            case 209 -> 186;
                                            case 210 -> 233;
                                            case 211 -> 91;
                                            case 212 -> 142;
                                            case 213 -> 171;
                                            case 214 -> 149;
                                            case 215 -> 43;
                                            case 216 -> 47;
                                            case 217 -> 204;
                                            case 218 -> 244;
                                            case 219 -> 100;
                                            case 220 -> 197;
                                            case 221 -> 132;
                                            case 222 -> 194;
                                            case 223 -> 120;
                                            case 224 -> 53;
                                            case 225 -> 46;
                                            case 226 -> 48;
                                            case 227 -> 86;
                                            case 228 -> 121;
                                            case 229 -> 9;
                                            case 230 -> 170;
                                            case 231 -> 27;
                                            case 232 -> 57;
                                            case 233 -> 97;
                                            case 234 -> 20;
                                            case 235 -> 216;
                                            case 236 -> 207;
                                            case 237 -> 147;
                                            case 238 -> 232;
                                            case 239 -> 153;
                                            case 240 -> 79;
                                            case 241 -> 87;
                                            case 242 -> 191;
                                            case 243 -> 64;
                                            case 244 -> 201;
                                            case 245 -> 224;
                                            case 246 -> 45;
                                            case 247 -> 96;
                                            case 248 -> 54;
                                            case 249 -> 247;
                                            case 250 -> 93;
                                            case 251 -> 26;
                                            case 252 -> 231;
                                            case 253 -> 13;
                                            case 254 -> 251;
                                            default -> 113;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c2 ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c2 ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (actionTimestampArray != null) break block32;
                            if (ActionTimestamp.q()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.q(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 89574752482464L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.q();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1085390670 + -((char)-14450), -1085521740 - -((char)-13176), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1085390670 + -((char)-14446), 1085390670 + (char)-12664, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1085390670 + -((char)-14473), -1085521740 - -((char)-3565), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1085390670 + -((char)-14450), -1085521740 - -((char)-13176), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1085390670 + -((char)-14446), 1085390670 + (char)-12664, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1085390670 + -((char)-14474), -1085390670 + -((char)-6335), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 70018115817561L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.q();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1558946580 + 15024, 1558946580 - 6028, (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1558946580 + 15027, 1558946580 - 8834, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 43548115103616L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.q();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    actionTimestampArray = actionTimestampArray2;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18446, 1441638930 + 27658, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18450, -1441638930 + -((char)-16648), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18419, 1441638930 + (char)-15371, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18450, -1441638930 + -((char)-16648), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18444, -1441638930 + -27597, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18446, 1441638930 + 27658, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18450, -1441638930 + -((char)-16648), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18434, 1441638930 + 24185, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18446, 1441638930 + 27658, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18450, -1441638930 + -((char)-16648), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18433, -1441638930 + -22217, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18446, 1441638930 + 27658, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18450, -1441638930 + -((char)-16648), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1441638930 + (char)-18432, 1441638930 + (char)-31468, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 79198164735221L;
                    Object object = this.lock;
                    actionTimestampArray = SshAgentIpcService.q();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1032176250 + -25621, -1032176250 + -((char)-28643), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1032176250 + -25617, 1032176250 + 27401, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1032176250 + -25632, 1032176250 + 31683, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1032176250 + -25637, 1032176250 + (char)-19324, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1032176250 + -25621, -1032176250 + -((char)-28643), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1032176250 + -25617, 1032176250 + 27401, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1032176250 + -25638, 1032176250 + (char)-31931, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1032176250 + -25621, -1032176250 + -((char)-28643), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1032176250 + -25617, 1032176250 + 27401, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1032176250 + -25635, -1032176250 + -18636, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1032176250 + -25621, -1032176250 + -((char)-28643), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1032176250 + -25617, 1032176250 + 27401, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1032176250 + -25636, 1032176250 + 22059, (int)l2));
                    if (actionTimestampArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1032176250 + -25621, -1032176250 + -((char)-28643), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1032176250 + -25617, 1032176250 + 27401, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1032176250 + -25641, -1032176250 + -25514, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1032176250 + -25642, -1032176250 + -((char)-28008), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0086\u001e\u00b1W\u00e5\u00ee\u007f>\u0014\u0090XKxD\u0083\u00e4\u0089\u00d8\u00ab\u00a1\u00a5S\u00d06a\\IJ\u0005\u0006\u00cb\u00ea\u0018\u00c9\u00ba|\u0018B\u0088qR\u0081\u0003^YG\u00cc]9\u00aa\u00bc[nX\u00c1\u00e4\u0089\u00cc\u009d\u00c7(\tr\u00c8\u00e9\u00eb\u00f9\u00abI\u0004\u0099\u0005\u0010\u00ccc\r\u00cf\b\u00c9\u00e6X9\u008a\u0005\u0094\u00a1\u0014pR/\u00a2\u00a5\u00d0\u00edt\u0097\u00c9\u00e3]Ql\u00cd\u001b1\u00d5\u001e\u00d4\u0005\u0099\tR\u00b5\u00e9\u001e\u00a8\u00baa\u00a7\u0012y\u008el\u00f8~\u00e1\u00e8q\u00a6\u0082I\u0082\u00b4m\u00d3Q\u00f9xi\u00e2Xo\u00b5e\u00c9\u0010\u00aaS\u00c5_\u00d1T\u00000TG\u00f92t\u00a8\u008d\u0017\t\u00ab6\u0004%\u0017U\u00b2D\b\u0010\u00a4\u00f5\u0004\u008b\u00e9\u00ce\u0007c\u00b4-\u00e5\u007f\u00f7\u0001\u00fd\"?\u00ffI\u0083\u00d9C\u00bf!\u00d8|94\u00fbt2\u001f\u00e2\u00f4\u00a4\u00de\u0014\u00a9S\u001cZ~\u00d6\u00f1\u00d0\u00813\u00d8\u0085DC-\u00ce\u00f7]8u$\u00e8\u0088\u0098\u001f\u0085\u00d2\u00cb\u0015$%\u00c5{:~\u00fa\u00d3\u0007E)\u00db\u00a1Q\bBr)\u00ab\u00a4WQ\u00eb\f\u000b\u00e3\u0010\u0082\u009e\u0010\u00f8\u0004b\u0089m\u00efF\u00ec\u0086\u00ec.\u0001\u0085\u000b\u00b6\u001c\u00d3\u00a8`qI\u00a0\u00ab\u00ff\u00ea\u00bfr\u0097\u00cd\u00d8\u00bb\u00d0\u00c1\u00d79\u00fa'\u008d;\u00d2\"=\u00c3/\u00b1\u0088,\u00a1\u00d6\u00b3\u00a4\u00a6\u0087\u00b1\u00f6\u009e{2\u0084v\u0084\u00c96\u00ba\u00ea\u00fe(\u009f\u00e8\u00851X\u00ed'\u00c1b\u00f4\u001f\u00f4\u00fb\u00ea\u008fc|\u00a0\u00cc=jYjf\u00ebkQ\u00c4_\u00d8d,\u008f\u0000\f\u008c$\u00b5\u00f6#P\u00b4\u000b\u00f5\u0098\u00cf\u00ede\u00fd\u0087\u00b9\u008d2\u009a\u0015\u0085\u00b6\u00c1+\u00a3M\u00b3\u00d25\u00bfE\u001b[i\u00d1Wh\u000b\u0090\u0097\u0013)\u00a7\u00d7\u0080\n.\u00cc\t\u00da\b\u00a8\u00ff2\u00b6\u00ea\u00eft\u000bs\u00faF\u0098\u00b3P\u0093\u00e9\u009e\u00ce\u00d9cA>\u00c9Z\u00d9J1\u00df\u00f2\u001d\u00ed\u00b0\u0007\u008c\u00f6\u00ef4\u00e7V\u00ab\u0007\u001f\u008a\u00f9\u00d7\u00c2\u00c5\u0019(\u0086{\u00e8\u00be\u00930HbPh\u00de\u001c\u00b1\u00aeM\u007fX\u00bf>\u009ca\u00d6\u0000\u00f4s\u00ce+\u00a8\u00e8\u000f\u0094\u0019\u00f4\u00a8\u0001\u00b2\f\u00ff\u00f4\u00bf\u000f\u00aa\u00c2#\u00a0\u0002\u009f\u00dfT\u00d7#\u008f$;\u00fd\u0082\"\u00167\u00b6\u0016\u00e8O\u00d1\u00aa\u0013\u00a6\u009c\u00f3\u00d9\u00def<\u00d1S+\u0000H{\u00ea\u00da-\u00e3\u009b\u00a8\u00ed]MM\u001a\u00ba\u000eR(<\u00fd\u00e14\u00a3!X\u008d~\u00f1\tM\u001b\u00a9\u009fD\u000e\u0015\u00ff\u00a8\u0004n\u00ae5\u00940\u00d7}\u000b\u001a\u001f\u00ef\u0015\u00eb\u00ed\u00ed\u00ae\u0086\u0000\u00bb\n\u009bf\u00c66Q\u001c\u00f3R\u00ae\u0006\u0018\u00f78\u008f\u00f7m|\u0086*\u00b5\u00a2\u008c\u008a\u00beGP8\u00c8xb\u0080\"\u0014\u008f\u00c2)\u001e\u00d5\u00b7J\u00c8\u00c4\u00d5\u00db\u0093\u0088\u008c6\u00dcc=>/O\u00a1\u0004\u00c9\u00eb3\u0094\u00f0\u00ecp{\u00e7I\u0015Y\u001a\u0015\u0097<\u00baw\u00b1]%\t\u00d3K\u000b\u0094\u00fc\u00ac\u0099 \u00d0";
                var4_3 = "\u0086\u001e\u00b1W\u00e5\u00ee\u007f>\u0014\u0090XKxD\u0083\u00e4\u0089\u00d8\u00ab\u00a1\u00a5S\u00d06a\\IJ\u0005\u0006\u00cb\u00ea\u0018\u00c9\u00ba|\u0018B\u0088qR\u0081\u0003^YG\u00cc]9\u00aa\u00bc[nX\u00c1\u00e4\u0089\u00cc\u009d\u00c7(\tr\u00c8\u00e9\u00eb\u00f9\u00abI\u0004\u0099\u0005\u0010\u00ccc\r\u00cf\b\u00c9\u00e6X9\u008a\u0005\u0094\u00a1\u0014pR/\u00a2\u00a5\u00d0\u00edt\u0097\u00c9\u00e3]Ql\u00cd\u001b1\u00d5\u001e\u00d4\u0005\u0099\tR\u00b5\u00e9\u001e\u00a8\u00baa\u00a7\u0012y\u008el\u00f8~\u00e1\u00e8q\u00a6\u0082I\u0082\u00b4m\u00d3Q\u00f9xi\u00e2Xo\u00b5e\u00c9\u0010\u00aaS\u00c5_\u00d1T\u00000TG\u00f92t\u00a8\u008d\u0017\t\u00ab6\u0004%\u0017U\u00b2D\b\u0010\u00a4\u00f5\u0004\u008b\u00e9\u00ce\u0007c\u00b4-\u00e5\u007f\u00f7\u0001\u00fd\"?\u00ffI\u0083\u00d9C\u00bf!\u00d8|94\u00fbt2\u001f\u00e2\u00f4\u00a4\u00de\u0014\u00a9S\u001cZ~\u00d6\u00f1\u00d0\u00813\u00d8\u0085DC-\u00ce\u00f7]8u$\u00e8\u0088\u0098\u001f\u0085\u00d2\u00cb\u0015$%\u00c5{:~\u00fa\u00d3\u0007E)\u00db\u00a1Q\bBr)\u00ab\u00a4WQ\u00eb\f\u000b\u00e3\u0010\u0082\u009e\u0010\u00f8\u0004b\u0089m\u00efF\u00ec\u0086\u00ec.\u0001\u0085\u000b\u00b6\u001c\u00d3\u00a8`qI\u00a0\u00ab\u00ff\u00ea\u00bfr\u0097\u00cd\u00d8\u00bb\u00d0\u00c1\u00d79\u00fa'\u008d;\u00d2\"=\u00c3/\u00b1\u0088,\u00a1\u00d6\u00b3\u00a4\u00a6\u0087\u00b1\u00f6\u009e{2\u0084v\u0084\u00c96\u00ba\u00ea\u00fe(\u009f\u00e8\u00851X\u00ed'\u00c1b\u00f4\u001f\u00f4\u00fb\u00ea\u008fc|\u00a0\u00cc=jYjf\u00ebkQ\u00c4_\u00d8d,\u008f\u0000\f\u008c$\u00b5\u00f6#P\u00b4\u000b\u00f5\u0098\u00cf\u00ede\u00fd\u0087\u00b9\u008d2\u009a\u0015\u0085\u00b6\u00c1+\u00a3M\u00b3\u00d25\u00bfE\u001b[i\u00d1Wh\u000b\u0090\u0097\u0013)\u00a7\u00d7\u0080\n.\u00cc\t\u00da\b\u00a8\u00ff2\u00b6\u00ea\u00eft\u000bs\u00faF\u0098\u00b3P\u0093\u00e9\u009e\u00ce\u00d9cA>\u00c9Z\u00d9J1\u00df\u00f2\u001d\u00ed\u00b0\u0007\u008c\u00f6\u00ef4\u00e7V\u00ab\u0007\u001f\u008a\u00f9\u00d7\u00c2\u00c5\u0019(\u0086{\u00e8\u00be\u00930HbPh\u00de\u001c\u00b1\u00aeM\u007fX\u00bf>\u009ca\u00d6\u0000\u00f4s\u00ce+\u00a8\u00e8\u000f\u0094\u0019\u00f4\u00a8\u0001\u00b2\f\u00ff\u00f4\u00bf\u000f\u00aa\u00c2#\u00a0\u0002\u009f\u00dfT\u00d7#\u008f$;\u00fd\u0082\"\u00167\u00b6\u0016\u00e8O\u00d1\u00aa\u0013\u00a6\u009c\u00f3\u00d9\u00def<\u00d1S+\u0000H{\u00ea\u00da-\u00e3\u009b\u00a8\u00ed]MM\u001a\u00ba\u000eR(<\u00fd\u00e14\u00a3!X\u008d~\u00f1\tM\u001b\u00a9\u009fD\u000e\u0015\u00ff\u00a8\u0004n\u00ae5\u00940\u00d7}\u000b\u001a\u001f\u00ef\u0015\u00eb\u00ed\u00ed\u00ae\u0086\u0000\u00bb\n\u009bf\u00c66Q\u001c\u00f3R\u00ae\u0006\u0018\u00f78\u008f\u00f7m|\u0086*\u00b5\u00a2\u008c\u008a\u00beGP8\u00c8xb\u0080\"\u0014\u008f\u00c2)\u001e\u00d5\u00b7J\u00c8\u00c4\u00d5\u00db\u0093\u0088\u008c6\u00dcc=>/O\u00a1\u0004\u00c9\u00eb3\u0094\u00f0\u00ecp{\u00e7I\u0015Y\u001a\u0015\u0097<\u00baw\u00b1]%\t\u00d3K\u000b\u0094\u00fc\u00ac\u0099 \u00d0".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 19;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00055\"\u00a0\u008co\u00abX\u00aa\u000e]\u0010\u0010QR\u008e4\u00a3d\u00eb\u00d2\u00dfU:a\u00d3%/+\u0014]\u00b3\u0004\u00f3[\u0004\u00f1\u008f\u008c\u009d\u00dd\u0095* \u00ef\u0089\u0091\u00a2\u0005\u008e";
                    var4_3 = "\u00055\"\u00a0\u008co\u00abX\u00aa\u000e]\u0010\u0010QR\u008e4\u00a3d\u00eb\u00d2\u00dfU:a\u00d3%/+\u0014]\u00b3\u0004\u00f3[\u0004\u00f1\u008f\u008c\u009d\u00dd\u0095* \u00ef\u0089\u0091\u00a2\u0005\u008e".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 78;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 16;
                            break;
                        }
                        case 1: {
                            v15 = 30;
                            break;
                        }
                        case 2: {
                            v15 = 28;
                            break;
                        }
                        case 3: {
                            v15 = 7;
                            break;
                        }
                        case 4: {
                            v15 = 15;
                            break;
                        }
                        case 5: {
                            v15 = 61;
                            break;
                        }
                        default: {
                            v15 = 125;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xD88) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 232;
                case 1 -> 82;
                case 2 -> 97;
                case 3 -> 209;
                case 4 -> 196;
                case 5 -> 91;
                case 6 -> 132;
                case 7 -> 148;
                case 8 -> 137;
                case 9 -> 237;
                case 10 -> 178;
                case 11 -> 114;
                case 12 -> 183;
                case 13 -> 212;
                case 14 -> 166;
                case 15 -> 143;
                case 16 -> 189;
                case 17 -> 179;
                case 18 -> 199;
                case 19 -> 122;
                case 20 -> 249;
                case 21 -> 118;
                case 22 -> 177;
                case 23 -> 201;
                case 24 -> 83;
                case 25 -> 55;
                case 26 -> 25;
                case 27 -> 20;
                case 28 -> 92;
                case 29 -> 40;
                case 30 -> 155;
                case 31 -> 218;
                case 32 -> 105;
                case 33 -> 203;
                case 34 -> 89;
                case 35 -> 14;
                case 36 -> 1;
                case 37 -> 180;
                case 38 -> 202;
                case 39 -> 159;
                case 40 -> 233;
                case 41 -> 254;
                case 42 -> 167;
                case 43 -> 63;
                case 44 -> 99;
                case 45 -> 106;
                case 46 -> 46;
                case 47 -> 165;
                case 48 -> 39;
                case 49 -> 31;
                case 50 -> 98;
                case 51 -> 223;
                case 52 -> 58;
                case 53 -> 28;
                case 54 -> 193;
                case 55 -> 236;
                case 56 -> 100;
                case 57 -> 110;
                case 58 -> 145;
                case 59 -> 127;
                case 60 -> 173;
                case 61 -> 67;
                case 62 -> 101;
                case 63 -> 107;
                case 64 -> 131;
                case 65 -> 38;
                case 66 -> 15;
                case 67 -> 184;
                case 68 -> 144;
                case 69 -> 242;
                case 70 -> 13;
                case 71 -> 12;
                case 72 -> 60;
                case 73 -> 75;
                case 74 -> 251;
                case 75 -> 23;
                case 76 -> 50;
                case 77 -> 78;
                case 78 -> 234;
                case 79 -> 207;
                case 80 -> 231;
                case 81 -> 59;
                case 82 -> 85;
                case 83 -> 219;
                case 84 -> 2;
                case 85 -> 206;
                case 86 -> 81;
                case 87 -> 0;
                case 88 -> 69;
                case 89 -> 238;
                case 90 -> 230;
                case 91 -> 200;
                case 92 -> 156;
                case 93 -> 65;
                case 94 -> 103;
                case 95 -> 96;
                case 96 -> 42;
                case 97 -> 187;
                case 98 -> 221;
                case 99 -> 190;
                case 100 -> 111;
                case 101 -> 22;
                case 102 -> 197;
                case 103 -> 71;
                case 104 -> 149;
                case 105 -> 74;
                case 106 -> 181;
                case 107 -> 29;
                case 108 -> 77;
                case 109 -> 108;
                case 110 -> 61;
                case 111 -> 152;
                case 112 -> 244;
                case 113 -> 109;
                case 114 -> 49;
                case 115 -> 119;
                case 116 -> 8;
                case 117 -> 217;
                case 118 -> 139;
                case 119 -> 161;
                case 120 -> 191;
                case 121 -> 10;
                case 122 -> 21;
                case 123 -> 174;
                case 124 -> 6;
                case 125 -> 151;
                case 126 -> 16;
                case 127 -> 204;
                case 128 -> 250;
                case 129 -> 185;
                case 130 -> 175;
                case 131 -> 215;
                case 132 -> 235;
                case 133 -> 226;
                case 134 -> 171;
                case 135 -> 27;
                case 136 -> 225;
                case 137 -> 150;
                case 138 -> 79;
                case 139 -> 94;
                case 140 -> 147;
                case 141 -> 141;
                case 142 -> 112;
                case 143 -> 210;
                case 144 -> 172;
                case 145 -> 134;
                case 146 -> 170;
                case 147 -> 24;
                case 148 -> 188;
                case 149 -> 130;
                case 150 -> 34;
                case 151 -> 224;
                case 152 -> 87;
                case 153 -> 162;
                case 154 -> 140;
                case 155 -> 157;
                case 156 -> 72;
                case 157 -> 176;
                case 158 -> 163;
                case 159 -> 154;
                case 160 -> 26;
                case 161 -> 227;
                case 162 -> 245;
                case 163 -> 113;
                case 164 -> 51;
                case 165 -> 240;
                case 166 -> 246;
                case 167 -> 220;
                case 168 -> 146;
                case 169 -> 120;
                case 170 -> 56;
                case 171 -> 5;
                case 172 -> 18;
                case 173 -> 57;
                case 174 -> 4;
                case 175 -> 239;
                case 176 -> 104;
                case 177 -> 86;
                case 178 -> 135;
                case 179 -> 153;
                case 180 -> 117;
                case 181 -> 64;
                case 182 -> 54;
                case 183 -> 229;
                case 184 -> 205;
                case 185 -> 52;
                case 186 -> 66;
                case 187 -> 126;
                case 188 -> 53;
                case 189 -> 128;
                case 190 -> 33;
                case 191 -> 248;
                case 192 -> 37;
                case 193 -> 194;
                case 194 -> 253;
                case 195 -> 133;
                case 196 -> 11;
                case 197 -> 80;
                case 198 -> 121;
                case 199 -> 228;
                case 200 -> 123;
                case 201 -> 216;
                case 202 -> 17;
                case 203 -> 168;
                case 204 -> 9;
                case 205 -> 115;
                case 206 -> 208;
                case 207 -> 252;
                case 208 -> 102;
                case 209 -> 19;
                case 210 -> 255;
                case 211 -> 32;
                case 212 -> 136;
                case 213 -> 164;
                case 214 -> 129;
                case 215 -> 247;
                case 216 -> 3;
                case 217 -> 48;
                case 218 -> 68;
                case 219 -> 169;
                case 220 -> 125;
                case 221 -> 62;
                case 222 -> 95;
                case 223 -> 36;
                case 224 -> 76;
                case 225 -> 211;
                case 226 -> 30;
                case 227 -> 90;
                case 228 -> 192;
                case 229 -> 73;
                case 230 -> 186;
                case 231 -> 241;
                case 232 -> 195;
                case 233 -> 47;
                case 234 -> 182;
                case 235 -> 35;
                case 236 -> 160;
                case 237 -> 93;
                case 238 -> 213;
                case 239 -> 84;
                case 240 -> 158;
                case 241 -> 138;
                case 242 -> 41;
                case 243 -> 45;
                case 244 -> 124;
                case 245 -> 7;
                case 246 -> 43;
                case 247 -> 198;
                case 248 -> 142;
                case 249 -> 70;
                case 250 -> 116;
                case 251 -> 222;
                case 252 -> 88;
                case 253 -> 44;
                case 254 -> 214;
                default -> 243;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 123030832521954L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1494329070 - -5793, 1494329070 + 21175, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 124103177281705L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.q();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-97253940 + -6099, 97253940 + 14483, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-97253940 + -6098, 97253940 + 3586, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-97253940 + -6097, 97253940 + 32253, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00a6\u0006\u008d|\u00daU\n\u00a0\u0010\u001f\u00ecK\u0080\u00b8q\u00bf}\u00dc\u00d6\u00c0\u00b8\u008dk[\u0010";
                    var4_3 = "\u00a6\u0006\u008d|\u00daU\n\u00a0\u0010\u001f\u00ecK\u0080\u00b8q\u00bf}\u00dc\u00d6\u00c0\u00b8\u008dk[\u0010".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 108;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00e3$\u00ef\u00f2,5\u001a\u0095\u00c7\u00a8\u00fb\u0087\u0005\u00c26P\u00c5b\u0010\u0010'?\u001f4F\u0083\u00fe\u0007\u00efv\u0083\u008eE\u00a9\u00a4\u0099_u:\u00f5\u00bez\u00f5\u0013\u00de\u00a5\\\u00853h\u00cf\u0092H\u00af\u00aa}t9\u00f6";
                        var4_3 = "\u00e3$\u00ef\u00f2,5\u001a\u0095\u00c7\u00a8\u00fb\u0087\u0005\u00c26P\u00c5b\u0010\u0010'?\u001f4F\u0083\u00fe\u0007\u00efv\u0083\u008eE\u00a9\u00a4\u0099_u:\u00f5\u00bez\u00f5\u0013\u00de\u00a5\\\u00853h\u00cf\u0092H\u00af\u00aa}t9\u00f6".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 67;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 69;
                                break;
                            }
                            case 1: {
                                v15 = 16;
                                break;
                            }
                            case 2: {
                                v15 = 30;
                                break;
                            }
                            case 3: {
                                v15 = 126;
                                break;
                            }
                            case 4: {
                                v15 = 103;
                                break;
                            }
                            case 5: {
                                v15 = 92;
                                break;
                            }
                            default: {
                                v15 = 114;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCD51) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 206;
                    case 1 -> 190;
                    case 2 -> 69;
                    case 3 -> 152;
                    case 4 -> 47;
                    case 5 -> 33;
                    case 6 -> 242;
                    case 7 -> 139;
                    case 8 -> 125;
                    case 9 -> 129;
                    case 10 -> 88;
                    case 11 -> 253;
                    case 12 -> 213;
                    case 13 -> 217;
                    case 14 -> 61;
                    case 15 -> 165;
                    case 16 -> 176;
                    case 17 -> 203;
                    case 18 -> 252;
                    case 19 -> 251;
                    case 20 -> 175;
                    case 21 -> 234;
                    case 22 -> 200;
                    case 23 -> 119;
                    case 24 -> 59;
                    case 25 -> 76;
                    case 26 -> 159;
                    case 27 -> 208;
                    case 28 -> 114;
                    case 29 -> 137;
                    case 30 -> 17;
                    case 31 -> 100;
                    case 32 -> 187;
                    case 33 -> 183;
                    case 34 -> 153;
                    case 35 -> 169;
                    case 36 -> 112;
                    case 37 -> 46;
                    case 38 -> 111;
                    case 39 -> 238;
                    case 40 -> 104;
                    case 41 -> 42;
                    case 42 -> 44;
                    case 43 -> 162;
                    case 44 -> 170;
                    case 45 -> 245;
                    case 46 -> 89;
                    case 47 -> 106;
                    case 48 -> 120;
                    case 49 -> 207;
                    case 50 -> 41;
                    case 51 -> 136;
                    case 52 -> 84;
                    case 53 -> 171;
                    case 54 -> 29;
                    case 55 -> 31;
                    case 56 -> 184;
                    case 57 -> 181;
                    case 58 -> 28;
                    case 59 -> 194;
                    case 60 -> 142;
                    case 61 -> 148;
                    case 62 -> 220;
                    case 63 -> 93;
                    case 64 -> 229;
                    case 65 -> 151;
                    case 66 -> 1;
                    case 67 -> 199;
                    case 68 -> 135;
                    case 69 -> 62;
                    case 70 -> 83;
                    case 71 -> 210;
                    case 72 -> 164;
                    case 73 -> 223;
                    case 74 -> 22;
                    case 75 -> 71;
                    case 76 -> 50;
                    case 77 -> 98;
                    case 78 -> 11;
                    case 79 -> 26;
                    case 80 -> 189;
                    case 81 -> 185;
                    case 82 -> 127;
                    case 83 -> 168;
                    case 84 -> 57;
                    case 85 -> 219;
                    case 86 -> 9;
                    case 87 -> 131;
                    case 88 -> 144;
                    case 89 -> 212;
                    case 90 -> 156;
                    case 91 -> 211;
                    case 92 -> 188;
                    case 93 -> 163;
                    case 94 -> 196;
                    case 95 -> 81;
                    case 96 -> 193;
                    case 97 -> 87;
                    case 98 -> 143;
                    case 99 -> 32;
                    case 100 -> 249;
                    case 101 -> 19;
                    case 102 -> 2;
                    case 103 -> 141;
                    case 104 -> 173;
                    case 105 -> 92;
                    case 106 -> 221;
                    case 107 -> 110;
                    case 108 -> 138;
                    case 109 -> 150;
                    case 110 -> 67;
                    case 111 -> 18;
                    case 112 -> 250;
                    case 113 -> 108;
                    case 114 -> 121;
                    case 115 -> 246;
                    case 116 -> 132;
                    case 117 -> 65;
                    case 118 -> 167;
                    case 119 -> 160;
                    case 120 -> 124;
                    case 121 -> 202;
                    case 122 -> 122;
                    case 123 -> 79;
                    case 124 -> 195;
                    case 125 -> 58;
                    case 126 -> 172;
                    case 127 -> 0;
                    case 128 -> 99;
                    case 129 -> 91;
                    case 130 -> 205;
                    case 131 -> 63;
                    case 132 -> 78;
                    case 133 -> 113;
                    case 134 -> 225;
                    case 135 -> 145;
                    case 136 -> 239;
                    case 137 -> 25;
                    case 138 -> 27;
                    case 139 -> 226;
                    case 140 -> 254;
                    case 141 -> 16;
                    case 142 -> 80;
                    case 143 -> 72;
                    case 144 -> 95;
                    case 145 -> 116;
                    case 146 -> 178;
                    case 147 -> 255;
                    case 148 -> 68;
                    case 149 -> 243;
                    case 150 -> 52;
                    case 151 -> 204;
                    case 152 -> 123;
                    case 153 -> 224;
                    case 154 -> 182;
                    case 155 -> 109;
                    case 156 -> 227;
                    case 157 -> 7;
                    case 158 -> 209;
                    case 159 -> 56;
                    case 160 -> 53;
                    case 161 -> 107;
                    case 162 -> 192;
                    case 163 -> 39;
                    case 164 -> 30;
                    case 165 -> 94;
                    case 166 -> 146;
                    case 167 -> 23;
                    case 168 -> 97;
                    case 169 -> 43;
                    case 170 -> 126;
                    case 171 -> 186;
                    case 172 -> 60;
                    case 173 -> 232;
                    case 174 -> 231;
                    case 175 -> 8;
                    case 176 -> 48;
                    case 177 -> 128;
                    case 178 -> 20;
                    case 179 -> 102;
                    case 180 -> 101;
                    case 181 -> 233;
                    case 182 -> 21;
                    case 183 -> 134;
                    case 184 -> 24;
                    case 185 -> 37;
                    case 186 -> 216;
                    case 187 -> 215;
                    case 188 -> 103;
                    case 189 -> 228;
                    case 190 -> 180;
                    case 191 -> 5;
                    case 192 -> 105;
                    case 193 -> 70;
                    case 194 -> 179;
                    case 195 -> 64;
                    case 196 -> 35;
                    case 197 -> 86;
                    case 198 -> 55;
                    case 199 -> 157;
                    case 200 -> 90;
                    case 201 -> 149;
                    case 202 -> 49;
                    case 203 -> 75;
                    case 204 -> 115;
                    case 205 -> 201;
                    case 206 -> 3;
                    case 207 -> 13;
                    case 208 -> 218;
                    case 209 -> 235;
                    case 210 -> 248;
                    case 211 -> 161;
                    case 212 -> 240;
                    case 213 -> 77;
                    case 214 -> 36;
                    case 215 -> 154;
                    case 216 -> 82;
                    case 217 -> 155;
                    case 218 -> 174;
                    case 219 -> 230;
                    case 220 -> 247;
                    case 221 -> 117;
                    case 222 -> 6;
                    case 223 -> 158;
                    case 224 -> 40;
                    case 225 -> 140;
                    case 226 -> 197;
                    case 227 -> 130;
                    case 228 -> 237;
                    case 229 -> 10;
                    case 230 -> 73;
                    case 231 -> 34;
                    case 232 -> 45;
                    case 233 -> 66;
                    case 234 -> 236;
                    case 235 -> 241;
                    case 236 -> 74;
                    case 237 -> 38;
                    case 238 -> 12;
                    case 239 -> 133;
                    case 240 -> 85;
                    case 241 -> 96;
                    case 242 -> 244;
                    case 243 -> 118;
                    case 244 -> 177;
                    case 245 -> 14;
                    case 246 -> 4;
                    case 247 -> 51;
                    case 248 -> 54;
                    case 249 -> 198;
                    case 250 -> 147;
                    case 251 -> 191;
                    case 252 -> 166;
                    case 253 -> 222;
                    case 254 -> 214;
                    default -> 15;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 127973498417026L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0016@|^.wIO\t\u0011JoTc5TS\f";
                    var5_4 = "\u0016@|^.wIO\t\u0011JoTc5TS\f".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 94;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 35;
                                    break;
                                }
                                case 1: {
                                    v11 = 123;
                                    break;
                                }
                                case 2: {
                                    v11 = 80;
                                    break;
                                }
                                case 3: {
                                    v11 = 110;
                                    break;
                                }
                                case 4: {
                                    v11 = 21;
                                    break;
                                }
                                case 5: {
                                    v11 = 69;
                                    break;
                                }
                                default: {
                                    v11 = 36;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 48840831842826L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = ")e\u001dI\u0004D\t\u0004/{\u0011S\n#d\u001aS\bF\u0011\te\u0013\t#d\u001aS\bF\u0011\u0005o\r$b\u0007^\u0002K\u000b\u0005h\u0000T\u0003B";
                    var5_4 = ")e\u001dI\u0004D\t\u0004/{\u0011S\n#d\u001aS\bF\u0011\te\u0013\t#d\u001aS\bF\u0011\u0005o\r$b\u0007^\u0002K\u000b\u0005h\u0000T\u0003B".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 83;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "O\u000bw\"h'n\u0006O\u000bw\"d-";
                        var5_4 = "O\u000bw\"h'n\u0006O\u000bw\"d-".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 63;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 51;
                                break;
                            }
                            case 1: {
                                v15 = 88;
                                break;
                            }
                            case 2: {
                                v15 = 39;
                                break;
                            }
                            case 3: {
                                v15 = 110;
                                break;
                            }
                            case 4: {
                                v15 = 62;
                                break;
                            }
                            case 5: {
                                v15 = 118;
                                break;
                            }
                            default: {
                                v15 = 54;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 140446020706699L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-590208210 - -((char)-2231), 590077140 + (char)-10407, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 22465105348115L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "Z\u00a7\u0016VL\u0003{Q\u0086\u0005\u00c0\u009cc\u00f5\u0001\r\u0082\u00d2\u001dv;\u0096\u00193v\u00b9\u00acnJ\u0010[\u00a3\u00e1\u00b3\u009b\u00bb&\u00abX.\u008a\u00d1h\u00bbh\u00bd\u0005\u0000\"{\"\u00023'\b\u008e\u0010\u00a3\u008b\u0011\u00b9\u00c3\u0091r\u000f\u00b11\u007f\u00f3\u00cc\u00a6\u00f7\u00b7X\u00c2 \u00ae\u00a1\u00b6\u008e\u00cf&\u009c\u00d8\u0098\u00b7\u0088\u00d8\u00fb\u00be\u0089\u0017@\u009eT?\u001d\u00d7^\u0099z.\u00b2i";
                    var4_3 = "Z\u00a7\u0016VL\u0003{Q\u0086\u0005\u00c0\u009cc\u00f5\u0001\r\u0082\u00d2\u001dv;\u0096\u00193v\u00b9\u00acnJ\u0010[\u00a3\u00e1\u00b3\u009b\u00bb&\u00abX.\u008a\u00d1h\u00bbh\u00bd\u0005\u0000\"{\"\u00023'\b\u008e\u0010\u00a3\u008b\u0011\u00b9\u00c3\u0091r\u000f\u00b11\u007f\u00f3\u00cc\u00a6\u00f7\u00b7X\u00c2 \u00ae\u00a1\u00b6\u008e\u00cf&\u009c\u00d8\u0098\u00b7\u0088\u00d8\u00fb\u00be\u0089\u0017@\u009eT?\u001d\u00d7^\u0099z.\u00b2i".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 37;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "*\u00e5x\u00cc\u001f\u00e3\u0001\u0017\u000b\u000eWbdz^2L\u00c7\u00c22\u00e2|\u00ee\u0003\u00d8\u00c2d\u00c2\u0096\u00d8jZI\u00da\u0097}\u00d0\u00d6\u00fdl\\\u00bc\u00b4\u00bf\u00feMD\u00ed[\u00b6\u00a9>t\u00e7\u0011\u00b1\u0082\u00cbF\u00ed\u0095/&\u00fa\u00fa\u0007!\u0013y\u00d7\r\u00d16\u00f35#\u0013Z[\u0011\u00e3\u00c0\u001a\u008b'\u009b\u00a7d \u00f2\u0085u\u0005";
                        var4_3 = "*\u00e5x\u00cc\u001f\u00e3\u0001\u0017\u000b\u000eWbdz^2L\u00c7\u00c22\u00e2|\u00ee\u0003\u00d8\u00c2d\u00c2\u0096\u00d8jZI\u00da\u0097}\u00d0\u00d6\u00fdl\\\u00bc\u00b4\u00bf\u00feMD\u00ed[\u00b6\u00a9>t\u00e7\u0011\u00b1\u0082\u00cbF\u00ed\u0095/&\u00fa\u00fa\u0007!\u0013y\u00d7\r\u00d16\u00f35#\u0013Z[\u0011\u00e3\u00c0\u001a\u008b'\u009b\u00a7d \u00f2\u0085u\u0005".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 48;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 71;
                                break;
                            }
                            case 1: {
                                v15 = 45;
                                break;
                            }
                            case 2: {
                                v15 = 28;
                                break;
                            }
                            case 3: {
                                v15 = 99;
                                break;
                            }
                            case 4: {
                                v15 = 49;
                                break;
                            }
                            case 5: {
                                v15 = 51;
                                break;
                            }
                            default: {
                                v15 = 37;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFBBFC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 52;
                    case 1 -> 174;
                    case 2 -> 115;
                    case 3 -> 111;
                    case 4 -> 215;
                    case 5 -> 190;
                    case 6 -> 20;
                    case 7 -> 137;
                    case 8 -> 248;
                    case 9 -> 88;
                    case 10 -> 48;
                    case 11 -> 250;
                    case 12 -> 46;
                    case 13 -> 117;
                    case 14 -> 6;
                    case 15 -> 247;
                    case 16 -> 25;
                    case 17 -> 2;
                    case 18 -> 197;
                    case 19 -> 169;
                    case 20 -> 198;
                    case 21 -> 36;
                    case 22 -> 245;
                    case 23 -> 101;
                    case 24 -> 69;
                    case 25 -> 202;
                    case 26 -> 11;
                    case 27 -> 84;
                    case 28 -> 129;
                    case 29 -> 177;
                    case 30 -> 94;
                    case 31 -> 195;
                    case 32 -> 70;
                    case 33 -> 19;
                    case 34 -> 157;
                    case 35 -> 109;
                    case 36 -> 238;
                    case 37 -> 110;
                    case 38 -> 191;
                    case 39 -> 155;
                    case 40 -> 106;
                    case 41 -> 91;
                    case 42 -> 221;
                    case 43 -> 81;
                    case 44 -> 209;
                    case 45 -> 218;
                    case 46 -> 16;
                    case 47 -> 164;
                    case 48 -> 223;
                    case 49 -> 242;
                    case 50 -> 143;
                    case 51 -> 241;
                    case 52 -> 92;
                    case 53 -> 142;
                    case 54 -> 78;
                    case 55 -> 212;
                    case 56 -> 77;
                    case 57 -> 234;
                    case 58 -> 112;
                    case 59 -> 201;
                    case 60 -> 204;
                    case 61 -> 118;
                    case 62 -> 253;
                    case 63 -> 156;
                    case 64 -> 249;
                    case 65 -> 171;
                    case 66 -> 199;
                    case 67 -> 44;
                    case 68 -> 196;
                    case 69 -> 167;
                    case 70 -> 9;
                    case 71 -> 179;
                    case 72 -> 186;
                    case 73 -> 255;
                    case 74 -> 34;
                    case 75 -> 107;
                    case 76 -> 82;
                    case 77 -> 90;
                    case 78 -> 158;
                    case 79 -> 210;
                    case 80 -> 76;
                    case 81 -> 97;
                    case 82 -> 175;
                    case 83 -> 168;
                    case 84 -> 60;
                    case 85 -> 54;
                    case 86 -> 22;
                    case 87 -> 231;
                    case 88 -> 126;
                    case 89 -> 192;
                    case 90 -> 149;
                    case 91 -> 216;
                    case 92 -> 217;
                    case 93 -> 58;
                    case 94 -> 144;
                    case 95 -> 4;
                    case 96 -> 12;
                    case 97 -> 131;
                    case 98 -> 208;
                    case 99 -> 227;
                    case 100 -> 127;
                    case 101 -> 160;
                    case 102 -> 35;
                    case 103 -> 40;
                    case 104 -> 136;
                    case 105 -> 30;
                    case 106 -> 28;
                    case 107 -> 1;
                    case 108 -> 39;
                    case 109 -> 222;
                    case 110 -> 75;
                    case 111 -> 185;
                    case 112 -> 243;
                    case 113 -> 86;
                    case 114 -> 104;
                    case 115 -> 59;
                    case 116 -> 219;
                    case 117 -> 166;
                    case 118 -> 93;
                    case 119 -> 102;
                    case 120 -> 189;
                    case 121 -> 85;
                    case 122 -> 105;
                    case 123 -> 55;
                    case 124 -> 135;
                    case 125 -> 184;
                    case 126 -> 41;
                    case 127 -> 7;
                    case 128 -> 176;
                    case 129 -> 203;
                    case 130 -> 145;
                    case 131 -> 162;
                    case 132 -> 18;
                    case 133 -> 62;
                    case 134 -> 214;
                    case 135 -> 56;
                    case 136 -> 254;
                    case 137 -> 113;
                    case 138 -> 45;
                    case 139 -> 27;
                    case 140 -> 72;
                    case 141 -> 103;
                    case 142 -> 24;
                    case 143 -> 13;
                    case 144 -> 237;
                    case 145 -> 225;
                    case 146 -> 108;
                    case 147 -> 68;
                    case 148 -> 116;
                    case 149 -> 123;
                    case 150 -> 153;
                    case 151 -> 8;
                    case 152 -> 178;
                    case 153 -> 33;
                    case 154 -> 74;
                    case 155 -> 132;
                    case 156 -> 71;
                    case 157 -> 239;
                    case 158 -> 138;
                    case 159 -> 53;
                    case 160 -> 251;
                    case 161 -> 140;
                    case 162 -> 43;
                    case 163 -> 125;
                    case 164 -> 23;
                    case 165 -> 246;
                    case 166 -> 146;
                    case 167 -> 21;
                    case 168 -> 47;
                    case 169 -> 151;
                    case 170 -> 10;
                    case 171 -> 235;
                    case 172 -> 139;
                    case 173 -> 50;
                    case 174 -> 240;
                    case 175 -> 83;
                    case 176 -> 95;
                    case 177 -> 232;
                    case 178 -> 170;
                    case 179 -> 205;
                    case 180 -> 87;
                    case 181 -> 26;
                    case 182 -> 173;
                    case 183 -> 226;
                    case 184 -> 183;
                    case 185 -> 15;
                    case 186 -> 206;
                    case 187 -> 120;
                    case 188 -> 244;
                    case 189 -> 31;
                    case 190 -> 65;
                    case 191 -> 3;
                    case 192 -> 121;
                    case 193 -> 119;
                    case 194 -> 0;
                    case 195 -> 154;
                    case 196 -> 89;
                    case 197 -> 17;
                    case 198 -> 38;
                    case 199 -> 194;
                    case 200 -> 14;
                    case 201 -> 229;
                    case 202 -> 163;
                    case 203 -> 228;
                    case 204 -> 165;
                    case 205 -> 73;
                    case 206 -> 32;
                    case 207 -> 233;
                    case 208 -> 128;
                    case 209 -> 207;
                    case 210 -> 172;
                    case 211 -> 148;
                    case 212 -> 152;
                    case 213 -> 134;
                    case 214 -> 66;
                    case 215 -> 133;
                    case 216 -> 150;
                    case 217 -> 141;
                    case 218 -> 182;
                    case 219 -> 200;
                    case 220 -> 159;
                    case 221 -> 63;
                    case 222 -> 181;
                    case 223 -> 122;
                    case 224 -> 147;
                    case 225 -> 114;
                    case 226 -> 224;
                    case 227 -> 161;
                    case 228 -> 99;
                    case 229 -> 98;
                    case 230 -> 67;
                    case 231 -> 188;
                    case 232 -> 79;
                    case 233 -> 124;
                    case 234 -> 187;
                    case 235 -> 42;
                    case 236 -> 61;
                    case 237 -> 213;
                    case 238 -> 64;
                    case 239 -> 5;
                    case 240 -> 96;
                    case 241 -> 51;
                    case 242 -> 252;
                    case 243 -> 130;
                    case 244 -> 230;
                    case 245 -> 57;
                    case 246 -> 211;
                    case 247 -> 49;
                    case 248 -> 220;
                    case 249 -> 193;
                    case 250 -> 180;
                    case 251 -> 80;
                    case 252 -> 236;
                    case 253 -> 29;
                    case 254 -> 37;
                    default -> 100;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 136734099979958L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-478929780 - -((char)-2941), 478929780 - (char)-685, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 69773973883215L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.q();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-2064745710 + -((char)-11237), -2064745710 + -((char)-28121), (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 94145178435742L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "/\u0097\u00ce\u00f0\u00e8\u0003\u00e6_\u00a1";
                var4_3 = "/\u0097\u00ce\u00f0\u00e8\u0003\u00e6_\u00a1".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 27;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 56;
                                break;
                            }
                            case 1: {
                                v11 = 69;
                                break;
                            }
                            case 2: {
                                v11 = 124;
                                break;
                            }
                            case 3: {
                                v11 = 55;
                                break;
                            }
                            case 4: {
                                v11 = 123;
                                break;
                            }
                            case 5: {
                                v11 = 80;
                                break;
                            }
                            default: {
                                v11 = 29;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x2FB9) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 247;
                    case 1 -> 118;
                    case 2 -> 6;
                    case 3 -> 122;
                    case 4 -> 113;
                    case 5 -> 193;
                    case 6 -> 167;
                    case 7 -> 96;
                    case 8 -> 19;
                    case 9 -> 57;
                    case 10 -> 209;
                    case 11 -> 155;
                    case 12 -> 42;
                    case 13 -> 111;
                    case 14 -> 149;
                    case 15 -> 253;
                    case 16 -> 0;
                    case 17 -> 8;
                    case 18 -> 22;
                    case 19 -> 81;
                    case 20 -> 184;
                    case 21 -> 206;
                    case 22 -> 100;
                    case 23 -> 153;
                    case 24 -> 135;
                    case 25 -> 7;
                    case 26 -> 168;
                    case 27 -> 175;
                    case 28 -> 47;
                    case 29 -> 152;
                    case 30 -> 49;
                    case 31 -> 76;
                    case 32 -> 243;
                    case 33 -> 85;
                    case 34 -> 220;
                    case 35 -> 46;
                    case 36 -> 215;
                    case 37 -> 115;
                    case 38 -> 252;
                    case 39 -> 228;
                    case 40 -> 26;
                    case 41 -> 195;
                    case 42 -> 62;
                    case 43 -> 48;
                    case 44 -> 56;
                    case 45 -> 142;
                    case 46 -> 233;
                    case 47 -> 67;
                    case 48 -> 92;
                    case 49 -> 200;
                    case 50 -> 39;
                    case 51 -> 166;
                    case 52 -> 204;
                    case 53 -> 144;
                    case 54 -> 40;
                    case 55 -> 25;
                    case 56 -> 219;
                    case 57 -> 59;
                    case 58 -> 255;
                    case 59 -> 71;
                    case 60 -> 86;
                    case 61 -> 95;
                    case 62 -> 11;
                    case 63 -> 250;
                    case 64 -> 246;
                    case 65 -> 217;
                    case 66 -> 112;
                    case 67 -> 176;
                    case 68 -> 82;
                    case 69 -> 165;
                    case 70 -> 63;
                    case 71 -> 178;
                    case 72 -> 93;
                    case 73 -> 161;
                    case 74 -> 66;
                    case 75 -> 29;
                    case 76 -> 188;
                    case 77 -> 248;
                    case 78 -> 30;
                    case 79 -> 54;
                    case 80 -> 80;
                    case 81 -> 87;
                    case 82 -> 1;
                    case 83 -> 108;
                    case 84 -> 45;
                    case 85 -> 244;
                    case 86 -> 201;
                    case 87 -> 70;
                    case 88 -> 107;
                    case 89 -> 205;
                    case 90 -> 180;
                    case 91 -> 164;
                    case 92 -> 41;
                    case 93 -> 110;
                    case 94 -> 177;
                    case 95 -> 44;
                    case 96 -> 127;
                    case 97 -> 170;
                    case 98 -> 159;
                    case 99 -> 172;
                    case 100 -> 28;
                    case 101 -> 68;
                    case 102 -> 254;
                    case 103 -> 101;
                    case 104 -> 5;
                    case 105 -> 192;
                    case 106 -> 230;
                    case 107 -> 89;
                    case 108 -> 221;
                    case 109 -> 37;
                    case 110 -> 251;
                    case 111 -> 88;
                    case 112 -> 43;
                    case 113 -> 183;
                    case 114 -> 52;
                    case 115 -> 236;
                    case 116 -> 4;
                    case 117 -> 20;
                    case 118 -> 154;
                    case 119 -> 227;
                    case 120 -> 181;
                    case 121 -> 212;
                    case 122 -> 239;
                    case 123 -> 97;
                    case 124 -> 90;
                    case 125 -> 185;
                    case 126 -> 128;
                    case 127 -> 225;
                    case 128 -> 119;
                    case 129 -> 139;
                    case 130 -> 210;
                    case 131 -> 51;
                    case 132 -> 75;
                    case 133 -> 64;
                    case 134 -> 2;
                    case 135 -> 171;
                    case 136 -> 79;
                    case 137 -> 190;
                    case 138 -> 245;
                    case 139 -> 174;
                    case 140 -> 27;
                    case 141 -> 179;
                    case 142 -> 214;
                    case 143 -> 55;
                    case 144 -> 216;
                    case 145 -> 105;
                    case 146 -> 35;
                    case 147 -> 17;
                    case 148 -> 99;
                    case 149 -> 61;
                    case 150 -> 53;
                    case 151 -> 234;
                    case 152 -> 213;
                    case 153 -> 73;
                    case 154 -> 211;
                    case 155 -> 103;
                    case 156 -> 158;
                    case 157 -> 102;
                    case 158 -> 229;
                    case 159 -> 191;
                    case 160 -> 140;
                    case 161 -> 198;
                    case 162 -> 226;
                    case 163 -> 58;
                    case 164 -> 84;
                    case 165 -> 242;
                    case 166 -> 151;
                    case 167 -> 120;
                    case 168 -> 3;
                    case 169 -> 69;
                    case 170 -> 241;
                    case 171 -> 12;
                    case 172 -> 133;
                    case 173 -> 72;
                    case 174 -> 162;
                    case 175 -> 31;
                    case 176 -> 137;
                    case 177 -> 207;
                    case 178 -> 32;
                    case 179 -> 169;
                    case 180 -> 148;
                    case 181 -> 124;
                    case 182 -> 197;
                    case 183 -> 18;
                    case 184 -> 50;
                    case 185 -> 143;
                    case 186 -> 203;
                    case 187 -> 23;
                    case 188 -> 130;
                    case 189 -> 98;
                    case 190 -> 235;
                    case 191 -> 194;
                    case 192 -> 138;
                    case 193 -> 224;
                    case 194 -> 77;
                    case 195 -> 114;
                    case 196 -> 146;
                    case 197 -> 238;
                    case 198 -> 116;
                    case 199 -> 94;
                    case 200 -> 131;
                    case 201 -> 106;
                    case 202 -> 147;
                    case 203 -> 157;
                    case 204 -> 231;
                    case 205 -> 83;
                    case 206 -> 145;
                    case 207 -> 187;
                    case 208 -> 132;
                    case 209 -> 13;
                    case 210 -> 223;
                    case 211 -> 199;
                    case 212 -> 189;
                    case 213 -> 123;
                    case 214 -> 10;
                    case 215 -> 249;
                    case 216 -> 14;
                    case 217 -> 182;
                    case 218 -> 24;
                    case 219 -> 160;
                    case 220 -> 78;
                    case 221 -> 208;
                    case 222 -> 222;
                    case 223 -> 9;
                    case 224 -> 173;
                    case 225 -> 232;
                    case 226 -> 15;
                    case 227 -> 38;
                    case 228 -> 60;
                    case 229 -> 134;
                    case 230 -> 218;
                    case 231 -> 74;
                    case 232 -> 16;
                    case 233 -> 240;
                    case 234 -> 237;
                    case 235 -> 117;
                    case 236 -> 125;
                    case 237 -> 150;
                    case 238 -> 186;
                    case 239 -> 136;
                    case 240 -> 163;
                    case 241 -> 121;
                    case 242 -> 129;
                    case 243 -> 156;
                    case 244 -> 33;
                    case 245 -> 196;
                    case 246 -> 36;
                    case 247 -> 109;
                    case 248 -> 34;
                    case 249 -> 21;
                    case 250 -> 126;
                    case 251 -> 65;
                    case 252 -> 91;
                    case 253 -> 104;
                    case 254 -> 141;
                    default -> 202;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

