/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.xml.util;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.xml.util.HtmlReferenceProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.HtmlUtil;
import org.intellij.images.util.ImageInfo;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HtmlUpdateImageSizeIntention
extends BaseIntentionAction {
    private boolean myUseElementToTheLeft = false;

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = HtmlToolsBundle.message("html.intention.update.image.size", new Object[0]);
        if (string == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        int offset;
        if (project == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(1);
        }
        if (this.isAvailable(HtmlUpdateImageSizeIntention.getTag(psiFile, offset = editor.getCaretModel().getOffset()))) {
            return true;
        }
        if (offset > 0 && this.isAvailable(HtmlUpdateImageSizeIntention.getTag(psiFile, offset - 1))) {
            this.myUseElementToTheLeft = true;
            return true;
        }
        return false;
    }

    public boolean isAvailable(@Nullable XmlTag tag) {
        if (tag == null) {
            return false;
        }
        ImageInfo imageInfo = HtmlUpdateImageSizeIntention.getImageInfo(tag);
        if (imageInfo == null || imageInfo.height == 0 || imageInfo.width == 0) {
            return false;
        }
        String widthValue = tag.getAttributeValue("width");
        String heightValue = tag.getAttributeValue("height");
        this.setText(widthValue != null || heightValue != null ? HtmlToolsBundle.message("html.intention.update.image.size", new Object[0]) : HtmlToolsBundle.message("html.intention.insert.image.size", new Object[0]));
        return imageInfo.width != HtmlReferenceProvider.SizeReference.getSizeValue(widthValue, (XmlElement)tag) || imageInfo.height != HtmlReferenceProvider.SizeReference.getSizeValue(heightValue, (XmlElement)tag);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        XmlTag tag = HtmlUpdateImageSizeIntention.getTag(psiFile, this.myUseElementToTheLeft ? offset - 1 : offset);
        if (tag == null) {
            return;
        }
        ImageInfo imageInfo = HtmlUpdateImageSizeIntention.getImageInfo(tag);
        if (imageInfo != null && imageInfo.height != 0 && imageInfo.width != 0) {
            tag.setAttribute("width", String.valueOf(imageInfo.width));
            tag.setAttribute("height", String.valueOf(imageInfo.height));
        }
    }

    @Nullable
    private static ImageInfo getImageInfo(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(3);
        }
        if ("img".equalsIgnoreCase(xmlTag.getName())) {
            return HtmlReferenceProvider.SizeReference.getImageInfo(xmlTag);
        }
        return null;
    }

    @Nullable
    private static XmlTag getTag(@NotNull PsiFile file, int offset) {
        if (file == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(4);
        }
        if (!HtmlUtil.hasHtml((PsiFile)file)) {
            return null;
        }
        return (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file.getViewProvider().findElementAt(offset, (Language)HTMLLanguage.INSTANCE), (Class[])new Class[]{XmlTag.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImageInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

