/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.diagrams.presentation;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.microservices.diagrams.MsDiagramRelationship;
import com.intellij.microservices.diagrams.model.MsDiagramElement;
import com.intellij.microservices.diagrams.model.MsDiagramRequest;
import com.intellij.microservices.diagrams.presentation.MsDiagramNode;
import com.intellij.microservices.diagrams.usages.MsDiagramShowUsagesManagerKt;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/intellij/microservices/diagrams/presentation/MsDiagramEdge;", "Lcom/intellij/diagram/DiagramEdgeBase;", "Lcom/intellij/microservices/diagrams/model/MsDiagramElement;", "source", "Lcom/intellij/microservices/diagrams/presentation/MsDiagramNode;", "target", "relationship", "Lcom/intellij/microservices/diagrams/MsDiagramRelationship;", "builder", "Lcom/intellij/diagram/DiagramBuilder;", "<init>", "(Lcom/intellij/microservices/diagrams/presentation/MsDiagramNode;Lcom/intellij/microservices/diagrams/presentation/MsDiagramNode;Lcom/intellij/microservices/diagrams/MsDiagramRelationship;Lcom/intellij/diagram/DiagramBuilder;)V", "requests", "", "Lcom/intellij/microservices/diagrams/model/MsDiagramRequest;", "getRequests", "()Ljava/util/List;", "getSource", "getTarget", "getRelationship", "getName", "", "getNavigationElements", "", "Lcom/intellij/psi/PsiElement;", "()[Lcom/intellij/psi/PsiElement;", "intellij.microservices.diagrams"})
public final class MsDiagramEdge
extends DiagramEdgeBase<MsDiagramElement> {
    @NotNull
    private final DiagramBuilder builder;
    @NotNull
    private final List<MsDiagramRequest> requests;

    public MsDiagramEdge(@NotNull MsDiagramNode source, @NotNull MsDiagramNode target, @NotNull MsDiagramRelationship relationship, @NotNull DiagramBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)relationship), (String)"relationship");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super((DiagramNode)source, (DiagramNode)target, (DiagramRelationshipInfo)relationship);
        this.builder = builder;
        this.requests = new ArrayList();
    }

    @NotNull
    public final List<MsDiagramRequest> getRequests() {
        return this.requests;
    }

    @NotNull
    public MsDiagramNode getSource() {
        DiagramNode diagramNode = super.getSource();
        Intrinsics.checkNotNull((Object)diagramNode, (String)"null cannot be cast to non-null type com.intellij.microservices.diagrams.presentation.MsDiagramNode");
        return (MsDiagramNode)diagramNode;
    }

    @NotNull
    public MsDiagramNode getTarget() {
        DiagramNode diagramNode = super.getTarget();
        Intrinsics.checkNotNull((Object)diagramNode, (String)"null cannot be cast to non-null type com.intellij.microservices.diagrams.presentation.MsDiagramNode");
        return (MsDiagramNode)diagramNode;
    }

    @NotNull
    public MsDiagramRelationship getRelationship() {
        DiagramRelationshipInfo diagramRelationshipInfo = super.getRelationship();
        Intrinsics.checkNotNull((Object)diagramRelationshipInfo, (String)"null cannot be cast to non-null type com.intellij.microservices.diagrams.MsDiagramRelationship");
        return (MsDiagramRelationship)diagramRelationshipInfo;
    }

    @NotNull
    public String getName() {
        return this.getRelationship().getLocalizedName();
    }

    @NotNull
    public PsiElement[] getNavigationElements() {
        MsDiagramShowUsagesManagerKt.scheduleFindAndShowEdgeRequests(this.builder, this);
        return new PsiElement[0];
    }
}

