/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller.ui.welcome;

import com.intellij.icons.AllIcons;
import com.intellij.llmInstaller.AIAssistantContentExtension;
import com.intellij.llmInstaller.LLMInstallerBundle;
import com.intellij.llmInstaller.common.LLMIcons;
import com.intellij.llmInstaller.common.branding.LLMInstallerAIAssistantBranding;
import com.intellij.llmInstaller.ui.welcome.BaseWelcomePanel;
import com.intellij.llmInstaller.ui.welcome.FeatureWelcomePanel;
import com.intellij.llmInstaller.ui.welcome.NavigationType;
import com.intellij.llmInstaller.ui.welcome.WelcomeFeatureSelectedAction;
import com.intellij.llmInstaller.ui.welcome.WelcomeFeaturesOrderedNavigationService;
import com.intellij.llmInstaller.ui.welcome.features.WelcomeFeatureDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.util.PropertyOperationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.InlineBanner;
import com.intellij.ui.WebAnimationUtils;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsYKt;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00122\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel;", "Lcom/intellij/llmInstaller/ui/welcome/BaseWelcomePanel;", "project", "Lcom/intellij/openapi/project/Project;", "featureDescriptor", "Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;", "index", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/llmInstaller/ui/welcome/features/WelcomeFeatureDescriptor;I)V", "createContent", "Ljavax/swing/JComponent;", "getDefaultComponent", "createDescription", "Lcom/intellij/ui/components/JBHtmlPane;", "llmInstallerIconsProvider", "Ljavax/swing/Icon;", "key", "", "createAnimation", "videoUrl", "isVideoVisible", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "createBrowser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "onVideoError", "Lkotlin/Function0;", "", "ScalableWrapper", "EditorPaneWrapper", "intellij.llmInstaller"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nFeatureWelcomePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureWelcomePanel.kt\ncom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,235:1\n23#2:236\n23#2:237\n*S KotlinDebug\n*F\n+ 1 FeatureWelcomePanel.kt\ncom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel\n*L\n126#1:236\n137#1:237\n*E\n"})
public final class FeatureWelcomePanel
extends BaseWelcomePanel {
    @NotNull
    private final WelcomeFeatureDescriptor featureDescriptor;
    private final int index;

    public FeatureWelcomePanel(@NotNull Project project, @NotNull WelcomeFeatureDescriptor featureDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)featureDescriptor, (String)"featureDescriptor");
        super(project);
        this.featureDescriptor = featureDescriptor;
        this.index = index;
    }

    @Override
    @NotNull
    protected JComponent createContent() {
        DialogPanel dialogPanel;
        DialogPanel $this$createContent_u24lambda_u241 = dialogPanel = BuilderKt.panel(arg_0 -> FeatureWelcomePanel.createContent$lambda$0(this, arg_0));
        boolean bl = false;
        $this$createContent_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)20, (int)20, (int)22, (int)20));
        return (JComponent)dialogPanel;
    }

    @Override
    @Nullable
    public JComponent getDefaultComponent() {
        return null;
    }

    private final JBHtmlPane createDescription() {
        JBHtmlPane jBHtmlPane;
        JBHtmlPaneStyleConfiguration styleConfiguration = new JBHtmlPaneStyleConfiguration();
        JBHtmlPaneConfiguration paneConfiguration2 = new JBHtmlPaneConfiguration(arg_0 -> FeatureWelcomePanel.createDescription$lambda$0(this, arg_0));
        JBHtmlPane $this$createDescription_u24lambda_u241 = jBHtmlPane = new JBHtmlPane(styleConfiguration, paneConfiguration2);
        boolean bl = false;
        $this$createDescription_u24lambda_u241.setOpaque(false);
        return jBHtmlPane;
    }

    private final Icon llmInstallerIconsProvider(String key) {
        Class<LLMIcons> iconClass = LLMIcons.class;
        String string = iconClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)key, (String)string, (boolean)false, (int)2, null)) {
            return null;
        }
        try {
            return IconLoader.findIcon((String)key, iconClass);
        }
        catch (Throwable t) {
            FeatureWelcomePanel $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FeatureWelcomePanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unable to find icon " + key, t);
            if (t instanceof NoSuchFieldException) {
                return AllIcons.Stub;
            }
            return null;
        }
    }

    private final JComponent createAnimation(String videoUrl, AtomicBooleanProperty isVideoVisible) {
        JBCefBrowser browser = this.createBrowser(videoUrl, (Function0<Unit>)((Function0)() -> FeatureWelcomePanel.createAnimation$lambda$0(this, videoUrl, isVideoVisible)));
        Component component2 = browser.getBrowserComponent();
        if (component2 != null) {
            component2.addMouseListener(new MouseAdapter(browser, this, videoUrl){
                final /* synthetic */ JBCefBrowser $browser;
                final /* synthetic */ FeatureWelcomePanel this$0;
                final /* synthetic */ String $videoUrl;
                {
                    this.$browser = $browser;
                    this.this$0 = $receiver;
                    this.$videoUrl = $videoUrl;
                }

                public void mouseClicked(MouseEvent e) {
                    this.$browser.getCefBrowser().executeJavaScript("pauseVideo()", this.$browser.getCefBrowser().getURL(), 0);
                    JBDimension largeSize = new JBDimension(800, 450);
                    DialogBuilder dialogBuilder = new DialogBuilder();
                    JComponent jComponent = FeatureWelcomePanel.createBrowser$default(this.this$0, this.$videoUrl, null, 2, null).getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                    DialogBuilder dialogBuilder2 = dialogBuilder.centerPanel((JComponent)new ScalableWrapper(jComponent, 1.7777777777777777, largeSize));
                    JBCefBrowser jBCefBrowser = this.$browser;
                    DialogBuilder $this$mouseClicked_u24lambda_u240 = dialogBuilder2;
                    boolean bl = false;
                    Function0 play = () -> createAnimation.1.mouseClicked$lambda$0$0(jBCefBrowser, $this$mouseClicked_u24lambda_u240);
                    $this$mouseClicked_u24lambda_u240.setOkOperation(() -> createAnimation.1.mouseClicked$lambda$0$1(play));
                    $this$mouseClicked_u24lambda_u240.setCancelOperation(() -> createAnimation.1.mouseClicked$lambda$0$2(play));
                    $this$mouseClicked_u24lambda_u240.removeAllActions();
                    $this$mouseClicked_u24lambda_u240.addCloseButton();
                    dialogBuilder2.show();
                }

                private static final Unit mouseClicked$lambda$0$0(JBCefBrowser $browser, DialogBuilder $this_apply) {
                    $browser.getCefBrowser().executeJavaScript("playVideo()", $browser.getCefBrowser().getURL(), 0);
                    $this_apply.getDialogWrapper().close(0);
                    return Unit.INSTANCE;
                }

                private static final void mouseClicked$lambda$0$1(Function0 $tmp0) {
                    $tmp0.invoke();
                }

                private static final void mouseClicked$lambda$0$2(Function0 $tmp0) {
                    $tmp0.invoke();
                }
            });
        }
        JComponent jComponent = browser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final JBCefBrowser createBrowser(String videoUrl, Function0<Unit> onVideoError) {
        String string;
        JBCefBrowser jBCefBrowser = JBCefBrowser.createBuilder().setMouseWheelEventEnable(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefBrowser, (String)"build(...)");
        JBCefBrowser browser = jBCefBrowser;
        Function0<Unit> function0 = onVideoError;
        if (function0 != null) {
            Function0<Unit> it = function0;
            boolean bl = false;
            JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)browser));
            Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
            JBCefJSQuery query = jBCefJSQuery;
            query.addHandler(arg_0 -> FeatureWelcomePanel.createBrowser$lambda$0$1(arg_0 -> FeatureWelcomePanel.createBrowser$lambda$0$0(onVideoError, arg_0), arg_0));
            string = query.inject(null);
        } else {
            string = null;
        }
        String onVideoErrorInjection = string;
        Color color = this.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
        String pageHtml = WebAnimationUtils.createVideoHtmlPageWithUrl$default((WebAnimationUtils)WebAnimationUtils.INSTANCE, (String)videoUrl, (Color)color, null, (boolean)false, (boolean)false, null, (String)onVideoErrorInjection, (int)60, null);
        browser.loadHTML(pageHtml);
        return browser;
    }

    static /* synthetic */ JBCefBrowser createBrowser$default(FeatureWelcomePanel featureWelcomePanel, String string, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        return featureWelcomePanel.createBrowser(string, (Function0<Unit>)function0);
    }

    private static final Unit createContent$lambda$0(FeatureWelcomePanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.customizeSpacingConfiguration((SpacingConfiguration)new EmptySpacingConfiguration(), arg_0 -> FeatureWelcomePanel.createContent$lambda$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$0(FeatureWelcomePanel this$0, Panel $this$customizeSpacingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$customizeSpacingConfiguration, (String)"$this$customizeSpacingConfiguration");
        AtomicBooleanProperty videoVisible = new AtomicBooleanProperty(true);
        JComponent animationComponent = this$0.createAnimation(this$0.featureDescriptor.getVideoUrl(), videoVisible);
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> FeatureWelcomePanel.createContent$lambda$0$0$0(animationComponent, arg_0), (int)1, null).visibleIf((ObservableProperty)videoVisible);
        this$0.title($this$customizeSpacingConfiguration, this$0.featureDescriptor.getTitle());
        String string = this$0.featureDescriptor.getDescription().getAsHtml();
        if (string != null) {
            String it = string;
            boolean bl = false;
            Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> FeatureWelcomePanel.createContent$lambda$0$0$1$0(this$0, it, arg_0), (int)1, null);
        }
        Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> FeatureWelcomePanel.createContent$lambda$0$0$2(this$0, arg_0), (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)24, (int)0, (int)2, null));
        if (CollectionsKt.firstOrNull((List)AIAssistantContentExtension.Companion.getEP_NAME().getExtensionList()) == null) {
            Panel.row$default((Panel)$this$customizeSpacingConfiguration, null, arg_0 -> FeatureWelcomePanel.createContent$lambda$0$0$3(this$0, arg_0), (int)1, null).customize(UnscaledGapsYKt.UnscaledGapsY$default((int)36, (int)0, (int)2, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$0$0(JComponent $animationComponent, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBDimension minSize = new JBDimension(50, 10);
        ScalableWrapper wrapper = new ScalableWrapper($animationComponent, 1.7777777777777777, minSize);
        $this$row.cell((JComponent)wrapper).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$0$1$0(FeatureWelcomePanel this$0, String $it, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        EditorPaneWrapper wrapper = new EditorPaneWrapper((JEditorPane)this$0.createDescription(), $it);
        $this$row.cell((JComponent)wrapper).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$0$2(FeatureWelcomePanel this$0, Row $this$row) {
        block1: {
            Pair<WelcomeFeatureDescriptor, Integer> pair;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            WelcomeFeaturesOrderedNavigationService navigationService = WelcomeFeaturesOrderedNavigationService.Companion.getInstance(this$0.getProject());
            Pair<WelcomeFeatureDescriptor, Integer> pair2 = navigationService.getPreviousFeature(this$0.index);
            if (pair2 != null) {
                pair = pair2;
                boolean bl = false;
                WelcomeFeatureDescriptor previousFeature = (WelcomeFeatureDescriptor)pair.component1();
                int previousFeatureIndex = ((Number)pair.component2()).intValue();
                $this$row.button(LLMInstallerBundle.INSTANCE.message("welcome.previous.feature.button", new Object[0]), arg_0 -> FeatureWelcomePanel.createContent$lambda$0$0$2$0$0(this$0, previousFeature, previousFeatureIndex, arg_0)).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)0, (int)0, (int)6, (int)7, null));
            }
            Pair<WelcomeFeatureDescriptor, Integer> pair3 = navigationService.getNextFeature(this$0.index);
            if (pair3 == null) break block1;
            pair = pair3;
            boolean bl = false;
            WelcomeFeatureDescriptor nextFeature = (WelcomeFeatureDescriptor)pair.component1();
            int nextFeatureIndex = ((Number)pair.component2()).intValue();
            Object[] objectArray = new Object[]{nextFeature.getTitle()};
            $this$row.button(LLMInstallerBundle.INSTANCE.message("welcome.next.feature.button", objectArray), arg_0 -> FeatureWelcomePanel.createContent$lambda$0$0$2$1$0(this$0, nextFeature, nextFeatureIndex, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$0$2$0$0(FeatureWelcomePanel this$0, WelcomeFeatureDescriptor $previousFeature, int $previousFeatureIndex, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            WelcomeFeatureSelectedAction welcomeFeatureSelectedAction = this$0.getOnFeatureSelected();
            if (welcomeFeatureSelectedAction == null) break block0;
            welcomeFeatureSelectedAction.onFeatureSelected($previousFeature, $previousFeatureIndex, this$0.getClass(), NavigationType.PREVIOUS);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$0$2$1$0(FeatureWelcomePanel this$0, WelcomeFeatureDescriptor $nextFeature, int $nextFeatureIndex, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            WelcomeFeatureSelectedAction welcomeFeatureSelectedAction = this$0.getOnFeatureSelected();
            if (welcomeFeatureSelectedAction == null) break block0;
            welcomeFeatureSelectedAction.onFeatureSelected($nextFeature, $nextFeatureIndex, this$0.getClass(), NavigationType.NEXT);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createContent$lambda$0$0$3(FeatureWelcomePanel this$0, Row $this$row) {
        void $this$createContent_u24lambda_u240_u240_u243_u241;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{LLMInstallerAIAssistantBranding.Name};
        Object[] objectArray2 = objectArray = new InlineBanner(LLMInstallerBundle.INSTANCE.message("welcome.install.plugin.banner.message", new Object[0]), null, 2, null).setIcon(null).addAction(LLMInstallerBundle.INSTANCE.message("welcome.install.plugin.banner.action", objectArray), () -> FeatureWelcomePanel.createContent$lambda$0$0$3$0(this$0));
        Row row = $this$row;
        boolean bl = false;
        $this$createContent_u24lambda_u240_u240_u243_u241.showCloseButton(false);
        row.cell((JComponent)objectArray).align((Align)AlignX.FILL.INSTANCE).customize(UnscaledGapsKt.UnscaledGaps$default((int)0, (int)12, (int)0, (int)12, (int)5, null)).visibleIf(ComponentPredicate.Companion.fromObservableProperty$default((ComponentPredicate.Companion)ComponentPredicate.Companion, (ObservableProperty)PropertyOperationUtil.transform((ObservableProperty)((ObservableProperty)this$0.getOnInstallPlugin()), FeatureWelcomePanel::createContent$lambda$0$0$3$2), null, (int)2, null));
        return Unit.INSTANCE;
    }

    private static final void createContent$lambda$0$0$3$0(FeatureWelcomePanel this$0) {
        block0: {
            Runnable runnable = (Runnable)this$0.getOnInstallPlugin().get();
            if (runnable == null) break block0;
            runnable.run();
        }
    }

    private static final boolean createContent$lambda$0$0$3$2(Runnable it) {
        return it != null;
    }

    private static final Unit createDescription$lambda$0(FeatureWelcomePanel this$0, JBHtmlPaneConfiguration.Builder $this$JBHtmlPaneConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$JBHtmlPaneConfiguration, (String)"$this$JBHtmlPaneConfiguration");
        $this$JBHtmlPaneConfiguration.customStyleSheet("pre {white-space: pre-wrap;} code, pre, a {overflow-wrap: anywhere;}");
        ExtendableHTMLViewFactory.Extension[] extensionArray = new ExtendableHTMLViewFactory.Extension[]{ExtendableHTMLViewFactory.Extensions.icons((Function1)((Function1)new Function1<String, Icon>((Object)this$0){

            public final Icon invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return FeatureWelcomePanel.access$llmInstallerIconsProvider((FeatureWelcomePanel)this.receiver, p0);
            }
        }))};
        $this$JBHtmlPaneConfiguration.extensions(extensionArray);
        return Unit.INSTANCE;
    }

    private static final Unit createAnimation$lambda$0(FeatureWelcomePanel this$0, String $videoUrl, AtomicBooleanProperty $isVideoVisible) {
        FeatureWelcomePanel $this$thisLogger$iv = this$0;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(FeatureWelcomePanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Unable to load video " + $videoUrl);
        $isVideoVisible.set(false);
        return Unit.INSTANCE;
    }

    private static final JBCefJSQuery.Response createBrowser$lambda$0$0(Function0 $onVideoError, String it) {
        $onVideoError.invoke();
        return null;
    }

    private static final JBCefJSQuery.Response createBrowser$lambda$0$1(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Icon access$llmInstallerIconsProvider(FeatureWelcomePanel $this, String key) {
        return $this.llmInstallerIconsProvider(key);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel$EditorPaneWrapper;", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JEditorPane;", "htmlText", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljavax/swing/JEditorPane;Ljava/lang/String;)V", "updateUI", "", "getPreferredSize", "Ljava/awt/Dimension;", "getMinimumSize", "intellij.llmInstaller"})
    private static final class EditorPaneWrapper
    extends JPanel {
        @NotNull
        private final JEditorPane component;
        @NotNull
        private final String htmlText;

        public EditorPaneWrapper(@NotNull JEditorPane component2, @NotNull String htmlText) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)htmlText, (String)"htmlText");
            super(new BorderLayout());
            this.component = component2;
            this.htmlText = htmlText;
            this.component.setText(this.htmlText);
            this.add((Component)this.component, "Center");
        }

        @Override
        public void updateUI() {
            block0: {
                super.updateUI();
                String string = this.htmlText;
                if (string == null) break block0;
                String it = string;
                boolean bl = false;
                this.component.setText(this.htmlText);
            }
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Container container = this.getParent();
            if (container == null) {
                return this.getMinimumSize();
            }
            Container parent = container;
            int n = parent.getWidth();
            Insets insets = parent.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            int availableWidth = n - UiSizeUtilKt.getWidth((Insets)insets);
            this.component.setSize(new Dimension(availableWidth, Short.MAX_VALUE));
            Dimension preferredSize = this.component.getPreferredSize();
            return new Dimension(this.getMinimumSize().width, preferredSize.height);
        }

        @Override
        @NotNull
        public Dimension getMinimumSize() {
            return (Dimension)new JBDimension(50, 10);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/llmInstaller/ui/welcome/FeatureWelcomePanel$ScalableWrapper;", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "proportion", "", "minSize", "Lcom/intellij/util/ui/JBDimension;", "<init>", "(Ljavax/swing/JComponent;DLcom/intellij/util/ui/JBDimension;)V", "getMinSize", "()Lcom/intellij/util/ui/JBDimension;", "getPreferredSize", "Ljava/awt/Dimension;", "getMinimumSize", "intellij.llmInstaller"})
    private static final class ScalableWrapper
    extends JPanel {
        private final double proportion;
        @NotNull
        private final JBDimension minSize;

        public ScalableWrapper(@NotNull JComponent component2, double proportion, @NotNull JBDimension minSize) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)minSize, (String)"minSize");
            super(new BorderLayout());
            this.proportion = proportion;
            this.minSize = minSize;
            this.add((Component)component2, "Center");
        }

        @NotNull
        public final JBDimension getMinSize() {
            return this.minSize;
        }

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            Container container = this.getParent();
            if (container == null) {
                return this.getMinimumSize();
            }
            Container parent = container;
            int n = parent.getWidth();
            Insets insets = parent.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
            double height = (double)(n - UiSizeUtilKt.getWidth((Insets)insets)) / this.proportion;
            return new Dimension(this.getMinimumSize().width, (int)height);
        }

        @Override
        @NotNull
        public Dimension getMinimumSize() {
            return (Dimension)this.minSize;
        }
    }
}

