/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.transformer;

import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.DiagnosableProposalTransformer;
import com.intellij.util.text.EditDistance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/TrimSimilarLinesTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/DiagnosableProposalTransformer;", "<init>", "()V", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "blankLinesAndFirstNonBlank", "", "getOrder", "", "Companion", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\nProposalTransformers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProposalTransformers.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/transformer/TrimSimilarLinesTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,580:1\n1563#2:581\n1634#2,2:582\n1636#2:590\n774#2:591\n865#2,2:592\n434#3:584\n507#3,5:585\n*S KotlinDebug\n*F\n+ 1 ProposalTransformers.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/transformer/TrimSimilarLinesTransformer\n*L\n321#1:581\n321#1:582,2\n321#1:590\n322#1:591\n322#1:592,2\n321#1:584\n321#1:585,5\n*E\n"})
public final class TrimSimilarLinesTransformer
extends DiagnosableProposalTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double THRESHOLD = 0.3;
    private static final int USE_LINES = 5;

    public TrimSimilarLinesTransformer() {
        super("Trim similar lines");
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal) {
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        return (RawMLCompletionProposal)this.diagnoseMapping((MLCompletionProposal)proposal, () -> TrimSimilarLinesTransformer.transformRaw$lambda$0(proposal, this));
    }

    private final String blankLinesAndFirstNonBlank(String $this$blankLinesAndFirstNonBlank) {
        StringBuilder result2 = new StringBuilder();
        Iterator iterator = StringsKt.lineSequence((CharSequence)$this$blankLinesAndFirstNonBlank).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String line = (String)iterator.next();
            if (index != 0) {
                result2.append('\n');
            }
            result2.append(line);
            if (!(!StringsKt.isBlank((CharSequence)line))) continue;
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int getOrder() {
        return 200;
    }

    /*
     * WARNING - void declaration
     */
    private static final RawMLCompletionProposal transformRaw$lambda$0(RawMLCompletionProposal $proposal, TrimSimilarLinesTransformer this$0) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.lines((CharSequence)$proposal.getSuggestion());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv2;
            void line;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void $this$filter$iv = line;
            boolean $i$f$filter = false;
            CharSequence charSequence = (CharSequence)$this$filter$iv;
            Appendable destination$iv$iv2 = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv2.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv2.charAt(index$iv$iv);
                boolean bl2 = false;
                if (!Character.isLetterOrDigit(it)) continue;
                destination$iv$iv2.append(element$iv$iv);
            }
            collection.add(((StringBuilder)destination$iv$iv2).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)it);
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lines = (List)destination$iv$iv;
        int[] connected = new int[lines.size()];
        int n = lines.size();
        for (int i = RangesKt.coerceAtLeast((int)(lines.size() - 5), (int)0); i < n; ++i) {
            int n2 = lines.size();
            for (int j = i + 1; j < n2; ++j) {
                int limit = (int)((double)(((String)lines.get(i)).length() + ((String)lines.get(j)).length()) / 2.0 * 0.3);
                if (EditDistance.optimalAlignment((CharSequence)((CharSequence)lines.get(i)), (CharSequence)((CharSequence)lines.get(j)), (boolean)true, (int)(limit + 1)) > limit) continue;
                int n3 = j;
                int n4 = connected[n3];
                connected[n3] = n4 + 1;
                if (connected[i] < 1) continue;
                return $proposal.withSuggestion(this$0.blankLinesAndFirstNonBlank($proposal.getSuggestion()));
            }
        }
        return $proposal;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/TrimSimilarLinesTransformer$Companion;", "", "<init>", "()V", "THRESHOLD", "", "USE_LINES", "", "intellij.fullLine.core.completion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

