/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.cloud.inline.debounce;

import com.intellij.ml.llm.completion.cloud.inline.debounce.CloudInlineCompletionFinishedCompletionsStorage;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudCompletionAdaptiveDebounceCalculator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "expectedDebounce", "Lkotlin/time/Duration;", "base", "expectedDebounce-wmV0flA", "(J)J", "decayFactor", "", "timeSinceCompletion", "", "resultWeight", "result", "Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$Result;", "calculateMultiplier", "completions", "", "Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$FinishedCompletion;", "now", "Companion", "intellij.ml.llm.completion"})
@SourceDebugExtension(value={"SMAP\nCloudCompletionAdaptiveDebounceCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudCompletionAdaptiveDebounceCalculator.kt\ncom/intellij/ml/llm/completion/cloud/inline/debounce/CloudCompletionAdaptiveDebounceCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1803#2,3:66\n*S KotlinDebug\n*F\n+ 1 CloudCompletionAdaptiveDebounceCalculator.kt\ncom/intellij/ml/llm/completion/cloud/inline/debounce/CloudCompletionAdaptiveDebounceCalculator\n*L\n51#1:66,3\n*E\n"})
public final class CloudCompletionAdaptiveDebounceCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public CloudCompletionAdaptiveDebounceCalculator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final long expectedDebounce-wmV0flA(long l) {
        List<CloudInlineCompletionFinishedCompletionsStorage.FinishedCompletion> completions = CloudInlineCompletionFinishedCompletionsStorage.Companion.getInstance(this.project).getRecentCompletions();
        long now = System.currentTimeMillis();
        double multiplier = this.calculateMultiplier(completions, now);
        long baseMs = Duration.getInWholeMilliseconds-impl((long)l);
        double resultMs = (double)baseMs * multiplier;
        resultMs = RangesKt.coerceIn((double)resultMs, (double)20.0, (double)3000.0);
        return DurationKt.toDuration((long)((long)resultMs), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    private final double decayFactor(long timeSinceCompletion) {
        return Math.exp(-((double)timeSinceCompletion) / (double)600000L);
    }

    private final double resultWeight(CloudInlineCompletionFinishedCompletionsStorage.Result result2) {
        return switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1 -> 0.8;
            case 2 -> 2.2;
            case 3 -> 1.0;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    public final double calculateMultiplier(@NotNull List<CloudInlineCompletionFinishedCompletionsStorage.FinishedCompletion> completions, long now) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(completions, (String)"completions");
        Iterable iterable = completions;
        double initial$iv = 1.0;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            double d;
            void completion2;
            CloudInlineCompletionFinishedCompletionsStorage.FinishedCompletion finishedCompletion = (CloudInlineCompletionFinishedCompletionsStorage.FinishedCompletion)element$iv;
            double acc = accumulator$iv;
            boolean bl = false;
            long timeSinceCompletion = now - completion2.getFinishTime();
            if (timeSinceCompletion > 600000L) {
                d = acc;
            } else {
                double decay = this.decayFactor(timeSinceCompletion);
                double weight = this.resultWeight(completion2.getResult());
                d = acc * (1.0 + (weight - 1.0) * decay);
            }
            accumulator$iv = d;
        }
        return accumulator$iv;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudCompletionAdaptiveDebounceCalculator$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudCompletionAdaptiveDebounceCalculator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.completion"})
    @SourceDebugExtension(value={"SMAP\nCloudCompletionAdaptiveDebounceCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudCompletionAdaptiveDebounceCalculator.kt\ncom/intellij/ml/llm/completion/cloud/inline/debounce/CloudCompletionAdaptiveDebounceCalculator$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n30#2,2:66\n*S KotlinDebug\n*F\n+ 1 CloudCompletionAdaptiveDebounceCalculator.kt\ncom/intellij/ml/llm/completion/cloud/inline/debounce/CloudCompletionAdaptiveDebounceCalculator$Companion\n*L\n63#1:66,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CloudCompletionAdaptiveDebounceCalculator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<CloudCompletionAdaptiveDebounceCalculator> serviceClass$iv = CloudCompletionAdaptiveDebounceCalculator.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CloudCompletionAdaptiveDebounceCalculator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CloudInlineCompletionFinishedCompletionsStorage.Result.values().length];
            try {
                nArray[CloudInlineCompletionFinishedCompletionsStorage.Result.ACCEPTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudInlineCompletionFinishedCompletionsStorage.Result.REJECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloudInlineCompletionFinishedCompletionsStorage.Result.OTHER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

