/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rbs.completion.kit;

import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultilineSupporter;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.ruby.rbs.common.psi.RbsPsiFile;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclaration;
import com.intellij.ruby.rbs.common.psi.api.RbsContainerDeclarationElement;
import com.intellij.ruby.rbs.common.psi.api.RbsMethodMember;
import com.intellij.ruby.rbs.common.psi.api.RbsModuleTypeParams;
import com.intellij.ruby.rbs.common.psi.api.RbsProcType;
import com.intellij.ruby.rbs.common.psi.tree.RbsElementTypesGenerated;
import com.intellij.util.DocumentUtil;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/rbs/completion/kit/RbsMultilineSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultilineSupporter;", "<init>", "()V", "parentClasses", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "[Ljava/lang/Class;", "isMultilineSuitable", "", "element", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "findParent", "intellij.ml.llm.rbs.completion"})
public final class RbsMultilineSupporter
implements MLCompletionMultilineSupporter {
    @NotNull
    private final Class<? extends PsiElement>[] parentClasses;

    public RbsMultilineSupporter() {
        Class[] classArray = new Class[]{RbsContainerDeclarationElement.class, RbsMethodMember.class, RbsModuleTypeParams.class, RbsProcType.class, RbsPsiFile.class};
        this.parentClasses = classArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMultilineSuitable(@NotNull PsiElement element, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (!DocumentUtil.isAtLineEnd((int)offset, (Document)document)) {
            return false;
        }
        PsiElement psiElement = this.findParent(element);
        if (psiElement == null) {
            return false;
        }
        PsiElement parent = psiElement;
        PsiElement psiElement2 = parent;
        if (psiElement2 instanceof RbsContainerDeclaration) return true;
        if (psiElement2 instanceof RbsPsiFile) {
            return true;
        }
        if (psiElement2 instanceof RbsMethodMember) {
            if (((RbsMethodMember)parent).getMethodTypeList().isEmpty()) return true;
            List list = ((RbsMethodMember)parent).getMethodTypeList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMethodTypeList(...)");
            Object object = CollectionsKt.last((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            if (PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)object)) > offset) return false;
            return true;
        }
        if (psiElement2 instanceof RbsModuleTypeParams) {
            if (((RbsModuleTypeParams)parent).getModuleTypeParamList().isEmpty()) return true;
            List list = ((RbsModuleTypeParams)parent).getModuleTypeParamList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getModuleTypeParamList(...)");
            Object object = CollectionsKt.last((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
            if (PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)object)) > offset) return false;
            return true;
        }
        if (!(psiElement2 instanceof RbsProcType)) return false;
        if (((RbsProcType)parent).getParamList().isEmpty()) return true;
        List list = ((RbsProcType)parent).getParamList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParamList(...)");
        Object object = CollectionsKt.last((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
        if (PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)object)) > offset) return false;
        return true;
    }

    private final PsiElement findParent(PsiElement element) {
        PsiElement psiElement;
        if (element instanceof PsiWhiteSpace) {
            psiElement = PsiTreeUtil.prevVisibleLeaf((PsiElement)element);
            if (psiElement == null) {
                psiElement = element;
            }
        } else {
            psiElement = element;
        }
        PsiElement previous = psiElement;
        PsiElement next = PsiTreeUtil.nextVisibleLeaf((PsiElement)previous);
        Class<? extends PsiElement>[] classArray = this.parentClasses;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)previous, (boolean)true, (Class[])Arrays.copyOf(classArray, classArray.length));
        if (parent instanceof RbsProcType && next != null && !Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)next), (Object)RbsElementTypesGenerated.RBS_KRPAREN)) {
            return this.findParent(parent);
        }
        return parent;
    }
}

