/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal.completion.validation;

import com.intellij.ml.llm.terminal.completion.ParsedCommand;
import com.intellij.ml.llm.terminal.completion.validation.RiskCategory;
import com.intellij.ml.llm.terminal.completion.validation.Validator;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/terminal/completion/validation/SystemCorruptionValidator;", "Lcom/intellij/ml/llm/terminal/completion/validation/Validator;", "<init>", "()V", "validate", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/terminal/completion/validation/RiskCategory;", "", "command", "Lcom/intellij/ml/llm/terminal/completion/ParsedCommand;", "intellij.ml.llm.terminal.completion"})
@SourceDebugExtension(value={"SMAP\nSystemCorruptionValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemCorruptionValidator.kt\ncom/intellij/ml/llm/terminal/completion/validation/SystemCorruptionValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1761#2,3:39\n1761#2,3:42\n1761#2,3:45\n*S KotlinDebug\n*F\n+ 1 SystemCorruptionValidator.kt\ncom/intellij/ml/llm/terminal/completion/validation/SystemCorruptionValidator\n*L\n20#1:39,3\n22#1:42,3\n29#1:45,3\n*E\n"})
public final class SystemCorruptionValidator
implements Validator {
    @Override
    @Nullable
    public Pair<RiskCategory, String> validate(@NotNull ParsedCommand command) {
        boolean bl;
        block23: {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Object[] objectArray = new String[]{"fdisk", "gdisk", "parted", "wipefs"};
            if (SetsKt.setOf((Object[])objectArray).contains(command.getBaseCommand())) {
                return TuplesKt.to((Object)((Object)RiskCategory.SYSTEM_CORRUPTION), (Object)(command + ".baseCommand can destroy filesystems"));
            }
            if (StringsKt.startsWith$default((String)command.getBaseCommand(), (String)"mkfs", (boolean)false, (int)2, null)) {
                return TuplesKt.to((Object)((Object)RiskCategory.SYSTEM_CORRUPTION), (Object)(command + ".baseCommand can destroy filesystems"));
            }
            if (Intrinsics.areEqual((Object)command.getBaseCommand(), (Object)"dd")) {
                boolean bl2;
                String it;
                boolean $i$f$any;
                Iterable $this$any$iv;
                block21: {
                    boolean bl3;
                    block20: {
                        $this$any$iv = command.getArgs();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl4 = false;
                                if (!(StringsKt.startsWith$default((String)it, (String)"of=/dev/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (CharSequence)"/dev/null", (boolean)false, (int)2, null))) continue;
                                bl3 = true;
                                break block20;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        return TuplesKt.to((Object)((Object)RiskCategory.SYSTEM_CORRUPTION), (Object)"dd writing directly to block device");
                    }
                    $this$any$iv = command.getArgs();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl5 = false;
                            if (!StringsKt.startsWith$default((String)it, (String)"count=", (boolean)false, (int)2, null)) continue;
                            bl2 = true;
                            break block21;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) {
                    boolean bl6;
                    block22: {
                        $this$any$iv = command.getArgs();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl6 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl7 = false;
                                if (!(StringsKt.contains$default((CharSequence)it, (CharSequence)"/dev/zero", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"/dev/random", (boolean)false, (int)2, null))) continue;
                                bl6 = true;
                                break block22;
                            }
                            bl6 = false;
                        }
                    }
                    if (bl6) {
                        return TuplesKt.to((Object)((Object)RiskCategory.RESOURCE_EXHAUSTION), (Object)"dd without size limit can fill disk");
                    }
                }
            }
            Object[] $i$f$any = new String[]{"fstab", "sudoers", "grub.cfg", "grub.conf"};
            List criticalConfigs = CollectionsKt.listOf((Object[])$i$f$any);
            Iterable $this$any$iv = criticalConfigs;
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl8 = false;
                    if (!StringsKt.contains$default((CharSequence)command.getFullCommand(), (CharSequence)("/etc/" + it), (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        if (bl) {
            boolean isModifying;
            Object[] objectArray;
            boolean bl9 = StringsKt.contains$default((CharSequence)command.getFullCommand(), (CharSequence)">", (boolean)false, (int)2, null) || SetsKt.setOf((Object[])(objectArray = new String[]{"sed", "awk", "tee"})).contains(command.getBaseCommand()) ? true : (isModifying = false);
            if (isModifying) {
                return TuplesKt.to((Object)((Object)RiskCategory.SYSTEM_CORRUPTION), (Object)"modifying critical system configuration");
            }
        }
        return null;
    }
}

