/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.KaConstantValueForAnnotation;
import org.jetbrains.kotlin.analysis.api.KaInitializerValue;
import org.jetbrains.kotlin.analysis.api.KaNonConstantInitializerValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.KaSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u0005H\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a0\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000e0\u0015H\u0000\u00a8\u0006\u0017"}, d2={"unwrap", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "computeImportableName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "asKaInitializerValue", "Lorg/jetbrains/kotlin/analysis/api/KaInitializerValue;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "builder", "Lorg/jetbrains/kotlin/analysis/api/fir/KaSymbolByFirBuilder;", "forAnnotationDefaultValue", "", "processEqualsFunctions", "", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nfirUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 firUtils.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/FirUtilsKt\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,121:1\n53#2:122\n28#2:123\n28#2:124\n57#3:125\n*S KotlinDebug\n*F\n+ 1 firUtils.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/FirUtilsKt\n*L\n72#1:122\n75#1:123\n76#1:124\n106#1:125\n*E\n"})
public final class FirUtilsKt {
    @NotNull
    public static final PsiElement unwrap(@NotNull PsiElement $this$unwrap) {
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        return $this$unwrap instanceof KtExpression ? (PsiElement)FirUtilsKt.unwrap((KtExpression)$this$unwrap) : $this$unwrap;
    }

    @NotNull
    public static final KtExpression unwrap(@NotNull KtExpression $this$unwrap) {
        KtExpression ktExpression;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$unwrap, (String)"<this>");
        KtExpression ktExpression2 = $this$unwrap;
        if (ktExpression2 instanceof KtLabeledExpression) {
            KtExpression ktExpression3 = ((KtLabeledExpression)$this$unwrap).getBaseExpression();
            object = ktExpression3 != null ? FirUtilsKt.unwrap(ktExpression3) : null;
        } else if (ktExpression2 instanceof KtAnnotatedExpression) {
            KtExpression ktExpression4 = ((KtAnnotatedExpression)$this$unwrap).getBaseExpression();
            object = ktExpression4 != null ? FirUtilsKt.unwrap(ktExpression4) : null;
        } else if (ktExpression2 instanceof KtFunctionLiteral) {
            PsiElement psiElement = ((KtFunctionLiteral)$this$unwrap).getParent();
            KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
            object = ktLambdaExpression != null ? FirUtilsKt.unwrap((KtExpression)ktLambdaExpression) : null;
        } else {
            object = ktExpression = $this$unwrap;
        }
        if (object == null) {
            ktExpression = $this$unwrap;
        }
        return ktExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final FqName computeImportableName(@NotNull FirCallableSymbol<?> $this$computeImportableName) {
        CallableId callableId;
        block10: {
            FirClassLikeSymbol<?> containingClass;
            block11: {
                boolean $i$f$isStatic;
                FirCallableSymbol<?> $this$isStatic$iv;
                block9: {
                    Intrinsics.checkNotNullParameter($this$computeImportableName, (String)"<this>");
                    CallableId callableId2 = $this$computeImportableName.getCallableId();
                    if (callableId2 == null) {
                        return null;
                    }
                    callableId = callableId2;
                    if (callableId.isLocal()) {
                        return null;
                    }
                    if ($this$computeImportableName.getOrigin() instanceof FirDeclarationOrigin.SamConstructor) {
                        return callableId.asSingleFqName();
                    }
                    ClassId classId = callableId.getClassId();
                    if (classId == null) {
                        return callableId.asSingleFqName();
                    }
                    ClassId containingClassId = classId;
                    FirClassLikeSymbol<?> firClassLikeSymbol = ContainingClassUtilsKt.getContainingClassSymbol((FirBasedSymbol)$this$computeImportableName);
                    if (firClassLikeSymbol == null) {
                        return null;
                    }
                    containingClass = firClassLikeSymbol;
                    if ($this$computeImportableName instanceof FirConstructorSymbol) {
                        FirClassLikeSymbol<?> $this$isInner$iv = containingClass;
                        boolean $i$f$isInner = false;
                        if ($this$isInner$iv.getRawStatus().isInner()) return null;
                        FqName fqName2 = containingClassId.asSingleFqName();
                        return fqName2;
                    }
                    if (!(containingClass.getOrigin() instanceof FirDeclarationOrigin.Java)) break block9;
                    $this$isStatic$iv = $this$computeImportableName;
                    $i$f$isStatic = false;
                    if ($this$isStatic$iv.getRawStatus().isStatic()) break block10;
                }
                if (FirHelpersKt.getClassKind(containingClass) != ClassKind.ENUM_CLASS) break block11;
                $this$isStatic$iv = $this$computeImportableName;
                $i$f$isStatic = false;
                if ($this$isStatic$iv.getRawStatus().isStatic()) break block10;
            }
            if (FirHelpersKt.getClassKind(containingClass) != ClassKind.OBJECT) return null;
        }
        boolean bl = true;
        boolean canBeImported = bl;
        if (!canBeImported) return null;
        FqName fqName3 = callableId.asSingleFqName();
        return fqName3;
    }

    @NotNull
    public static final KaInitializerValue asKaInitializerValue(@NotNull FirExpression $this$asKaInitializerValue, @NotNull KaSymbolByFirBuilder builder2, boolean forAnnotationDefaultValue) {
        KaAnnotationValue annotationConstantValue;
        Intrinsics.checkNotNullParameter((Object)$this$asKaInitializerValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        PsiElement psiElement = UtilsKt.getPsi($this$asKaInitializerValue);
        KtExpression ktExpression = psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
        KaConstantValue evaluated = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue($this$asKaInitializerValue, builder2.getRootSession());
        KaInitializerValue kaInitializerValue = evaluated == null ? (forAnnotationDefaultValue ? ((annotationConstantValue = FirAnnotationValueConverter.INSTANCE.toConstantValue($this$asKaInitializerValue, builder2)) != null ? (KaInitializerValue)new KaConstantValueForAnnotation(annotationConstantValue, ktExpression) : (KaInitializerValue)new KaNonConstantInitializerValue(ktExpression)) : (KaInitializerValue)new KaNonConstantInitializerValue(ktExpression)) : (KaInitializerValue)new KaConstantInitializerValue(evaluated, ktExpression);
        return kaInitializerValue;
    }

    public static final void processEqualsFunctions(@NotNull FirEqualityOperatorCall $this$processEqualsFunctions, @NotNull FirSession session2, @NotNull KaFirSession analysisSession, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)$this$processEqualsFunctions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        FirCall $this$arguments$iv = $this$processEqualsFunctions;
        boolean $i$f$getArguments = false;
        FirExpression firExpression = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        if (firExpression == null) {
            return;
        }
        FirExpression lhs = firExpression;
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(FirTypeUtilsKt.getResolvedType(lhs), session2, analysisSession.getScopeSessionFor(analysisSession.getFirSession$analysis_api_fir()), CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS);
        if (firTypeScope == null) {
            return;
        }
        FirTypeScope scope = firTypeScope;
        scope.processFunctionsByName(OperatorNameConventions.EQUALS, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirUtilsKt.processEqualsFunctions$lambda$0(processor2, arg_0)));
    }

    private static final Unit processEqualsFunctions$lambda$0(Function1 $processor, FirNamedFunctionSymbol functionSymbol) {
        Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
        FirValueParameterSymbol parameterSymbol = (FirValueParameterSymbol)CollectionsKt.singleOrNull(functionSymbol.getValueParameterSymbols());
        if (parameterSymbol != null && ConeBuiltinTypeUtilsKt.isNullableAny(parameterSymbol.getResolvedReturnType())) {
            $processor.invoke((Object)functionSymbol);
        }
        return Unit.INSTANCE;
    }
}

