/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.mpp.ActualTypealiasToSpecialAnnotationUtils;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ)\u0010\u000e\u001a\u00020\u0007*\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0002J5\u0010\u0014\u001a\u00020\u0007*\u00020\u00022\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0017J1\u0010\u0018\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001bJ1\u0010\u001c\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypeAliasChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)V", "checkDefaultArgumentsInExpectWithActualTypeAlias", "getMembersWithDefaultValueParametersUnlessAnnotation", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "checkTypeAliasToClassWithDeclarationSiteVariance", "expandedTypeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)V", "checkTypeAliasWithUseSiteVariance", "expandedType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;)V", "checkTypeAliasWithComplexSubstitution", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirActualTypeAliasChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirActualTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypeAliasChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n34#2:171\n1#3:172\n1#3:189\n873#4:173\n1807#4,3:174\n874#4:177\n1642#4,10:178\n1915#4:188\n1916#4:190\n1652#4:191\n*S KotlinDebug\n*F\n+ 1 FirActualTypeAliasChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirActualTypeAliasChecker\n*L\n38#1:171\n111#1:189\n108#1:173\n108#1:174,3\n108#1:177\n111#1:178,10\n111#1:188\n111#1:190\n111#1:191\n*E\n"})
public final class FirActualTypeAliasChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirActualTypeAliasChecker INSTANCE = new FirActualTypeAliasChecker();

    private FirActualTypeAliasChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirTypeAlias declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirMemberDeclaration $this$isActual$iv = declaration;
        boolean $i$f$isActual = false;
        if (!$this$isActual$iv.getStatus().isActual()) {
            return;
        }
        this.checkDefaultArgumentsInExpectWithActualTypeAlias(context2, reporter, declaration);
        ConeKotlinType coneKotlinType = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(declaration.getExpandedTypeRef()));
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType expandedType2 = coneClassLikeType;
        FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol((SessionHolder)context2, expandedType2);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> expandedTypeSymbol = firClassLikeSymbol;
        if (expandedTypeSymbol instanceof FirTypeAliasSymbol) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_NOT_TO_CLASS(), null, (int)8, null);
        }
        this.checkTypeAliasToClassWithDeclarationSiteVariance(context2, reporter, declaration, expandedTypeSymbol);
        this.checkTypeAliasWithUseSiteVariance(context2, reporter, declaration, expandedType2);
        this.checkTypeAliasWithComplexSubstitution(context2, reporter, declaration, expandedType2);
        if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.MultiplatformRestrictions)) {
            ClassId classId;
            if (ConeBuiltinTypeUtilsKt.isNothing(expandedType2)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_NOTHING(), null, (int)8, null);
            }
            if (expandedType2.isMarkedNullable()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_NULLABLE_TYPE(), null, (int)8, null);
            }
            if (FirHelpersKt.getClassKind(expandedTypeSymbol) == ClassKind.ANNOTATION_CLASS && ActualTypealiasToSpecialAnnotationUtils.INSTANCE.isAnnotationProhibitedInActualTypeAlias(classId = expandedTypeSymbol.getClassId())) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), FirErrors.INSTANCE.getACTUAL_TYPEALIAS_TO_SPECIAL_ANNOTATION(), (Object)classId, null, (int)16, null);
            }
        }
    }

    private final void checkDefaultArgumentsInExpectWithActualTypeAlias(CheckerContext context2, DiagnosticReporter reporter, FirTypeAlias $this$checkDefaultArgumentsInExpectWithActualTypeAlias) {
        LanguageVersionSettings it = context2.getLanguageVersionSettings();
        boolean bl = false;
        boolean bl2 = !it.supportsFeature(LanguageFeature.MultiplatformRestrictions) || !it.supportsFeature(LanguageFeature.MultiplatformRestrictions);
        if (bl2) {
            return;
        }
        FirTypeAliasSymbol actualTypealiasSymbol = $this$checkDefaultArgumentsInExpectWithActualTypeAlias.getSymbol();
        FirBasedSymbol<?> firBasedSymbol = ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull(actualTypealiasSymbol);
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> expectedSingleCandidate = firBasedSymbol;
        FirRegularClassSymbol expectClassSymbol = (FirRegularClassSymbol)expectedSingleCandidate;
        List<FirFunctionSymbol<?>> membersWithDefaultValueParameters = this.getMembersWithDefaultValueParametersUnlessAnnotation(expectClassSymbol);
        if (membersWithDefaultValueParameters.isEmpty()) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkDefaultArgumentsInExpectWithActualTypeAlias.getSource()), FirErrors.INSTANCE.getDEFAULT_ARGUMENTS_IN_EXPECT_WITH_ACTUAL_TYPEALIAS(), (Object)expectClassSymbol, membersWithDefaultValueParameters, null, (int)32, null);
    }

    private final List<FirFunctionSymbol<?>> getMembersWithDefaultValueParametersUnlessAnnotation(FirClassSymbol<?> classSymbol) {
        List result2 = new ArrayList();
        FirActualTypeAliasChecker.getMembersWithDefaultValueParametersUnlessAnnotation$collectFunctions(result2, classSymbol);
        return result2;
    }

    private final void checkTypeAliasToClassWithDeclarationSiteVariance(CheckerContext context2, DiagnosticReporter reporter, FirTypeAlias $this$checkTypeAliasToClassWithDeclarationSiteVariance, FirClassLikeSymbol<?> expandedTypeSymbol) {
        for (FirTypeParameterSymbol typeParameterSymbol : expandedTypeSymbol.getTypeParameterSymbols()) {
            if (typeParameterSymbol.getVariance() == Variance.INVARIANT) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkTypeAliasToClassWithDeclarationSiteVariance.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE(), null, (int)8, null);
            break;
        }
    }

    private final void checkTypeAliasWithUseSiteVariance(CheckerContext context2, DiagnosticReporter reporter, FirTypeAlias $this$checkTypeAliasWithUseSiteVariance, ConeClassLikeType expandedType2) {
        for (ConeTypeProjection typeArgument : expandedType2.getTypeArguments()) {
            if (typeArgument.getKind() == ProjectionKind.INVARIANT) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkTypeAliasWithUseSiteVariance.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE(), null, (int)8, null);
            break;
        }
    }

    private final void checkTypeAliasWithComplexSubstitution(CheckerContext context2, DiagnosticReporter reporter, FirTypeAlias $this$checkTypeAliasWithComplexSubstitution, ConeClassLikeType expandedType2) {
        boolean reportActualTypeAliasWithComplexSubstitution = false;
        if ($this$checkTypeAliasWithComplexSubstitution.getTypeParameters().size() != expandedType2.getTypeArguments().length) {
            reportActualTypeAliasWithComplexSubstitution = true;
        } else {
            int n = $this$checkTypeAliasWithComplexSubstitution.getTypeParameters().size();
            for (int i2 = 0; i2 < n; ++i2) {
                ConeTypeProjection typeArgument = expandedType2.getTypeArguments()[i2];
                if (typeArgument instanceof ConeTypeParameterType) {
                    if (Intrinsics.areEqual((Object)$this$checkTypeAliasWithComplexSubstitution.getTypeParameters().get(i2).getSymbol(), (Object)((ConeTypeParameterType)typeArgument).getLookupTag().getTypeParameterSymbol())) continue;
                    reportActualTypeAliasWithComplexSubstitution = true;
                    break;
                }
                if (!(typeArgument instanceof ConeKotlinType) || !(!(((ConeKotlinType)typeArgument).getTypeArguments().length == 0))) continue;
                reportActualTypeAliasWithComplexSubstitution = true;
                break;
            }
        }
        if (reportActualTypeAliasWithComplexSubstitution) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$checkTypeAliasWithComplexSubstitution.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION(), null, (int)8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void getMembersWithDefaultValueParametersUnlessAnnotation$collectFunctions(List<FirFunctionSymbol<?>> result2, FirClassSymbol<?> classSymbol) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv;
        FirContainingNamesAwareScope memberScope2;
        if (classSymbol.getClassKind() == ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirContainingNamesAwareScope $this$getMembersWithDefaultValueParametersUnlessAnnotation_u24collectFunctions_u24lambda_u240 = memberScope2 = FirDeclaredMemberScopeProviderKt.declaredMemberScope(classSymbol, classSymbol.getModuleData().getSession(), null);
        boolean bl = false;
        List functionsAndConstructors = CollectionsKt.plus(FirContainingNamesAwareScopeKt.collectAllFunctions($this$getMembersWithDefaultValueParametersUnlessAnnotation_u24collectFunctions_u24lambda_u240), (Iterable)FirScopeKt.getDeclaredConstructors($this$getMembersWithDefaultValueParametersUnlessAnnotation_u24collectFunctions_u24lambda_u240));
        Iterable iterable = functionsAndConstructors;
        Iterable destination$iv = result2;
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            boolean bl2;
            block7: {
                FirFunctionSymbol it = (FirFunctionSymbol)element$iv;
                boolean bl3 = false;
                Iterable $this$any$iv = it.getValueParameterSymbols();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        FirValueParameterSymbol p0 = (FirValueParameterSymbol)element$iv2;
                        boolean bl4 = false;
                        if (!p0.getHasDefaultValue()) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            destination$iv.add(element$iv);
        }
        destination$iv = memberScope2.getClassifierNames();
        boolean $i$f$mapNotNull = false;
        Iterator iterator2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            FirClassSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl5 = false;
            Name it = (Name)element$iv$iv;
            boolean bl6 = false;
            FirClassifierSymbol<?> firClassifierSymbol = FirScopeKt.getSingleClassifier(memberScope2, it);
            if ((firClassifierSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassifierSymbol : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nestedClasses = (List)destination$iv$iv;
        for (FirClassSymbol nestedClassSymbol : nestedClasses) {
            FirActualTypeAliasChecker.getMembersWithDefaultValueParametersUnlessAnnotation$collectFunctions(result2, nestedClassSymbol);
        }
    }
}

