/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.highlighting;

import com.intellij.codeInsight.daemon.SyntheticPsiFileSupport;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.idea.base.highlighting.KotlinScriptHighlightingExtension;
import org.jetbrains.kotlin.idea.base.projectStructure.ApiKt;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.util.KotlinPlatformUtils;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0002H\u0002\u00a8\u0006\n"}, d2={"shouldHighlightErrors", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "shouldHighlightFile", "isIndexingInProgress", "project", "Lcom/intellij/openapi/project/Project;", "shouldDefinitelyHighlight", "calculateShouldHighlightFile", "calculateShouldHighlightScript", "kotlin.highlighting.shared"})
@JvmName(name="KotlinHighlightingUtils")
public final class KotlinHighlightingUtils {
    @ApiStatus.Internal
    public static final boolean shouldHighlightErrors(@NotNull KtFile $this$shouldHighlightErrors) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHighlightErrors, (String)"<this>");
        if ($this$shouldHighlightErrors.isCompiled()) {
            return false;
        }
        if ($this$shouldHighlightErrors instanceof KtCodeFragment && ((KtCodeFragment)$this$shouldHighlightErrors).getContext() != null) {
            return true;
        }
        Project project = $this$shouldHighlightErrors.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        boolean indexingInProgress = KotlinHighlightingUtils.isIndexingInProgress(project);
        if (!indexingInProgress && $this$shouldHighlightErrors.isScript()) {
            return KotlinHighlightingUtils.calculateShouldHighlightScript($this$shouldHighlightErrors);
        }
        return SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, indexingInProgress, false, 47, null), (PsiElement)$this$shouldHighlightErrors);
    }

    @ApiStatus.Internal
    public static final boolean shouldHighlightFile(@NotNull KtFile $this$shouldHighlightFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$shouldHighlightFile, (String)"<this>");
        Project project = $this$shouldHighlightFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (KotlinHighlightingUtils.isIndexingInProgress(project)) {
            return SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.everything, false, false, false, false, true, false, 47, null), (PsiElement)$this$shouldHighlightFile);
        }
        if ($this$shouldHighlightFile.isScript()) {
            Project project2 = $this$shouldHighlightFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            bl = KotlinScriptHighlightingExtension.Companion.shouldHighlightScript(project2, $this$shouldHighlightFile);
        } else {
            Object object = CachedValuesManager.getManager((Project)$this$shouldHighlightFile.getProject()).getCachedValue((UserDataHolder)$this$shouldHighlightFile, () -> KotlinHighlightingUtils.shouldHighlightFile$lambda$0($this$shouldHighlightFile));
            Intrinsics.checkNotNull((Object)object);
            bl = (Boolean)object;
        }
        return bl;
    }

    private static final boolean isIndexingInProgress(Project project) {
        return (Boolean)ActionsKt.runReadAction(() -> KotlinHighlightingUtils.isIndexingInProgress$lambda$0(project));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean shouldDefinitelyHighlight(@NotNull KtFile $this$shouldDefinitelyHighlight) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldDefinitelyHighlight, (String)"<this>");
        if ($this$shouldDefinitelyHighlight instanceof KtCodeFragment) {
            if (((KtCodeFragment)$this$shouldDefinitelyHighlight).getContext() != null) return true;
        }
        if (SyntheticPsiFileSupport.isOutsiderFile((VirtualFile)$this$shouldDefinitelyHighlight.getVirtualFile())) return true;
        if ($this$shouldDefinitelyHighlight instanceof KtCodeFragment) return false;
        VirtualFile virtualFile = $this$shouldDefinitelyHighlight.getVirtualFile();
        if (!((virtualFile != null ? virtualFile.getFileSystem() : null) instanceof NonPhysicalFileSystem)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean calculateShouldHighlightFile(KtFile $this$calculateShouldHighlightFile) {
        if (KotlinHighlightingUtils.shouldDefinitelyHighlight($this$calculateShouldHighlightFile)) return true;
        if (!SourceKindFilterUtils.matches(RootKindFilter.everything, (PsiElement)$this$calculateShouldHighlightFile)) return false;
        PsiElement psiElement = (PsiElement)$this$calculateShouldHighlightFile;
        Project project = $this$calculateShouldHighlightFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (ApiKt.getKaModule(psiElement, project, null) instanceof KaNotUnderContentRootModule) return false;
        return true;
    }

    private static final boolean calculateShouldHighlightScript(KtFile $this$calculateShouldHighlightScript) {
        if (KotlinHighlightingUtils.shouldDefinitelyHighlight($this$calculateShouldHighlightScript)) {
            return true;
        }
        if (KotlinPlatformUtils.isCidr()) {
            return false;
        }
        Project project = $this$calculateShouldHighlightScript.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        boolean isReadyToHighlight = KotlinScriptHighlightingExtension.Companion.shouldHighlightScript(project, $this$calculateShouldHighlightScript);
        return isReadyToHighlight && SourceKindFilterUtils.matches(RootKindFilter.copy$default(RootKindFilter.projectSources, false, false, false, false, true, false, 47, null), (PsiElement)$this$calculateShouldHighlightScript);
    }

    private static final CachedValueProvider.Result shouldHighlightFile$lambda$0(KtFile $this_shouldHighlightFile) {
        Object[] objectArray = new Object[]{ProjectRootModificationTracker.getInstance((Project)$this_shouldHighlightFile.getProject())};
        return CachedValueProvider.Result.create((Object)KotlinHighlightingUtils.calculateShouldHighlightFile($this_shouldHighlightFile), (Object[])objectArray);
    }

    private static final boolean isIndexingInProgress$lambda$0(Project $project) {
        return DumbService.Companion.getInstance($project).isDumb();
    }
}

