/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.v1;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptResidenceExceptionProvider;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0005\u001a\u001c\u0010\u0007\u001a\u00020\u0004*\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0014\u0010\u000f\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"scriptResidenceExceptionProviders", "", "Lorg/jetbrains/kotlin/idea/core/script/v1/ScriptResidenceExceptionProvider;", "hasUnknownScriptExt", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasNoExceptionsToBeUnderSourceRoot", "isEnabled", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "compilerAllowsAnyScriptsInSourceRoots", "isRunnableKotlinScript", "isStandaloneKotlinScript", "intellij.kotlin.base.scripting.shared"})
@SourceDebugExtension(value={"SMAP\nScriptResidenceExceptionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptResidenceExceptionProvider.kt\norg/jetbrains/kotlin/idea/core/script/v1/ScriptResidenceExceptionProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n2746#2,3:83\n2746#2,3:86\n1#3:89\n*S KotlinDebug\n*F\n+ 1 ScriptResidenceExceptionProvider.kt\norg/jetbrains/kotlin/idea/core/script/v1/ScriptResidenceExceptionProviderKt\n*L\n53#1:83,3\n56#1:86,3\n*E\n"})
public final class ScriptResidenceExceptionProviderKt {
    @NotNull
    private static final List<ScriptResidenceExceptionProvider> scriptResidenceExceptionProviders;

    public static final boolean hasUnknownScriptExt(@NotNull VirtualFile $this$hasUnknownScriptExt) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasUnknownScriptExt, (String)"<this>");
            Iterable $this$none$iv = scriptResidenceExceptionProviders;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ScriptResidenceExceptionProvider it = (ScriptResidenceExceptionProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.isSupportedScriptExtension($this$hasUnknownScriptExt)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean hasNoExceptionsToBeUnderSourceRoot(@NotNull VirtualFile $this$hasNoExceptionsToBeUnderSourceRoot) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasNoExceptionsToBeUnderSourceRoot, (String)"<this>");
            Iterable $this$none$iv = scriptResidenceExceptionProviders;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ScriptResidenceExceptionProvider it = (ScriptResidenceExceptionProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.isSupportedUnderSourceRoot($this$hasNoExceptionsToBeUnderSourceRoot)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isEnabled(@NotNull LanguageFeature $this$isEnabled, @Nullable Module module, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Module module2 = module;
        if (module2 == null || (module2 = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(module2)) == null) {
            module2 = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(project);
        }
        Module settings2 = module2;
        return settings2.supportsFeature($this$isEnabled);
    }

    @ApiStatus.Internal
    public static final boolean compilerAllowsAnyScriptsInSourceRoots(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CompilerSettings additionalSettings = (CompilerSettings)KotlinCompilerSettings.Companion.getInstance(project).getSettings();
        return StringsKt.contains$default((CharSequence)additionalSettings.getAdditionalArguments(), (CharSequence)"-Xallow-any-scripts-in-source-roots", (boolean)false, (int)2, null);
    }

    @ApiStatus.Internal
    public static final boolean isRunnableKotlinScript(@NotNull VirtualFile $this$isRunnableKotlinScript, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$isRunnableKotlinScript, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CharSequence charSequence = $this$isRunnableKotlinScript.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        if (StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".gradle.kts", (boolean)false, (int)2, null)) {
            return false;
        }
        return ScriptResidenceExceptionProviderKt.isStandaloneKotlinScript($this$isRunnableKotlinScript, project);
    }

    @ApiStatus.Internal
    public static final boolean isStandaloneKotlinScript(@NotNull VirtualFile $this$isStandaloneKotlinScript, @NotNull Project project) {
        Object object;
        block5: {
            block4: {
                KtFile ktFile2;
                Intrinsics.checkNotNullParameter((Object)$this$isStandaloneKotlinScript, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                PsiFile psiFile = PhysicalFileSystemUtilsKt.toPsiFile($this$isStandaloneKotlinScript, project);
                object = psiFile instanceof KtFile ? (KtFile)psiFile : null;
                if (object == null) break block4;
                KtFile p0 = ktFile2 = object;
                boolean bl = false;
                object = p0.isScript() ? ktFile2 : null;
                if (object != null) break block5;
            }
            return false;
        }
        KtFile ktFile3 = object;
        Object object2 = ScriptDefinitionProvider.Companion.getInstance(project);
        if (object2 == null || (object2 = object2.findDefinition(new KtFileScriptSource(ktFile3, null, 2, null))) == null) {
            return false;
        }
        Object scriptDefinition = object2;
        return Intrinsics.areEqual((Object)((ScriptDefinition)((Object)scriptDefinition)).getCompilationConfiguration().get(ScriptCompilationKt.isStandalone(ScriptCompilationConfiguration.Companion)), (Object)true);
    }

    static {
        Object[] objectArray = new ScriptResidenceExceptionProvider[]{new ScriptResidenceExceptionProvider(".gradle.kts", true), new ScriptResidenceExceptionProvider(".main.kts", false, 2, null), new ScriptResidenceExceptionProvider(".space.kts", false, 2, null), new ScriptResidenceExceptionProvider(".inspection.kts", false, 2, null), new ScriptResidenceExceptionProvider(){

            public boolean isSupportedScriptExtension(VirtualFile virtualFile) {
                Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
                String string = virtualFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)".kts", (boolean)false, (int)2, null)) {
                    return false;
                }
                for (VirtualFile parent = virtualFile.getParent(); parent != null; parent = parent.getParent()) {
                    if (!parent.isDirectory() || !Intrinsics.areEqual((Object)parent.getName(), (Object)".teamcity")) continue;
                    return true;
                }
                return false;
            }
        }};
        scriptResidenceExceptionProviders = CollectionsKt.listOf((Object[])objectArray);
    }
}

