/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SelfReferenceConstructorParameterInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "selfReferenceParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "ConvertToNullableTypeFix", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nSelfReferenceConstructorParameterInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelfReferenceConstructorParameterInspection.kt\norg/jetbrains/kotlin/idea/inspections/SelfReferenceConstructorParameterInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n295#2,2:64\n*S KotlinDebug\n*F\n+ 1 SelfReferenceConstructorParameterInspection.kt\norg/jetbrains/kotlin/idea/inspections/SelfReferenceConstructorParameterInspection\n*L\n39#1:64,2\n*E\n"})
public final class SelfReferenceConstructorParameterInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return VisitorWrappersKt.primaryConstructorVisitor(arg_0 -> SelfReferenceConstructorParameterInspection.buildVisitor$lambda$0(this, holder2, arg_0));
    }

    private final KtParameter selfReferenceParameter(KtParameterList $this$selfReferenceParameter) {
        Object v4;
        KtClass containingClass;
        block9: {
            KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)$this$selfReferenceParameter));
            if (ktClass == null) {
                return null;
            }
            containingClass = ktClass;
            String string = containingClass.getName();
            if (string == null) {
                return null;
            }
            String className = string;
            List list2 = $this$selfReferenceParameter.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtParameter it = (KtParameter)element$iv;
                boolean bl = false;
                KtTypeReference ktTypeReference = it.getTypeReference();
                if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? ktTypeReference.getText() : null), (Object)className)) continue;
                v4 = element$iv;
                break block9;
            }
            v4 = null;
        }
        KtParameter ktParameter = v4;
        if (ktParameter == null) {
            return null;
        }
        KtParameter parameter = ktParameter;
        if (parameter.isVarArg()) {
            return null;
        }
        KtTypeReference ktTypeReference = parameter.getTypeReference();
        if (ktTypeReference == null) {
            return null;
        }
        KtTypeReference typeReference = ktTypeReference;
        BindingContext context2 = ResolutionUtils.analyze((KtElement)$this$selfReferenceParameter, BodyResolveMode.PARTIAL);
        KotlinType kotlinType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
        if (kotlinType == null) {
            return null;
        }
        KotlinType type2 = kotlinType;
        if (KotlinTypeKt.isNullable((KotlinType)type2)) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)type2.getConstructor().getDeclarationDescriptor(), (Object)context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)containingClass))) {
            return null;
        }
        return parameter;
    }

    private static final Unit buildVisitor$lambda$0(SelfReferenceConstructorParameterInspection this$0, ProblemsHolder $holder, KtPrimaryConstructor constructor) {
        KtParameterList ktParameterList = constructor.getValueParameterList();
        if (ktParameterList == null || (ktParameterList = this$0.selfReferenceParameter(ktParameterList)) == null) {
            return Unit.INSTANCE;
        }
        KtParameterList parameter = ktParameterList;
        KtTypeReference ktTypeReference = parameter.getTypeReference();
        if (ktTypeReference == null || (ktTypeReference = ktTypeReference.getTextRange()) == null || (ktTypeReference = ktTypeReference.shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)parameter)))) == null) {
            return Unit.INSTANCE;
        }
        KtTypeReference rangeInElement = ktTypeReference;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ConvertToNullableTypeFix()};
        $holder.registerProblem((PsiElement)parameter, (TextRange)rangeInElement, KotlinBundle.message((String)"constructor.has.non.null.self.reference.parameter", (Object[])new Object[0]), localQuickFixArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SelfReferenceConstructorParameterInspection$ConvertToNullableTypeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "kotlin.idea"})
    private static final class ConvertToNullableTypeFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"convert.to.nullable.type.fix.text", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement = descriptor2.getPsiElement();
            KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
            if (ktParameter == null) {
                return;
            }
            KtParameter parameter = ktParameter;
            KtTypeReference ktTypeReference = parameter.getTypeReference();
            if (ktTypeReference == null) {
                return;
            }
            KtTypeReference typeReference = ktTypeReference;
            KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)parameter, BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
            if (kotlinType == null) {
                return;
            }
            KotlinType type2 = kotlinType;
            PsiModificationUtilsKt.setType$default((KtCallableDeclaration)parameter, TypeUtilsKt.makeNullable((KotlinType)type2), false, 2, null);
        }
    }
}

