/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.suppress;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiHeuristics;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/suppress/RemoveRedundantSuppression;", "Lcom/intellij/codeInspection/LocalQuickFix;", "toolId", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.kotlin.base.codeInsight"})
@SourceDebugExtension(value={"SMAP\nKotlinInspectionSuppressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinInspectionSuppressor.kt\norg/jetbrains/kotlin/idea/inspections/suppress/RemoveRedundantSuppression\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n67#2:97\n125#3:98\n1#4:99\n*S KotlinDebug\n*F\n+ 1 KotlinInspectionSuppressor.kt\norg/jetbrains/kotlin/idea/inspections/suppress/RemoveRedundantSuppression\n*L\n73#1:97\n84#1:98\n*E\n"})
final class RemoveRedundantSuppression
implements LocalQuickFix {
    @NotNull
    private final String toolId;

    public RemoveRedundantSuppression(@NotNull String toolId) {
        Intrinsics.checkNotNullParameter((Object)toolId, (String)"toolId");
        this.toolId = toolId;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"remove.suppression.action.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        block11: {
            Object v10;
            KtValueArgumentList valueArgumentList;
            KtAnnotatedExpression ktAnnotatedExpression;
            block8: {
                KtAnnotationEntry suppressAnnotationEntry;
                block9: {
                    block10: {
                        void $this$parentOfType$iv;
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                        PsiElement psiElement = descriptor2.getPsiElement();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
                        PsiElement psiElement2 = psiElement;
                        boolean withSelf$iv = true;
                        boolean $i$f$parentOfType = false;
                        KtAnnotated ktAnnotated = (KtAnnotated)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtAnnotated.class, (boolean)false);
                        if (ktAnnotated == null) {
                            throw new KotlinExceptionWithAttachments("Annotated element is not found").withAttachment("class.txt", descriptor2.getPsiElement().getClass()).withPsiAttachment("element.txt", descriptor2.getPsiElement());
                        }
                        KtAnnotated annotated = ktAnnotated;
                        KtAnnotationEntry ktAnnotationEntry = KotlinPsiHeuristics.findSuppressAnnotation(annotated);
                        if (ktAnnotationEntry == null) {
                            throw new KotlinExceptionWithAttachments("Suppress annotation is not found").withPsiAttachment("element.txt", descriptor2.getPsiElement()).withPsiAttachment("annotatedElement.txt", (PsiElement)annotated);
                        }
                        suppressAnnotationEntry = ktAnnotationEntry;
                        if (suppressAnnotationEntry.getValueArguments().size() != 1) break block9;
                        KtAnnotated $this$safeAs$iv = annotated;
                        boolean $i$f$safeAs = false;
                        KtAnnotated ktAnnotated2 = $this$safeAs$iv;
                        if (!(ktAnnotated2 instanceof KtAnnotatedExpression)) {
                            ktAnnotated2 = null;
                        }
                        if ((ktAnnotatedExpression = (KtAnnotatedExpression)ktAnnotated2) == null || (ktAnnotatedExpression = ktAnnotatedExpression.getBaseExpression()) == null) break block10;
                        KtAnnotatedExpression it = ktAnnotatedExpression;
                        boolean bl = false;
                        PsiElement psiElement3 = annotated.replace((PsiElement)it);
                        ktAnnotatedExpression = psiElement3;
                        if (psiElement3 != null) break block11;
                    }
                    suppressAnnotationEntry.delete();
                    ktAnnotatedExpression = Unit.INSTANCE;
                    break block11;
                }
                KtValueArgumentList ktValueArgumentList = suppressAnnotationEntry.getValueArgumentList();
                if (ktValueArgumentList == null) {
                    return;
                }
                valueArgumentList = ktValueArgumentList;
                List list2 = valueArgumentList.getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getArguments(...)");
                Iterable iterable = list2;
                for (Object t : iterable) {
                    KtValueArgument it = (KtValueArgument)t;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    String string = KotlinPsiUtils.findSingleLiteralStringTemplateText((ValueArgument)it);
                    boolean bl2 = string != null ? StringsKt.equals((String)string, (String)this.toolId, (boolean)true) : false;
                    if (!bl2) continue;
                    v10 = t;
                    break block8;
                }
                v10 = null;
            }
            KtValueArgument ktValueArgument = v10;
            if (ktValueArgument == null) {
                throw new KotlinExceptionWithAttachments("ToolId is not found").withAttachment("arguments.txt", (Object)valueArgumentList.getText()).withAttachment("tool.txt", (Object)this.toolId);
            }
            KtValueArgument argument2 = ktValueArgument;
            valueArgumentList.removeArgument(argument2);
            ktAnnotatedExpression = Unit.INSTANCE;
        }
    }
}

