/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaRenderer;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaReceiverValue;
import org.jetbrains.kotlin.analysis.api.symbols.KaAnonymousFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassifierSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaReceiverParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaVariableSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaFunctionType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaUsualClassType;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u0004H\u0002\u001a\f\u0010\u000e\u001a\u00020\b*\u00020\u000fH\u0002\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"buildReferenceText", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "callableRefExpr", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "canMove", "", "lambdaExpression", "functionInterfaces", "", "Lorg/jetbrains/kotlin/name/FqName;", "propertyTypes", "isFunctionInterfaceOrPropertyType", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "intellij.kotlin.codeInsight.inspections"})
@SourceDebugExtension(value={"SMAP\nSuspiciousCallableReferenceInLambdaInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspiciousCallableReferenceInLambdaInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/SuspiciousCallableReferenceInLambdaInspectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
public final class SuspiciousCallableReferenceInLambdaInspectionKt {
    @NotNull
    private static final Set<FqName> functionInterfaces;
    @NotNull
    private static final Set<FqName> propertyTypes;

    /*
     * Enabled aggressive block sorting
     */
    private static final String buildReferenceText(KaSession $this$buildReferenceText, KtLambdaExpression element, KtCallableReferenceExpression callableRefExpr) {
        String string;
        KtSimpleNameExpression ktSimpleNameExpression = callableRefExpr.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
        KtSimpleNameExpression callableReference = ktSimpleNameExpression;
        KtExpression ktExpression = callableRefExpr.getReceiverExpression();
        if (ktExpression == null) {
            String string2 = callableReference.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            return "::" + ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        KtExpression receiverExpression = ktExpression;
        KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)receiverExpression));
        KaSymbol receiverSymbol = ktReference != null ? $this$buildReferenceText.resolveToSymbol(ktReference) : null;
        KtFunctionLiteral ktFunctionLiteral = element.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
        KaAnonymousFunctionSymbol lambdaSymbol = $this$buildReferenceText.getSymbol(ktFunctionLiteral);
        if (receiverSymbol == null || receiverSymbol instanceof KaValueParameterSymbol) {
            KaValueParameterSymbol kaValueParameterSymbol = (KaValueParameterSymbol)receiverSymbol;
            if (Intrinsics.areEqual((Object)(kaValueParameterSymbol != null ? $this$buildReferenceText.getContainingSymbol(kaValueParameterSymbol) : null), (Object)lambdaSymbol)) {
                String string3;
                String string4;
                KaLifetimeOwner kaLifetimeOwner;
                KaCallInfo kaCallInfo = $this$buildReferenceText.resolveToCall((KtElement)callableRefExpr);
                KaFunctionCall<Object> kaFunctionCall = kaCallInfo != null ? KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo) : null;
                KaLifetimeOwner kaLifetimeOwner2 = kaFunctionCall;
                if (kaLifetimeOwner2 != null && (kaLifetimeOwner2 = kaLifetimeOwner2.getPartiallyAppliedSymbol()) != null) {
                    KaLifetimeOwner it = kaLifetimeOwner2;
                    boolean bl = false;
                    kaLifetimeOwner = it.getExtensionReceiver();
                    if (kaLifetimeOwner == null || (kaLifetimeOwner = kaLifetimeOwner.getType()) == null) {
                        KaReceiverValue kaReceiverValue = it.getDispatchReceiver();
                        kaLifetimeOwner = kaReceiverValue != null ? kaReceiverValue.getType() : null;
                    }
                } else {
                    kaLifetimeOwner = null;
                }
                KaReceiverValue receiverType = kaLifetimeOwner;
                String typeText = receiverType != null && (string4 = KaRenderer.render$default($this$buildReferenceText, (KaType)((Object)receiverType), null, Variance.INVARIANT, 1, null)) != null && (string3 = StringsKt.substringAfterLast$default((String)string4, (char)'.', null, (int)2, null)) != null ? string3 : "";
                String string5 = callableReference.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                string = typeText + "::" + ((Object)StringsKt.trim((CharSequence)string5)).toString();
                return string;
            }
        }
        String string7 = receiverExpression.getText();
        string7 = callableReference.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
        string = string6 + "::" + ((Object)StringsKt.trim((CharSequence)string7)).toString();
        return string;
    }

    private static final boolean canMove(KaSession $this$canMove, KtLambdaExpression lambdaExpression) {
        KaLifetimeOwner paramType;
        KaType receiverType;
        KaSymbol receiverSymbol;
        KaType lambdaParamType;
        KaParameterSymbol lambdaParam;
        Object object = lambdaExpression.getBodyExpression();
        KtExpression ktExpression = object != null && (object = object.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : null;
        KtCallableReferenceExpression ktCallableReferenceExpression = ktExpression instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)ktExpression : null;
        if (ktCallableReferenceExpression == null) {
            return false;
        }
        KtCallableReferenceExpression body2 = ktCallableReferenceExpression;
        KtFunctionLiteral ktFunctionLiteral = lambdaExpression.getFunctionLiteral();
        Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"getFunctionLiteral(...)");
        KaAnonymousFunctionSymbol lambdaSymbol = $this$canMove.getSymbol(ktFunctionLiteral);
        KaReceiverParameterSymbol kaReceiverParameterSymbol = lambdaSymbol.getReceiverParameter();
        KaParameterSymbol kaParameterSymbol = lambdaParam = kaReceiverParameterSymbol != null ? (KaParameterSymbol)kaReceiverParameterSymbol : (KaParameterSymbol)CollectionsKt.singleOrNull(lambdaSymbol.getValueParameters());
        KaType kaType = lambdaParamType = kaParameterSymbol != null ? kaParameterSymbol.getReturnType() : null;
        if (lambdaParamType == null) {
            KaType kaType2;
            Object object2;
            KtSimpleNameExpression ktSimpleNameExpression = body2.getCallableReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
            KaSymbol kaSymbol = $this$canMove.resolveToSymbol((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktSimpleNameExpression));
            if (kaSymbol == null) {
                return false;
            }
            KaSymbol target = kaSymbol;
            KaSymbol kaSymbol2 = target;
            return kaSymbol2 instanceof KaVariableSymbol ? ((object2 = (kaType2 = ((KaVariableSymbol)target).getReturnType()) instanceof KaFunctionType ? (KaFunctionType)kaType2 : null) != null && (object2 = ((KaFunctionType)object2).getParameterTypes()) != null ? object2.isEmpty() : false) : (kaSymbol2 instanceof KaFunctionSymbol ? ((KaFunctionSymbol)target).getValueParameters().isEmpty() : false);
        }
        KtExpression ktExpression2 = body2.getReceiverExpression();
        KaSymbol kaSymbol = ktExpression2 != null && (ktExpression2 = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression2))) != null ? $this$canMove.resolveToSymbol((KtReference)ktExpression2) : (receiverSymbol = null);
        if (Intrinsics.areEqual(receiverSymbol, (Object)lambdaParam)) {
            return true;
        }
        KaSymbol kaSymbol3 = receiverSymbol;
        KaType kaType3 = kaSymbol3 instanceof KaVariableSymbol ? ((KaVariableSymbol)receiverSymbol).getReturnType() : (kaSymbol3 instanceof KaValueParameterSymbol ? ((KaValueParameterSymbol)receiverSymbol).getReturnType() : (receiverType = kaSymbol3 instanceof KaClassSymbol ? $this$canMove.getDefaultType((KaClassifierSymbol)receiverSymbol) : null));
        boolean bl = receiverType != null ? KaTypeRelationChecker.semanticallyEquals$default($this$canMove, receiverType, lambdaParamType, null, 2, null) : false;
        if (bl) {
            return true;
        }
        if (receiverSymbol instanceof KaVariableSymbol) {
            KaType kaType4 = ((KaVariableSymbol)receiverSymbol).getReturnType();
            KaFunctionType functionType = kaType4 instanceof KaFunctionType ? (KaFunctionType)kaType4 : null;
            Object object3 = functionType;
            KaType kaType5 = object3 != null && (object3 = ((KaFunctionType)object3).getParameterTypes()) != null ? (KaType)CollectionsKt.firstOrNull((List)object3) : (paramType = null);
            boolean bl2 = paramType != null ? KaTypeRelationChecker.semanticallyEquals$default($this$canMove, paramType, lambdaParamType, null, 2, null) : false;
            if (bl2) {
                return true;
            }
        }
        KtSimpleNameExpression ktSimpleNameExpression = body2.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
        KaSymbol kaSymbol4 = $this$canMove.resolveToSymbol((KtReference)ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktSimpleNameExpression));
        KaFunctionSymbol kaFunctionSymbol = kaSymbol4 instanceof KaFunctionSymbol ? (KaFunctionSymbol)kaSymbol4 : null;
        if (kaFunctionSymbol == null) {
            return false;
        }
        KaFunctionSymbol funcSymbol = kaFunctionSymbol;
        KaLifetimeOwner kaLifetimeOwner = (KaValueParameterSymbol)CollectionsKt.firstOrNull(funcSymbol.getValueParameters());
        if (kaLifetimeOwner == null || (kaLifetimeOwner = kaLifetimeOwner.getReturnType()) == null) {
            return false;
        }
        paramType = kaLifetimeOwner;
        return KaTypeRelationChecker.semanticallyEquals$default($this$canMove, paramType, lambdaParamType, null, 2, null);
    }

    private static final boolean isFunctionInterfaceOrPropertyType(KaType $this$isFunctionInterfaceOrPropertyType) {
        KaUsualClassType kaUsualClassType = $this$isFunctionInterfaceOrPropertyType instanceof KaUsualClassType ? (KaUsualClassType)$this$isFunctionInterfaceOrPropertyType : null;
        FqName fqName2 = kaUsualClassType != null && (kaUsualClassType = kaUsualClassType.getClassId()) != null ? kaUsualClassType.asSingleFqName() : null;
        return CollectionsKt.contains((Iterable)functionInterfaces, (Object)fqName2) || CollectionsKt.contains((Iterable)propertyTypes, (Object)fqName2);
    }

    public static final /* synthetic */ boolean access$canMove(KaSession $receiver, KtLambdaExpression lambdaExpression) {
        return SuspiciousCallableReferenceInLambdaInspectionKt.canMove($receiver, lambdaExpression);
    }

    public static final /* synthetic */ String access$buildReferenceText(KaSession $receiver, KtLambdaExpression element, KtCallableReferenceExpression callableRefExpr) {
        return SuspiciousCallableReferenceInLambdaInspectionKt.buildReferenceText($receiver, element, callableRefExpr);
    }

    public static final /* synthetic */ boolean access$isFunctionInterfaceOrPropertyType(KaType $receiver) {
        return SuspiciousCallableReferenceInLambdaInspectionKt.isFunctionInterfaceOrPropertyType($receiver);
    }

    static {
        Object[] objectArray = new FqName[]{new FqName("kotlin.Function"), new FqName("kotlin.reflect.KFunction")};
        functionInterfaces = SetsKt.setOf((Object[])objectArray);
        objectArray = new FqName[]{new FqName("kotlin.reflect.KProperty"), new FqName("kotlin.reflect.KProperty0"), new FqName("kotlin.reflect.KProperty1"), new FqName("kotlin.reflect.KMutableProperty"), new FqName("kotlin.reflect.KMutableProperty0"), new FqName("kotlin.reflect.KMutableProperty1")};
        propertyTypes = SetsKt.setOf((Object[])objectArray);
    }
}

