/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.HammingComparator;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002 !B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\u0012\u0010\n\u001a\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\tH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH&J\u001f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\fH\u0016\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AbstractRenameUnresolvedReferenceFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;)V", "getText", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "invoke", "", "findOccurrences", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "container", "Lorg/jetbrains/kotlin/psi/KtElement;", "isCallee", "getTargetCandidates", "", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;)[Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "startInWriteAction", "Companion", "ReferenceNameExpression", "kotlin.fir.frontend-independent"})
@SourceDebugExtension(value={"SMAP\nAbstractRenameUnresolvedReferenceFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractRenameUnresolvedReferenceFix.kt\norg/jetbrains/kotlin/idea/quickfix/AbstractRenameUnresolvedReferenceFix\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n249#2:98\n183#3,2:99\n1869#4,2:101\n*S KotlinDebug\n*F\n+ 1 AbstractRenameUnresolvedReferenceFix.kt\norg/jetbrains/kotlin/idea/quickfix/AbstractRenameUnresolvedReferenceFix\n*L\n48#1:98\n57#1:99,2\n65#1:101,2\n*E\n"})
public abstract class AbstractRenameUnresolvedReferenceFix
extends KotlinQuickFixAction<KtNameReferenceExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String INPUT_VARIABLE_NAME = "INPUT_VAR";
    @NotNull
    private static final String OTHER_VARIABLE_NAME = "OTHER_VAR";

    public AbstractRenameUnresolvedReferenceFix(@NotNull KtNameReferenceExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message((String)"rename.wrong.reference.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"rename.wrong.reference.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)this.getElement();
        if (ktNameReferenceExpression == null) {
            return false;
        }
        KtNameReferenceExpression element = ktNameReferenceExpression;
        if (editor == null) return false;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTypeReference.class, (boolean)true) != null) return false;
        return true;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Object v2;
        String originalName;
        KtExpression patternExpression;
        KtNameReferenceExpression element;
        block8: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)this.getElement();
            if (ktNameReferenceExpression == null) {
                return;
            }
            element = ktNameReferenceExpression;
            if (editor == null) {
                return;
            }
            KtElement ktElement = KtPsiUtilKt.getQualifiedElement((KtSimpleNameExpression)((KtSimpleNameExpression)element));
            KtExpression ktExpression = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
            if (ktExpression == null) {
                return;
            }
            patternExpression = ktExpression;
            originalName = element.getReferencedName();
            Sequence $this$firstOrNull$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)element));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtDeclarationWithBody || it instanceof KtClassOrObject || it instanceof KtFile)) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = null;
        }
        PsiElement psiElement = v2;
        if (psiElement == null) {
            return;
        }
        PsiElement container = psiElement;
        List<KtNameReferenceExpression> occurrences = this.findOccurrences(patternExpression, (KtElement)container, KtPsiUtilKt.isCallee((KtSimpleNameExpression)((KtSimpleNameExpression)element)));
        LookupElementBuilder[] lookupItems = this.getTargetCandidates(patternExpression, element);
        ReferenceNameExpression nameExpression2 = new ReferenceNameExpression((LookupElement[])lookupItems, originalName);
        TemplateBuilderImpl builder2 = new TemplateBuilderImpl(container);
        Iterable $this$forEach$iv = occurrences;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtNameReferenceExpression it = (KtNameReferenceExpression)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)element)) {
                builder2.replaceElement(it.getReferencedNameElement(), OTHER_VARIABLE_NAME, INPUT_VARIABLE_NAME, false);
                continue;
            }
            builder2.replaceElement(it.getReferencedNameElement(), INPUT_VARIABLE_NAME, (Expression)nameExpression2, true);
        }
        editor.getCaretModel().moveToOffset(PsiTreeUtilKt.getStartOffset((PsiElement)container));
        if (file.isPhysical()) {
            ActionsKt.runWriteAction(() -> AbstractRenameUnresolvedReferenceFix.invoke$lambda$2(project, editor, builder2));
        }
    }

    @NotNull
    public abstract List<KtNameReferenceExpression> findOccurrences(@NotNull KtExpression var1, @NotNull KtElement var2, boolean var3);

    @NotNull
    public abstract LookupElementBuilder[] getTargetCandidates(@NotNull KtExpression var1, @NotNull KtNameReferenceExpression var2);

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static final Unit invoke$lambda$2(Project $project, Editor $editor, TemplateBuilderImpl $builder) {
        TemplateManager.getInstance((Project)$project).startTemplate($editor, $builder.buildInlineTemplate());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AbstractRenameUnresolvedReferenceFix$Companion;", "", "<init>", "()V", "INPUT_VARIABLE_NAME", "", "OTHER_VARIABLE_NAME", "kotlin.fir.frontend-independent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001f\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0011R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AbstractRenameUnresolvedReferenceFix$ReferenceNameExpression;", "Lcom/intellij/codeInsight/template/Expression;", "items", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "originalReferenceName", "", "<init>", "([Lcom/intellij/codeInsight/lookup/LookupElement;Ljava/lang/String;)V", "[Lcom/intellij/codeInsight/lookup/LookupElement;", "calculateResult", "Lcom/intellij/codeInsight/template/TextResult;", "context", "Lcom/intellij/codeInsight/template/ExpressionContext;", "calculateQuickResult", "", "calculateLookupItems", "(Lcom/intellij/codeInsight/template/ExpressionContext;)[Lcom/intellij/codeInsight/lookup/LookupElement;", "kotlin.fir.frontend-independent"})
    private static final class ReferenceNameExpression
    extends Expression {
        @NotNull
        private final LookupElement[] items;
        @NotNull
        private final String originalReferenceName;

        public ReferenceNameExpression(@NotNull LookupElement[] items, @NotNull String originalReferenceName) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            Intrinsics.checkNotNullParameter((Object)originalReferenceName, (String)"originalReferenceName");
            this.items = items;
            this.originalReferenceName = originalReferenceName;
            Arrays.sort(this.items, new HammingComparator(this.originalReferenceName, ReferenceNameExpression::_init_$lambda$0));
        }

        @NotNull
        public TextResult calculateResult(@NotNull ExpressionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Object object = (LookupElement)ArraysKt.firstOrNull((Object[])this.items);
            if (object == null || (object = object.getLookupString()) == null) {
                object = this.originalReferenceName;
            }
            return new TextResult((String)object);
        }

        @Nullable
        public Void calculateQuickResult(@NotNull ExpressionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return null;
        }

        @Nullable
        public LookupElement[] calculateLookupItems(@NotNull ExpressionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            return this.items.length <= 1 ? null : this.items;
        }

        private static final String _init_$lambda$0(LookupElement $this$HammingComparator) {
            String string = $this$HammingComparator.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
            return string;
        }
    }
}

