/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.createFromUsage;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.idea.refactoring.JavaTransformUtilKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/createFromUsage/TransformToJavaUtil;", "", "<init>", "()V", "transformToJavaMemberIfApplicable", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "isExtension", "needStatic", "targetClass", "Lcom/intellij/psi/PsiClass;", "getClassKind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "convertToJava", "Lcom/intellij/psi/PsiMember;", "intellij.kotlin.codeInsight.shared"})
public final class TransformToJavaUtil {
    @NotNull
    public static final TransformToJavaUtil INSTANCE = new TransformToJavaUtil();

    private TransformToJavaUtil() {
    }

    public final boolean transformToJavaMemberIfApplicable(@NotNull KtNamedDeclaration declaration, @NotNull FqName packageFqName, boolean isExtension, boolean needStatic, @NotNull PsiClass targetClass) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        if (isExtension) {
            return false;
        }
        if (!KotlinCommonRefactoringUtilKt.canRefactorElement((PsiElement)targetClass)) {
            return false;
        }
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiMember psiMember = this.convertToJava(declaration, packageFqName, targetClass);
        if (psiMember == null) {
            return false;
        }
        PsiMember newJavaMember = psiMember;
        PsiModifierList psiModifierList = newJavaMember.getModifierList();
        Intrinsics.checkNotNull((Object)psiModifierList);
        PsiModifierList modifierList = psiModifierList;
        if (newJavaMember instanceof PsiMethod || newJavaMember instanceof PsiClass) {
            modifierList.setModifierProperty("final", false);
        }
        modifierList.setModifierProperty("static", needStatic);
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)newJavaMember);
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project2, targetClass.getContainingFile().getVirtualFile());
        Editor editor = FileEditorManager.getInstance((Project)project2).openTextEditor(descriptor2, true);
        Intrinsics.checkNotNull((Object)editor);
        Editor targetEditor = editor;
        targetEditor.getSelectionModel().removeSelection();
        PsiMember psiMember2 = newJavaMember;
        if (psiMember2 instanceof PsiMethod) {
            CreateFromUsageUtils.setupEditor((PsiMethod)((PsiMethod)newJavaMember), (Editor)targetEditor);
        } else if (psiMember2 instanceof PsiField) {
            targetEditor.getCaretModel().moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)newJavaMember)) - 1);
        } else if (psiMember2 instanceof PsiClass) {
            PsiMethodCallExpression superCall;
            PsiExpressionStatement superStatement;
            Object[] constructor;
            PsiMethod[] psiMethodArray = ((PsiClass)newJavaMember).getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
            Object[] objectArray = constructor = (Object[])ArraysKt.firstOrNull((Object[])psiMethodArray);
            PsiStatement psiStatement = constructor != null && (objectArray = objectArray.getBody()) != null && (objectArray = objectArray.getStatements()) != null ? (PsiStatement)ArraysKt.firstOrNull((Object[])objectArray) : null;
            PsiExpressionStatement psiExpressionStatement = superStatement = psiStatement instanceof PsiExpressionStatement ? (PsiExpressionStatement)psiStatement : null;
            PsiExpression psiExpression = psiExpressionStatement != null ? psiExpressionStatement.getExpression() : null;
            PsiMethodCallExpression psiMethodCallExpression = superCall = psiExpression instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)psiExpression : null;
            if (superCall != null) {
                PsiElement lParen = superCall.getArgumentList().getFirstChild();
                CaretModel caretModel = targetEditor.getCaretModel();
                Intrinsics.checkNotNull((Object)lParen);
                caretModel.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)lParen));
            } else {
                PsiIdentifier psiIdentifier = ((PsiClass)newJavaMember).getNameIdentifier();
                targetEditor.getCaretModel().moveToOffset(psiIdentifier != null ? PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)psiIdentifier)) : PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)newJavaMember)));
            }
        }
        targetEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return true;
    }

    private final ClassKind getClassKind(KtDeclaration declaration) {
        return declaration instanceof KtObjectDeclaration ? ClassKind.OBJECT : (declaration instanceof KtEnumEntry ? ClassKind.ENUM_ENTRY : (declaration instanceof KtClass && ((KtClass)declaration).isAnnotation() ? ClassKind.ANNOTATION_CLASS : (declaration instanceof KtClass && ((KtClass)declaration).isEnum() ? ClassKind.ENUM_CLASS : (declaration instanceof KtClass && ((KtClass)declaration).isInterface() ? ClassKind.INTERFACE : ClassKind.CLASS))));
    }

    @Nullable
    public final PsiMember convertToJava(@NotNull KtNamedDeclaration declaration, @NotNull FqName packageFqName, @NotNull PsiClass targetClass) {
        Object object;
        KtDeclaration ktDeclaration;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtPackageDirective ktPackageDirective = psiFactory.createPackageDirectiveIfNeeded(packageFqName);
        if (ktPackageDirective != null) {
            KtPackageDirective it = ktPackageDirective;
            boolean bl = false;
            declaration.getContainingFile().addBefore((PsiElement)it, null);
        }
        KtNamedDeclaration ktNamedDeclaration = declaration;
        if (ktNamedDeclaration instanceof KtNamedFunction || ktNamedDeclaration instanceof KtProperty) {
            KtClass klass = psiFactory.createClass("class Foo {}");
            KtClassBody ktClassBody = klass.getBody();
            Intrinsics.checkNotNull((Object)ktClassBody);
            ktClassBody.add((PsiElement)declaration);
            PsiElement psiElement = ((KtTypeParameterListOwnerStub)declaration).replace((PsiElement)klass);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            KtClassBody ktClassBody2 = ((KtClass)psiElement).getBody();
            Intrinsics.checkNotNull((Object)ktClassBody2);
            ktDeclaration = (KtDeclaration)CollectionsKt.first((List)ktClassBody2.getDeclarations());
        } else {
            ktDeclaration = (KtDeclaration)declaration;
        }
        KtDeclaration adjustedDeclaration = ktDeclaration;
        ktNamedDeclaration = adjustedDeclaration;
        if (ktNamedDeclaration instanceof KtNamedFunction || ktNamedDeclaration instanceof KtSecondaryConstructor) {
            Intrinsics.checkNotNull((Object)adjustedDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            object = (PsiMember)JavaTransformUtilKt.createJavaMethod((KtFunction)adjustedDeclaration, targetClass);
        } else {
            object = ktNamedDeclaration instanceof KtProperty ? (PsiMember)JavaTransformUtilKt.createJavaField((KtNamedDeclaration)adjustedDeclaration, targetClass) : (ktNamedDeclaration instanceof KtClass ? (PsiMember)JavaTransformUtilKt.createJavaClass((KtClass)adjustedDeclaration, targetClass, this.getClassKind(adjustedDeclaration)) : null);
        }
        return object;
    }
}

